REM
REM Parabelplotter
REM
REM Copyright by www.jb-electronics.de
REM

DECLARE SUB Status (Text$)
DECLARE FUNCTION f# (x AS DOUBLE)

REM 640x480
SCREEN 12

REM Die Variablen
DIM SHARED a, b, c, y AS DOUBLE
DIM SHARED xCenter, yCenter
DIM SHARED x AS DOUBLE
xCenter = 320
yCenter = 240

REM Startbildschirm anzeigen
CLS
COLOR 15
PRINT
PRINT "          Ŀ"
PRINT "                 Parabelplotter        "
PRINT "          "
PRINT
PRINT "   Formel: ";
COLOR 10: PRINT "y";
COLOR 15: PRINT " = ";
COLOR 10: PRINT "a";
COLOR 15: PRINT "(";
COLOR 10: PRINT "x";
COLOR 15: PRINT "-";
COLOR 10: PRINT "b";
COLOR 15: PRINT ")^2+";
COLOR 10
PRINT "c"
COLOR 15
PRINT
PRINT "  Bitte geben Sie die Werte fr ";
COLOR 10: PRINT "a";
COLOR 15: PRINT ", ";
COLOR 10: PRINT "b ";
COLOR 15: PRINT "und ";
COLOR 10: PRINT "c ";
COLOR 15: PRINT " ein!"
PRINT

REM Werte eingeben und umrechnen
LINE INPUT "  -> a --> "; aa$
LINE INPUT "  -> b --> "; bb$
LINE INPUT "  -> c --> "; cc$
a = VAL(aa$)
b = VAL(bb$)
c = VAL(cc$)


REM Jetzt geht's los:
ready = 0
CLS
LOCATE 2, 5
COLOR 15: PRINT " Parabel der Form ";
COLOR 10: PRINT "y";
COLOR 15: PRINT "=";
COLOR 10: PRINT RTRIM$(LTRIM$(STR$(a)));
COLOR 15: PRINT "*(";
COLOR 10: PRINT "x";
COLOR 15: PRINT "-";
COLOR 10: PRINT RTRIM$(LTRIM$(STR$(b)));
COLOR 15: PRINT ")^2+";
COLOR 10: PRINT RTRIM$(LTRIM$(STR$(c)))
COLOR 15: PRINT

REM Koordinatensystem zeichnen
LINE (xCenter, 0)-(xCenter, yCenter * 2), 10
LINE (0, yCenter)-(xCenter * 2, yCenter), 10

REM Berechnung des Start- und Endpunktes der Anzeige
x = 0
IF a > 0 THEN
        Status "Berechne Start- und Endpunkt..."
        DO
                x = x + 1
                IF (f#(x) + yCenter <= 0) OR (x + xCenter > (xCenter * 2)) THEN
                        EndPunkt = x
                        EXIT DO
                END IF
        LOOP
ELSEIF a < 0 THEN
        Status "Berechne Start- und Endpunkt..."
        DO
                x = x + 1
                IF (f#(x) + yCenter >= xCenter * 2) OR (x + xCenter > (xCenter * 2)) THEN
                        EndPunkt = x
                        EXIT DO
                END IF
        LOOP
ELSE
        PRINT
        PRINT "++ Fehler ++"
        PRINT
        COLOR 10: PRINT "a";
        COLOR 15: PRINT " ist = 0!"
        PRINT "Es kann so nur eine Gerade entstehen!"
        LINE (0, yCenter - c)-(xCenter * 2, yCenter - c), 14
        SLEEP: END
END IF

REM Den Startpunkt ermitteln
StartPunkt = -EndPunkt

REM kleine Pause
FOR i = 0 TO 40
        WAIT &H3DA, 8
          WAIT &H3DA, 8, 8
NEXT

REM Meldung erstatten
LOCATE 25, 4
PRINT STRING$(31, " ")
Status "Erzeuge Parabel..."

REM Parabel zeichnen
FOR x = StartPunkt TO EndPunkt STEP 1

        REM Der Funktionsaufruf f(x)
        y = f#(x)

        REM Variablen werden gerettet bzw. errechnet, damit nicht jeder
        REM einzelne Punkt errechnet werden muss.
        xcc = xc
        ycc = yc
        xc = x + xCenter
        yc = y + yCenter

        REM Die Hilfslinie wird erstellt, aber nicht im ersten Durchgang.
        IF ready = 1 THEN LINE (xc, yc)-(xcc, ycc), 14
        ready = 1

        REM Der eigentlich errechnete (und wieder umgerechnete) Parabelpunkt wird
        REM angezeigt
        PSET (xc, yc), 10

        REM Effektsteigerung durch eine kleine Pause
        WAIT &H3DA, 8
        WAIT &H3DA, 8, 8

NEXT

REM Erfolgsmeldung erstatten
LOCATE 25, 4
PRINT STRING$(18, " ")
Status "...fertig!"
SLEEP
END

REM Diese FUNCTION liefert die PArabelfunktionswerte zurck,
REM allerdings in modifizierter Form; siehe unten
FUNCTION f# (x AS DOUBLE)

        REM ACHTUNG: Diese Formel ist nur fr das Grafik-
        REM Koordinatensystemvon QuickBasic!
        REM Die korrekte Formel lautete:
        REM y = a * (x - b) ^ 2 + c

        f# = -a * (x - b) ^ 2 - c

END FUNCTION

REM Diese SUB zeigt einen Text an fester Stelle an
SUB Status (Text$)

        REM Zeige den Text an
        LOCATE 24, 4
        PRINT "---- Status ----"
        LOCATE 25, 4
        PRINT Text$

END SUB

