' **************************************************************************
'
' EasyCalc - Umrechenprogramm
'
' Copyright www.jb-electronics.de
'
' entwickelt vom 28.03.07 bis zum 28.04.07
'
' **************************************************************************

' **************************************************************************
' dynamische Arrays zulassen
'$DYNAMIC

' **************************************************************************
' allgemeine SUBs und FUNCTIONs:

' FUNCTIONs:
DECLARE FUNCTION GetDate$ ()
DECLARE FUNCTION TRIM$ (Ausdruck AS STRING)
DECLARE FUNCTION GetLines (FileName AS STRING)
DECLARE FUNCTION InputString$ (Ausdruck AS STRING, Taste AS STRING, MaxLength AS INTEGER)
DECLARE FUNCTION InputNumber$ (Ausdruck AS STRING, Taste AS STRING, MaxLength AS INTEGER)
DECLARE FUNCTION Runde$ (Wert AS DOUBLE, Length AS INTEGER)

' SUBs:
DECLARE SUB ClearScreen ()
DECLARE SUB DrawWindow (Title AS STRING, PosX AS INTEGER, PosY AS INTEGER, Zeilen AS INTEGER, Spalten AS INTEGER)
DECLARE SUB DrawBox (PosX AS INTEGER, PosY AS INTEGER, WidthX AS INTEGER, WidthY AS INTEGER)
DECLARE SUB PrintText (Zeile AS INTEGER, Spalte AS INTEGER, Text AS STRING)
DECLARE SUB ShowTitle ()

' **************************************************************************
' Die Mausroutinen
TYPE MouseInfoType
    PosX    AS INTEGER
    PosY    AS INTEGER
    Daten   AS INTEGER
    Buttons AS INTEGER
    TMP     AS INTEGER
END TYPE
DECLARE FUNCTION InitMouse% ()
DECLARE FUNCTION IsMouseClicked (MouseInfo AS ANY, Zeile AS INTEGER, Spalte AS INTEGER, SpaltenCount AS INTEGER)
DECLARE FUNCTION IsMouseOnceClicked (MouseInfo AS ANY, Zeile AS INTEGER, Spalte AS INTEGER, SpaltenCount AS INTEGER)
DECLARE FUNCTION IsMouseOverArea (MouseInfo AS ANY, Zeile AS INTEGER, ZeilenCount AS INTEGER, Spalte AS INTEGER, SpaltenCount AS INTEGER)
DECLARE SUB LoadMouse ()
DECLARE SUB SetMouse (PosX AS INTEGER, PosY AS INTEGER)
DECLARE SUB SetMouseInvisible ()
DECLARE SUB MouseDriver (AX AS INTEGER, BX AS INTEGER, CX AS INTEGER, DX AS INTEGER)
DECLARE SUB GetMouseData (MouseData AS MouseInfoType)
DECLARE SUB ShowMouse (MouseData AS MouseInfoType)
DIM SHARED AssemblerCode AS STRING

' **************************************************************************
' Die Kurse
TYPE KursTyp
    Caption AS STRING * 3
    Country AS STRING * 15
    Faktor  AS DOUBLE
END TYPE
DECLARE SUB ZeichneKurse (Zeile AS INTEGER, Spalte AS INTEGER, Kurse() AS KursTyp, MouseData AS MouseInfoType, Taste AS STRING, StartIndex AS INTEGER, EndIndex AS INTEGER, Selected AS INTEGER, Active AS INTEGER)
DECLARE SUB LadeKurse (Feld() AS KursTyp)
DECLARE SUB SpeicherKurse (Feld() AS KursTyp)

' **************************************************************************
' Der Bildschirmmodus (Doublebuffering im Textmodus)
SCREEN 0
WIDTH 80, 25
SCREEN 0, , 0, 1
COLOR 15, 1

' **************************************************************************
' Fehlerberhandlung
ON ERROR GOTO Fehler

' **************************************************************************
' Variablen deklarieren
DIM Taste AS STRING
DIM CurrentTask AS STRING
DIM Mouse AS MouseInfoType
DIM VonIndex AS INTEGER, NachIndex AS INTEGER, Index AS INTEGER
DIM VonSelected AS INTEGER, NachSelected AS INTEGER
DIM VonActive AS INTEGER, NachActive AS INTEGER
DIM Faktor AS DOUBLE, Wert1 AS DOUBLE, Wert2 AS DOUBLE
DIM Umzurechnen AS STRING, Umgerechnet AS STRING, EingabeAktiv AS INTEGER
DIM Cursor AS INTEGER, CursorDisplay AS INTEGER, AutoReset AS INTEGER
DIM AdaptIndex AS INTEGER, ChangeMode AS INTEGER
DIM CursorPosition AS INTEGER, TMP AS KursTyp
DIM Country AS STRING, Caption AS STRING, Kurs AS STRING
DIM NeuIndex AS INTEGER, NeuerKurs AS INTEGER

' **************************************************************************
' Konstanten
CONST FALSE = 0, TRUE = NOT FALSE

' **************************************************************************
' Pfad setzen?
CONST COMPILE = FALSE
IF COMPILE = FALSE THEN
    CHDIR "C:\EasyCalc"
END IF

' **************************************************************************
' Starttask auf das Hauptmen setzen
CurrentTask = "main"

' **************************************************************************
' Maus laden
CALL LoadMouse

' **************************************************************************
' Kurse laden
DIM Kurse(GetLines("data\kurs.dat")) AS KursTyp
CALL LadeKurse(Kurse())
VonIndex = 1
NachIndex = 1
VonSelected = 1
NachSelected = 1
VonActive = FALSE
NachActive = FALSE
CursorDisplay = TRUE
AutoReset = TRUE

' **************************************************************************
' Start des Hauptprogramms
DO

    ' Tastatur und Maus abfragen
    Taste = INKEY$
    CALL GetMouseData(Mouse)
   
    ' Bildschirm lschen und auf Strahlrcklauf warten
    CLS
    WAIT &H3DA, 8
    WAIT &H3DA, 8, 8

    ' Bildschirm "lschen"
    CALL ClearScreen

    ' Titel anzeigen
    CALL ShowTitle
  
    ' Welchen Task ausfhren?
    SELECT CASE LCASE$(CurrentTask)

        ' Das Hauptmen
        CASE "main"

            ' Men anzeigen
            CALL DrawWindow("EasyCalc - Hauptmen", 10, 7, 9, 60)
            CALL PrintText(9, 12, "Willkommen beim Einheitenumrechner EasyCalc!")
            CALL PrintText(11, 12, "[a] Umrechnen")
            CALL PrintText(12, 12, "[b] Hilfe")
            CALL PrintText(13, 12, "[c] Whrungen")
            CALL PrintText(14, 12, "[d] Zustzliche Informationen")
            CALL PrintText(15, 12, "[e] Beenden")

            ' Benutzereingaben auswerten
            IF LCASE$(Taste) = "a" OR IsMouseOnceClicked(Mouse, 11, 12, 13) THEN
                CurrentTask = "calculate"
                EingabeAktiv = FALSE
                Umzurechnen = ""
                VonIndex = 1
                NachIndex = 1
                VonSelected = 1
                NachSelected = 1
                VonActive = FALSE
                NachActive = FALSE

            ELSEIF LCASE$(Taste) = "b" OR IsMouseOnceClicked(Mouse, 12, 12, 9) THEN
                CurrentTask = "help"

            ELSEIF LCASE$(Taste) = "c" OR IsMouseOnceClicked(Mouse, 13, 12, 13) THEN
                CurrentTask = "adapt"
                AdaptIndex = 1
          
            ELSEIF LCASE$(Taste) = "d" OR IsMouseOnceClicked(Mouse, 14, 12, 29) THEN
                CurrentTask = "info"

            ELSEIF LCASE$(Taste) = "e" OR Taste$ = CHR$(27) OR IsMouseOnceClicked(Mouse, 15, 12, 11) THEN
                CurrentTask = "end"
            END IF

        ' Umrechnen
        CASE "calculate"

            ' Men anzeigen
            CALL DrawWindow("EasyCalc - Umrechnen", 4, 7, 15, 73)
            CALL DrawBox(6, 8, 17, 15)
            CALL PrintText(8, 8, "Von")
            CALL ZeichneKurse(8, 7, Kurse(), Mouse, Taste, VonIndex, VonIndex + 12, VonSelected, VonActive)
            CALL DrawBox(58, 8, 17, 15)
            CALL PrintText(8, 60, "Nach")
            CALL ZeichneKurse(8, 59, Kurse(), Mouse, Taste, NachIndex, NachIndex + 12, NachSelected, NachActive)
            CALL PrintText(19, 22, "Ĵ")
            CALL PrintText(20, 22, "[] [ ] Automatischer Reset []")
            CALL PrintText(21, 22, "[] [Umrechnung speichern]  []")
            CALL PrintText(22, 22, "")
            CALL DrawBox(24, 9, 33, 3)
            CALL PrintText(9, 26, "Ihr Betrag")
            CALL PrintText(10, 26, "[                       ] " + Kurse(VonSelected).Caption)
            CALL PrintText(10, 27, Umzurechnen)
            CALL DrawBox(24, 13, 33, 3)
            CALL PrintText(13, 26, "Umgerechnet")
            CALL PrintText(14, 26, "[                       ] " + Kurse(NachSelected).Caption)
            CALL PrintText(17, 24, "[a] Zurck")
            IF AutoReset = TRUE THEN
                CALL PrintText(20, 30, "x")
            END IF
          
            ' Buttons zum Steuern der Von-Box
            IF IsMouseOnceClicked(Mouse, 20, 23, 4) THEN
                IF VonSelected > 1 THEN
                    VonSelected = VonSelected - 1
                    IF VonSelected < VonIndex THEN
                        VonIndex = VonIndex - 1
                    END IF
                END IF
            ELSEIF IsMouseOnceClicked(Mouse, 21, 23, 4) THEN
                IF VonSelected < UBOUND(Kurse) THEN
                    VonSelected = VonSelected + 1
                    IF VonSelected > VonIndex + 12 THEN
                        VonIndex = VonIndex + 1
                    END IF
                END IF
            END IF

            ' Buttons zum Steuern der Nach-Box
            IF IsMouseOnceClicked(Mouse, 20, 54, 4) THEN
                IF NachSelected > 1 THEN
                    NachSelected = NachSelected - 1
                    IF NachSelected < NachIndex THEN
                        NachIndex = NachIndex - 1
                    END IF
                END IF
            ELSEIF IsMouseOnceClicked(Mouse, 21, 54, 4) THEN
                IF NachSelected < UBOUND(Kurse) THEN
                    NachSelected = NachSelected + 1
                    IF NachSelected > NachIndex + 12 THEN
                        NachIndex = NachIndex + 1
                    END IF
                END IF
            END IF
          
            ' Checkbox angeklickt?
            IF IsMouseOnceClicked(Mouse, 20, 29, 23) THEN
                AutoReset = AutoReset XOR 1
            END IF
           
            ' Speicherbutton angeklickt?
            IF IsMouseOnceClicked(Mouse, 21, 29, 22) THEN
                f = FREEFILE
                OPEN "CALC.TXT" FOR APPEND AS #f
                    PRINT #f, "Rechnung von EasyCalc am " + GetDate$ + " um " + TIME$ + ":"
                    PRINT #f, TRIM$(Umzurechnen) + " " + Kurse(VonSelected).Caption + " (" + TRIM$(Kurse(VonSelected).Country) + ") = " + TRIM$(Umgerechnet) + " " + Kurse(NachSelected).Caption + " (" + TRIM$(Kurse(NachSelected).Country) + ")"
                    PRINT #f,
                CLOSE #f
            END IF

            ' Textbox aktiviert?
            IF IsMouseOverArea(Mouse, 9, 3, 24, 33) THEN
                EingabeAktiv = TRUE
                IF AutoReset = TRUE THEN
                    Umzurechnen = ""
                END IF
            ELSEIF Mouse.Buttons THEN
                EingabeAktiv = FALSE
            END IF
           
            ' Benutzerengaben auswerten
            IF EingabeAktiv = FALSE AND ((LCASE$(Taste) = "a" OR Taste = CHR$(27) OR IsMouseOnceClicked(Mouse, 17, 24, 10))) THEN
                CurrentTask = "main"
            END IF

            ' Eingaberoutine fr die Textbox
            IF EingabeAktiv THEN
               
                ' Cursor blinken lassen
                Cursor = Cursor + 1
                IF Cursor > 50 THEN Cursor = 0
                IF (Cursor < 25) AND (CursorDisplay = TRUE) THEN
                    IF LEN(Umzurechnen) < 23 THEN
                        CALL PrintText(10, 27 + LEN(Umzurechnen), "")
                    ELSE
                        CALL PrintText(10, 26 + LEN(Umzurechnen), "")
                    END IF
                END IF

                ' Wert eingeben
                Umzurechnen = InputNumber$(Umzurechnen, Taste, 23)
                IF Taste = CHR$(13) THEN
                    EingabeAktiv = FALSE
                END IF

            END IF

            ' Wert umrechnen
            Faktor = Kurse(NachSelected).Faktor / Kurse(VonSelected).Faktor
            Wert1 = VAL(Umzurechnen)
            Wert2 = Wert1 * Faktor

            ' Wert runden?
            IF LEN(Taste) OR Mouse.Buttons THEN
                Umgerechnet = Runde$(Wert2, 23)
            END IF

            ' Wert ausgeben
            IF LEN(TRIM$(Umzurechnen)) THEN
                CALL PrintText(14, 27, Umgerechnet)
            END IF

        ' Hilfe
        CASE "help"

            ' Men zeichnen
            CALL DrawWindow("EasyCalc - Hilfe", 8, 7, 11, 64)
            CALL PrintText(9, 10, "Willkommen in der Hilfe zu EasyCalc!")
            CALL PrintText(10, 10, "Whlen Sie einen der Unterbereiche aus, zu denen Sie")
            CALL PrintText(11, 10, "mehr Informationen erhalten wollen:")
            CALL PrintText(13, 10, "[a] Einfaches Umrechnen eines Betrages")
            CALL PrintText(14, 10, "[b] Das Bearbeiten von Whrungen")
            CALL PrintText(15, 10, "[c] Das Implementieren von neuen Whrungen")
            CALL PrintText(17, 10, "[d] Zurck")

            ' Benutzereingaben auswerten
            IF LCASE$(Taste) = "a" OR IsMouseOnceClicked(Mouse, 13, 10, 38) THEN
                CurrentTask = "help_calculate"

            ELSEIF LCASE$(Taste) = "b" OR IsMouseOnceClicked(Mouse, 14, 10, 32) THEN
                CurrentTask = "help_adapt"

            ELSEIF LCASE$(Taste) = "c" OR IsMouseOnceClicked(Mouse, 15, 10, 42) THEN
                CurrentTask = "help_new"

            ELSEIF LCASE$(Taste) = "d" OR Taste = CHR$(27) OR IsMouseOnceClicked(Mouse, 17, 10, 10) THEN
                CurrentTask = "main"
            END IF

        ' Whrungen bearbeiten/hinzufgen
        CASE "adapt"

            ' Das Men zeichnen
            CALL DrawWindow("EasyCalc - Whrungen", 8, 7, 13, 64)
            CALL PrintText(9, 10, "Hier knnen Sie bestehende Whrungen/Kurse bearbeiten oder")
            CALL PrintText(10, 10, "neue Whrungen hinzufgen.")
            CALL DrawBox(10, 12, 34, 5)
            CALL PrintText(12, 12, "Daten")
            CALL PrintText(13, 43, "Ŀ")
            CALL PrintText(14, 43, " []  [Lschen] ")
            CALL PrintText(15, 43, " []  [Neu...]  ")
            CALL PrintText(16, 43, "")
            CALL PrintText(18, 10, "[a] Zurck und nderungen speichern")
            CALL PrintText(19, 10, "[b] Zurck und nderungen verwerfen")
            IF UBOUND(Kurse) OR NeuerKurs THEN
                CALL PrintText(13, 12, "Land/Region: [               ]")
                CALL PrintText(14, 12, "Whrung    : [   ]")
                CALL PrintText(15, 12, "Kurs       : [               ]")
                CALL PrintText(13, 26, Kurse(AdaptIndex).Country)
                CALL PrintText(14, 26, Kurse(AdaptIndex).Caption)
                CALL PrintText(15, 26, TRIM$(STR$(Kurse(AdaptIndex).Faktor)))
            ELSE
                CALL PrintText(14, 12, "Keine Kurse vorhanden...")
            END IF
          
            ' Cursor blinken lassen
            Cursor = Cursor + 1
            IF Cursor > 50 THEN
                Cursor = 0
            END IF
           
            ' Cursor anzeigen
            IF Cursor < 25 THEN
                IF ChangeMode = 1 THEN
                    IF LEN(TRIM$(Country)) < 15 THEN
                        CALL PrintText(13, 26 + LEN(TRIM$(Country)), "")
                    ELSE
                        CALL PrintText(13, 40, "")
                    END IF
                ELSEIF ChangeMode = 2 THEN
                    IF LEN(TRIM$(Caption)) < 3 THEN
                        CALL PrintText(14, 26 + LEN(TRIM$(Caption)), "")
                    ELSE
                        CALL PrintText(14, 26 + LEN(TRIM$(Caption)) - 1, "")
                    END IF
                ELSEIF ChangeMode = 3 THEN
                    IF LEN(TRIM$(Kurs)) < 15 THEN
                        CALL PrintText(15, 26 + LEN(TRIM$(Kurs)), "")
                    ELSE
                        CALL PrintText(15, 26 + LEN(TRIM$(Kurs)) - 1, "")
                    END IF
                END IF
            END IF

            ' Buttons angeklickt?
           
            ' Pfeil nach oben
            IF IsMouseOnceClicked(Mouse, 14, 45, 5) THEN
                IF UBOUND(Kurse) THEN
                    IF AdaptIndex > 1 THEN
                        AdaptIndex = AdaptIndex - 1
                    END IF
                END IF
          
            ' Pfeil nach unten
            ELSEIF IsMouseOnceClicked(Mouse, 15, 45, 5) THEN
                IF UBOUND(Kurse) THEN
                    IF AdaptIndex < UBOUND(Kurse) THEN
                        AdaptIndex = AdaptIndex + 1
                    END IF
                END IF
           
            ' Whrung lschen
            ELSEIF IsMouseOnceClicked(Mouse, 14, 52, 9) THEN
                IF UBOUND(Kurse) > 1 THEN
                    Kurse(AdaptIndex).Caption = ""
                    REDIM TmpKurse(UBOUND(Kurse) - 1) AS KursTyp
                    IF UBOUND(TmpKurse) THEN
                        Index = 1
                        NeuIndex = 1
                        FOR Index = 1 TO UBOUND(Kurse) STEP 1
                            IF TRIM$(Kurse(Index).Caption) <> "" THEN
                                TmpKurse(NeuIndex) = Kurse(Index)
                                NeuIndex = NeuIndex + 1
                            END IF
                        NEXT Index
                        REDIM Kurse(UBOUND(TmpKurse)) AS KursTyp
                        FOR Index = 1 TO UBOUND(TmpKurse) STEP 1
                            Kurse(Index) = TmpKurse(Index)
                        NEXT Index
                        IF AdaptIndex > UBOUND(Kurse) THEN
                            AdaptIndex = UBOUND(Kurse)
                        END IF
                    END IF
                ELSE
                    REDIM Kurse(0) AS KursTyp
                END IF

            ' neue Whrung
            ELSEIF IsMouseOnceClicked(Mouse, 15, 52, 8) AND NeuerKurs = FALSE THEN
                REDIM TmpKurse(UBOUND(Kurse)) AS KursTyp
                FOR Index = 1 TO UBOUND(Kurse) STEP 1
                    TmpKurse(Index) = Kurse(Index)
                NEXT Index
                REDIM Kurse(UBOUND(Kurse) + 1) AS KursTyp
                FOR Index = 1 TO UBOUND(Kurse) - 1 STEP 1
                    Kurse(Index) = TmpKurse(Index)
                NEXT Index
                AdaptIndex = Index
                Country = ""
                Kurse(AdaptIndex).Country = ""
                Caption = ""
                Kurse(AdaptIndex).Caption = ""
                Kurs = "1"
                Kurse(AdaptIndex).Faktor = 1
                NeuerKurs = TRUE
            END IF

            ' Welche Eigenschaft ndern?
            IF IsMouseOnceClicked(Mouse, 13, 12, 30) THEN
                Country = TRIM$(Kurse(AdaptIndex).Country)
                ChangeMode = 1
            ELSEIF IsMouseOnceClicked(Mouse, 14, 12, 18) THEN
                Caption = TRIM$(Kurse(AdaptIndex).Caption)
                ChangeMode = 2
            ELSEIF IsMouseOnceClicked(Mouse, 15, 12, 30) THEN
                Kurs = TRIM$(STR$(Kurse(AdaptIndex).Faktor))
                ChangeMode = 3
            ELSEIF Mouse.Buttons AND 1 THEN
                ChangeMode = 0
            END IF
          
            ' Landesnamen ndern?
            IF ChangeMode = 1 THEN
                Country = InputString$(Country, Taste, 15)
                Kurse(AdaptIndex).Country = Country
          
            ' Whrungsnamen ndern?
            ELSEIF ChangeMode = 2 THEN
                Caption = InputString$(Caption, Taste, 3)
                Kurse(AdaptIndex).Caption = Caption
          
            ' Kurs ndern?
            ELSEIF ChangeMode = 3 THEN
                Kurs = InputNumber$(Kurs, Taste, 15)
                Kurse(AdaptIndex).Faktor = VAL(Kurs)
            END IF
          
            ' Eingabe beendet?
            IF Taste = CHR$(13) THEN
                ChangeMode = 0
            END IF

            ' Benutzereingaben auswerten
            IF ChangeMode = 0 THEN
                ' Speichern
                IF LCASE$(Taste) = "a" OR IsMouseOnceClicked(Mouse, 18, 10, 35) THEN
                    IF NeuerKurs THEN
                        IF LEN(TRIM$(Country)) AND LEN(TRIM$(Caption)) AND VAL(Kurs) <> 0 THEN
                           CALL SpeicherKurse(Kurse())
                           CurrentTask = "main"
                        END IF
                        NeuerKurs = FALSE
                    ELSE
                        CALL SpeicherKurse(Kurse())
                        CurrentTask = "main"
                    END IF
                ' Reset
                ELSEIF LCASE$(Taste) = "b" OR Taste$ = CHR$(27) OR IsMouseOnceClicked(Mouse, 19, 10, 35) THEN
                    REDIM Kurse(GetLines("data\kurs.dat")) AS KursTyp
                    CALL LadeKurse(Kurse())
                    CurrentTask = "main"
                END IF
            END IF

        ' zustzliche Informationen
        CASE "info"

            ' Men zeichnen
            CALL DrawWindow("EasyCalc - Informationen", 8, 7, 12, 64)
            CALL PrintText(9, 10, "EasyCalc wurde programmiert von jb (jbsoft) fr den")
            CALL PrintText(10, 10, "Offiziellen QuickBASIC- und freeBASIC-Programmierwettbewerb.")
            CALL PrintText(12, 10, "Dieses Programm ist Freeware und darf unter Einhaltung der")
            CALL PrintText(13, 10, "in der Readme angegebenen Bestimmungen beliebig weitergege-")
            CALL PrintText(14, 10, "ben werden.")
            CALL PrintText(16, 10, "[a] Zurck")
            CALL PrintText(18, 10, "Viel Spa nun mit EasyCalc,")
            CALL PrintText(19, 10, "Jens Boos")

            ' Tastatureingaben auswerten
            IF LCASE$(Taste) = "a" OR Taste = CHR$(27) THEN
                CurrentTask = "main"
            END IF

            ' Mausklicks auswerten
            IF IsMouseOnceClicked(Mouse, 16, 10, 10) THEN
                CurrentTask = "main"
            END IF

        ' Programm beenden
        CASE "end"
           
            ' Men zeichnen
            CALL DrawWindow("EasyCalc - Beenden", 16, 8, 6, 45)
            CALL PrintText(10, 18, "EasyCalc wirklich beenden?")
            CALL PrintText(12, 18, "[a] Ja")
            CALL PrintText(13, 18, "[b] Nein")

            ' Tastatureingaben auswerten
            IF (LCASE$(Taste) = "a") OR (Taste = CHR$(27)) THEN
                EXIT DO
            ELSEIF (LCASE$(Taste) = "b") THEN
                CurrentTask = "main"
            END IF

            ' Mausklicks auswerten
            IF IsMouseOnceClicked(Mouse, 12, 18, 6) THEN
                EXIT DO
            ELSEIF IsMouseOnceClicked(Mouse, 13, 18, 8) THEN
                CurrentTask = "main"
            END IF

        ' Hilfe zum Umrechnen eines Betrages
        CASE "help_calculate"

            ' Das Men zeichnen
            CALL DrawWindow("EasyCalc - Einen Betrag umrechnen", 3, 7, 15, 75)
            CALL PrintText(9, 5, "1) Whlen Sie im Hauptmen den Menpunkt " + CHR$(34) + "[a] Umrechnen" + CHR$(34) + ".")
            CALL PrintText(11, 5, "2) Klicken Sie in die obere Textbox und geben Sie Ihren umzurechnenden")
            CALL PrintText(12, 5, "   Betrag ein. Whlen Sie nun in der Liste " + CHR$(34) + "Von" + CHR$(34) + " durch Klicken die")
            CALL PrintText(13, 5, "   Nationalitt, in dessen Whrung Ihr Betrag steht. Whlen Sie analog")
            CALL PrintText(14, 5, "   dazu in der Liste " + CHR$(34) + "Nach" + CHR$(34) + " die Whrung, in die Ihr Betrag umgerechnet")
            CALL PrintText(15, 5, "   werden soll.")
            CALL PrintText(16, 5, "   Benutzen Sie dabei die Pfeil-Buttons oder -Tasten, um sich in der")
            CALL PrintText(17, 5, "   Liste zu bewegen.")
            CALL PrintText(19, 5, "3) Der umgerechnete Betrag erscheint nun in der unteren Textbox.")
            CALL PrintText(21, 5, "[a] Zurck")
           
            ' Benutzereingaben auswerten
            IF LCASE$(Taste) = "a" OR Taste = CHR$(27) OR IsMouseOnceClicked(Mouse, 21, 5, 10) THEN
                CurrentTask = "help"
            END IF

        ' Hilfe zum Bearbeiten von Whrungen
        CASE "help_adapt"

            ' Das Men zeichnen
            CALL DrawWindow("EasyCalc - Das Bearbeiten von Whrungen", 4, 7, 13, 73)
            CALL PrintText(9, 6, "1) Whlen Sie im Hauptmen den Menpunkt " + CHR$(34) + "[c] Whrungen" + CHR$(34) + ".")
            CALL PrintText(11, 6, "2) In der Box " + CHR$(34) + "Daten" + CHR$(34) + " knnen Sie die Angaben innerhalb der Textboxen")
            CALL PrintText(12, 6, "   verndern, indem Sie diese anklicken, den neuen Wert eingeben und")
            CALL PrintText(13, 6, "   mit ENTER besttigen. Um die aktuelle Whrung zu lschen, klicken")
            CALL PrintText(14, 6, "   bitte den Button [Lschen] an.")
            CALL PrintText(16, 6, "3) Um diese nderungen zu speichern, whlen Sie Menpunkt [a]. Um sie")
            CALL PrintText(17, 6, "   zu verwerfen, whlen Sie bitte Menpunkt [b].")
            CALL PrintText(19, 6, "[a] Zurck")
          
            ' Benutzereingaben auswerten
            IF LCASE$(Taste) = "a" OR Taste = CHR$(27) OR IsMouseOnceClicked(Mouse, 19, 6, 10) THEN
                CurrentTask = "help"
            END IF

        ' Hilfe zum Erstellen neuer Whrungen
        CASE "help_new"

            ' Das Men zeichnen
            CALL DrawWindow("EasyCalc - Das Erstellen neuer Whrungen", 4, 7, 14, 73)
            CALL PrintText(9, 6, "1) Whlen Sie im Hauptmen den Menpunkt " + CHR$(34) + "[c] Whrungen" + CHR$(34) + ".")
            CALL PrintText(11, 6, "2) Klicken Sie auf den Button [Neu...] und geben Sie die Daten der")
            CALL PrintText(12, 6, "   neuen Whrung in der Box " + CHR$(34) + "Daten" + CHR$(34) + " an, indem Sie die Textboxen")
            CALL PrintText(13, 6, "   anklicken, Ihren Wert eingeben und mit ENTER besttigen.")
            CALL PrintText(14, 6, "   Um mehrere neue Whrungen zu erstellen, knnen Sie diesen Schritt")
            CALL PrintText(15, 6, "   beliebig oft wiederholen.")
            CALL PrintText(17, 6, "3) Um diese nderungen zu speichern, whlen Sie Menpunkt [a]. Um sie")
            CALL PrintText(18, 6, "   zu verwerfen, whlen Sie bitte Menpunkt [b].")
            CALL PrintText(20, 6, "[a] Zurck")

            ' Benutzereingaben auswerten
            IF LCASE$(Taste) = "a" OR Taste = CHR$(27) OR IsMouseOnceClicked(Mouse, 20, 6, 10) THEN
                CurrentTask = "help"
            END IF
      
    END SELECT
   
    ' In Primrpufer kopieren
    PCOPY 0, 1

LOOP
END

' ***************************************************************************
' Fehlerbehandlung
Fehler:

 CLS
 CALL ClearScreen
 CALL ShowTitle
 CALL DrawWindow("EasyCalc - Programmfehler", 11, 8, 7, 60)
 CALL PrintText(10, 13, "Der Fehler Nr. " + TRIM$(STR$(ERR)) + " ist aufgetreten.")
 CALL PrintText(12, 13, "EasyCalc muss beendet werden.")
 CALL PrintText(14, 13, "[Beliebige Taste]")
 PCOPY 0, 1

 ' Benutzereingaben auswerten
 DO
  Taste = INKEY$
  IF LEN(TRIM$(Taste)) THEN
   EXIT DO
  END IF
 LOOP
 END

' **************************************************************************
' Assemblercode fr die Mausroutine
MouseCode:
DATA 55, 89, E5, 8B, 5E, 0C, 8B, 07, 50, 8B, 5E, 0A, 8B, 07, 50, 8B
DATA 5E, 08, 8B, 0F, 8B, 5E, 06, 8B, 17, 5B, 58, 1E, 07, CD, 33, 53
DATA 8B, 5E, 0C, 89, 07, 58, 8B, 5E, 0A, 89, 07, 8B, 5E, 08, 89, 0F
DATA 8B, 5E, 06, 89, 17, 5D, CA, 08, 00

REM $STATIC
SUB ClearScreen

    ' Variablen
    DIM Count AS INTEGER

    ' Bildschirm leeren
    COLOR 7
    FOR Count = 1 TO 25 STEP 1
        LOCATE Count, 1: PRINT STRING$(80, CHR$(178));
    NEXT Count
    COLOR 15, 1

END SUB

SUB DrawBox (PosX AS INTEGER, PosY AS INTEGER, WidthX AS INTEGER, WidthY AS INTEGER)

    ' Variablen
    DIM Count AS INTEGER

    ' Box zeichnen
    CALL PrintText(PosY, PosX, "" + STRING$(WidthX - 2, "") + "")
    FOR Count = PosY + 1 TO PosY + WidthY - 2 STEP 1
        CALL PrintText(Count, PosX, "" + STRING$(WidthX - 2, " ") + "")
    NEXT Count
    CALL PrintText(Count, PosX, "" + STRING$(WidthX - 2, "") + "")

END SUB

SUB DrawWindow (Title AS STRING, PosX AS INTEGER, PosY AS INTEGER, Zeilen AS INTEGER, Spalten AS INTEGER)

    ' Variablen
    DIM LO AS STRING, RO AS STRING, LU AS STRING, RU AS STRING
    DIM HB AS STRING, VB AS STRING, S AS STRING
    DIM Ausgleich AS STRING, LeerDBL AS DOUBLE, Leer AS INTEGER
    DIM Ueberschrift AS STRING, LetzteZeile AS STRING, Zeile AS STRING
    DIM Counter AS INTEGER

    ' Die einzelnen Zeichen definieren
    LO = ""
    RO = ""
    LU = ""
    RU = ""
    HB = ""
    VB = ""
    S = ""

    ' Titel zentrieren
    LeerDBL = ((Spalten - LEN(Title)) / 2) - 2

    ' Wenn es eine ungerade Zahl ergibt, links eine Leerstelle anfgen
    Leer = INT(LeerDBL)
    IF LeerDBL <> Leer THEN
        Ausgleich = HB
    ELSE
        Ausgleich = ""
    END IF

    ' berschrift und letzte Zeile erstellen und aufzeichnen
    Ueberschrift = LO + Ausgleich + STRING$(INT(Leer), HB) + "[" + Title + "]" + STRING$(Leer, HB) + RO
    LetzteZeile = LU + STRING$(Spalten - 2, HB) + RU
    COLOR 15, 1: CALL PrintText(PosY, PosX, Ueberschrift)
   
    ' restliche Zeilen anzeigen
    FOR Counter = PosY + 1 TO PosY + Zeilen STEP 1

        Zeile = VB + STRING$(LEN(Ueberschrift) - 2, " ") + VB
        COLOR 15, 1: CALL PrintText(Counter, PosX, Zeile)
        COLOR 0: PRINT S

    NEXT Counter

    ' Und die letzte Zeile ausgeben
    COLOR 15, 1: LOCATE Counter, PosX: PRINT LetzteZeile;
    COLOR 0: PRINT S;
    CALL PrintText(Counter + 1, PosX + 1, STRING$(LEN(LetzteZeile), S))

    ' Farben rsetten
    COLOR 15, 1

END SUB

FUNCTION GetDate$

    ' Variablen
    DIM Tag AS STRING, Monat AS STRING, Jahr AS STRING, Datum AS STRING

    ' Datum extrahieren
    Datum = DATE$
    Tag = MID$(Datum, 4, 2)
    Monat = LEFT$(Datum, 2)
    Jahr = RIGHT$(Datum, 2)
    Datum = Tag + "." + Monat + "." + Jahr

    ' Wert zurckgeben
    GetDate$ = Datum

END FUNCTION

FUNCTION GetLines (FileName AS STRING)

    ' Variablen
    DIM f AS INTEGER, Zeilen AS INTEGER
    DIM Dummy AS STRING

    ' Datei ffnen und Zeilen zhlen
    f = FREEFILE
    OPEN FileName FOR INPUT AS #f
    DO UNTIL EOF(f)
        LINE INPUT #f, Dummy
        IF LEN(Dummy) THEN Zeilen = Zeilen + 1
    LOOP
    CLOSE #f

    ' Wert zurckgeben
    GetLines = Zeilen

END FUNCTION

SUB GetMouseData (MouseData AS MouseInfoType)

    ' Variablen
    DIM AX AS INTEGER, BX AS INTEGER, CX AS INTEGER, DX AS INTEGER

    ' Mausinformationen holen
    AX = 3
    MouseDriver AX, BX, CX, DX
    MouseData.Daten = BX
    MouseData.PosX = CX \ 8 + 1
    MouseData.PosY = DX \ 8 + 1

    ' Tasten entprellen
    MouseData.Buttons = MouseData.Daten
    IF (MouseData.Buttons <> MouseData.TMP) THEN
        MouseData.TMP = MouseData.Buttons
        IF MouseData.TMP AND 1 THEN
            MouseData.Buttons = MouseData.Buttons AND 1
        END IF
    ELSE
        MouseData.Buttons = 0
    END IF

END SUB

FUNCTION InitMouse%

    ' Variablen
    DIM AX AS INTEGER

    ' Register setzen
    AX = 0
    MouseDriver AX, 0, 0, 0
    InitMouse% = AX

END FUNCTION

FUNCTION InputNumber$ (Ausdruck AS STRING, Taste AS STRING, MaxLength AS INTEGER)

    ' Variablen
    DIM Eingabe AS STRING

    ' aktuellen Wert bernehmen
    Eingabe = Ausdruck
   
    ' Eingaben auswerten
    SELECT CASE LCASE$(Taste)
        
        ' Backspace
        CASE CHR$(8)
            IF LEN(Eingabe) THEN
                Eingabe = LEFT$(Eingabe, LEN(Eingabe) - 1)
                Cursor = 0
            END IF
       
        CASE "0" TO "9"
            IF LEN(Eingabe) < MaxLength THEN
                Eingabe = Eingabe + Taste
                Cursor = 0
            END IF
       
        CASE ".", ","
            IF INSTR(Eingabe, ".") = FALSE AND LEN(Eingabe) < MaxLength THEN
                Eingabe = Eingabe + "."
                Cursor = 0
            END IF
       
        CASE "-"
            IF LEN(Eingabe) = 0 THEN
                Eingabe = "-"
                Cursor = 0
            END IF
   
    END SELECT

    ' Wert zurckgeben
    InputNumber$ = Eingabe

END FUNCTION

FUNCTION InputString$ (Ausdruck AS STRING, Taste AS STRING, MaxLength AS INTEGER)

    ' Variablen
    DIM Eingabe AS STRING

    ' Wert bernehmen
    Eingabe = Ausdruck
  
    ' welche Eingabe?
    SELECT CASE LCASE$(Taste)

        ' Escape
        CASE CHR$(27)
            Eingabe = ""

        ' Backspace
        CASE CHR$(8)
            IF LEN(Eingabe) THEN
                Eingabe = LEFT$(Eingabe, LEN(Eingabe) - 1)
            END IF

        ' Sonstiges
        CASE IS > CHR$(31)
            IF LEN(Eingabe) < MaxLength THEN
                Eingabe = Eingabe + Taste
            END IF
           
    END SELECT

    ' Wert zurckgeben
    InputString$ = Eingabe

END FUNCTION

FUNCTION IsMouseClicked (MouseInfo AS MouseInfoType, Zeile AS INTEGER, Spalte AS INTEGER, SpaltenCount AS INTEGER)

    IsMouseClicked = 0
    IF (MouseInfo.PosY = Zeile) THEN
        IF (MouseInfo.PosX >= Spalte) AND (MouseInfo.PosX <= Spalte + SpaltenCount - 1) THEN
            IF (MouseInfo.Daten AND 1) THEN
                IsMouseClicked = -1
            END IF
        END IF
    END IF

END FUNCTION

FUNCTION IsMouseOnceClicked (MouseInfo AS MouseInfoType, Zeile AS INTEGER, Spalte AS INTEGER, SpaltenCount AS INTEGER)

    IsMouseOnceClicked = FALSE
    IF (MouseInfo.PosY = Zeile) THEN
        IF (MouseInfo.PosX >= Spalte) AND (MouseInfo.PosX <= Spalte + SpaltenCount - 1) THEN
            IF (MouseInfo.Buttons AND 1) THEN
                IsMouseOnceClicked = TRUE
            END IF
        END IF
    END IF

END FUNCTION

FUNCTION IsMouseOverArea (MouseInfo AS MouseInfoType, Zeile AS INTEGER, ZeilenCount AS INTEGER, Spalte AS INTEGER, SpaltenCount AS INTEGER)

    IsMouseOverArea = FALSE
    IF (MouseInfo.PosY >= Zeile) AND (MouseInfo.PosY <= Zeile + ZeilenCount - 1) THEN
        IF (MouseInfo.PosX >= Spalte) AND (MouseInfo.PosX <= Spalte + SpaltenCount - 1) THEN
            IF (MouseInfo.Buttons AND 1) THEN
                IsMouseOverArea = TRUE
            END IF
        END IF
    END IF


END FUNCTION

SUB LadeKurse (Feld() AS KursTyp)

    ' Variablen
    DIM f AS INTEGER, Index AS INTEGER
    DIM Dummy1 AS STRING, Dummy2 AS STRING

    ' Kursdatei ffnen
    f = FREEFILE
    OPEN "data\kurs.dat" FOR INPUT AS #f
        FOR Index = 1 TO UBOUND(Feld) STEP 1
           INPUT #f, Dummy1, Dummy2, Feld(Index).Faktor
           Feld(Index).Caption = LEFT$(Dummy1, 3)
           Feld(Index).Country = LEFT$(Dummy2, 15)
        NEXT Index
    CLOSE #f

END SUB

SUB LoadMouse

    ' Variablen
    DIM Zeichen AS STRING
    DIM Index AS INTEGER, InitOK AS INTEGER

    ' DATA-Block auswhlen
    RESTORE MouseCode

    ' Assembler-String generieren
    AssemblerCode = SPACE$(57)
    FOR Index = 1 TO 57 STEP 1
     READ Zeichen
     MID$(AssemblerCode, Index, 1) = CHR$(VAL("&h" + Zeichen))
    NEXT Index

    ' Maus vorhanden?
    InitOK = InitMouse%
    CALL SetMouseInvisible

END SUB

SUB MouseDriver (AX AS INTEGER, BX AS INTEGER, CX AS INTEGER, DX AS INTEGER)

    ' Variablen
    DIM Pointer AS INTEGER
 
    ' Assemblerprogramm ausfhren
    DEF SEG = VARSEG(AssemblerCode)
        Pointer = SADD(AssemblerCode)
        CALL Absolute(AX, BX, CX, DX, Pointer)
    DEF SEG

END SUB

SUB PrintText (Zeile AS INTEGER, Spalte AS INTEGER, Text AS STRING)

 LOCATE Zeile, Spalte: PRINT Text;

END SUB

FUNCTION Runde$ (Wert AS DOUBLE, Length AS INTEGER)

    ' Variablen
    DIM FormatString AS STRING, Zeichen AS STRING, Zahl AS STRING, Fertig AS STRING
    DIM Index AS INTEGER, f AS INTEGER

    ' Wert in temporre Datei schreiben
    f = FREEFILE
    OPEN "data/tmp.dat" FOR OUTPUT AS #f
    IF (Wert < 1) AND (Wert > -1) THEN
        PRINT #f, USING "+#.############"; Wert
    ELSE
        PRINT #f, Wert
    END IF
    CLOSE #f
    f = FREEFILE
    OPEN "data/tmp.dat" FOR INPUT AS #f
        LINE INPUT #f, Zahl
    CLOSE #f
    KILL "data/tmp.dat"

    ' bestmgliche Formatierung des errechneten Wertes ermitteln
    FormatString = ""
    FOR Index = 1 TO LEN(TRIM$(Zahl)) STEP 1
        Zeichen = MID$(TRIM$(Zahl), Index, 1)
        SELECT CASE Zeichen
            CASE "-"
                FormatString = "+"
            CASE "0" TO "9"
                FormatString = FormatString + "#"
            CASE "."
                IF Index = 1 THEN
                    FormatString = FormatString + "#."
                 ELSE
                    FormatString = FormatString + "."
                END IF
        END SELECT
    NEXT Index

    ' Wert mit neuem Format in temporre Datei schreiben
    f = FREEFILE
    OPEN "data/tmp.dat" FOR OUTPUT AS #f
        PRINT #f, USING FormatString; VAL(Zahl)
    CLOSE #f
    OPEN "data/tmp.dat" FOR INPUT AS #f
        LINE INPUT #f, Zahl
    CLOSE #f
    KILL "data/tmp.dat"

    ' Ausgabestring erstellen
    Fertig = SPACE$(Length)
    RSET Fertig = Zahl
    Runde$ = Fertig

END FUNCTION

SUB SetMouse (PosX AS INTEGER, PosY AS INTEGER)

    ' Variablen
    DIM AX AS INTEGER, BX AS INTEGER, CX AS INTEGER, DX AS INTEGER

    ' Register setzen
    AX = 4
    CX = PosX
    DX = PosY
    MouseDriver AX, BX, CX, DX

END SUB

SUB SetMouseInvisible
 
    ' Variablen
    DIM AX AS INTEGER
   
    ' Register setzen
    AX = 2
    MouseDriver AX, 0, 0, 0

END SUB

SUB ShowTitle

    ' Box mit Datum, Uhrzeit und Schatten zeichnen
    COLOR 15, 1
    LOCATE 2, 17: PRINT "" + STRING$(44, "") + ""
    LOCATE 3, 17: PRINT " EasyCalc by jbsoft  " + GetDate$ + "  " + TIME$ + " ";
    COLOR 0: PRINT ""

    ' Unteres Ende der Box mit Schatten zeichnen
    COLOR 15, 1: LOCATE 4, 17: PRINT "" + STRING$(44, "") + "";
    COLOR 0: PRINT ""

    ' unteren Schatten zeichnen
    LOCATE 5, 18: PRINT STRING$(46, "")

    ' Farbe zurcksetzen
    COLOR 15, 1

END SUB

SUB SpeicherKurse (Feld() AS KursTyp)

    ' Variablen
    DIM f AS INTEGER, Index AS INTEGER
   
    ' Kursdatei ffnen
    f = FREEFILE
    OPEN "data\kurs.dat" FOR OUTPUT AS #f
        FOR Index = 1 TO UBOUND(Feld) STEP 1
           WRITE #f, Feld(Index).Caption, Feld(Index).Country, Feld(Index).Faktor
        NEXT Index
    CLOSE #f

END SUB

FUNCTION TRIM$ (Ausdruck AS STRING)

    TRIM$ = RTRIM$(LTRIM$(Ausdruck))

END FUNCTION

SUB ZeichneKurse (Zeile AS INTEGER, Spalte AS INTEGER, Kurse() AS KursTyp, MouseData AS MouseInfoType, Taste AS STRING, StartIndex AS INTEGER, EndIndex AS INTEGER, Selected AS INTEGER, Active AS INTEGER)

    ' Variablen
    DIM Index AS INTEGER, Zaehler AS INTEGER
    DIM OldIndex AS INTEGER

    ' Box aktiviert?
    IF IsMouseOverArea(MouseData, Zeile, EndIndex - StartIndex + 3, Spalte - 1, 17) THEN
        Active = TRUE
    ELSEIF (MouseData.Buttons AND 1) THEN
        Active = FALSE
    END IF

    ' Kurse zeichnen
    FOR Index = StartIndex TO EndIndex STEP 1
        IF Index <= UBOUND(Kurse) THEN
            Zaehler = Zaehler + 1
            IF IsMouseOnceClicked(MouseData, Zeile + Zaehler, Spalte, 15) THEN
                Selected = Index
            END IF
            IF Selected = Index THEN
                COLOR 1, 15
            ELSE
                COLOR 15, 1
            END IF
            CALL PrintText(Zeile + Zaehler, Spalte, Kurse(Index).Country)
        END IF
    NEXT Index
    COLOR 15, 1

    ' Auf Tastendruck reagieren?
    IF Active = TRUE THEN
        SELECT CASE LCASE$(Taste)
            CASE CHR$(0) + "h"
                IF Selected > 1 THEN
                    Selected = Selected - 1
                    IF Selected < StartIndex THEN
                        StartIndex = StartIndex - 1
                    END IF
                END IF
            CASE CHR$(0) + "p"
                IF Selected < UBOUND(Kurse) THEN
                    Selected = Selected + 1
                    IF Selected > EndIndex THEN
                        StartIndex = StartIndex + 1
                    END IF
                END IF
            CASE CHR$(13)
                Active = FALSE
        END SELECT
    END IF

END SUB

