REM
REM DrawClock.BAS
REM Uhr mittels DRAW-Befehl
REM
REM Copyright by www.jb-electronics.de
REM

DECLARE FUNCTION Datum$ ()
DECLARE SUB FadeOut ()
DIM SHARED f%(255, 3), rt(255), gr(255), bl(255)

REM Die Startzeit holen
startstd = VAL(LEFT$(TIME$, 2))
startmin = VAL(MID$(TIME$, 4, 2))
startsek = VAL(RIGHT$(TIME$, 2))

REM 320x200 mit 2 Seiten initiieren
SCREEN 7, , 0, 1

DO
        FOR std = startstd * 30 TO 360 STEP 30
                FOR min = startmin * 6 TO 360 STEP 6
                        FOR sek = startsek * 6 TO 360 STEP 6

                                REM Die tastatur abfragen
                                Eingabe$ = INKEY$

                                REM Eine Sekunde warten
                                WHILE t$ = TIME$: WEND
                                t$ = TIME$

                                REM Bildschirm loeschen und Datum/Zeit digital ausgeben
                                CLS
                                LINE (0, 0)-(319, 199), 1, B
                                LOCATE 2, 2
                                PRINT " Uhr mit dem DRAW-Befehl"
                                LOCATE 23, 2
                                PRINT " Beenden mit Escape"
                                LINE (125, 125)-(194, 137), 14, B
                                LOCATE 17, 17
                                PRINT TIME$
                                LOCATE 10, 16
                                PRINT Datum$
                                LINE (116, 81)-(203, 69), 14, B
                                CIRCLE (160, 100), 4, 15
                                CIRCLE (160, 100), 65, 15

                                REM Das Zeichnen der Zeiger mit dem DRAW-Befehl
                                DRAW "TA" + STR$(360 - sek) + "S4" + "C10 U50"
                                DRAW "B M160, 100"
                                DRAW "TA" + STR$(360 - min) + "S4" + "C4  U40"
                                DRAW "B M160, 100"
                                DRAW "TA" + STR$(360 - std) + "S4" + "C1  U30"
                               
                                REM Und alles in den Primaerbuffer kopieren
                                PCOPY 0, 1
  
                                REM Wurde Escape gedrueckt?
                                IF Eingabe$ = CHR$(27) THEN
                                        FadeOut
                                        END
                                END IF

                        NEXT
                        startsek = 1

                NEXT
                startmin = 1

        NEXT
        startstd = 1

LOOP
END

REM Diese FUNCTION liefert das Datum in deutscher Schreibweise zurueck
FUNCTION Datum$

        REM Einzelne Daten isolieren
        tag$ = MID$(DATE$, 4, 2)
        monat$ = LEFT$(DATE$, 2)
        jahr$ = RIGHT$(DATE$, 4)

        REM Und neu zusammensetzen
        Datum$ = RTRIM$(LTRIM$(tag$ + "." + monat$ + "." + jahr$))

END FUNCTION

REM Diese SUB dunkelt den Bildschirm nach und nach ab 
SUB FadeOut

        REM Farbwerte sichern
        FOR i = 0 TO 255
                OUT &H3C7, i
                f%(i, 1) = INP(&H3C9)
                f%(i, 2) = INP(&H3C9)
                f%(i, 3) = INP(&H3C9)
        NEXT

        REM Schleife bis alle Farben = RGB(0, 0, 0)
        DO
                fertig = 0
 
                FOR i = 0 TO 255
                        OUT &H3C7, i
                        rt = INP(&H3C9) - 1
                        gr = INP(&H3C9) - 1
                        bl = INP(&H3C9) - 1
                        IF rt < 0 THEN rt = 0
                        IF gr < 0 THEN gr = 0
                        IF bl < 0 THEN bl = 0
                        OUT &H3C8, i
                        OUT &H3C9, rt
                        OUT &H3C9, gr
                        OUT &H3C9, bl
                        IF rt <> 0 OR gr <> 0 OR bl <> 0 THEN fertig = fertig + 1
                NEXT
  
                REM kleine Pause
                WAIT &H3DA, 8
                WAIT &H3DA, 8, 8

        LOOP UNTIL fertig = 0
          
        REM Bildschirm loeschen
        LINE (0, 0)-(320, 200), 0, BF

        REM Und in den primaerbuffer kopieren
        PCOPY 0, 1

        REM Alte Farbwerte wiederherstellen
        FOR i = 0 TO 255
                OUT &H3C8, i
                OUT &H3C9, f%(i, 1)
                OUT &H3C9, f%(i, 2)
                OUT &H3C9, f%(i, 3)
        NEXT

END SUB

