//
// Primat - www.jb-electronics.de
//
// GUI
//

import javax.swing.*;
import java.awt.*;
import java.awt.event.*;

public class Primat extends JFrame implements ActionListener {

	// Instanzvariablen: der Button und die beiden Textfelder
	private JButton los;
	private JTextField eingabe;
	private JTextArea ausgabe;
	
	// Konstruktor
	public Primat () {
	
		super("Primat");
		setSize(600, 330);
		setResizable(false);
		setDefaultCloseOperation(EXIT_ON_CLOSE);
		setContentPane(new LogoPanel("primat.jpg"));
	
		// absolute Positionierung
		setLayout(null);
		
		// Ausrechnen-Button
		los = new JButton("Ausrechnen!");
		los.addActionListener(this);
		los.setBounds(5, 262, 110, 30);
		add(los);
		
		// Eingabe-Textfeld
		eingabe = new JTextField("Zahl");
		eingabe.addActionListener(this);
		eingabe.setBounds(125, 262, 100, 30);
		eingabe.selectAll();
		add(eingabe);
		
		// Ausgabe-Textfeld
		ausgabe = new JTextArea();
		ausgabe.setBounds(35, 75, 250, 75);
		ausgabe.setLineWrap(true);
		ausgabe.setWrapStyleWord(true);
		ausgabe.setEditable(false);
		ausgabe.setText("Noch nichts.\n\nNoch hast du micht ja nichts gefragt...");
		add(ausgabe);

		// alles sichtbar machen
		setVisible(true);
	
	}
	
	// Main-Methode
	public static void main (String[] args) {
	
		Primat p = new Primat();
	
	}
	
	// reagiert auf Events
	public void actionPerformed (ActionEvent e) {
		
		// Zerlegung
		try {
		
			// Primzahl?
			if (Mathe.isPrime(eingabe.getText())) {
				ausgabe.setText(eingabe.getText() + " ist eine Primzahl.");
				
			// wenn nicht Faktoren ausgeben
			} else {
				ausgabe.setText(eingabe.getText() + " = " + Mathe.getPrimfaktoren(eingabe.getText()));  
			}
			
		// falsche Eingabe?
		} catch (Exception ex) {
			ausgabe.setText("Gib nicht so einen Quatsch ein bitte.");
		}
		
		// Eingabe-Textfeld selektieren
		eingabe.selectAll();
		
	}
	
}