//
// Primat - www.jb-electronics.de
//
// Matheklasse zur Primfaktorzerlegung
//

public class Mathe {

	private static int temp = 0;

	private static double sqrt (double r) {

		double tmp = r;
		double alterWert;

		do {

			alterWert = tmp;
			tmp = heron(tmp, r);

		} while (alterWert != tmp);

		return tmp;


	}

	// Heron-Verfahren zur Bestimmung der Quadratwurzel
	private static double heron (double x, double root) {

		return (x + root / x) / 2;

	}
	
	// berprft, ob Zahl w eine Primzahl ist
	public static boolean isPrime (int w) {

		// oder: for (int i = 2; i * i <= n; i++) {
		if (w < 0) {
			w = -w;
		}
		
		for (int i = 2; i <= sqrt(w); i++) {

			if (i != w) {

				if ((w % i) == 0) {
					temp = i;
					return false;
				}

			}
		}

		return true;		

	}
	
	// berladene isPrime fr Strings
	public static boolean isPrime (String w) {
	
		return isPrime(Integer.parseInt(w));
	
	}

	// Diese Methode bercksichtigt den Faktor 1 bzw. -1 als Sonderflle
	public static String getPrimfaktoren (int zahl) {
	
		if (zahl > 0) {
			return "1 * " + getPrimfaktoren_rek(zahl);
		} else {
			return "-1 * " + getPrimfaktoren_rek(zahl * -1);
		}
	
	}
	
	// zerlegt eine Zahl in ihre Primfaktoren (rekursiv)
	private static String getPrimfaktoren_rek (int zahl) {
	
		if (isPrime(zahl)) {
			return zahl + "";
		} else {
			return (temp + " * " + getPrimfaktoren_rek(zahl / temp));
		}
		
	}
	
	// berladenes getPrimfaktoren fr Strings
	public static String getPrimfaktoren (String zahl) {
	
		return getPrimfaktoren(Integer.parseInt(zahl));
		
	}

}