//
// HyperCube - www.jb-electronics.de
//
// Das Panel mit dem Hintergrundbild
//

import javax.swing.*;
import java.awt.*;

public class LogoPanel extends JPanel {

	// Instanzvariablen fr das Hintergrundbild, die Anzahl der Ecken und Kanten
	private Image myImage;
	private Long ecken, kanten; 

	// Konstruktor ldt das Hintergrundbild
	public LogoPanel () {
	
		myImage = new ImageIcon("hyper.jpg").getImage();
	
	}
	
	// zeichnet das Hintergrundbild und die Zahlen
	public void paint (Graphics g) {
	
		// zeichne das Bild
		g.drawImage(myImage, 0, 0, this);

		// schreibe die Texte
		g.setFont(new Font("Courier New", Font.BOLD, 24));
		g.setColor(Color.green);
		g.drawString(String.format("%15d", ecken), 156, 170);
		g.drawString(String.format("%15d", kanten), 116, 262);
		g.setColor(Color.red);
		g.drawString(String.format("%15d", ecken), 155, 169);
		g.drawString(String.format("%15d", kanten), 115, 261);
	
	}
	
	public void refreshVars (long k, long e) {
			ecken = e;
			kanten = k;
	}

}