//
// HyperCube - www.jb-electronics.de
//
// GUI
//

import javax.swing.*;
import java.awt.*;
import java.awt.event.*;

public class HyperGUI extends JFrame {

	// GUI-Components
	private JFrame frame;
	private JPanel hauptPanel;
	private JPanel bedienPanel;
	private LogoPanel lp;
	private JButton starteBerechnung;
	private JTextField dimension;
	
	// Die Hypermath Mathe-Bibliothek
	private HyperMath schlaumeier;
	
	public HyperGUI (String titel, int width, int height) {
	
		// Frame initialisieren
		frame = new JFrame(titel);
		frame.setSize(width, height);
		
		frame.setResizable(false);
		frame.setDefaultCloseOperation(JFrame.EXIT_ON_CLOSE);
		
		// sonstige GUI-Elemente
		hauptPanel = new JPanel();
		hauptPanel.setLayout(new BorderLayout());
		frame.add(hauptPanel);
		
		lp = new LogoPanel();
		hauptPanel.add(lp, BorderLayout.CENTER);
		
		bedienPanel = new JPanel();
		bedienPanel.setLayout(new BoxLayout(bedienPanel, BoxLayout.X_AXIS));
		
		starteBerechnung = new JButton("Starte Berechnung");
		starteBerechnung.addActionListener(new BerechnungsListener());
		bedienPanel.add(starteBerechnung);		
		
		bedienPanel.add(new JLabel("  Geben Sie hier die Dimension ein:   "));
		
		dimension = new JTextField("0");
		update();
		
		dimension.addActionListener(new EingabeListener());
		bedienPanel.add(dimension);

		hauptPanel.add(bedienPanel, BorderLayout.SOUTH);
		
		frame.setVisible(true);

		dimension.selectAll();
		dimension.requestFocus();
		
		frame.repaint();

	}

	public void update () {

		try {
			lp.refreshVars(HyperMath.ecken(Long.parseLong(dimension.getText())), HyperMath.kanten(Long.parseLong(dimension.getText())));
			frame.repaint();
		} catch (Exception e) {
			JOptionPane.showMessageDialog(null, "Bitte nur ganze, positive Zahlen eingeben.", "Fehler!", JOptionPane.ERROR_MESSAGE);
		}
		
	
	}

	class BerechnungsListener implements ActionListener {
	
		public void actionPerformed (ActionEvent e) {
		
			update();
			dimension.selectAll();
			dimension.requestFocus();
		
		}
		
	}
	
	class EingabeListener implements ActionListener {
	
		public void actionPerformed (ActionEvent e) {
		
			update();
			dimension.selectAll();
			dimension.requestFocus();
			
		
		}
		
	}
	
}