'
' WayFinder 
'
' pogrammiert von jb fr den 
'
' Deutschen QuickBASIC & freeBASIC Programmierwettbewerb
'
' Zur genaueren Erklrung des Programms schauen Sie bitte
' in die Datei Readme.TXT
'

' Und jetzt geht's los:

' Die Deklaration der FUNCTIONs:
declare function benutzt (xpos as integer, ypos as integer) as integer
declare function convert$ (Wort$)
declare function exist (dn$) as integer
declare function frei (xpos as integer, ypos as integer) as integer 

' Die Deklarationen der SUBs:
declare sub checkcommand (bildschirmmodus as integer, feldladen as integer, dn$, fehler as integer)
declare sub clr (zeile_anfang as integer, zeile_ende as integer, length as integer)
declare sub eingabe (wort$, l, beenden)
declare sub getfeldinfo (dn as string, anzahl_x as integer, anzahl_y as integer)
declare sub ladefeld (dn as string, anzahl_x as integer, anzahl_y as integer)
declare sub speicherfeld (dateiname$)
declare sub zeichnefeld (xres as integer, yres as integer) 
declare sub zeigespur (spur() as any, index as integer)

'$dynamic

' Die Deklarationen der Variablen
' (die SHARED-Variablen waren ntig, um das Programm bersichtlich zu halten)
dim x as double, y as double
dim shared anzahl_x as integer, anzahl_y as integer
dim shared xl as double, yl as double
dim xneu as double, yneu as double
dim xres as integer, yres as integer

' Typ fr den Such-Algorhythmus erstellen:
type SpurenType
 xpos as integer
 ypos as integer
 sackgasse as integer 
 gefunden as integer
 wegbeschreibung as string
end type 
dim AnzahlSpuren as integer

' Den Zufallsgenerator initialisieren
randomize timer

 ' Pfad ermitteln
 dim shared pfad$ 
 pfad$ = exepath

 ' Die Auflsung des Simulationsfeldes
 xres = 500: yres = 400
 
 ' Einstellungen aus der Kommandozeile holen:
 if command$ <> "" then 
  checkcommand (bildschirmmodus, laden, dn$, fehler)
  kommandozeile = 1
 end if 
 
 ' Der Videomodus
 screen 20, , , bildschirmmodus
 color 15, 8
 
 ' War ein Fehler in der Kommmandozeile enthalten?
 if fehler then 
   
  ' Fehlermeldungsdialog anzeigen
  cls
  locate 16
  print " > Fehlerhafte Kommandozeile."
  print " > Wollen Sie fortfahren und die Einstellungen in"
  print " > der Kommandozeile verwerfen oder das Programm"
  print convert$(" > beenden und die Kommandozeile auf Fehler berprfen?")
  print 
  print " > [a] Weiter, Kommandozeile verwerfen"
  print " > [b] Programm beenden"
  do
   e$ = lcase$(inkey$)
   sleep 10
  loop until e$ = "a" or e$ = "b"
  if e$ = "b" then end
  
  ' Schrift lschen
  clr(16, 22, 55)

 end if

 
' Die Hauptschleife des Programms
do
 
 ' Den Bildschirm lschen
 cls
 
 ' Das Simulationsfeld ersteckt sich von (0|0) bis (500|400) 
 window screen(-480, -100)-(544, 686)

 ' Das Simulationsfenster
 locate 6, 80: print " -- Simulationsfenster --"
 line (-2, -2)-(502, 402), 0, bf
 line (-3, -3)-(503, 403), 15, b
 color 15, 0: locate 18, 85: print " -- leer --": color 15, 8
 
 ' Die berschrift
 locate 2, 4: print "                          "
 locate 3, 4: print "                                 " 
 locate 4, 4: print "                      "
 locate 5, 4: print "                                 "
 locate 6, 4: print "                              "
 
 ' Das Men
 locate 9, 2: print convert$(" - - - Hauptmen - - -")
 locate 11, 2: print convert$("[a] Zufllig generiertes Feld erstellen")
 locate 12, 2: print "[b] Eigenes Feld erstellen"
 locate 13, 2: print "[c] Eigenes Feld laden"
 locate 14, 2: print "[d] Beenden"
 
 if not kommandozeile then 
  
  ' Variablen resetten
  laden = 0   
  dn$ = ""
  zufall = 0
  eigen = 0
 
 end if
  
 ' Das Hauptmen mit Tastaturabfrage
 do
  
  ' Tastaturabfrage
  e$ = inkey$
  
  ' Den Prozessor schonen
  sleep 10
  
  ' Auswahl getroffen?
  if zufall or eigen or laden then exit do
  
  ' Variablen resetten
  zufall = 0
  eigen = 0
  laden = 0
  
  ' Welche TAste wurde gedrckt?
  select case lcase$(e$)
   case "a"
    zufall = 1
   case "b"
    eigen = 1
   case "c"
    laden = 1   
   case "d", chr$(27)
    end   
  end select
 
 loop
 
 ' ******************************************************************
 ' Dieser Unterzweig enthlt die Zufallsfunktion, die durch das Setzen 
 ' der Variable 'zufall' auf 1 aktiviert wird.
 '
 if zufall then  
  
  ' Variable resetten
  zufall = 0
  
  do
  
   ax$ = ""
   ay$ = ""
   
   ' Alte Eingaben lschen (falls vorhanden)
   locate 16, 2: print string$(25, " ")
   locate 17, 2: print string$(25, " ")
   
   ' Eingabe der Anzahl der x-Ksten
   locate 16, 2: print convert$("Anzahl x-Ksten: ");
   eingabe ax$, 3, beenden
   if beenden then exit do
   anzahl_x = int(val(ax$))
   
   ' Eingabe der Anzahl der y-Ksten
   locate 17, 2: print convert$("Anzahl y-Ksten: ");
   eingabe ay$, 3, beenden
   if beenden then exit do
   anzahl_y = int(val(ay$))
  
  loop until (anzahl_x > 0 and anzahl_y > 0) and (anzahl_x < 101 and anzahl_y < 101)

  ' Wurde auch kein Escape gedrckt?
  if not beenden then  
   
   ' Die Datenfelder dimensionieren
   redim shared feld(1 to anzahl_x, 1 to anzahl_y) as integer
   dim shared schongegangen(1 to anzahl_x, 1 to anzahl_y) as integer
   dim wohin(1 to 4) as integer
   
   ' Gre eines einzelnen Kastens ermitteln
   xl = xres / anzahl_x
   yl = yres / anzahl_y
   x = 0
   y = 0
 
   ' Flle das Feld mit Zufallswerten:
   for xdummy = 1 to anzahl_x step 1
    for ydummy = 1 to anzahl_y step 1   
    
     ' Zufall zwischen Fllen/Nichtfllen
     z = int(rnd * 2) + 1
     if z = 1 then feld(xdummy, ydummy) = 1  
    
    next ydummy
   next xdummy
  
   ' Das Zeichnen des Feldes:
   zeichnefeld(xres, yres)
  
   ' Die Wege suchen
   suchewege = 1

  end if 

 end if

 ' ******************************************************************
 ' Dieser Unterzweig enthlt die Felderstellungsfunktion, die durch 
 ' das Setzen der Variable 'eigen' auf 1 aktiviert wird.
 '
 if eigen then 
  
  ' Variable resetten 
  eigen = 0
  
  ' Die Position im Feld
  feld_xpos = 1
  feld_ypos = 1
  
  ' Die Gre des Feldes
  anzahl_x = 10
  anzahl_y = 10
  
  p = 1
  
  ' Zeige die Steuerung an:
  locate 19, 2: print convert$("Erhhen:")
  locate 20, 4: print convert$("w (x-Ksten); s (y-Ksten)")
  locate 22, 2: print "Verringern:"
  locate 23, 4: print convert$("q (x-Ksten); a (y-Ksten)")
  locate 25, 2: print convert$("Ausgewhltes Feld fllen: Enter")
  locate 26, 2: print convert$("Ausgewhltes Feld leeren: Backspace")
  locate 28, 2: print convert$("Komplettes Feld fllen: Strg + F")
  locate 29, 2: print "Komplettes Feld leeren: Strg + L"
  locate 30, 2: print "Feld speichern: Strg + S"
  
  do
   
   ' Kleine Pause
   sleep 5
   
   ' Tasten und Maus abfragen
   e$ = inkey$
   
   ' Welche Taste wurde gedrckt?
   ' Wenn eine Taste gedrckt wurde, ist p > 0, sonst 0.
   select case e$
    
    ' Enter
    case chr$(13)
     feld(feld_xpos, feld_ypos) = 1
     p = 2
     
    ' Backspace
    case chr$(8)
     feld(feld_xpos, feld_ypos) = 0
     p = 2
    
    ' Nach oben
    case chr$(255) + "H"
     if feld_ypos > 1 then feld_ypos = feld_ypos - 1
     p = 2
    
    ' Nach unten
    case chr$(255) + "P"
     if feld_ypos < anzahl_y then feld_ypos = feld_ypos + 1
     p = 2
    
    ' Nach links
    case chr$(255) + "K"
     if feld_xpos > 1 then feld_xpos = feld_xpos - 1
     p = 2
     
    ' Nach rechts
    case chr$(255) + "M"
     if feld_xpos < anzahl_x then feld_xpos = feld_xpos + 1
     p = 2   
        
    ' Einen x-Kasten weniger (falls mglich)
    case "q"
     if anzahl_x > 1 then 
      anzahl_x = anzahl_x - 1
      feld_xpos = 1
      feld_ypos = 1
     end if 
     p = 1
    
    ' Einen x-Kasten mehr (falls mglich)
    case "w"
     if anzahl_x < 100 then 
      anzahl_x = anzahl_x + 1
      feld_xpos = 1
      feld_ypos = 1
     end if 
     p = 1
    
    ' Einen y-Kasten weniger (falls mglich)
    case "a"
     if anzahl_y > 1 then 
      anzahl_y = anzahl_y - 1
      feld_xpos = 1
      feld_ypos = 1
     end if
     p = 1
    
    ' Einen y-Kasten mehr (falls mglich)
    case "s"
     if anzahl_y < 100 then 
      anzahl_y = anzahl_y + 1
      feld_xpos = 1
      feld_ypos = 1
     end if 
     p = 1
    
    ' Strg + S
    case chr$(19)
     speichern = 1
     zeichnefeld(xres, yres)
     exit do
    
    ' Strg + L
    case chr$(12)   
     ' Feld lschen
     redim shared feld(anzahl_x, anzahl_y) as integer
     p = 3
     
    ' Strg + F
    case chr$(6)
     ' Feld fllen
      for xdummy = 1 to anzahl_x step 1
       for ydummy = 1 to anzahl_y step 1
       feld(xdummy, ydummy) = 1
      next ydummy
     next xdummy
     p = 3
     
   end select
 
 
   ' Es wurde eine Taste gedrckt
   ' -> nderungen anzeigen
   if p > 0 then 
     
     ' Zeige die aktuelle Feld-Konstellation an 
     locate 16, 20: print string$(5, " ")
     locate 17, 20: print string$(5, " ")
     locate 16, 2: print convert$("Anzahl x-Ksten: "); ltrim$(str$(anzahl_x))
     locate 17, 2: print convert$("Anzahl y-Ksten: "); ltrim$(str$(anzahl_y))
     
     ' Das Feld lschen, wenn p = 1 ist
     ' (das heit, wenn Q, W, A oder S gedrckt wurde)
     if p = 1 then
      
      ' Redimensioniere das Feld und lsche dadurch die alten Eintrge
      redim shared feld(1 to anzahl_x, 1 to anzahl_y) as integer
         
     end if
 
     ' zeichne das neue Feld
     zeichnefeld (xres, yres) 
     
     ' Breite fr ein einzelnes Feld ausrechnen
     xl = xres / anzahl_x
     yl = yres / anzahl_y
     
     ' Die aktuelle Cursorposition im Feld zeichnen 
     if p = 2 then line(xl * (feld_xpos - 1), yl * (feld_ypos - 1))-(xl * feld_xpos, yl * feld_ypos), 10, b
               
   end if
   
  ' p wieder resetten
  p = 0
   
  loop until e$ = chr$(27)
  
 end if
  
 ' ******************************************************************
 ' Dieser Unterzweig enthlt die Speicherfunktion, die durch das Setzen 
 ' der Variable 'speichern' auf 1 aktiviert wird.
 '
 if speichern then 
   
   ' Variablen resetten
   speichern = 0
   repeat = 0
   
   do
   
    ' Speichern-Dialog anzeigen
    dateiname$ = "sample"
    locate 32
    print " > Geben Sie den Dateinamen ohne Dateiendung und ohne Pfad an!"
    print " > Unerlaubte Zeichen: / \ * . :" 
    print
    
    do
   
     ' Etwaige vorherige Eingabe lschen
     locate 35, 15: print string$(10, " ")
    
     ' Eingabe des Dateinamens
     locate 35: print " > Dateiname: ";
     eingabe dateiname$, 10, beenden
     if beenden then exit do
   
     ' Ist der Pfadname in Ordnung?
     inordnung = 1
     check = instr(dateiname$, "/") or instr(dateiname$, "\") or instr(dateiname$, "*") 
     check = check or instr(dateiname$, ".") or instr(dateiname$, ":")
     if not len(trim$(dateiname$)) then check = 1
     if check then inordnung = 0 else exit do
     dateiname$ = "sample"
   
    loop
 
    ' Wurde auch kein Escape gedrckt?
    if not beenden then 
   
     ' Dateinamen erstellen
     dn$ = pfad$ + "\Felder\" + dateiname$ + ".way"
   
     ' Existiert die Datei oder nicht?
     if not exist(dn$) then 
   
      ' Nachricht anzeigen
      print
      print " > Datei " + dateiname$ + ".way erfolgreich abgespeichert."
      print 
   
     else
    
      ' Nachricht anzeigen
      print
      print " > Datei " + dateiname$ + ".way existiert bereits."
      print
      print " > Ersetzen?" 
      print 
      print " > [1] Ja     [2] Nein"
      print
      do
       sleep 10
       e$ = inkey$
       if e$ = "1" then 
        repeat = 0 
        exit do
       elseif e$ = "2" then
        repeat = 1
        exit do
       end if
      loop 
            
     end if
    
    else
    
     ' Bei Escape die Schleife verlassen
     exit do
    
    end if
 
  loop until not repeat

  ' Feld speichern
  speicherfeld(dn$)
  print " > Fortfahren mit beliebiger Taste."
  getkey
  clr(37, 45, 50)
 
 end if    
 
 ' ******************************************************************
 ' Dieser Unterzweig enthlt die Ladefunktion, die durch das Setzen 
 ' der Variable 'laden' auf 1 aktiviert wird.
 '
 if laden then 
  
  ' Variablen resetten
  laden = 0
  beenden = 0
    
  ' Soll eine Datei aufgrund eines Kommandozeilenaufrufs geladen werden?
  if kommandozeile then 
      
   ' Kommandozeile resetten
   kommandozeile = 0
   
   ' Das Feld laden
   getfeldinfo(dn$, anzahl_x, anzahl_y)
   redim shared feld(1 to anzahl_x, 1 to anzahl_y) as integer
   redim shared schongegangen(1 to anzahl_x, 1 to anzahl_y) as integer
   ladefeld(dn$, anzahl_x, anzahl_y)
  
  ' Andernfalls
  else
   
   ' Laden-Dialog anzeigen
   dateiname$ = "sample"
   locate 16 
   print " > Geben Sie den Dateinamen ohne Dateiendung und"
   print " > ohne Pfad an!"
   print " > Unerlaubte Zeichen: / \ * . :" 
   print
    
   do
   
    ' Etwaige vorherige Eingabe lschen
    locate 20, 15: print string$(10, " ")
    
    ' Eingabe des Dateinamens
    locate 20: print " > Dateiname: ";
    eingabe dateiname$, 10, beenden
    if beenden then exit do
   
    ' Ist der Pfadname in Ordnung?
    inordnung = 1
    check = instr(dateiname$, "/") or instr(dateiname$, "\") or instr(dateiname$, "*") 
    check = check or instr(dateiname$, ".") or instr(dateiname$, ":")
    if not len(trim$(dateiname$)) then check = 1
    if check then inordnung = 0 else exit do
    dateiname$ = "sample"
   
   loop
 
   ' Wurde auch kein Escape gedrckt?
   if not beenden then 
   
    ' Dateinamen erstellen
    dn$ = pfad$ + "\Felder\" + dateiname$ + ".way"
   
    if exist(dn$) then  
     
     ' Das Feld laden
     getfeldinfo(dn$, anzahl_x, anzahl_y)
     redim shared feld(1 to anzahl_x, 1 to anzahl_y) as integer
     redim shared schongegangen(1 to anzahl_x, 1 to anzahl_y) as integer
     ladefeld(dn$, anzahl_x, anzahl_y)
    
     ' Nachricht anzeigen
     print
     print " > Datei " + dateiname$ + ".way erfolgreich geladen."
     print 
     print " > Fortfahren mit beliebiger Taste."
     getkey
    
    else
    
     ' Nachricht anzeigen
     print
     print " > Datei " + dateiname$ + ".way existert nicht."
     print 
     print " > Fortfahren mit beliebiger Taste."
     getkey
     beenden = 1
    
    end if
   
   end if 
  
  end if
   
  ' Wurde auch kein Escape gedrckt?
  if not beenden then 
  
   clr(15, 26, 50)
  
   locate 16, 2: print convert$("Anzahl x-Ksten: "); trim$(str$(anzahl_x)) 
   locate 17, 2: print convert$("Anzahl y-Ksten: "); trim$(str$(anzahl_y))

   ' Die gre pro kasten ermitteln
   xl = xres / anzahl_x 
   yl = yres / anzahl_y
   
   ' Das Zeichnen des Feldes:
   zeichnefeld(xres, yres)
  
   ' die Wege suchen
   suchewege = 1
  
  end if
 
 end if
 
 ' ******************************************************************
 ' Dieser Unterzweig enthlt die Suchfunktion, die durch das Setzen 
 ' der Variable 'suchewege' auf 1 aktiviert wird.
 '
 if suchewege then 
     
  ' "Legende" anzeigen
  locate 33, 65: color 7:  print "";: color 15: print " : Freier Weg"
  locate 33, 95: color 9:  print "";: color 15: print " : Besetzter Weg"
  locate 35, 65: color 4:  print "";: color 15: print " : Vorgeschlagener Weg"
  locate 35, 95: color 10: print "";: color 15: print " : Aktuelle Spur"
  color 15
  
  ' Datenfeld fr die Spuren dimensionieren
  redim spur(1 to AnzahlSpuren) as SpurenType
  
  ' Einstiegspunkt(e) ermitteln:
  AnzahlSpuren = 0
  for x = 1 to anzahl_x step 1
   if frei(int(x), 1) = 1 then  
    AnzahlSpuren = AnzahlSpuren + 1   
    redim preserve spur(AnzahlSpuren) as SpurenType
     with spur(AnzahlSpuren)
     .xpos = int(x)
     .ypos = 1
     .sackgasse = 0
     .gefunden = 0
    end with
    schongegangen(int(x), 1) = 1
   end if 
  next x   
  
  ' Meldung anzeigen
  locate 19, 2
   if AnzahlSpuren = 1 then 
   print "> Es wurde 1 Einstiegspunkt gefunden."
  else
   print "> Es wurden "; trim$(str$(AnzahlSpuren)); " Einstiegspunkte gefunden."   
  end if
  locate 20, 2: print "> Starten mit beliebiger Taste!"
  getkey
  locate 21, 2: print "> Wege werden gesucht - bitte warten."
  locate 22, 2: print "> Vorgang mit Escape abbrechen."
  
  
  ' Wurden berhaupt Spuren gefunden?
  if AnzahlSpuren > 0 then  
   
   ' temporres Feld fr die freien Umgebungsfelder dimensionieren
   dim wohin(4) as integer
 
   ' Endlosschleife bis alle Spuren beendet sind
   do
      
     ' Variablen zur Suche-Ende-Bestimmung resetten
     suche_ende = 0
     suche_wege = 0
     suche_sackgassen = 0
     
     ' Schleife ber alle Spuren:
     for s = 1 to AnzahlSpuren step 1
     
      ' Wurde Escape gedrckt?
      e$ = inkey$
      if e$ = chr$(27) then exit do
    
      ' Schreibarbeit sparen
      with spur(s)
     
       ' Steckt die aktuelle Spur in einer Sackgasse oder wurde der Weg schon gefunden?
       if (not .sackgasse) and (not .gefunden) then  
         
        ' Ist die *komplette* Suche schon beendet?
        ' D.h. sind alle in einer Sackgasse bzw. haben alle den Weg gefunden?
         suche_ende = suche_ende + .sackgasse
         suche_wege = suche_wege + .gefunden
         suche_sackgassen = suche_sackgassen + .sackgasse
      
        ' Feld fr freie Umgebungsfelder resetten
        for res = 1 to 4 step 1
         wohin(res) = 0
        next res
      
        ' Aktuelles Feld als "begangen" bezeichnen
        schongegangen(.xpos, .ypos) = 1
        paint(.xpos * xl - (xl / 2), .ypos * yl - (yl / 2)), 4, 0
       
        ' und zur Wegbeschreibung hinzufgen
        if not len(.wegbeschreibung) then balken$ = "" else balken$ = "-"
        if not .sackgasse then 
         .wegbeschreibung = .wegbeschreibung + balken$ + "(" + trim$(str$(.xpos)) + "|" + trim$(str$(.ypos)) + ")"
        end if
      
         ' Welche Umgebungsfelder sind frei und wurden noch nicht benutzt?
        
         ' oben
         if frei(.xpos, .ypos - 1) = 1 then 
          if benutzt(.xpos, .ypos - 1) = 0 then 
           wohin(1) = 1
          end if 
         end if 
         ' unten
         if frei(.xpos, .ypos + 1) = 1 then 
          if benutzt(.xpos, .ypos + 1) = 0 then 
           wohin(2) = 1
          end if
         end if
         ' links
         if frei(.xpos - 1, .ypos) = 1 then 
          if benutzt(.xpos - 1, .ypos) = 0 then 
           wohin(3) = 1
          end if
         end if
         ' rechts
         if frei(.xpos + 1, .ypos) = 1 then 
          if benutzt(.xpos + 1, .ypos) = 0 then 
           wohin(4) = 1
          end if
         end if
              
        ' Wie viele Abzweigungen gibt es?
        abzweigungen = 0
        for tmp = 1 to 4 step 1 
         if wohin(tmp) then abzweigungen = abzweigungen + 1
        next tmp
       
         ' Wie wird weiter verfahren?
        
        
          ' Wenn es *mehrere* Abzweigungen gibt, wird es kompliziert... 
          if abzweigungen > 1 then 
          
           ' Gehe mit der aktuellen Spur die *erstmgliche* Abzweigung weiter
           ' und speichere dabei die Richtungsnderung, damit der ursprngliche 
           ' Standort fr sptere Verwendung wiederhergestellt werden kann (xplus, yplus)
           for tmp = 1 to 4 step 1
          
            if wohin(tmp) then 
            
             xplus = 0
             yplus = 0
             select case tmp
              case 1
               if .ypos > 1 then 
                .ypos = .ypos - 1 
                xplus = 0
                yplus = 1
               end if 
              case 2
               if .ypos < anzahl_y then 
                .ypos = .ypos + 1
                xplus = 0
                yplus = -1
               else
                .gefunden = 1   
               end if 
              case 3
               if .xpos > 1 then 
                .xpos = .xpos - 1
                xplus = 1
                yplus = 0
               end if
              case 4
               if .xpos < anzahl_x then 
                .xpos = .xpos + 1    
                xplus = -1
                yplus = 0
               end if
             end select    
             ' Die bereits gegangene Spur lschen und von den mglichen Abzweigungen abziehen
             ' (es gibt ja jetzt eine Abzweigung weniger)
             wohin(tmp) = 0
             abzweigungen = abzweigungen - 1
             exit for
           
            end if    
           
           next tmp
         
           ' Teile die brige Spur/die brigen Spuren auf neue auf
           for tmp = 1 to 4 step 1
           
            if wohin(tmp) then  
          
             ' Erstelle einen neuen Eintrag und bernehme die Daten
             ' Achtung: Stelle dabei den *ursprnglichen* Standort der 
             ' ersten Spur wieder her (xplus, yplus)
              AnzahlSpuren = AnzahlSpuren + 1
              redim preserve spur(AnzahlSpuren) as SpurenType 
              spur(AnzahlSpuren).xpos = .xpos + xplus
              spur(AnzahlSpuren).ypos = .ypos + yplus
              spur(AnzahlSpuren).sackgasse = .sackgasse
              spur(AnzahlSpuren).gefunden = .gefunden
              spur(AnzahlSpuren).wegbeschreibung = .wegbeschreibung
              schongegangen(spur(AnzahlSpuren).xpos, spur(AnzahlSpuren).ypos) = 1
            
              ' Bewege die Spur
               select case tmp
                case 1
                 if spur(AnzahlSpuren).ypos > 1 then 
                  spur(AnzahlSpuren).ypos = spur(AnzahlSpuren).ypos - 1
                 end if
                case 2
                 if spur(AnzahlSpuren).ypos < anzahl_y then 
                  spur(AnzahlSpuren).ypos = spur(AnzahlSpuren).ypos + 1 
                 else 
                  spur(AnzahlSpuren).gefunden = 1
                 end if
                case 3
                 if spur(AnzahlSpuren).xpos > 1 then 
                  spur(AnzahlSpuren).xpos = spur(AnzahlSpuren).xpos - 1
                 end if 
                case 4
                 if spur(AnzahlSpuren).xpos < anzahl_x then 
                  spur(AnzahlSpuren).xpos = spur(AnzahlSpuren).xpos + 1
                 end if
               end select
                          
            end if
          
           next tmp
         
         ' keine Abzweigungen (-> Sackgasse)
          elseif not abzweigungen then 
           .sackgasse = 1 
         
        
          ' Wenn es aber *eine* Abzweigung gibt, ...
          elseif abzweigungen = 1 then 
           for tmp = 1 to 4 step 1
            if wohin(tmp) then 
             select case tmp
              case 1: if .ypos > 1 then .ypos = .ypos - 1
              case 2: if .ypos < anzahl_y then .ypos = .ypos + 1
              case 3: if .xpos > 1 then .xpos = .xpos - 1
              case 4: if .xpos < anzahl_x then .xpos = .xpos + 1    
             end select
             exit for
            end if
           next tmp 
          end if 
        
          ' Hat die Spur den Ausgang gefunden?
          if .ypos = anzahl_y then 
           .gefunden = 1
          end if 
        
       end if
    
      end with
     
     next s   
 
     ' Ist die Suche zu Ende?
     if suche_ende = AnzahlSpuren then 
      exit do   
     end if
 
   loop   
     
  end if
  
  ' Meldung anzeigen
  locate 22
  print
  print
  print " >  * * * * * FERTIG * * * * *"
  print " > Suche bendet."
  print
  print " > Anzahl Spuren     : "; trim$(str$(AnzahlSpuren))
  print " > Anzahl Wege       : "; trim$(str$(suche_wege))
  print " > Anzahl Sackgassen : "; trim$(str$(AnzahlSpuren - suche_wege))
  print
  getkey
  
  ' Man kann nnatrlich nur Spuren anzeigen, wennes auch welche gibt...
  if AnzahlSpuren > 0 then
  
   ' Startvariablen setzen
   SpurIndex = 1
   ersterdurchlauf = 1
   
   do
    
    e$ = inkey$
    sleep 10
    
    ' Auswertungen
    if e$ = chr$(27) then exit do
    
    if e$ = "+" then
     if SpurIndex < AnzahlSpuren then SpurIndex = SpurIndex + 1  
    end if
    
    if e$ = "-" then 
     if SpurIndex > 1 then SpurIndex = SpurIndex - 1
    end if 
    
    if e$ = "-" or e$ = "+" or ersterdurchlauf then 
     
     ' Feld neu zeichnen und aktuelle Spur anzeigen
     zeichnefeld(xres, yres)
     zeigespur(spur(), SpurIndex)
     
     ' kleine Nachricht
     locate 31: print " > Aktuelle Spur:                 "
     locate 31: print " > Aktuelle Spur: "; trim$(str$(SpurIndex))
     locate 33: print " > Verlassen mit Escape."
    
    end if 
    
    ersterdurchlauf = 0
   
   loop
      
   if suche_wege then 
    
    print
    if suche_wege = 1 then 
     print " > Wollen Sie den gefundenen Weg abspeichern?"
    else 
     print " > Wollen Sie die gefundenen Wege abspeichern?"
    end if
    print " > [1] Ja     [2] Nein"
    print
   
    do
     sleep 10
     e$ = inkey$ 
    loop until e$ = "1" or e$ = "2" or e$ = chr$(27)
   
    ' Speichern
    if e$ = "1" then 
    
     do
     
      ' Variable resetten
      repeat = 0
   
      ' Bildschirm lschen
      clr(38, 42, 50)
     
      ' Etwaige vorherige Eingabe lschen
      locate 38, 15: print string$(10, " ")
    
      ' Eingabe des Dateinamens
      dateiname$ = "sample.txt"
      locate 38: print " > Dateiname: ";
      eingabe dateiname$, 10, beenden
     
      ' Ist der Pfadname in Ordnung?
      inordnung = 1
      check = instr(dateiname$, "/") or instr(dateiname$, "\") or instr(dateiname$, "*") 
      check = check or instr(dateiname$, ":")
      if not len(trim$(dateiname$)) then check = 1
      if check then inordnung = 0 else inordnung = 1
     
      ' Pfadnamen zusammenbasteln
      dn$ = pfad$ + "\Wege\" + dateiname$
     
      if exist(dn$) then 
      
       print
       print " > Die Datei " + dateiname$ + " existiert bereits."
       print 
       print " > Ersetzen?"
       print
       print " > [1] Ja     [2] Nein"
       do
        sleep 10
        e$ = inkey$    
        if e$ = "1" then 
         exit do
        elseif e$ = "2" then 
         repeat = 1
         exit do
        end if 
      loop
      
      end if 
   
     loop until not repeat and inordnung
           
     ' Wurde auch kein Escape gedrckt?
     if not beenden then 
     
      ' Die Datei ffnen
      f = freefile
      open dn$ for output as #f
        
       print #f, "WayFinder - Log"
       print #f, "Am "; mid$(date$, 4, 2); "."; left$(date$, 2); "."; right$(date$, 2); " um "; time$  
       print #f,
       print #f, "Folgende Spuren wurden gefunden:"
     
       ' Die Wege speichern
       for i = 1 to AnzahlSpuren step 1
     
        with spur(i)
          
         if .gefunden then 
        
          print #f, ""
          print #f, "Die Spur Nr. "; trim$(str$(i)); " war erfolgreich!"
          print #f, "Hier ihre Wegbeschreibung:"
          print #f, .wegbeschreibung
       
         end if 
          
        end with    
      
       next i    
          
      ' Datei schlieen
      close #f
   
     end if
   
     print " > Fortfahren mit beliebiger Taste!"
     getkey
   
    end if 
   
   end if
   
   ' Bildschirm lschen 
   clr(19, 35, 50)
  
   ' Variable resetten
   suchewege = 0
 
  end if    
 
 end if
 
loop
end

' **************************************************************
' Das Hauptprogramm ist zu Ende, jetzt folgen die Unterprogramme:

' Zu erst die FUNCTIONs:

' **************************************************************
' Diese FUNCTION liefert
'    * 0 zurck, wenn das entsprechende Feld noch nicht genutzt wurde
'    * 1 zurck, wenn das entsprechende Feld schon benutzt wurde
'    * 99 zurck, wenn xpos und/oder ypos ungltige Indicies sind
function benutzt (xpos as integer, ypos as integer)
 
 if (xpos > 0 and xpos < anzahl_x + 1) and (ypos > 0 and ypos < anzahl_y + 1) then 
  b = schongegangen(xpos, ypos)
 else
  b = 99
 end if
 benutzt = b

end function

' **************************************************************
' Diese FUNCTION liefert einen konvertierten Ausdruck zurck.
' Diese Kovertierung betrifft nur die Umlaute sowie das scharfe s, und ist in 
' beide Richtungen durchfhrbar (direction) 
' Diese SUB habe ich aus EasyCash bernommen.
function convert$ (Wort$)
 
 NeuerText$ = ""
 
 ' Schleife ber alle Buchstaben des Ausdrucks 
 for i = 1 to len(Wort$)
  
   ' Schauen, ob ein Zeichen ersetzt werden muss
   Zeichen$ = mid$(Wort$, i, 1)
   select case Zeichen$
    case chr$(223): Zeichen$ = chr$(225)
    case chr$(196): Zeichen$ = chr$(142)
    case chr$(228): Zeichen$ = chr$(132)
    case chr$(214): Zeichen$ = chr$(153)    
    case chr$(246): Zeichen$ = chr$(148)
    case chr$(220): Zeichen$ = chr$(154)
    case chr$(252): Zeichen$ = chr$(129)   
   end select
   NeuerText$ = NeuerText$ + Zeichen$
    
 next i

 convert$ = NeuerText$

end function

' **************************************************************
' Diese FUNCTION liefdert den Wert 1 zurck, wenn die Datei 
' existiert, und den Wert 0, wenn nicht
function exist (dn$) as integer

 ' Datei binr ffnen
 f = freefile
 open dn$ for binary access read as #f
 
 ' Exisistiert die Datei?
 if lof(f) = 0 then e = 0 else e = 1
 
 ' Datei schlieen
 close #f
  
 ' Wert bergeben
 exist = e
  
end function

' **************************************************************
' Diese Funktion liefert 
'    * 0 zurck, wenn das entsprechende Feld besetzt ist
'    * 1 zurck, wenn das entsprechende Feld frei ist
'    * oder 99, wenn xpos und/oder ypos ungltige Indicies sind
function frei (xpos as integer, ypos as integer) as integer
    
 if (xpos > 0 and xpos < anzahl_x + 1) and (ypos > 0 and ypos < anzahl_y + 1)  then 
  if feld(xpos, ypos) = 1 then f = 0 else f = 1
 else
  f = 99
 end if
 frei = f
 
end function

' Und jetzt die SUBs:

' **************************************************************
' Diese SUB durchsucht die Kommandozeile nach Anweisungen
sub checkcommand (bildschirmmodus as integer, feldladen as integer, dn$, fehler as integer)

 ' Volllbild oder Fenstermodus?
 if instr(lcase$(command$), "/f") then bildschirmmodus = 1

 ' Soll eine Datei geladen werden?
 lade = instr(lcase$(command$), "/w ")
 if lade then 
  
  feldladen = 1
  
  ' Den Dateinamen zussammenbasteln
  start = lade + 3
  for i = start to len(command$) step 1
   
   ' Zeichen isolieren
   zeichen$ = mid$(lcase$(command$), i, 1)
   
   if zeichen$ = "/" or zeichen$ = "\" or zeichen$ = ":" or zeichen$ = "." or zeichen$ = "*" then fehler = 1: exit for
   if zeichen$ <> " " then dn$ = dn$ + zeichen$ else exit for
  
 next i

 dn$ = pfad$ + "\Felder\" + dn$ + ".way"

 end if

end sub

' **************************************************************
' Diese Sub lscht einen bestimmten Bildschirmbereich
sub clr (zeile_anfang as integer, zeile_ende as integer, length as integer) 
 
 ' Cursorposition sichern
 zeile = csrlin
 spalte = pos
 
 ' Fehler abfangen
 if zeile_anfang > zeile_ende then swap zeile_anfang, zeile_ende
 
 if length < 0 then length = 0 
 
 ' Bildschirm leeren
 for dummyzeile = zeile_anfang to zeile_ende step 1
  locate dummyzeile: print string$(length, " ")   
 next dummyzeile
  
 ' Ursprngliche Cursorposition wiederherstellen
 locate zeile, spalte

end sub

' **************************************************************
' Diese SUB ist eine einfache Eingaberoutine, die die Eingabe wort$ 
' mit der Maximallnge l zurckliefert.
sub eingabe (wort$, l, beenden)

 zeile = csrlin
 spalte = pos
 
 ' Bei ersten Durchlauf den Inhalt von wort$ *ohne Eingabe* anzeigen
 ersterdurchlauf = 1
 
 do

  tmplen = len(wort$)
  
  e$ = inkey$
  sleep 10
  
  select case e$
   
   'Escape
   case chr$(27)   
    wort$ = ""
    beenden = 1
    exit sub
   
   ' Enter
   case chr$(13)
    beenden = 0
    exit sub
   
   ' Backspace
   case chr$(8) 
    if len(wort$) then wort$ = left$(wort$, len(wort$) - 1)
   
   case else
    if len(wort$) < l and asc(e$) < 128 then wort$ = wort$ + e$    
 
  end select

  ' Hat eine Eingabe stattgefunden, zeige die nderungen an.
  if len(wort$) <> tmplen or ersterdurchlauf then
   
   locate zeile, spalte: print string$(tmplen, " ")
   locate zeile, spalte: print wort$
   
  end if    
 
  tmplen = len(wort$)
 
  ersterdurchlauf = 0
 
 loop

end sub

' **************************************************************
' Diese SUB durchsucht eine Datei nach den Feld-Informationen Breite und Hhe
sub getfeldinfo (dn as string, anzahl_x as integer, anzahl_y as integer)

 ' Ein Pufferbyte
 dim pufferbyte as string * 3

 ' Datei ffnen
 f = freefile
 open dn for binary access read as #f
 
 ' Hole die Informationen
 get #f, , pufferbyte
 anzahl_x = val(pufferbyte)
 
 get #f, , pufferbyte
 anzahl_y = val(pufferbyte)
 
 ' Datei schlieen
 close #f
 
end sub

' **************************************************************
' Diese SUB ldt eine Datei in ein Feld
sub ladefeld (dn as string, anzahl_x as integer, anzahl_y as integer)

 ' Dummy-Variable
 dim dummy as string * 3
 
 ' Pufferbyte
 dim pufferbyte as string * 1

 ' Datei ffnen
 f = freefile
 open dn for binary access read as #f
 
 get #f, , dummy
 get #f, , dummy
 
 for xdummy = 1 to anzahl_x step 1
  for ydummy = 1 to anzahl_y step 1
   
   get #f, , pufferbyte
   feld(xdummy, ydummy) = val(pufferbyte)
  
  next ydummy
 next xdummy 

end sub

' **************************************************************
' Diese SUB dient dazu, ein Feld im .WAY-Format abzuspeichern
sub speicherfeld (dn$)

  ' Pufferbyte
  dim pufferbyte as string * 3
  
  ' Variable fr den Feld-Zustand
  dim zustand as string * 1
  
  ' Datei erstellen und wieder lschen - Sicherheitsmanahme
  f = freefile
  open dn$ for binary as #f
  close #f
  kill dn$
  
  ' Datei im Binrmodus ffnen
  f = freefile
  open dn$ for binary access write as #f
  
  ' Feldgre schreiben
  pufferbyte = trim$(str$(anzahl_x))
  put #f, , pufferbyte
  
  pufferbyte = trim$(str$(anzahl_y))
  put #f, , pufferbyte
  
  ' Jetzt die Zustnde (Besetzt/Frei) schreiben
  for xdummy = 1 to anzahl_x step 1 
   for ydummy = 1 to anzahl_y step 1
    
    zustand = trim$(str$(feld(xdummy, ydummy)))
    put #f, , zustand
   
   next tmpy
  next tmpx
  
  ' Datei wieder schlieen
  close #f

end sub

' **************************************************************
' Diese SUB zeichnet ein Feld, indem es die Daten im Feld feld() verwendet
sub zeichnefeld (xres as integer, yres as integer)     
  
  dim xl as double, yl as double
  dim x as double, y as double
  
  ' Die Kastengren ausrechnen
  xl = xres / anzahl_x
  yl = yres / anzahl_y
  
  ' Variablen resetten
  x = 0
  y = 0
      
  ' Schleife ber alle Kasten
  for ydummy = 1 to anzahl_y step 1
   for xdummy = 1 to anzahl_x step 1   
  
    ' Kasten zeichnen
    ' je nach Zustand (besetzt/frei) eine andere Farbe
    if feld(xdummy, ydummy) then f = 9 else f = 7 
    line (x, y)-(x + xl, y + yl), f, bf   
    line (x, y)-(x + xl, y + yl), 0, b
            
    ' Und einen Kasten weiter in x-Richtung
    x = x + xl
    
   next ydummy
       
   ' Variable x resetten und einen Kasten weiter in y-Richtung
   x = 0
   y = y + yl
  
  next xdummy   

end sub

' **************************************************************
' Diese Sub hebt die ausgewhlte Spur in grn hervor
sub zeigespur (spur() as SpurenType, index as integer)

 with spur(index)
   
   p = 1
   b$ = .wegbeschreibung
   do
    
    ' temporre Variablen resetten
    xpos$ = ""
    ypos$ = ""
    
    ' Zerhacke den String in Zahlen
    
     ' Die x-Position
     do
      z$ = mid$(b$, p, 1) 
      if val(z$) or z$ = "0" then xpos$ = xpos$ + mid$(b$, p, 1)
      if z$ = "|" then exit do
      p = p + 1
     loop  
     
     ' Die y-Position
     p = p + 1
     do
      z$ = mid$(b$, p, 1) 
     if val(z$) or z$ = "0" then ypos$ = ypos$ + mid$(b$, p, 1)
      if z$ = ")" then exit do
      p = p + 1
     loop
    
    p = p + 3
        
    ' Werte umrechnen und entsprechendes Feld grn frben.
    xp = val(xpos$)
    yp = val(ypos$)
    paint(xp * xl - (xl / 2), yp * yl - (yl / 2)), 10, 0
    
   loop until p >= len(b$) 
     
 end with    

end sub

