' *****************************************************************************
' Die Font-Routinen
type SingleFontType
    WidthX          as ubyte
    WidthY          as ubyte
    Daten           as ubyte ptr
end type
type FontType
    MaxWidthX       as ubyte
    MaxWidthY       as ubyte
    FontDaten(255)  as SingleFontType
end type
declare function   LoadFont           (FontDaten as FontType ptr, FileName as string) as integer
declare function UnLoadFont           (FontDaten as FontType ptr) as integer
declare function    GetFontTextLength (FontDaten as FontType ptr, Text as string) as integer
declare sub       PrintFont           (FontDaten as FontType ptr, PosX as integer, PosY as integer, Text as string, ColorFG as integer, ColorBG as integer = &hff00ff, DestinationPtr as integer ptr = 0, WidthX as integer = SCREEN_WIDTHX, WidthY = SCREEN_WIDTHY)

' *****************************************************************************
' Die Maus
type MouseInfoType
    PosX                as integer
    PosY                as integer
    tmp                 as integer
    Tasten              as integer
    Tasten2             as integer
    DoubleClick         as integer
    DoubleClickTmp      as integer
    ClickIndex          as integer
    Cursor              as integer
end type
const DoubleClickDelay = 100
const DoubleClickActive = 130
const DoubleClickDecreaseValue = 5
declare function IsMouseOver (MouseInfo as MouseInfoType, MinX as integer, MinY as integer, MaxX as integer, MaxY as integer) as integer
declare sub     GetMouseInfo (MouseInfo as MouseInfoType)

' *****************************************************************************
' Die Tastatureingabe
type TastaturInfoType
    Taste           as string
end type
declare sub GetTastaturInfo (TastaturInfo as TastaturInfoType)

' *****************************************************************************
' Das Farbschema
type DesignType
    HoverBoxColor   as integer
    Color1          as integer
    Color2          as integer
    Color3          as integer
    Color4          as integer
    Color5          as integer
    Color6          as integer
end type
declare function LoadDesign (DesignDaten as DesignType, DesignFile as string) as integer

' *****************************************************************************
' Die Bilderdaten
type ImageDataType
    ImagePointer    as integer ptr
    WidthX          as integer
    WidthY          as integer
end type
declare function TranslateToImageDataType (DateiName as string) as ImageDataType

' *****************************************************************************
' Hilfstyp Bilder
type ImageType
    PosX            as integer
    PosY            as integer
    ImageData       as ImageDataType
end type
declare function TranslateToImageType (PosX as integer, PosY as integer, ImageData as ImageDataType) as ImageType

' *****************************************************************************
' Hilfstyp Text
type TextType
    PosX        as integer
    PosY        as integer
    Caption     as string
    Font        as FontType ptr
end type
declare function TranslateToTextType (PosX as integer, PosY as integer, caption as string, FontType as FontType ptr) as TextType ptr

' *****************************************************************************
' Hilfstyp Hovertext
type HoverTextType
    PosX        as integer
    PosY        as integer
    Relativ		as integer
    Delay       as integer
    DelayTick   as integer
    Font        as FontType ptr
    Design      as DesignType ptr
    Caption     as string
end type
declare function TranslateToHoverTextType (PosX as integer, PosY as integer, Relativ as integer, Delay as integer, font as FontType ptr, Design as DesignType ptr, caption as string) as HoverTextType ptr

' *****************************************************************************
' Die Buttons
type ButtonType
    PosX        as integer
    PosY        as integer
    WidthX      as integer
    WidthY      as integer
    Design      as DesignType ptr
    ImageBG     as ImageType
    DisabledBG  as ImageType
    Text        as TextType ptr
    HoverText   as HoverTextType ptr
    Modus       as integer
    Status      as integer
    Disabled    as integer
    Clicked     as integer
end type
const BUTTON_NORMAL	= 1
const BUTTON_GRAPHICAL	= 2
const BUTTON_TOGGLE	= 4
declare function           CreateButton (ButtonDaten as ButtonType, PosX as integer, PosY as integer, WidthX as integer, WidthY as integer, Design as DesignType ptr, Text as TextType ptr, HoverText as HoverTextType ptr, Disabled as integer) as integer
declare function  CreateGraphicalButton (ButtonDaten as ButtonType, PosX as integer, PosY as integer, WidthX as integer, WidthY as integer, Design as DesignType ptr, Text as TextType ptr, HoverText as HoverTextType ptr, Image as ImageType, ImageDisabled as ImageType, Disabled as integer) as integer
declare function DestroyGraphicalButton (ButtonDaten as ButtonType) as integer
declare sub               ControlButton (ButtonDaten as ButtonType, MouseInfo as MouseInfoType)
declare sub                  ShowButton (ButtonDaten as ButtonType)

' *****************************************************************************
' Eine Section
type SectionType
    PosX        as integer
    PosY        as integer
    WidthX      as integer
    WidthY      as integer
    Caption     as string
    Font        as FontType ptr
    Design      as DesignType ptr
end type
declare function CreateSection (SectionDaten as SectionType, PosX as integer, PosY as integer, WidthX as integer, WidthY as integer, Font as FontType ptr, Caption as string, Design as DesignType ptr) as integer
declare sub        ShowSection (SectionDaten as Sectiontype) 

' *****************************************************************************
' Die Textbox
type TextBoxType
    PosX        as integer
    PosY        as integer
    WidthX      as integer
    WidthY      as integer
    Design      as DesignType ptr
    Content     as TextType
    Visible     as string
    HoverText   as HoverTextType ptr
    MinPosVis   as integer
    MaxPosVis   as integer
    MinPosM     as integer
    MaxPosM     as integer
    LengthM     as integer
    Marked      as integer
    Disabled    as integer
    CursorPos   as integer
    CursorTick  as integer
    Active      as integer
    Modus       as integer
end type
const TEXTBOX_NORMAL = 1
const TEXTBOX_PASSWORD = 2
declare function CreateTextBox (TextBoxDaten as TextBoxType, PosX as integer, PosY as integer, WidthX as integer, WidthY as integer, Design as DesignType ptr, Content as TextType, HoverText as HoverTextType ptr, Modus as integer, Disabled as integer = 0) as integer
declare sub        ShowTextBox (TextBoxDaten as TextBoxType)
declare sub         setText    (TextBoxDaten as TextBoxType, Caption as string)

' *****************************************************************************
' Sonstiges:
declare sub SetPixelFast (PosX as integer, PosY as integer, Farbe as integer, Destination as integer ptr, WidthX as integer = SCREEN_WIDTHX, WidthY as integer = SCREEN_WIDTHY)
declare sub ShowHoverBox (PosX as integer, PosY as integer, HoverTextDaten as HoverTextType, RelPosX as integer, RelPosY as integer)
declare sub ShowBox (Design as DesignType ptr, PosX as integer, PosY as integer, WidthX as integer, WidthY as integer)
declare function LoadImg (DateiName as string) as integer ptr


' *****************************************************************************
' Diese FUNCTION ldt eine beliebige Bitmap
function LoadImg (DateiName as string) as integer ptr

    ' Variablen
    dim as integer WidthPixel, HeightPixel
    dim as uinteger ptr ImagePointer

    ' Gre des Bildes ermitteln
    dim as integer f
    f = freefile
    open DateiName for binary access read as #f
        get #f, 19, WidthPixel
        get #f, 23, HeightPixel
    close #f
    
    ' Bild laden
    ImagePointer = imagecreate(WidthPixel, HeightPixel)
    bload DateiName, ImagePointer
    
    ' Daten zurckgeben
    return ImagePointer

end function













' *****************************************************************************
' Diese FUNCTION ldt einen Font in den Speicher
function LoadFont (FontDaten as FontType ptr, FileName as string) as integer

    ' Variablen
    dim as integer f
    dim as ubyte WidthX, WidthY
    dim as ubyte LetterIndex
    dim as ubyte Zeile, Spalte
    dim as integer Buffer
    dim as integer MaxWidthX, MaxWidthY

    f = freefile
    open FileName for binary access read as #f

        ' Datei ganz laden
        do until eof(f)

            ' welchen Buchstaben laden?
            get #f, , LetterIndex

            ' Buchstaben-Daten einlesen
            with FontDaten->FontDaten(LetterIndex)

                ' Abmesssungen laden
                get #f, , WidthX
                get #f, , WidthY
                .WidthX = WidthX
                .WidthY = WidthY

                ' grter Buchstabe?
                if WidthX > MaxWidthX then MaxWidthX = WidthX
                if WidthY > MaxWidthY then MaxWidthY = WidthY

                ' bentigten Speicherplatz ausrechnen und reservieren
                Buffer = ((WidthX  * WidthY) + 2) * len(ubyte)
                .Daten = callocate(Buffer)
                .Daten[0] = .WidthX
                .Daten[1] = .WidthY

                ' Pixelgrafik einlesen
                for Zeile = 1 to WidthY step 1
                    for Spalte = 1 to WidthX step 1
                        get #f, , .Daten[ ((Zeile - 1) * WidthX) + Spalte + 1 ]
                    next Spalte
                next Zeile

            end with

        loop

        ' Maximalgre schreiben
        FontDaten->MaxWidthX = MaxWidthX
        FontDaten->MaxWidthY = MaxWidthY

    close #f

    ' erfolgreich geladen
    return -1

end function

' *****************************************************************************
' Diese FUNCTION entfernt einen Font aus dem Speicher
function UnLoadFont (FontDaten as FontType ptr) as integer

    ' Variablen
    dim as integer Index

    ' Speicherplatz freigeben
    for Index = 0 to 255 step 1
        with FontDaten->FontDaten(Index)
            .WidthX = 0
            .WidthY = 0
            deallocate .Daten
        end with
    next Index

    ' erfolgreich freigegeben
    return -1

end function

' *****************************************************************************
' Diese SUB schreibt auf den Bildschirm
sub PrintFont (FontDaten as FontType ptr, PosX as integer, PosY as integer, Text as string, ColorFG as integer, ColorBG as integer = &hff00ff, DestinationPtr as integer ptr, WidthX as integer, WidthY as integer)

    ' Variablen
    dim as integer Index, Length
    dim as ubyte Zeile, Spalte
    dim as ubyte Zeichen, Status
    dim as integer RelPosX, fntWidthX, fntWidthY

    ' Ziel nicht angegeben?
    if DestinationPtr = 0 then
        DestinationPtr = screenptr
    end if

    ' Text ausgeben
    for Index = 1 to len(Text) step 1
    
        ' ASCII-Code ermitteln
        Zeichen = asc(mid$(Text, Index, 1))

        ' Zeichen anzeigen
        with FontDaten->FontDaten(Zeichen)

            fntWidthX = .Daten[0]
            fntWidthY = .Daten[1]
            for Zeile = 1 to fntWidthY step 1
                for Spalte = 1 to fntWidthX step 1

                    ' Pixel eingefrbt oder nicht?
                    Status = .Daten[((Zeile - 1) * fntWidthX) + Spalte + 1]
                    if Status then
                        SetPixelFast (RelPosX + PosX + Spalte, PosY + Zeile, ColorFG, DestinationPtr, WidthX, WidthY)
                    elseif (ColorBG <> &hff00ff) then
                        SetPixelFast (RelPosX + PosX + Spalte, PosY + Zeile, ColorBG, DestinationPtr, WidthX, WidthY)
                    end if

                next Spalte
            next Zeile

        end with

        RelPosX+ = fntWidthX

    next Index

end sub

' *****************************************************************************
' Diese FUNCTION ermittelt die Breite eines Textes
function GetFontTextLength (FontDaten as FontType ptr, Text as string) as integer

    ' Variablen
    dim as string Zeichen
    dim as integer Index, TextLength

    ' Text abscannen
    for Index = 1 to len(Text)
        Zeichen = mid$(Text, Index, 1)
        TextLength+ = FontDaten->FontDaten(asc(Zeichen)).WidthX
    next Index

    ' Wert zurckgeben
    return TextLength

end function

' *****************************************************************************
' Diese FUNCTION ermittelt den aktuellen Tag
function GetCurrentDay () as integer

    ' Tag ermitteln
    return val(mid$(date$, 4, 2))

end function

' *****************************************************************************
' Diese FUNCTION ermittelt den aktuellen Monat
function GetCurrentMonth () as integer

    ' Monat ermitteln
    return val(left$(date$, 2))

end function

' *****************************************************************************
' Diese FUNCTION ermittelt das aktuelle Jahr
function GetCurrentYear () as string

    ' Jahr ermitteln
    return right$(date$, 2)

end function

' *****************************************************************************
' Diese SUB zeichnet einen Pixel schneller als die PSET-Funktion
sub SetPixelFast (PosX as integer, PosY as integer, Farbe as integer, DestinationPtr as integer ptr = 0, WidthX as integer = SCREEN_WIDTHX, WidthY as integer = SCREEN_WIDTHY)

    if (PosX > 0) and (PosX < WidthX) and (PosY > 0) and (PosY < SCREEN_WIDTHY) then
        DestinationPtr[PosY * WidthX + PosX] = Farbe
    end if

end sub

' *****************************************************************************
' Diese FUNCTION berprft, ob sich die Maus ber einer bestimmten Stelle befindet
function IsMouseOver (MouseInfo as MouseInfoType, MinX as integer, MinY as integer, MaxX as integer, MaxY as integer) as integer

    with MouseInfo
        return ((.PosX >= MinX) and (.PosY >= MinY) and (.PosX <= MaxX) and (.PosY <= MaxY))
    end with

end function

' *****************************************************************************
' Diese SUB ermittelt die Position der Maus etc.
sub GetMouseInfo (MouseInfo as MouseInfoType)

    ' temporre Variablen
    dim as integer PosX, PosY, Tasten

    with MouseInfo

        ' Doppelklick resetten
        if .DoubleClick = 1 then
            .DoubleClick = 0
            .DoubleClickTmp = 0
        end if

        ' Maus abfragen
        getmouse PosX, PosY, , Tasten

        ' Maus ber dem Fenster?
        if (PosX <> -1) then
            .PosX = PosX
            .PosY = PosY
            .Tasten = Tasten
        end if

        ' Maus entprellen
        .Tasten2 = .Tasten
        if .Tasten2 <> .tmp then
            .tmp = .Tasten2
            if .tmp and 1 then .Tasten2 = .Tasten2 and 1
        else
            .Tasten2 = 0
        end if

        ' Doppelklick?
        if .Tasten2 and 1 then
            .DoubleClickTmp+ = DoubleClickDelay
            if .DoubleClickTmp > DoubleClickDelay * 2 then .DoubleClickTmp = 0
        end if
        if .DoubleClickTmp > 0 then .DoubleClickTmp- = DoubleClickDecreaseValue
        if (.DoubleClickTmp > DoubleClickActive) then
            .DoubleClick = 1
        else
            .DoubleClick = 0
        end if

        ' normaler Cursor
        .Cursor = 1

    end with

end sub

' *****************************************************************************
' Diese SUB fragt die Tastatur ab
sub GetTastaturInfo (TastaturInfo as TastaturInfoType)

    TastaturInfo.Taste = inkey$

end sub

' *****************************************************************************
' Diese FUNCTION ldt ein Farbschema
function LoadDesign (DesignDaten as DesignType, DesignFile as string) as integer

    ' Variablen
    dim as string Zeile, Zeichen
    dim as string Var, Value
    dim as integer f, Position

    ' Datei ffnen und Werte einlesen
    f = freefile
    open DesignFile for input as #f
    do until eof(f)

        ' Zeile einlesen
        line input #f, Zeile
        Zeile = trim$(Zeile)

        ' Werte herausfiltern
        Var = ""
        for Position = 1 to len(Zeile) step 1
            Zeichen = mid$(Zeile, Position, 1)
            if Zeichen <> "=" then
                if asc(Zeichen) > 32 then Var+ = Zeichen
            else
                exit for
            end if
        next Position
        Position+ = 1
        Value = ""
        for Position = Position to len(Zeile) step 1
            Zeichen = mid$(Zeile, Position, 1)
            if asc(Zeichen) > 32 then Value+ = Zeichen
        next Position

        ' Werte zuweisen
        select case lcase$(Var)
            case "color1"
                DesignDaten.Color1 = val(Value)
            case "color2"
                DesignDaten.Color2 = val(Value)
            case "color3"
                DesignDaten.Color3 = val(Value)
            case "color4"
                DesignDaten.Color4 = val(Value)
            case "color5"
                DesignDaten.Color5 = val(Value)
            case "color6"
                DesignDaten.Color6 = val(Value)
            case "hoverboxcolor"
                DesignDaten.HoverBoxColor = val(Value)
        end select

    loop
    close #f

    ' geladen
    return -1

end function

' *****************************************************************************
' Diese FUNCTION erstellt einen Button
function CreateButton (ButtonDaten as ButtonType, PosX as integer, PosY as integer, WidthX as integer, WidthY as integer, Design as DesignType ptr, Text as TextType ptr, HoverText as HoverTextType ptr, Disabled as integer) as integer

    ' Werte einsetzen
    with ButtonDaten
        .PosX = PosX
        .PosY = PosY
        .WidthX = WidthX
        .WidthY = WidthY
        if (.WidthX or .WidthY) = 0 then
            .WidthX = GetFontTextLength(@.Text->font[0], Text->caption)
            .WidthY = .Text->font->MaxWidthY
        end if
        .Design = Design
        .Text = Text
        if (.Text->PosX  or .Text->PosY) = 0 then
            .Text->PosX = (.WidthX - GetFontTextLength (@.Text->font[0], Text->caption)) / 2
            .Text->PosY = (.WidthY - .Text->Font->MaxWidthY) / 2
        end if
        .HoverText = HoverText
        .Disabled = Disabled
        .Status = 0
        .Modus = BUTTON_NORMAL
    end with

    ' erfolgreich
    return -1

end function

' *****************************************************************************
' Diese SUB steuert einen Button
sub ControlButton (ButtonDaten as ButtonType, MouseInfo as MouseInfoType)

    ' Maus ber Button?
    with ButtonDaten

        if IsMouseOver(MouseInfo, .PosX, .PosY, .PosX + .WidthX - 1, .PosY + .WidthY - 1) then
            if .HoverText->DelayTick < .HoverText->Delay then
                .HoverText->DelayTick+ = 1
            else
                if ((MouseInfo.Tasten and 1) = 0) then 'and (len(.HoverText->Caption)) then
                	ShowHoverBox(MouseInfo.PosX, MouseInfo.PosY + 20, .HoverText[0], .PosX, .PosY)                    
                end if
            end if
            if (MouseInfo.Tasten2 and 1) and (.Disabled = 0) then
		if ((.Modus and BUTTON_TOGGLE) = 0) then
                    .Status = 1
		else
		    .Status = .Status xor 1
		    .Clicked = 1
		end if
            end if
            if (.Status = 1) and (Mouseinfo.Tasten = 0) then
                .Clicked = 1
                .HoverText->DelayTick = 0
            end if
        else
            .HoverText->DelayTick = 0
        end if
        if .Status = 0 then .Clicked = 0
	' was: if (MouseInfo.Tasten = 0) then
	if (MouseInfo.Tasten = 0) and ((.Modus and BUTTON_TOGGLE) = 0) then       
            .Status = 0
        end if

    end with

end sub

' *****************************************************************************
' Diese SUB zeigt einen Button an
sub ShowButton (ButtonDaten as ButtonType)

    ' Variablen
    dim as integer CenterX, CenterY

    ' Button zeichnen
    with ButtonDaten

        ' Form des Buttons
        if .Status = 0 then
            line (.PosX, .PosY)-(.PosX + .WidthX - 2, .PosY), .Design->Color2
            line (.PosX, .PosY)-(.PosX, .PosY + .WidthY - 2), .Design->Color2
            line (.PosX + 1, .PosY + 1)-(.PosX + .WidthX - 3, .PosY + .WidthY - 3), .Design->Color1, bf
            line (.PosX + .WidthX - 2, .PosY + 1)-(.PosX + .WidthX - 2, .PosY + .WidthY - 2), .Design->Color4
            line (.PosX + 1, .PosY + .WidthY - 2)-(.PosX + .WidthX - 2, .PosY + .WidthY - 2), .Design->Color4
            line (.PosX + .WidthX - 1, .PosY)-(.PosX + .WidthX - 1, .PosY + .WidthY - 1), .Design->Color3
            line (.PosX, .PosY + .WidthY - 1)-(.PosX + .WidthX - 1, .PosY + .WidthY - 1), .Design->Color3
        elseif .Status = 1 then
            line (.PosX, .PosY)-(.PosX + .WidthX - 2, .PosY), .Design->Color3
            line (.PosX, .PosY)-(.PosX, .PosY + .WidthY - 2), .Design->Color3
            line (.PosX + 1, .PosY + 1)-(.PosX + .WidthX - 2, .PosY + .WidthY - 2), .Design->Color1, bf
            line (.PosX + 1, .PosY + 1)-(.PosX + .WidthX - 3, .PosY + 1), .Design->Color4
            line (.PosX + 1, .PosY + 1)-(.PosX + 1, .PosY + .WidthY - 3), .Design->Color4
            line (.PosX, .PosY + .WidthY - 1)-(.PosX + .WidthX - 1, .PosY + .WidthY - 1), .Design->Color2
            line (.PosX + .WidthX - 1, .PosY)-(.PosX + .WidthX - 1, .PosY + .WidthY - 1), .Design->Color2
        end if

        ' Text immer anzeigen
        if .Disabled = 0 then
            PrintFont (@.Text->Font[0], .PosX + .Text->PosX + .Status - 1, .PosY + .Text->PosY + .Status - 1, .Text->Caption, .Design->Color5)
        else
            PrintFont (@.Text->Font[0], .PosX + .Text->PosX, .PosY + .Text->PosY, .Text->Caption, .Design->Color2)
            PrintFont (@.Text->Font[0], .PosX + .Text->PosX - 1, .PosY + .Text->PosY - 1, .Text->Caption, .Design->Color4)
        end if

        ' Graphischer Button
        if (.Modus and BUTTON_GRAPHICAL) then
            if .Disabled = 0 then
                put(.PosX + .ImageBG.PosX + .Status, .PosY + .ImageBG.PosY + .Status), .ImageBG.ImageData.ImagePointer, trans
            else
                put(.PosX + .ImageBG.PosX, .PosY + .ImageBG.PosY), .DisabledBG.ImageData.ImagePointer, trans
            end if
        end if

    end with

end sub

' *****************************************************************************
' Diese FUNCTION erstellt einen graphischen Button
function CreateGraphicalButton (ButtonDaten as ButtonType, PosX as integer, PosY as integer, WidthX as integer, WidthY as integer, Design as DesignType ptr, Text as TextType ptr, HoverText as HoverTextType ptr, Image as ImageType, ImageDisabled as ImageType, Disabled as integer) as integer

    ' Werte einsetzen
    with ButtonDaten
        .PosX = PosX
        .PosY = PosY      
        .Text = Text
        if (.Text->PosX  or .Text->PosY) = 0 then
            .Text->PosX = (.WidthX - GetFontTextLength (@.Text->Font[0], Text->Caption)) / 2
            .Text->PosY = (.WidthY - .Text->Font->MaxWidthY) / 2
        end if
        .HoverText = HoverText
        if WidthX > Image.ImageData.WidthX then
            .WidthX = WidthX
        else
            .WidthX = Image.ImageData.WidthX + 2
        end if
        if WidthY > Image.ImageData.WidthY then
            .WidthY = WidthY
        else
            .WidthY = Image.ImageData.WidthY + 2
        end if
        .Design = Design
        .ImageBG = Image
        if (Image.PosX or Image.PosY) = 0 then
            .ImageBG.PosX = (.WidthX - .ImageBG.ImageData.WidthX) / 2
            .ImageBG.PosY = (.WidthY - .ImageBG.ImageData.WidthY) / 2
        end if
        .DisabledBG = ImageDisabled
        if (ImageDisabled.PosX or ImageDisabled.PosY) = 0 then
            .DisabledBG.PosX = (.WidthX - .DisabledBG.ImageData.WidthX) / 2
            .DisabledBG.PosY = (.WidthY - .DisabledBG.ImageData.WidthY) / 2
        end if
        .Disabled = Disabled
        .Status = 0
        .Modus = BUTTON_GRAPHICAL
    end with

    ' erfolgreich
    return -1

end function

' *****************************************************************************
' Diese FUNCTION gibt den reservierten Speicherplatz der Button-Bilder frei
function DestroyGraphicalButton (ButtonDaten as ButtonType) as integer

    with ButtonDaten
        if .ImageBG.ImageData.ImagePointer then
            imagedestroy .ImageBG.ImageData.ImagePointer
        end if
        if .DisabledBG.ImageData.ImagePointer then
            imagedestroy .DisabledBG.ImageData.ImagePointer
        end if
    end with

    ' erfolgreich freigegeben
    return -1

end function

' *****************************************************************************
' Diese SUB zeichnet einen Hover-Text
sub ShowHoverBox (PosX as integer, PosY as integer, HoverTextDaten as HoverTextType, RelPosX as integer, RelPosY as integer)

    ' Variablen
    dim as integer TextLength
    dim as integer NewPosX, NewPosY

    with HoverTextDaten

        ' Lnge des Textes ermitteln
        TextLength = GetFontTextLength (@.Font[0], .Caption)
    
        ' Box und Text zeichnen
        if .Relativ = 0 then
            line(.PosX + PosX, .PosY + PosY)-(.PosX + PosX + TextLength + 10, .PosY + PosY + .Font->MaxWidthY + 1), .Design->Color5, b
            line(.PosX + PosX + 1, .PosY + PosY + 1)-(.PosX + PosX + TextLength + 9, .PosY + PosY + .Font->MaxWidthY), .Design->HoverBoxColor, bf
            PrintFont(@.Font[0], .PosX + PosX + 5, .PosY + PosY + 1, .Caption, rgb(220, 200, 200))
            PrintFont(@.Font[0], .PosX + PosX + 4, .PosY + PosY, .Caption, .Design->Color5)
        else
            line(.PosX + RelPosX, .PosY + RelPosY)-(.PosX + RelPosX + TextLength + 10, .PosY + RelPosY + .Font->MaxWidthY + 1), .Design->Color5, b
            line(.PosX + RelPosX + 1, .PosY + RelPosY + 1)-(.PosX + RelPosX + TextLength + 9, .PosY + RelPosY + .Font->MaxWidthY), .Design->HoverBoxColor, bf
            PrintFont(@.Font[0], .PosX + RelPosX + 5, .PosY + RelPosY + 1, .Caption, rgb(220, 200, 200))
            PrintFont(@.Font[0], .PosX + RelPosX + 4, .PosY + RelPosY, .Caption, .Design->Color5)
        end if

    end with

end sub

' *****************************************************************************
' Diese SUB zeichnet eine Box
sub ShowBox (Design as DesignType ptr, PosX as integer, PosY as integer, WidthX as integer, WidthY as integer)

    line (PosX, PosY)-(PosX + WidthX - 1, PosY + WidthY - 1), Design->Color1, bf
    line (PosX + 1, PosY + 1)-(PosX + WidthX - 2, PosY + 1), Design->Color2
    line (PosX + 1, PosY + 1)-(PosX + 1, PosY + WidthY - 2), Design->Color2
    line (PosX + 1, PosY + WidthY - 2)-(PosX + WidthX - 2, PosY + WidthY - 2), Design->Color4
    line (PosX + WidthX - 2, PosY + 1)-(PosX + WidthX - 2, PosY + WidthY - 2), Design->Color4
    line (PosX + WidthX - 1, PosY)-(PosX + WidthX - 1, PosY + WidthY - 1), Design->Color3
    line (PosX, PosY + WidthY - 1)-(PosX + WidthX - 1, PosY + WidthY - 1), Design->Color3

end sub

' *****************************************************************************
' Diese FUNCTION erstellt eine Section
function CreateSection (SectionDaten as SectionType, PosX as integer, PosY as integer, WidthX as integer, WidthY as integer, Font as FontType ptr, Caption as string, Design as DesignType ptr) as integer

    ' Daten schreiben
    with SectionDaten
        .PosX = PosX
        .PosY = PosY
        .WidthX = WidthX
        .WidthY = WidthY
        .Font = Font
        .Caption = Caption
        .Design = Design
    end with

    ' erfolgreich erstellt
    return -1

end function

' *****************************************************************************
' Diese SUB zeigt eine Section an
sub ShowSection (SectionDaten as Sectiontype) 

    ' Variablen
    dim as integer PosX2

    ' Section zeichnen
    with SectionDaten

        ' Die Grafik
        line (.PosX, .PosY)-(.PosX + 5, .PosY), .Design->Color4
        line (.PosX, .PosY)-(.PosX, .PosY + .WidthY - 2), .Design->Color4
        line (.PosX + 1, .PosY + 1)-(.PosX + 5, .PosY + 1), .Design->Color2
        line (.PosX + 1, .PosY + 1)-(.PosX + 1, .PosY + .WidthY - 2), .Design->Color2
        line (.PosX, .PosY + .WidthY - 1)-(.PosX + .WidthX - 1, .PosY + .WidthY - 1), .Design->Color4
        line (.PosX, .PosY + .WidthY)-(.PosX + .WidthX, .PosY + .WidthY), .Design->Color2
        line (.PosX + .WidthX - 1, .PosY)-(.PosX + .WidthX - 1, .PosY + .WidthY - 1), .Design->Color4
        line (.PosX + .WidthX, .PosY)-(.PosX + .WidthX, .PosY + .WidthY), .Design->Color2
        PosX2 = .PosX + GetFontTextLength(@.Font[0], .Caption) + 12
        line (PosX2, .PosY)-(.PosX + .WidthX - 1, .PosY), .Design->Color4
        line (PosX2, .PosY + 1)-(.PosX + .WidthX - 2, .PosY + 1), .Design->Color2

        ' und den Titel anzeigen
        PrintFont (@.Font[0], .PosX + 8, .PosY - .Font->MaxWidthY / 2, .Caption, .Design->Color5)

    end with

end sub

' *****************************************************************************
' Diese FUNCTION erstellt eine Textbox
function CreateTextBox (TextBoxDaten as TextBoxType, PosX as integer, PosY as integer, WidthX as integer, WidthY as integer, Design as DesignType ptr, Content as TextType, HoverText as HoverTextType ptr, Modus as integer, Disabled as integer = 0) as integer

    ' Daten schreiben
    with TextBoxDaten
        .PosX = PosX
        .PosY = PosY
        .Content = Content
        .WidthX = WidthX
        .WidthY = WidthY
        .Design = Design
        if .WidthY < .Content.Font->MaxWidthY + 6 then
            .WidthY = .Content.Font->MaxWidthY + 6
            .Content.PosY = 2
        else
            .Content.PosY = (.WidthY - .Content.Font->MaxWidthY) / 2
        end if
        .Visible = .Content.Caption
        .HoverText = HoverText
        .Disabled = Disabled
        .Modus = Modus
        .CursorPos = len(.Visible)
        .MinPosVis = 1
        .MaxPosVis = len(.Visible)
        .MinPosM = .CursorPos
        .MaxPosM = .CursorPos
        .LengthM = 0
        .Marked = 0
    end with

    ' Textbox erfolgreich erstellt
    return -1

end function

' *****************************************************************************
' Diese SUB setzt den Text einer Textbox
sub setText (TextBoxDaten as TextBoxType, Caption as string)

    ' Variablen
    dim as string Tmp

    ' Daten setzen
    with TextBoxDaten

        Caption = trim(Caption)
        .Content.Caption = Caption
        .Visible = .Content.Caption
        .CursorPos = len(.Visible)
        .MinPosVis = 1
        .MaxPosVis = len(.Visible)
        .MinPosM = .CursorPos
        .MaxPosM = .CursorPos


        ' Eingabe zu lang?
        if (GetFontTextLength(@.Content.Font[0], Caption) > .WidthX) then

            for Index = 1 to len(Caption) step 1
                Tmp+ = mid$(Caption, Index, 1)
                if GetFontTextLength(@.Content.Font[0], Tmp) > .WidthX - .Content.Font->MaxWidthX then
                    Index- = 1
                    exit for
                end if
            next Index
            .MinPosVis = 1
            .MaxPosVis = Index

        end if


    end with

end sub

' *****************************************************************************
' Diese SUB zeigt eine Textbox an
sub ShowTextBox (TextBoxDaten as TextBoxType)

    ' Variablen
    dim as integer CursorPosX, Index, Marked
    dim as string Zeichen

    with TextBoxDaten

        ' uere Umrisse zeichnen
        if .Disabled then
            line(.PosX, .PosY)-(.PosX + .WidthX - 1, .PosY + .WidthY - 1), .Design->Color2, b
        else
            line(.PosX, .PosY)-(.PosX + .WidthX - 1, .PosY + .WidthY - 1), .Design->Color2, bf
        end if
'        line(.PosX, .PosY)-(.PosX + .WidthX - 2, .PosY), .Design->Color4
'        line(.PosX, .PosY)-(.PosX, .PosY + .WidthY - 2), .Design->Color4
        line(.PosX + 1, .PosY + 1)-(.PosX + .WidthX - 3, .PosY + 1), .Design->Color3
        line(.PosX + 1, .PosY + 1)-(.PosX + 1, .PosY + .WidthY - 3), .Design->Color3
' was:    line(.PosX + 1, .PosY + .WidthY - 2)-(.PosX + .WidthX - 2, .PosY + .WidthY - 2), .Design->Color1
' was:    line(.PosX + .WidthX - 2, .PosY + 1)-(.PosX + .WidthX - 2, .PosY + .WidthY - 2), .Design->Color1
        line(.PosX + 1, .PosY + .WidthY - 2)-(.PosX + .WidthX - 2, .PosY + .WidthY - 2), .Design->Color4
        line(.PosX + .WidthX - 2, .PosY + 1)-(.PosX + .WidthX - 2, .PosY + .WidthY - 2), .Design->Color4

        ' Cursor blinken lassen
        if .Active then
            .CursorTick+ = 1
            if .CursorTick > 100 then .CursorTick = 0
        else
            .CursorTick = 0
        end if

        ' Text anzeigen?
        if .Modus = TEXTBOX_NORMAL then

            if .Disabled then
                PrintFont (@.Content.Font[0], .PosX + 2, .PosY + .Content.PosY, mid$(.Content.Caption, .MinPosVis, .MaxPosVis - .MinPosVis + 1), .Design->Color1)
            else
                for Index = .MinPosVis to .MaxPosVis step 1
                    Zeichen = mid$(.Content.Caption, Index, 1)
                    ' was: PrintFont (@.Content.Font[0], .PosX + 2 + GetFontTextLength(@.Content.Font[0], mid$(.Content.Caption, .MinPosVis, Index - .MinPosVis)), .PosY + .Content.PosY, Zeichen, .Design->Color5)
                    PrintFont (@.Content.Font[0], .PosX + 2 + GetFontTextLength(@.Content.Font[0], mid$(.Content.Caption, .MinPosVis, Index - .MinPosVis)), .PosY + .Content.PosY, Zeichen, .Design->Color5)
                next Index
                CursorPosX = .PosX + 2 + GetFontTextLength(@.Content.Font[0], mid$(.Content.Caption, .MinPosVis, .CursorPos - .MinPosVis + 1))
                if (.CursorTick < 50) and (.Active = 1) then
                    PrintFont(@.Content.Font[0], CursorPosX, .PosY + .Content.PosY, chr$(124), .Design->Color5)
                end if
            end if

        ' oder Passwort-Textbox?
        else
            if .Disabled then
                PrintFont (@.Content.Font[0], .PosX + 2, .PosY + .Content.PosY, mid$(string$(len(.Content.Caption), "*"), .MinPosVis, .MaxPosVis - .MinPosVis + 1), .Design->Color4)
            else
                PrintFont (@.Content.Font[0], .PosX + 2, .PosY + .Content.PosY, mid$(string$(len(.Content.Caption), "*"), .MinPosVis, .MaxPosVis - .MinPosVis + 1), .Design->Color5)
                CursorPosX = .PosX + 2 + GetFontTextLength(@.Content.Font[0], mid$(string$(len(.Content.Caption), "*"), .MinPosVis, .CursorPos - .MinPosVis + 1))
                if (.CursorTick < 50) and (.Active = 1) then PrintFont(@.Content.Font[0], CursorPosX, .PosY, "|", .Design->Color5)
            end if
        end if

    end with

end sub

' *****************************************************************************
' Diese FUNCTION ldt ein beliebiges Bitmap
function TranslateToImageDataType (DateiName as string) as ImageDataType

    ' Variablen
    dim as integer WidthPixel, HeightPixel
    dim as integer ptr ImagePointer
    dim as ImageDataType TMP
    
    ' Gre des Bildes ermitteln
    dim as byte f
    f = freefile
    open DateiName for binary access read as #f
        get #f, 19, WidthPixel
        get #f, 23, HeightPixel
    close #f

    ' Bild laden
    ImagePointer = imagecreate(WidthPixel, HeightPixel)
    bload DateiName, ImagePointer

    ' Daten zurckgeben
    TMP.WidthX = WidthPixel
    TMP.WidthY = HeightPixel
    TMP.ImagePointer = ImagePointer
    return TMP

end function

' *****************************************************************************
' Diese FUNCTION verteilt die Argumente auf den Datentyp ImageType
function TranslateToImageType (PosX as integer, PosY as integer, ImageData as ImageDataType) as ImageType

    ' Variable
    dim as ImageType Tmp

    ' Daten schreiben
    Tmp.PosX = PosX
    Tmp.PosY = PosY
    Tmp.ImageData = ImageData

    ' und zurckgeben
    return Tmp

end function

' *****************************************************************************
' Diese FUNCTION verteilt die Argumente auf den Datentyp TextType
function TranslateToTextType (PosX as integer, PosY as integer, caption as string, font as FontType ptr) as TextType ptr

    ' Variable
    dim as TextType ptr Tmp
    Tmp = callocate(sizeof(TextType))

    ' Daten schreiben
    Tmp->PosX = PosX
    Tmp->PosY = PosY
    Tmp->caption = caption
    Tmp->font = font
    
    ' und zurckgeben
    return Tmp

end function

' *****************************************************************************
' Diese FUNCTION verteilt die Argumente auf den Datentyp HoverTextType
function TranslateToHoverTextType (PosX as integer, PosY as integer, Relativ as integer, Delay as integer, font as FontType ptr, Design as DesignType ptr, caption as string) as HoverTextType ptr

    ' Variable
    dim as HoverTextType ptr Tmp
    Tmp = callocate(sizeof(HoverTextType))

    ' Daten schreiben
    Tmp->PosX = PosX
    Tmp->PosY = PosY
    Tmp->Relativ = Relativ
    Tmp->Delay = Delay
    Tmp->Font = Font
    Tmp->Design = Design
    Tmp->Caption = Caption

    ' und zurckgeben
    return Tmp

end function