' *******************************************************************
' *                                                                 *
' *  Quick'n'Easy                                                   *
' *  Contact-List                                                   *
' *                                                                 *
' *  pogrammiert von Jens Boos                                      *
' *                                                                 *
' *  vom 16.07.09 bis zum 18.07.09                                  *
' *                                                                 *
' *  Copyright www.jb-electronics.de 2009                           *
' *                                                                 *
' *  Zur genaueren Erklrung des Programms schauen Sie              *
' *  bitte in die Datei Readme.txt                                  *
' *                                                                 *
' *******************************************************************
' *                                                                 *
' *  Programmiert in freeBASIC Version 0.20.0b                      *
' *                                                                 *
' *******************************************************************

' *****************************************************************************
' Dynamische Arrays
'$dynamic

' *****************************************************************************
' Wichtige globale Konstanten, Quasi-Konstanten und sonstige defines
dim shared as integer SCREEN_WIDTHX = 310
dim shared as integer SCREEN_WIDTHY = 625
#define IMAGE_RESIZE 	1       
#define fbOkOnly 		0
#define fbYesNo			4
#define fbExclamation 	48
#define fbInformation 	64
#undef name
#undef var
#undef value

' *****************************************************************************
' Einbinden der externen Definitionen etc. 
#include "windows.bi"
#include once "win\commdlg.bi"
#include "vbcompat.bi"
#include once "crt.bi"
#include once "freeimage.bi" 

' *****************************************************************************
' Einbinden der GUI-Elemente
#include "res/gui/gui.bi"

' *****************************************************************************
' Deklarationen der SUBs und FUNCTIONs

declare function convert (Wort$, direction = 0) as string
declare function Datum () as string
declare function getAlter (datum1 as string) as integer
declare function getLastChar (Ausdruck as string, what as string) as integer
declare function getMonth (Ausdruck as string) as integer
declare function sameDay (datum1 as string, datum2 as string) as integer
declare function SearchFile (Titel as string, Pfad as string, Filter as string) as string
declare function ShortPathName (FileName as string) as string
declare sub checkBirthday ()
declare sub control ()
declare sub display ()
declare sub updatePicture ()
declare sub writeToClipboard (Text as string)

declare sub mmxcopy cdecl alias "fb_hMemCpyMMX" (byval dest as any ptr, byval src as any ptr, byval size as integer)
declare function FIBitmap2FBImage(byval Dib as FIBITMAP ptr) as integer ptr
declare function getImage (FileName as string, Resize as integer = 0) as ImageDataType

' *****************************************************************************
' Videomodus- und Fenstereinstellungen
screenres SCREEN_WIDTHX, SCREEN_WIDTHY, 32, 2
screenset 1, 2
windowtitle "Quick'n'Easy Contact List"

' *****************************************************************************
' UDT fr die Kontakte
type ContactType
	Name			as string
	Festnetz		as string
	Handy			as string
	Email			as string
	Strasse			as string
	StadtLandPLZ	as string
	Geburtstag		as string
	Sonstiges		as string
	ImageURL		as string
	folder			as string
end type
dim shared as ContactType Contacts(0)
dim shared as integer ContactIndex = 1

declare sub gotoContact (Letter as string)
declare sub gotoFirst ()
declare sub gotoLast ()
declare sub gotoNext ()
declare sub gotoPrevious ()
declare sub loadContacts (noSave as integer = 0)
declare sub saveContacts (IndexC as integer = 0)

' *****************************************************************************
' Hilfsvariable zur GUI-Erstellung
dim as integer OK

' *****************************************************************************
' Die Schriftart
dim shared as FontType defaultFont
OK = LoadFont(@defaultFont, exepath + "\res\other\arial.jbfnt")

' *****************************************************************************
' Design laden
dim shared as DesignType Design
LoadDesign (Design, exepath + "\res\other\blue.des")
color , Design.Color1
cls

' *****************************************************************************
' Initialisierungen zur GUI

' Sections
dim shared as SectionType Daten
OK = CreateSection(Daten, 5, 130, 300, 425, @defaultFont, "Daten:", @Design)

' Buttons
dim shared as ButtonType Zurueck, Vor, CB1, CB2, CB3, CB4, CB5, CB6, CB7, CB8, Readme, Credits, Zurueck2
OK = CreateGraphicalButton(Zurueck, 5, 561, 54, 54, @Design, TranslateToTextType(0, 0, "", @defaultFont), TranslateToHoverTextType(2, 2, 1, 20, @defaultFont, @Design, "Zurck"), TranslateToImageType(0, 0, getImage("res/img/zurueck.png")), TranslateToImageType(0, 0, getImage("res/img/zurueck_disabled.png")), 0)
OK = CreateGraphicalButton(Vor, 251, 561, 54, 54, @Design, TranslateToTextType(0, 0, "", @defaultFont), TranslateToHoverTextType(2, 2, 1, 20, @defaultFont, @Design, "Vor"), TranslateToImageType(0, 0, getImage("res/img/vor.png")), TranslateToImageType(0, 0, getImage("res/img/vor_disabled.png")), 0)
OK = CreateGraphicalButton(CB1, 273, 349, 25, 22, @Design, TranslateToTextType(0, 0, "", @defaultFont), TranslateToHoverTextType(-110, 2, 1, 20, @defaultFont, @Design, "Namen kopieren"), TranslateToImageType(0, 0, getImage("res/img/c.png")), TranslateToImageType(0, 0, getImage("res/img/c.png")), 0)
OK = CreateGraphicalButton(CB2, 273, 374, 25, 22, @Design, TranslateToTextType(0, 0, "", @defaultFont), TranslateToHoverTextType(-170, 2, 1, 20, @defaultFont, @Design, "Festnetznummer kopieren"), TranslateToImageType(0, 0, getImage("res/img/c.png")), TranslateToImageType(0, 0, getImage("res/img/c.png")), 0)
OK = CreateGraphicalButton(CB3, 273, 399, 25, 22, @Design, TranslateToTextType(0, 0, "", @defaultFont), TranslateToHoverTextType(-154, 2, 1, 20, @defaultFont, @Design, "Handynummer kopieren"), TranslateToImageType(0, 0, getImage("res/img/c.png")), TranslateToImageType(0, 0, getImage("res/img/c.png")), 0)
OK = CreateGraphicalButton(CB4, 273, 424, 25, 22, @Design, TranslateToTextType(0, 0, "", @defaultFont), TranslateToHoverTextType(-149, 2, 1, 20, @defaultFont, @Design, "Emailadresse kopieren"), TranslateToImageType(0, 0, getImage("res/img/c.png")), TranslateToImageType(0, 0, getImage("res/img/c.png")), 0)
OK = CreateGraphicalButton(CB5, 273, 449, 25, 22, @Design, TranslateToTextType(0, 0, "", @defaultFont), TranslateToHoverTextType(-150, 2, 1, 20, @defaultFont, @Design, "Adresszeile 1 kopieren"), TranslateToImageType(0, 0, getImage("res/img/c.png")), TranslateToImageType(0, 0, getImage("res/img/c.png")), 0)
OK = CreateGraphicalButton(CB6, 273, 474, 25, 22, @Design, TranslateToTextType(0, 0, "", @defaultFont), TranslateToHoverTextType(-153, 2, 1, 20, @defaultFont, @Design, "Adresszeile 2 kopieren"), TranslateToImageType(0, 0, getImage("res/img/c.png")), TranslateToImageType(0, 0, getImage("res/img/c.png")), 0)
OK = CreateGraphicalButton(CB7, 273, 499, 25, 22, @Design, TranslateToTextType(0, 0, "", @defaultFont), TranslateToHoverTextType(-136, 2, 1, 20, @defaultFont, @Design, "Geburtstag kopieren"), TranslateToImageType(0, 0, getImage("res/img/c.png")), TranslateToImageType(0, 0, getImage("res/img/c.png")), 0)
OK = CreateGraphicalButton(CB8, 273, 524, 25, 22, @Design, TranslateToTextType(0, 0, "", @defaultFont), TranslateToHoverTextType(-128, 2, 1, 20, @defaultFont, @Design, "Sonstiges kopieren"), TranslateToImageType(0, 0, getImage("res/img/c.png")), TranslateToImageType(0, 0, getImage("res/img/c.png")), 0)
OK = CreateGraphicalButton(Readme, 65, 561, 180, 25, @Design, TranslateToTextType(0, 0, "", @defaultFont), TranslateToHoverTextType(1, -20, 1, 20, @defaultFont, @Design, "Readme aufrufen"), TranslateToImageType(0, 0, getImage("res/img/readme.png")), TranslateToImageType(0, 0, getImage("res/img/readme.png")), 0)
OK = CreateGraphicalButton(Credits, 65, 590, 180, 25, @Design, TranslateToTextType(0, 0, "", @defaultFont), TranslateToHoverTextType(1, -20, 1, 20, @defaultFont, @Design, "Credits aufrufen"), TranslateToImageType(0, 0, getImage("res/img/credits.png")), TranslateToImageType(0, 0, getImage("res/img/credits.png")), 0)
OK = CreateGraphicalButton(Zurueck2, 110, 265, 180, 32, @Design, TranslateToTextType(0, 0, "", @defaultFont), TranslateToHoverTextType(1, -20, 1, 20, @defaultFont, @Design, "Zurck"), TranslateToImageType(0, 0, getImage("res/img/zurueck2.png")), TranslateToImageType(0, 0, getImage("res/img/zurueck2.png")), 0)
CB1.Modus or = BUTTON_TOGGLE
CB2.Modus or = BUTTON_TOGGLE
CB3.Modus or = BUTTON_TOGGLE
CB4.Modus or = BUTTON_TOGGLE
CB5.Modus or = BUTTON_TOGGLE
CB6.Modus or = BUTTON_TOGGLE
CB7.Modus or = BUTTON_TOGGLE
CB8.Modus or = BUTTON_TOGGLE

' Textfelder
dim shared as TextBoxType Name, Festnetz, Handy, Email, Strasse, StadtLandPLZ, Geburtstag, Sonstiges
OK = CreateTextBox(Name, 87, 348, 180, 0, @Design, *TranslateToTextType(0, 0, "", @defaultFont), TranslateToHoverTextType(0, 0, 0, 0, @defaultFont, @Design, ""), TEXTBOX_NORMAL)
OK = CreateTextBox(Festnetz, 87, 373, 180, 0, @Design, *TranslateToTextType(0, 0, "", @defaultFont), TranslateToHoverTextType(0, 0, 0, 0, @defaultFont, @Design, ""), TEXTBOX_NORMAL)
OK = CreateTextBox(Handy, 87, 398, 180, 0, @Design, *TranslateToTextType(0, 0, "", @defaultFont), TranslateToHoverTextType(0, 0, 0, 0, @defaultFont, @Design, ""), TEXTBOX_NORMAL)
OK = CreateTextBox(Email, 87, 423, 180, 0, @Design, *TranslateToTextType(0, 0, "", @defaultFont), TranslateToHoverTextType(0, 0, 0, 0, @defaultFont, @Design, ""), TEXTBOX_NORMAL)
OK = CreateTextBox(Strasse, 87, 448, 180, 0, @Design, *TranslateToTextType(0, 0, "", @defaultFont), translateToHoverTextType(0, 0, 0, 0, @defaultFont, @Design, ""), TEXTBOX_NORMAL)
OK = CreateTextBox(StadtLandPLZ, 87, 473, 180, 0, @Design, *TranslateToTextType(0, 0, "", @defaultFont), TranslateToHoverTextType(0, 0, 0, 0, @defaultFont, @Design, ""), TEXTBOX_NORMAL)
OK = CreateTextBox(Geburtstag, 87, 498, 180, 0, @Design, *TranslateToTextType(0, 0, "", @defaultFont), TranslateToHoverTextType(0, 0, 0, 0, @defaultFont, @Design, ""), TEXTBOX_NORMAL)
OK = CreateTextBox(Sonstiges, 87, 523, 180, 0, @Design, *TranslateToTextType(0, 0, "", @defaultFont), TranslateToHoverTextType(0, 0, 0, 0, @defaultFont, @Design, ""), TEXTBOX_NORMAL)

' Die Maus
dim shared as MouseInfoType Mouse

' Dia Tastatur
dim shared as string Taste

' *****************************************************************************
' Sonstige Bildpuffer
dim shared as ImageDataType Logo, CreditsBG, currentPicture
dim shared as integer ptr Picture
Logo = getImage(exepath + "\res\img\logo.png")
CreditsBG = getImage(exepath + "\res\img\credits_large.png")
Picture = imagecreate(SCREEN_WIDTHX, 200)

' ****************************************************************************
' Variablen fr den Programmablauf
dim shared as integer firstRun = 1, KeyLock = 0
dim shared as integer MenuModus = 1

' *****************************************************************************
' Alle Kontakte laden
loadContacts ()

' ****************************************************************************'
' Beginn der Hauptschleife
do

	' Hat jemand Gebutstag?
	if (firstRun = 1) then
    	checkBirthday ()
    	firstRun = 0
	end if

	' Tastensperre beenden?
	if (KeyLock) then
		KeyLock = 0
	end if

	' Maus- und Tastaturinfo holen
    GetMouseInfo (Mouse)   
    Taste = inkey

	' ****************************************************************************
	' Das Hauptfenster
	if (MenuModus = 1) then

		' Link auf www.jb-eletronics.de
		if IsMouseOver (Mouse, 90, 70, 203, 82) and (Mouse.Tasten2 and 1) then
			shell "start http://www.jb-electronics.de/"
		end if
	
		' GUI-Elemente etc. anzeigen
		display ()
		
		' GUI-Elemente steuern und auf Tasteneingaben reagieren
		control ()

		' Beenden?
		if (((Taste = chr(27)) or (Taste = chr(255) + "k")) and (KeyLock = 0)) then
			exit do
		end if

	end if
	
	' ****************************************************************************
	' Das Credit-Fenster
	if (MenuModus = 2) then
		
		' Der Hintergrund
		put (0, 0), CreditsBG.ImagePointer, trans		

		' Der "Zurck"-Button
		ShowButton (Zurueck2)
		ControlButton (Zurueck2, Mouse)
		if (Zurueck2.Clicked) or ((Taste = chr(27)) and (KeyLock = 0)) then
			SCREEN_WIDTHX = 310
			SCREEN_WIDTHY = 625
			screenres SCREEN_WIDTHX, SCREEN_WIDTHY, 32, 2
			screenset 1, 2
			color , Design.Color1			
			MenuModus = 1			
		end if
		if (Taste = chr(255) + "k") then
			exit do
		end if
			
	end if

	' Doublebuffering, um Flimmern zu verhindern
    screencopy
    cls

	' Warteschleife fr den Prozessor
    sleep 50

loop

' ****************************************************************************'
' Kontaktdaten abspeichern
saveContacts ()

' *****************************************************************************
' Speicher leeren

OK = UnLoadFont(@defaultFont)

OK = DestroyGraphicalButton(Zurueck)
OK = DestroyGraphicalButton(Vor)
OK = DestroyGraphicalButton(CB1)
OK = DestroyGraphicalButton(CB2)
OK = DestroyGraphicalButton(CB3)
OK = DestroyGraphicalButton(CB4)
OK = DestroyGraphicalButton(CB5)
OK = DestroyGraphicalButton(CB6)
OK = DestroyGraphicalButton(CB7)
OK = DestroyGraphicalButton(CB8)
OK = DestroyGraphicalButton(Readme)
OK = DestroyGraphicalButton(Credits)
OK = DestroyGraphicalButton(Zurueck2)

imagedestroy Logo.ImagePointer
imagedestroy CreditsBG.ImagePointer
imagedestroy currentPicture.ImagePointer
imagedestroy Picture

end

' *****************************************************************************
' Es folgen die SUBs und FUNCTIONS

' *****************************************************************************
' Diese FUNCTION konvertiert zwischen WIndows-ASCII und DOS-ASCII
function convert (Ausdruck as string, direction = 0) as string
 
	' Variablen
	dim as string Zeichen, NeuerText
	dim as integer Index
 
	' Schleife ber alle Buchstaben
	for Index = 1 to len(Ausdruck) step 1
  
   		' Zeichen extrahieren
   		Zeichen = mid(Ausdruck, Index, 1)

		' In welche Richtung konvertieren?
		if direction = 0 then 

			select case Zeichen

				case "": Zeichen = chr(132)
				case "": Zeichen = chr(142)
				case "": Zeichen = chr(160)
				case "": Zeichen = chr(181)
				case "": Zeichen = chr(133)
				case "": Zeichen = chr(183)
				case "": Zeichen = chr(131)
				case "": Zeichen = chr(182)
				case "": Zeichen = chr(134)
				case "": Zeichen = chr(143)
				case "": Zeichen = chr(145)
				case "": Zeichen = chr(146)

				case "": Zeichen = chr(137)
				case "": Zeichen = chr(211)
				case "": Zeichen = chr(130)
				case "": Zeichen = chr(144)
				case "": Zeichen = chr(138)
				case "": Zeichen = chr(212)
				case "": Zeichen = chr(136)
				case "": Zeichen = chr(210)

				case "": Zeichen = chr(139)
				case "": Zeichen = chr(216)
				case "": Zeichen = chr(161)
				case "": Zeichen = chr(214)
				case "": Zeichen = chr(141)
				case "": Zeichen = chr(222)
				case "": Zeichen = chr(140)
				case "": Zeichen = chr(215)

				case "": Zeichen = chr(148)
				case "": Zeichen = chr(153)
				case "": Zeichen = chr(162)
				case "": Zeichen = chr(224)
				case "": Zeichen = chr(149)
				case "": Zeichen = chr(227)
				case "": Zeichen = chr(147)
				case "": Zeichen = chr(226)
				case "": Zeichen = chr(228)
				case "": Zeichen = chr(229)

				case "": Zeichen = chr(129)
				case "": Zeichen = chr(154)
				case "": Zeichen = chr(163)
				case "": Zeichen = chr(233)
				case "": Zeichen = chr(151)
				case "": Zeichen = chr(235)
				case "": Zeichen = chr(150)
				case "": Zeichen = chr(234)

				case "": Zeichen = chr(225)

				case "": Zeichen = chr(135)
				case "": Zeichen = chr(128)

				case "": Zeichen = chr(164)
				case "": Zeichen = chr(165)

			end select
  
		else

			select case Zeichen

				case chr(132): Zeichen = ""
				case chr(142): Zeichen = ""
				case chr(160): Zeichen = ""
				case chr(181): Zeichen = ""
				case chr(133): Zeichen = ""
				case chr(183): Zeichen = ""
				case chr(131): Zeichen = ""
				case chr(182): Zeichen = ""
				case chr(134): Zeichen = ""
				case chr(143): Zeichen = ""
				case chr(145): Zeichen = ""
				case chr(146): Zeichen = ""

				case chr(137): Zeichen = ""
				case chr(211): Zeichen = ""
				case chr(130): Zeichen = ""
				case chr(144): Zeichen = ""
				case chr(138): Zeichen = ""
				case chr(212): Zeichen = ""
				case chr(136): Zeichen = ""
				case chr(210): Zeichen = ""

				case chr(139): Zeichen = ""
				case chr(216): Zeichen = ""
				case chr(161): Zeichen = ""
				case chr(214): Zeichen = ""
				case chr(141): Zeichen = ""
				case chr(222): Zeichen = ""
				case chr(140): Zeichen = ""
				case chr(215): Zeichen = ""

				case chr(148): Zeichen = ""
				case chr(153): Zeichen = ""
				case chr(162): Zeichen = ""
				case chr(224): Zeichen = ""
				case chr(149): Zeichen = ""
				case chr(227): Zeichen = ""
				case chr(147): Zeichen = ""
				case chr(226): Zeichen = ""
				case chr(228): Zeichen = ""
				case chr(229): Zeichen = ""

				case chr(129): Zeichen = ""
				case chr(154): Zeichen = ""
				case chr(163): Zeichen = ""
				case chr(233): Zeichen = ""
				case chr(151): Zeichen = ""
				case chr(235): Zeichen = ""
				case chr(150): Zeichen = ""
				case chr(234): Zeichen = ""

				case chr(225): Zeichen = ""

				case chr(135): Zeichen = ""
				case chr(128): Zeichen = ""

				case chr(164): Zeichen = ""
				case chr(165): Zeichen = ""

			end select

		end if
		
		' Konvertiertes Zeichen hinzufgen
		NeuerText+ = Zeichen
  
	next Index

 	' konvertierten Wert zurckgeben
	return NeuerText 

end function

' *****************************************************************************
' Diese FUNCTION gibt das Datum in deutscher Schreibweise zurck
function Datum () as string
 
	return trim(mid(date, 4, 2) & "." & left(date$, 2) & "." & right(date, 4))
 
end function

' *****************************************************************************
' Diese FUNCTION ermittelt das Alter einer Person in Jahren
function getAlter (datum1 as string) as integer

	' Variablen
	dim as string jahr1, jahr2, jahr2_2, jahrtausend
	dim as integer Index, PunktCount

	' gemischte Schreibweise? (d.h. kommt der Punkt nur einmal vor?)
	for Index = 1 to len(datum1) step 1
		if (mid(datum1, Index, 1) = ".") then
			PunktCount+ = 1
		end if
	next

	' In welchem Code wurde das Jahr angegeben?
	' dazu Daten extrahieren
	if (PunktCount = 2) then
		jahr1 = mid(datum1, getLastChar(datum1, ".") + 1)
	else
		jahr1 = mid(datum1, getLastChar(datum1, " ") + 1)
	end if
	jahr2 = mid(Datum(), getLastChar(Datum(), ".") + 1)
	jahr2_2 = right(jahr2, 2)
	
	' einstellige und dreistellige Jahresangabe abfangen
	if ((len(jahr1) = 1) or (len(jahr1) = 3)) then
		jahr1 = "0" + jahr1
	end if
	
	' bei vierstelliger Angabe kein Problem	
	if len(jahr1) >= 4 then
		return (val(jahr2) - val(jahr1))
		
	' bei zweistelliger Angabe schon
	else

		' Jahrhundert ermitteln
		dim as integer jahrhundert
		jahrhundert = val(left(jahr2, 2)) + 1

		' Kann die Jahresangabe nicht aus diesem Jahrhundert sein? Dann nehme das vorherige an.
		if val(jahr1) > val(jahr2_2) then
				return (val(jahr2) - val(trim(str(jahrhundert - 2)) & jahr1))

		' Angabe kann aus diesem Jahrhundert sein
		else
			return (val(jahr2) - val(trim(str(jahrhundert - 1)) & jahr1))

		end if

	end if

end function

' *****************************************************************************
' Diese FUNCTION sucht das letzte bestimmte Zeichen
function getLastChar (Ausdruck as string, what as string) as integer

    dim as integer StringPosition, StringLength
    StringLength = len(Ausdruck)
    for StringPosition = StringLength to 1 step -1
        if mid(Ausdruck, StringPosition, 1) = what then
            return StringPosition
        end if
    next StringPosition
    return 0

end function

' *****************************************************************************
' Diese FUNCTION ermittelt den Monatsindex zum ausgeschriebenen Monatsnamen
function getMonth (Ausdruck as string) as integer
	
	' welcher Monat?
	select case lcase(trim(Ausdruck))
		
		case "januar"
			return 1
			
		case "februar"
			return 2
			
		case "mrz"
			return 3
			
		case "april"
			return 4
			
		case "mai"
			return 5
			
		case "juni"
			return 6
			
		case "juli"
			return 7
			
		case "august"
			return 8
			
		case "september"
			return 9
			
		case "oktober"
			return 10
			
		case "november"
			return 11
			
		case "dezember"
			return 12
		
	end select
	
end function

' *****************************************************************************
' Diese FUNCTION berprft, ob zwei Datumsangaben identisch sind
function sameDay (datum1 as string, datum2 as string) as integer

	' Variablen
	dim as integer Index, flag
	dim as string tag, monat
	dim as string Zeichen
	
	' berhaupt ein Geburtsdatum angegeben?
	if (len(trim(datum1)) = 0) then
		return 0
	end if
	
	' Daten extrahieren
	for Index = 0 to len(datum1) step 1

		Zeichen = trim(mid(datum1, Index, 1))

		if Zeichen = "." then
			flag+ = 1			
		elseif (flag = 0) then
			tag+ = Zeichen
		elseif (flag = 1) then
			monat+ = Zeichen
		endif
	
	next Index

	' Ist der Montat vielleicht ausgeschrieben?
	if ((val(monat) < 1) or (val(monat) > 12)) then
		
		' Monat neu extrahieren
		monat = trim(mid(datum1, getLastChar(datum1, ".") + 1))	
		monat = trim(left(monat, getLastChar(monat, " ") - 1))
		
		' Monatsnamen in Zahl konvertieren
		monat = str(getMonth(monat))		
		
	end if

	return ((val(tag) = val(left(datum2, 2))) and (val(monat) = val(mid(datum2, 4, 2))))
	
end function

' *****************************************************************************
' Diese FUNCTION erstellt den Windows-API-Datei-Laden-Dialog
function SearchFile (Titel as string, Pfad as string, Filter as string) as string

    ' TYPE fr den Datei-ffnen-Dialog
    dim as OpenFileName OpenSaveData

    ' Einstellungen festlegen
    with OpenSaveData

        dim as string * 2048 Datei, DateiTitel
        Datei = space$(2047) + chr$(0)
        DateiTitel = string$(2048, chr$(0))
        .lStructSize = len(OpenSaveData)
        .hwndOwner = 0
        .hInstance = 0
        .lpstrFilter = strptr(Filter)
        .nFilterIndex = 1
        .lpstrFile = strptr(Datei)
        .nMaxFile = len(Datei)
        .lpstrFileTitle = strptr(DateiTitel)
        .nMaxFileTitle = len(DateiTitel)

        ' Vorgegebenes Verzeichnis
        .lpstrInitialDir = strptr(Pfad)

        ' Titel festlegen
        .lpstrTitle = strptr(Titel)

        ' Datei geladen?
        if GetOpenFileName(@OpenSaveData) then return trim$(Datei)

    end with

end function

' *****************************************************************************
' Diese FUNCTION erstellt einen kurzen Pfadnamen aus einem langen
function ShortPathName (FileName as string) as string

    dim result as long
    dim ShortName as string
    ShortName = space$(256)
    result = getshortpathname(FileName, ShortName, len(ShortName)) 
    if result > 0 then 
        return ShortName
    else
        return ""
    end if
    
end function

' *****************************************************************************
' Diese SUB berprft, ob der Geburtstag eines Kontaktes heute ist
sub checkBirthday ()
	
	' Variablen
	dim as integer Index, ALter
	
	' Schleife ber alle Kontakte
	for Index = 1 to ubound(Contacts) step 1

		' ist heute ein Geburtstag?
		if sameDay(Contacts(Index).Geburtstag, Datum()) then			

			' Kontakt anzeigen
			ContactIndex = Index
			updatePicture ()
			display ()
			screencopy
			cls			
		
			' Alter ermitteln
			Alter = getAlter(Contacts(Index).Geburtstag)
		
			' Messagebox erstellen
			KeyLock = 1			
			dim as integer msg
			if (Alter > 0) then
				if (Alter = 1) then
					msg = MessageBox (NULL, chr(13) & "Heute hat " & Contacts(Index).Name & " Geburtstag, und wird schon " & Alter & " Jahr alt." & chr(13, 13) & "Herzlichen Glckwunsch!", "Geburtstag", fbOKOnly or fbInformation)
				else
					msg = MessageBox (NULL, chr(13) & "Heute hat " & Contacts(Index).Name & " Geburtstag, und wird ganze " & Alter & " Jahre alt." & chr(13, 13) & "Herzlichen Glckwunsch!", "Geburtstag", fbOKOnly or fbInformation)
				end if
			elseif (Alter = 0) then
				msg = MessageBox (NULL, chr(13) & "Heute hat " & Contacts(Index).Name & " Geburtstag, und zwar im wrtlichen Sinne!" & chr(13, 13) & "Herzlichen Glckwunsch!", "Geburtstag", fbOKOnly or fbInformation)
			else
				msg = MessageBox (NULL, chr(13) & "Heute in " & (-Alter) & " Jahren wird einmal " & Contacts(Index).Name & " das Licht der Welt erblicken." & chr(13, 13) & "Herzlichen Glckwunsch!", "Geburtstag", fbOKOnly or fbInformation)
			end if

		end if

	next Index

end sub

' *****************************************************************************
' Diese SUB bernimmt die Steuerungen
sub control ()

	' Variablen
	dim as integer ClipboardWanted, Index
	dim as string Clipboard, tmp

	' Daten ndern?
	if (ubound(Contacts)) then

  		' Neue Bilddatei?
		if IsMouseOver (Mouse, (SCREEN_WIDTHX - currentPicture.WidthX) / 2, 140 + (200 - currentPicture.WidthY) / 2, (SCREEN_WIDTHX + currentPicture.WidthX) / 2, 340 + (200 - currentPicture.WidthY) / 2) and (Mouse.DoubleClick) then	 
			KeyLock = 1
			tmp = Contacts(ContactIndex).ImageURL 		
			Contacts(ContactIndex).ImageURL = SearchFile("Bilddatei auswhlen", exepath + "\" + Contacts(ContactIndex).folder, "Bilddateien" + chr(0) + "*.*" + chr(0))
			if (len(trim(Contacts(ContactIndex).ImageURL)) = 0) then
				Contacts(ContactIndex).ImageURL = tmp
			else
				saveContacts (ContactIndex)
				loadContacts ()
			end if		
		end if
	
		'Sonstige Daten bearbeiten?
		if ((IsMouseOver (Mouse, 87, 350, 245, 545) and Mouse.DoubleClick) and fileexists(exepath + "\" + Contacts(ContactIndex).folder + "\daten.txt")) then
			shell "start " + ShortPathName(exepath + "\" + Contacts(ContactIndex).folder + "\daten.txt")		                                                                      
		end if

	end if

	' GUI steuern
    ControlButton (Zurueck, Mouse)
    ControlButton (Vor, Mouse)
    ControlButton (Readme, Mouse)
    ControlButton (Credits, Mouse)
   	ControlButton (CB1, Mouse)
   	ControlButton (CB2, Mouse)
   	ControlButton (CB3, Mouse)
   	ControlButton (CB4, Mouse)
   	ControlButton (CB5, Mouse)
   	ControlButton (CB6, Mouse)
   	ControlButton (CB7, Mouse)
   	ControlButton (CB8, Mouse)    	

	' Clipboardinformationen zusammensetzen
	ClipboardWanted = CB1.Clicked or CB2.Clicked or CB3.Clicked or CB4.Clicked or CB5.Clicked or CB6.Clicked or CB7.Clicked or CB8.Clicked	
	Clipboard = ""
	if CB1.Clicked and (len(trim(Name.Content.caption)) > 0) then
		ClipBoard+ = Name.Content.caption & chr(13) & chr(10)
	end if
	if CB2.Clicked and (len(trim(Festnetz.Content.caption)) > 0) then 
		ClipBoard+ = Festnetz.Content.caption & chr(13) & chr(10)
	end if
	if CB3.Clicked and (len(trim(Handy.Content.caption)) > 0) then	
		ClipBoard+ = Handy.Content.caption & chr(13) & chr(10)
	end if
	if CB4.Clicked and (len(trim(Email.Content.caption)) > 0) then
		ClipBoard+ = Email.Content.caption & chr(13) & chr(10)
	end if
	if CB5.Clicked and (len(trim(Strasse.Content.caption)) > 0) then
		ClipBoard+ = Strasse.Content.caption & chr(13) & chr(10)
	end if
	if CB6.Clicked and (len(trim(StadtLandPLZ.Content.caption)) > 0) then
		ClipBoard+ = StadtLandPLZ.Content.caption & chr(13) & chr(10)
	end if
	if CB7.Clicked and (len(trim(Geburtstag.Content.caption)) > 0) then
		ClipBoard+ = Geburtstag.Content.caption & chr(13) & chr(10)
	end if
	if CB8.Clicked and (len(trim(Sonstiges.Content.caption)) > 0) then
		ClipBoard+ = Sonstiges.Content.caption & chr(13) & chr(10)
	end if
	if ClipboardWanted then
		writeToClipboard (Clipboard)
	end if
	
	' Zurck?
	if ((Zurueck.Clicked) or (Taste = chr(255) + "K")) and (ContactIndex > 1) then
		ContactIndex- = 1
		updatePicture ()			
	end if
	
	' Vor?
	if ((Vor.Clicked) or (Taste = chr(255) + "M")) and (ContactIndex < ubound(Contacts)) then
		ContactIndex+ = 1
		updatePicture ()
	end if
	
	' Readme angeklickt?
	if Readme.Clicked then
		shell "start readme.txt"
	end if
	
	' Credits angeklickt?
    if Credits.Clicked then
 		MenuModus = 2 		
 		SCREEN_WIDTHX = 400
		SCREEN_WIDTHY = 305		
		screenres SCREEN_WIDTHX, SCREEN_WIDTHY, 32, 2
		screenset 1, 2
		color , Design.Color1 		
    end if

	' Sind Kontakte da?
	if ubound(Contacts) then

	    ' Irgendein Buchstabe gedrckt?
	    if ((asc(Taste) >= 65) and (asc(Taste) <= 90)) or ((asc(Taste) >= 97) and (asc(Taste) <= 122)) then
			gotoContact (Taste)
			updatePicture ()
	    end if
	
		' PgUp
		if (Taste = chr(255) + "I") then	
			gotoPrevious ()
			updatePicture ()
		end if
		
		' PgDn
		if (Taste = chr(255) + "Q") then	
			gotoNext ()
			updatePicture ()
		end if
		
		' Pos1
		if (Taste = chr(255) + "G") then	
			gotoFirst ()
			updatePicture ()
		end if        
		
		' Ende
		if (Taste = chr(255) + "O") then	
			gotoLast ()
			updatePicture ()
		end if
	
		' Lschen?
		if (Taste = chr(255) + "S") then
	 		
			' Zuletzt aktiven Kontakt speichern
			f = freefile
			open exepath + "\res\other\settings.dat" for output as #f
				print #f, ContactIndex
			close #f

			' Messagebox-Abfrage zum Lschen
			KeyLock = 1
	 		dim as integer msg
	  		msg = MessageBox (NULL, "Wenn Sie auf JA klicken, wird der Eintrag " & chr(34) & Contacts(ContactIndex).Name & chr(34) & " unwiderruflich gelscht." & chr(13, 13) & "Mchten Sie fortfahren?", "Eintrag lschen?", fbYesNo or fbExclamation)
			if (msg = 6) then	
				shell "rmdir /S /Q " & ShortPathName(convert(exepath + "\" + Contacts(ContactIndex).folder, 1))
				loadContacts ()
			end if
	
		end if	

	end if
	
	' F5
	if (Taste = chr(255) + "?") then
		
		' Zuletzt aktiven Kontakt speichern
		f = freefile
		open exepath + "\res\other\settings.dat" for output as #f
			print #f, ContactIndex
		close #f
		
		loadContacts ()
		
	end if		

end sub

' *****************************************************************************
' Diese SUB regelt die Displayausgabe im Kontakte-Bildschirm
sub display ()

	' Das Logo anzeigen
	put (5, 0), Logo.ImagePointer, trans

	' Die Daten-Section anzeigen
    ShowSection (Daten)

	' Die Beschreibungen der Textboxen anzeigen
    PrintFont (@defaultFont, 10, 350, "Name:", &h000000)
    PrintFont (@defaultFont, 10, 375, "Festnetz:", &h000000)
    PrintFont (@defaultFont, 10, 400, "Handy:", &h000000)
    PrintFont (@defaultFont, 10, 425, "Email:", &h000000)
	PrintFont (@defaultFont, 10, 450, "Adresse:", &h000000)
	PrintFont (@defaultFont, 10, 500, "Geburtstag:", &h000000)
	PrintFont (@defaultFont, 10, 525, "Sonstiges:", &h000000)

	' Buttons anpassen
	if (ContactIndex <= 1) then
		Zurueck.Disabled = 1
	else
		Zurueck.Disabled = 0
	end if
	if (ContactIndex = ubound(Contacts)) then
		Vor.Disabled = 1
	else
		Vor.Disabled = 0
	end if

	' Die Buttons anzeigen
    ShowButton (Zurueck)
    ShowButton (Vor)
    ShowButton (CB1)
    ShowButton (CB2)
    ShowButton (CB3)
    ShowButton (CB4)
    ShowButton (CB5)
    ShowButton (CB6)
    ShowButton (CB7)
    ShowButton (CB8)
    ShowButton (Readme)
    ShowButton (Credits) 

	' Anzuzeigender Kontakt zulssig?
	if (ContactIndex > 0) then

		' Den Text in den Textboxen anpassen
		setText(Name, Contacts(ContactIndex).Name)
		setText(Festnetz, Contacts(ContactIndex).Festnetz)
		setText(Handy, Contacts(ContactIndex).Handy)
		setText(Email, Contacts(ContactIndex).Email)
		setText(Strasse, Contacts(ContactIndex).Strasse)
		setText(StadtLandPLZ, Contacts(ContactIndex).StadtLandPLZ)
		setText(Geburtstag, Contacts(ContactIndex).Geburtstag)		
		setText(Sonstiges, Contacts(ContactIndex).Sonstiges)
	
	else
	
		' Den Text in den Textboxen anpassen
		setText(Name, "")
		setText(Festnetz, "")
		setText(Handy, "")
		setText(Email, "")
		setText(Strasse, "")
		setText(StadtLandPLZ, "")
		setText(Geburtstag, "")		
		setText(Sonstiges, "")
	
	end if

	' Die Textboxen anzeigen
    ShowTextBox (Name)
    ShowTextBox (Festnetz)
    ShowTextBox (Handy)
    ShowTextBox (Email)
    ShowTextBox (Strasse)
    ShowTextBox (StadtLandPLZ)
    ShowTextBox (Geburtstag)
    ShowTextBox (Sonstiges) 
  
 	' Das Kontaktfoto anzeigen
	line Picture, (0, 0)-(SCREEN_WIDTHX, 200), &hff00ff, bf
	put Picture, ((SCREEN_WIDTHX - currentPicture.WidthX) / 2, (200 - currentPicture.WidthY) / 2), currentPicture.ImagePointer, trans
	line Picture, (0, 0)-(10, 200), &hff00ff, bf
	line Picture, (300, 0)-(310, 200), &hff00ff, bf	
	put (0, 140), Picture, trans

end sub

' *****************************************************************************
' Diese SUB ldt das aktuelle Bild ein
sub updatePicture ()

	' Kontakte geladen?
	if ubound(Contacts) then

		' Datei definiert?
		if (len(trim(Contacts(ContactIndex).ImageURL))) then
	
			if (fileexists(Contacts(ContactIndex).ImageURL)) then
				currentPicture = getImage(Contacts(ContactIndex).ImageURL, IMAGE_RESIZE)	
			else
				currentPicture = getImage(exepath + "\res\img\default.png", IMAGE_RESIZE)
			end if
			
		' ansonsten das "Kein Foto"-Bild laden
		else
			
			currentPicture = getImage(exepath + "\res\img\default.png", IMAGE_RESIZE)
			
		end if

	end if

end sub

' *****************************************************************************
' Diese SUB schreibt einen Text in die Zwischenablage
sub writeToClipboard (Text as string)
 
	' Variablen
	dim lpMem       as any ptr
	dim hGlobalClip as any ptr
 
 	' Clipboard ffnen
	hGlobalClip = globalalloc(GMEM_MOVEABLE or GMEM_SHARE, len(text)+1)
    openclipboard(0)
    
    ' leeren
    emptyclipboard()
    
    ' Text hineinkopieren
    lpMem=globallock(hGlobalClip)
    lstrcpy(lpMem, strptr(text))
    globalunlock(lpMem)
    setclipboarddata (CF_TEXT, hGlobalClip)
    
    ' Clipboard wieder schlieen
    closeclipboard()

end sub

' *****************************************************************************
' Diese FUNCTION konvertiert ein FreeImageBitmap in ein FreeBasicImage
'
' Programmiert von Volta, vielen Dank an ihn.
'
function FIBitmap2FBImage(byval Dib as FIBITMAP ptr) as integer ptr

	' Variablen
	dim as integer Index
	dim as uinteger bpp, breit, hoch, pitch
	
	' Bild steht sonst auf dem Kopf
 	FreeImage_FlipVertical(Dib)
 	
 	' Wir wollen das 32Bit-Format
  	Dib = FreeImage_ConvertTo32Bits(Dib)

  	breit = FreeImage_GetWidth(Dib)
  	hoch = FreeImage_GetHeight(Dib)

  	dim as any ptr Image = imagecreate(breit, hoch), ximage = Image
  	dim as uinteger ptr buffer = Image
  	dim as ubyte ptr FIpixel = FreeImage_GetBits(Dib)

	' Neuer Header?
  	if (buffer[0] = 7) then
  		
  		' Bytes pro Pixel
    	bpp = buffer[1]
    	
    	' wir wollen 4x8Bit = 32Bit    	
    	if bpp <> 4 then
			return NULL
    	end if
    	
    	' Anzahl Byte pro Zeile (.align 16)
    	pitch = buffer[4]
    	
    	'Gre des FBImageHeaders addieren
    	ximage += 32
    	
    	' Und nun zeilenweise kopieren
    	for Index = 1 to hoch
      		mmxcopy ximage, FIpixel, breit * bpp
      		FIpixel+ = (breit * bpp)
      		ximage+ = pitch
    	next Index 

	' der alte Header
  	else
  		
  		' Bytes pro Pixel
    	bpp = buffer[0] And 7
    	
    	' Wir wollen wieder 4x8Bit = 32Bit
    	if bpp <> 4 then 
    		return NULL
    	end if
 
    	' Und kopieren
    	mmxcopy ximage +4, FIpixel,  breit * hoch * bpp
    	
  	end if
  	
  	' FIBitmap kann gelscht werden
  	FreeImage_Unload(Dib)
  	
  	' FBImage wird zurckgegeben
  	return Image
  	
end function

' *****************************************************************************
' Diese FUNCTION ldt ein beliebiges Bild mit Hilfe der FreeImage.dll
function getImage (FileName as string, Resize as integer = 0) as ImageDataType
	
	' Variablen
	dim as FIBITMAP ptr Bild
	dim as ImageDataType buffer

	' Datei laden
	select case lcase(mid(FileName, getLastChar(FileName, ".") + 1))
		
		' Bitmap
		case "bmp" 
			Bild = FreeImage_Load(FIF_BMP, FileName, BMP_DEFAULT)			
			
		' Dr. Halo
		case "cut"
			Bild = FreeImage_Load(FIF_CUT, FileName, CUT_DEFAULT)

		' DirectDraw Surface
		case "dds"
			Bild = FreeImage_Load(FIF_DDS, FileName, DDS_DEFAULT)

		' Raw Fax format CCITT G3	
		case "g3"
			Bild = FreeImage_Load(FIF_FAXG3, FileName, FAXG3_DEFAULT)
			
		' Graphics Interchange Format
		case "gif"
			Bild = FreeImage_Load(FIF_GIF, FileName, GIF_DEFAULT)
			
		' High Dynamic Range
		case "hdr"
			Bild = FreeImage_Load(FIF_HDR, FileName, HDR_DEFAULT)						

		' Windows Icon
		case "ico"
			Bild = FreeImage_Load(FIF_ICO, FileName, ICO_DEFAULT)

		' Amiga IFF
		case "iff", "lbm"
			Bild = FreeImage_Load(FIF_IFF, FileName, IFF_DEFAULT)

		' JPEG Network Graphics
		case "jng"
			Bild = FreeImage_Load(FIF_JNG, FileName, JPEG_DEFAULT)
		
		' Independent JPEG Group
		case "jpg", "jif", "jpeg", "jpe"
			Bild = FreeImage_Load(FIF_JPEG, FileName, JPEG_DEFAULT)

		' Commodore 64 Koala format
		case "koa"
			Bild = FreeImage_Load(FIF_KOALA, FileName, KOALA_DEFAULT)
			
		' Multiple Network Graphics
		case "mng"
			Bild = FreeImage_Load(FIF_MNG, FileName, MNG_DEFAULT)
			
		' Kodak PhotoCD
		case "pcd"
			Bild = FreeImage_Load(FIF_PCD, FileName, PCD_DEFAULT)
			
		' Zsoft Paintbrush PCX bitmap format
		case "pcx"
			Bild = FreeImage_Load(FIF_PCX, FileName, PCX_DEFAULT)			
		
		' Portable Network Graphics
		case "png"
			Bild = FreeImage_Load(FIF_PNG, FileName, PNG_DEFAULT)			
		
		' Adobe Photoshop
		case "psd"
			Bild = FreeImage_Load(FIF_PSD, FileName, PSD_DEFAULT)

		' SXun Rasterfile
		case "ras"
			Bild = FreeImage_Load(FIF_RAS, FileName, RAS_DEFAULT)
			
		' Silicon Graphics SGI image format
		case "sgi"
			Bild = FreeImage_Load(FIF_SGI, FileName, SGI_DEFAULT)
			
		' Truevision Targa files
		case "tga", "targa"
			Bild = FreeImage_Load(FIF_TARGA, FileName, TARGA_DEFAULT)
			
		' Tagged Image File Format
		case "tif", "tiff"
			Bild = FreeImage_Load(FIF_TIFF, FileName, TIFF_DEFAULT)
			
		' Wireless Bitmap
		case "wbmp"
			Bild = FreeImage_Load(FIF_WBMP, FileName, WBMP_DEFAULT)

		' X11 Bitmap Format
		case "xbm"
			Bild = FreeImage_Load(FIF_XBM, FileName, XBM_DEFAULT)

		' X11 Pixmap Format
		case "xpm"
			Bild = FreeImage_Load(FIF_XPM, FileName, XPM_DEFAULT)

		case else
			Bild = FreeImage_Load(FIF_PNG, exepath + "\res\img\default.png", PNG_DEFAULT)

	end select

	if (Resize) then
		
		dim as integer WidthX, WidthY
		dim as double Faktor
		WidthX = FreeImage_GetWidth(Bild)
		WidthY = FreeImage_GetHeight(Bild)
		Faktor = WidthY / 200   	
		Bild = FreeImage_Rescale(Bild, WidthX / Faktor, 200, FILTER_BOX)
		'Bild= FreeImage_MakeThumbnail(Bild, 200, 0)
	
	end if
	
	buffer.ImagePointer = FIBitmap2FBImage(Bild)
	buffer.WidthX = FreeImage_GetWidth(Bild)
	buffer.WidthY = FreeImage_GetHeight(Bild)
	
	FreeImage_Unload (Bild)
	
	return buffer 

end function

' *****************************************************************************
' Diese SUB hilft dabei, einen Buchstaben zu suchen
sub gotoContact (Letter as string)

	' Variablen
	dim as integer Index
	
	' Schleife ber alle Kontakte
	for Index = 1 to ubound(Contacts) step 1
  
		if (mid(lcase(Contacts(Index).folder), 16, 1) = lcase(Letter)) then
			ContactIndex = Index
			updatePicture ()
			exit for
		end if
	
	next Index		

end sub

' *****************************************************************************
' Diese SUB wandert zum nchsten ersten Buchstaben
sub gotoFirst ()

	ContactIndex = 1

end sub

' *****************************************************************************
' Diese SUB wandert zum nchsten letzten
sub gotoLast ()

	ContactIndex = ubound(Contacts)

end sub

' *****************************************************************************
' Diese SUB wandert zum nchsten Buchstaben in der Liste
sub gotoNext ()

	' Variablen
	dim as integer Index
	dim as string currentChar
	
	' aktuelles Zeichen
	currentChar = mid(lcase(Contacts(ContactIndex).folder), 16, 1)
	
	' nchstes suchen
	for Index = ContactIndex to ubound(Contacts) step 1
		if asc(mid(lcase(Contacts(Index).folder), 16, 1)) > asc(currentChar) then
			ContactIndex = Index
			exit for
		end if
	next Index

end sub

' *****************************************************************************
' Diese SUB wandert zum borherigen Buchstaben in der Liste
sub gotoPrevious ()

	' Variablen
	dim as integer Index
	dim as string currentChar
	
	' aktuelles Zeichen
	currentChar = mid(lcase(Contacts(ContactIndex).folder), 16, 1)
	
	' nchstes suchen
	for Index = ContactIndex to 1 step -1
		if asc(mid(lcase(Contacts(Index).folder), 16, 1)) < asc(currentChar) then
			ContactIndex = Index
			exit for
		end if
	next Index

end sub

' *****************************************************************************
' Diese SUB listet den Inhalt eines Verzeichnisses auf
sub loadContacts (noSave as integer = 0)
    
    ' Variablen
    dim as string Name, Directory, char, tmp
    dim as integer f, ContactCount, Index
    
    ' Konsole ffnen
    f = freefile
    open pipe "cmd /c dir /on /b /ad " + ShortPathName(exepath + "\Meine Kontakte") for input as #f
    
    redim preserve as ContactType Contacts(0)
    
    ' Verzeichnisinhalt einlesen
    FolderCount = 0
    do until eof(f)

    	' Ordnernamen einlesen
        line input #f, Name

		Name = convert(trim(Name), 1)
		if (len(Name)) then

	        ContactCount+ = 1
	        redim preserve as ContactType Contacts(ContactCount)
                   
            ' Verzeichnisnamen speichern
            Directory = Name
            Contacts(ContactCount).folder = "Meine Kontakte\" + Directory
                   
	        ' Namen ermitteln
	        tmp = ""
	        for Index = 0 to len(Name) step 1
				char = mid(Name, Index, 1)
				if (char <> ",") then
					tmp+ = char
				else
					exit for
				end if
			next Index
	        Contacts(ContactCount).Name = trim(trim(mid(Name, Index + 1)) & " " & trim(tmp))

			' Daten einlesen	        
	        dim as integer f2, flag
	        dim as string daten
	        f2 = freefile
	        open exepath + "\Meine Kontakte\" + Name + "\daten.txt" for input as #f2
	        
	        	do until eof(f2)
	        	
					line input #f2, daten       	
					daten = trim(daten)
					
					select case lcase(daten)
						case "[name]"
							flag = 1
						case "[festnetz]"
							flag = 2
						case "[handy]"
							flag = 3
						case "[email]"
							flag = 4
						case "[adresse]"
							flag = 5
						case "[geburtstag]"
							flag = 7
						case "[sonstiges]"
							flag = 8
						case "[bild]"
							flag = 99
						case else						
							select case flag
								case 1
									if (daten <> Name) then										
										Contacts(ContactCount).Name = daten
									end if
									flag = 0
								case 2
									Contacts(ContactCount).Festnetz = daten
									flag = 0
								case 3
									Contacts(ContactCount).Handy = daten
									flag = 0
								case 4														
									Contacts(ContactCount).Email = daten
									flag = 0
								case 5
									Contacts(ContactCount).Strasse = daten
									flag+ = 1
								case 6
									Contacts(ContactCount).StadtLandPLZ = daten
									flag = 0
								case 7
									Contacts(ContactCount).Geburtstag = daten
									flag = 0
								case 8
									Contacts(ContactCount).Sonstiges = daten
									flag = 0
								case 99
									Contacts(ContactCount).ImageURL = daten
									flag = 0
							end select														
					end select
					
	        	loop
       
	        close #f2

			' Kein Bild definiert, oder Dateiname nicht vorhanden? Dann danach suchen.
			if ((len(trim(Contacts(ContactCount).ImageURL)) = 0) or (fileexists(trim(Contacts(ContactCount).ImageURL)) = 0)) then
				 
			 	' Im Ordner
		        dim as integer f3
		        dim as string item
		        f3 = freefile      
		        open pipe "cmd /c dir /b /a " + ShortPathName(exepath + "\Meine Kontakte\" + Directory) for input as #f3
		        do until eof(f3)
		        	line input #f3, item	        	      	
		        	if (mid(lcase(item), GetLastChar(item, ".") + 1) = "bmp") _
		        		or (mid(lcase(item), GetLastChar(item, ".") + 1) = "jpg") _
		        		or (mid(lcase(item), GetLastChar(item, ".") + 1) = "jpeg") _
		        		or (mid(lcase(item), GetLastChar(item, ".") + 1) = "gif") _
						or (mid(lcase(item), GetLastChar(item, ".") + 1) = "tga") _
		        		or (mid(lcase(item), GetLastChar(item, ".") + 1) = "png")  then
		        		
		        		Contacts(ContactCount).ImageURL = exepath + "\Meine Kontakte\" + Directory + "\" + convert(trim(item), 1)
		        		Contacts(ContactCount).ImageURL = Contacts(ContactCount).ImageURL		        			        		

					end if	        		
		        loop
	        
			end if

        end if
        
    loop
    close #f
    
	' welcher Kontakt war zuletzt geffnet?
	f = freefile
	open exepath + "\res\other\settings.dat" for input as #f
		input #f, Index
	close #f
	ContactIndex = Index

	' Index zulssig?
	if (ContactIndex <= 0) and (ubound(Contacts) > 0) then
		ContactIndex = 1
	end if
	if (ContactIndex > ubound(Contacts)) then
		ContactIndex = ubound(Contacts)
	end if

	' aktuelles Bild laden
	updatePicture ()

	' Was, wenn noch kein einziger Kontakt vorhanden ist?
	if (ContactCount = 0) then	
		currentPicture = getImage(exepath + "\res\img\default.png")		
	end if

	' ein neuer erster Durchlauf
	firstRun = 1
	
end sub

' *****************************************************************************
' Diese SUB speichert alle Kontakte
sub saveContacts (IndexC as integer = 0)
       
	' Variablen
	dim as integer CountIndex, f
	
	if (IndexC = 0) then

		' Schleife ber alle Kontakte
		for CountIndex = 1 to ubound(Contacts) step 1
		
			f = freefile
			open exepath + "\" + Contacts(CountIndex).folder + "\daten.txt" for output as #f
			
			 	print #f, "// ****************************************"
			 	print #f, "//"
			 	print #f, "// Quick'n'Easy"
			 	print #f, "// Contact-List"
				print #f, "//"
				print #f, "// Copyright www.jb-electronics.de 2009"
				print #f, "//"
				print #f, "// " & Datum & " - " & time
				print #f, "//"
				print #f, ""
				
				print #f, "[Name]"
				print #f, Contacts(CountIndex).Name
				print #f, ""
				print #f, "[Festnetz]"
				print #f, Contacts(CountIndex).Festnetz
				print #f, ""
				print #f, "[Handy]"
				print #f, Contacts(CountIndex).Handy
				print #f, ""
				print #f, "[Email]"
				print #f, Contacts(CountIndex).Email 
				print #f, ""
				print #f, "[Adresse]" 			
				print #f, Contacts(CountIndex).Strasse 
				print #f, Contacts(CountIndex).StadtLandPLZ 
				print #f, ""
				print #f, "[Geburtstag]" 
				print #f, Contacts(CountIndex).Geburtstag 
				print #f, ""
				print #f, "[Sonstiges]" 
				print #f, Contacts(CountIndex).Sonstiges
				print #f, ""
				print #f, "[Bild]"
				print #f, Contacts(CountIndex).ImageURL
			
			close #f
	
		next CountIndex
	
		' Zuletzt aktiven Kontakt speichern
		f = freefile
		open exepath + "\res\other\settings.dat" for output as #f
			print #f, ContactIndex
		close #f

	' Nur einen Kontakt abspeichern
	else
	
		f = freefile
		open exepath + "\" + Contacts(IndexC).folder + "\daten.txt" for output as #f
		 
		 	print #f, "// ****************************************"
		 	print #f, "//"
		 	print #f, "// Quick'n'Easy"
		 	print #f, "// Contact List"
			print #f, "//"
			print #f, "// Copyright www.jb-electronics.de 2009"
			print #f, "//"
			print #f, "// " & Datum & " - " & time
			print #f, "//"
			print #f, ""
			
			print #f, "[Name]"
			print #f, Contacts(IndexC).Name
			print #f, ""
			print #f, "[Festnetz]"
			print #f, Contacts(IndexC).Festnetz
			print #f, ""
			print #f, "[Handy]"
			print #f, Contacts(IndexC).Handy
			print #f, ""
			print #f, "[Email]"
			print #f, Contacts(IndexC).Email 
			print #f, ""
			print #f, "[Adresse]" 			
			print #f, Contacts(IndexC).Strasse 
			print #f, Contacts(IndexC).StadtLandPLZ 
			print #f, ""
			print #f, "[Geburtstag]" 
			print #f, Contacts(IndexC).Geburtstag 
			print #f, ""
			print #f, "[Sonstiges]" 
			print #f, Contacts(IndexC).Sonstiges
			print #f, ""
			print #f, "[Bild]"
			print #f, Contacts(IndexC).ImageURL
			
		close #f
			
	end if

end sub


