' *******************************************************************
' *                                                                 *
' *  Maumau                                                         *
' *                                                                 *
' *  pogrammiert von Jens Boos (jb) fr den                         *
' *                                                                 *
' *  Deutschen QuickBASIC & freeBASIC Programmierwettbewerb         *
' *                                                                 *
' *  vom 24.11.05 bis zum 28.01.06                                  *
' *                                                                 *
' *  Zur genaueren Erklrung des Programms schauen Sie              *
' *  bitte in die Datei Readme.TXT                                  *
' *                                                                 *
' *******************************************************************
' *                                                                 *
' *  Programmiert in freeBASIC Version 0.15b                        *
' *                                                                 *
' *******************************************************************
'
' Und jetzt geht's auch schon los:
'

' *******************************************************************
' Definierung der User Defined Types (UDTs):

' UDT fr die allgemeinen Einstellungen
type SettingsType
 sound                 as integer   
 anzeige               as integer
 computerbeginnt       as integer
 protokoll             as integer
 protokollnr           as integer
 vollbild              as integer
 kartenanfang          as integer
end type

' UDT fr die Karten
type KartenType
 karte                 as integer
 farbe                 as integer
end type 

' UDT fr den Highscore
type HighscoreType
 username              as string
 userscore             as integer
end type 

' UDT fr spielinterne Ablufe
type SpielInternType
 gamestart             as integer
 am_zug                as integer
 ueberspringen         as integer
 zweiziehen            as integer
 computerdelay         as integer
 computerdelaycounter  as integer
 spielerwunsch         as integer
 computerwunsch        as integer
 wuenschenanzeigen     as integer
 wunschfarbe           as integer
 gezogen               as integer
 kannlegen_anzahl      as integer
 bestekarte_index      as integer
 bestekarte_wert       as integer
 maxwert               as integer
 startzeit             as string
 highscoreeintrag      as integer
end type

' *******************************************************************
' Die Deklarationen der SUBs / FUNCTIONs:
' Beschreibungen zu den Unterroutinen sind ber den SUBS/FUNCTIONs 
' weiter unten im Programmcode zu finden. Ausgenommen davon sind die 
' beiden folgenden API-Deklarationen, die der Soundausgabe dienen.

' Die API-Deklarationen zum Abspielen des Sounds:
declare function GetShortPathName lib "kernel32" _ 
  alias "GetShortPathNameA" (byval lpszLongPath as string, _ 
  byval lpszShortPath as string, _ 
  byval cchBuffer as long) as long
declare function mciSendString lib "winmm.dll" _ 
  alias "mciSendStringA" (byval lpszCommand as string, _ 
  byval lpszReturnString as string, _ 
  byval cchReturnLength as long, _ 
  byval hwndCallback as long) as long

' Die FUNCTIONs:
declare function getfarbe (farbnummer as integer) as string
declare function getminutes (zeit1 as string, zeit2 as string) as integer
declare function getpoints (welcherspieler) as integer
declare function getrealname (kartennummer as integer, kartenfarbe as integer) as string
declare function gewonnen () as integer
declare function mouseover (xmin as integer, ymin as integer, xmax as integer, ymax as integer)
declare function nochkarten () as integer

' Die SUBs:
declare sub clearmemory ()
declare sub config (what2do as integer=1)
declare sub druck (xpos as integer, ypos as integer, text as string, alphawert as integer=255)
declare sub eingabe (text$, tastatur$, fertig)
declare sub play (sFile as string, sAlias as string)
declare sub mouseovercard (kartennummer as integer)
declare sub setupmemory ()
declare sub show.basicelements ()
declare sub show.finaldialog (final_result as integer)
declare sub show.gameplayelements (gameplay_result as integer)
declare sub show.highscore (highscore_result as integer, keycode as string)
declare sub show.infomenu (info_result as integer)
declare sub show.mainmenu (main_result as integer)
declare sub show.optionmenu (option_result as integer)
declare sub spiel.computeractions ()
declare sub spiel.gebekarten ()
declare sub spiel.legekarte (welcherspieler as integer, kartenindex as integer, ok as integer)
declare sub spiel.protokoll (text as string, neuesprotokoll as integer=0)
declare sub spiel.spieleractions (gameplay_result as integer)
declare sub spiel.zeigehaende ()
declare sub spiel.ziehekarte (welcherspieler as integer, anzahl as integer=1)
declare sub stapelinit (what2do as integer=1)

' *******************************************************************
' Der Videomodus
' 800 x 600 x 24Bit
screen 19, 24, 2
screenset 1, 2

' *******************************************************************
' Generelle Einstellungen und Startbildschirm frs Laden 
option base 1
randomize timer
locate 8, 10:  print "Mau Mau - Copyright by jbsoft 2006"
locate 10, 10: print "Lade Daten..."
screencopy
cls

' *******************************************************************
' Die Variablendeklarationen:

' $dynamic

' Die Einstellungen
dim shared settings as SettingsType

' Der Highscore
dim shared highscore(8) as HighscoreType

' Eine Highscorevariable fr den Gewinner
dim shared as HighscoreType spieler1

' Die spielinternen Ablufe
dim shared as SpielInternType spiel_intern
spiel_intern.computerdelay = 100

' Der Spieler/Computergegner
dim shared as integer spieler, computer
spieler = 1
computer = 2

' Die Anzahl der Karten des Spielers/des Computergegners
dim shared anzahlkarten(2) as integer

' Die Hand des Spielers/Computergegners
dim shared as KartenType hand(2, 32)

' Feld mit den Legemglichkeiten des Computers
dim shared as integer kannlegen(32)

' Hilfsfeld fr den Computerspieler
dim shared as integer computerkartenanzahl(4)

' Die Bildpuffer
dim shared as any ptr items, boxes

dim shared as any ptr background, cards, fonts, kartenfeld
dim shared as any ptr arrow_up, arrow_down, arrow_left, arrow_right
dim shared as any ptr arrow_hover_up, arrow_hover_down, arrow_hover_left, arrow_hover_right
dim shared as any ptr updownbackground, karten(8, 4), button(10), button_hover, button_blank, cursor
dim shared as any ptr font(95), back(2), control, control_active, wunschfarben(4)
dim shared as any ptr menu, menu_small, options, result, wunschbox

' Die Ausgabe des Mausstatus erfolgt ebenfalls in globalen Variablen, sodass 
' alle SUBs/FUNCTIONs darauf zugreifen knnen:
dim shared as integer x, y, click

' Der Overroll-Effekt fr das Men:
dim shared as integer transparency, transparency_speed
transparency = 50
transparency_speed = 5

' Die Soundvariablen
dim shared as string snd(6)
dim shared as string snd_src(6) 

' Der Kartenstock 
dim shared as KartenType stock(32)

' Wie viel ist von jeder Karte zu sehen (in Pixeln)?
dim shared as integer kartenspalt = 30

' Wie viele Karten pro Spalte gibt es also?
dim shared as integer kartenprospalte = 8

' Die vom User vernderbaren Einstellungen laden
config ()

' Und die smtlichen anderen Daten (Bilder & Sounds) laden  
setupmemory ()

' Vollbild? (Diese nderung wird nur bei Neustart des Programms sichtbar, 
' da sonst ein Fehler beim Beenden auftreten kann; siehe Readme)
if settings.vollbild then 
 screen 19, 24, 2, 1
 screenset 1, 2
end if

' Mauszeiger unsichtbar machen
setmouse , , 0

' Beginn Hauptschleife
do
    
    ' Pause um den Prozessor nicht zu berlasten
    sleep 10
    
    ' Bildschirm lschen
    cls
    
    ' Maus- und Tastaturabfrage
    getmouse x, y, , click
    e$ = inkey$
    
    ' Maustaste "entprellen"
    if click <> lb THEN
     lb = click
     if lb and 1 then
      click = 1
     end if
    else
     click = 0
    end if

    ' Den Hintergrund etc. anzeigen
    show.basicelements ()
    
    ' Das obere Men anzeigen
    show.mainmenu (main_result)
    
    ' Wurde Escape gedrckt, oder soll das Fenster geschlossen werden?
    if (e$ = chr$(27)) or (e$ = chr$(255) + "k") then main_result = 3

    ' Was wurde im Men angeklickt?
    select case main_result
     
     ' Das Spiel wird gestartet
     case 1
     
      ' Zeige die Spielobjekte an und reagiere auf Benutzereingaben
      show.gameplayelements (gameplay_result)
      
      ' Wurde das Spiel gerade erst gestartet?
      if not spiel_intern.gamestart then
       ' Anfangswerte setzen / Variablen resetten
       config ()
       redim hand(2, 32) as KartenType
       stapelinit
       stapelinit (2)
       spiel.gebekarten ()
       gameplay_result = 0
       with spiel_intern
        .gamestart = 1
        .computerdelaycounter = 0
        .zweiziehen = 0
        .spielerwunsch = 0
        .computerwunsch = 0
        .wuenschenanzeigen = 0
        .startzeit = time$
        .highscoreeintrag=0
       end with
       spieler1.username=""
       spieler1.userscore=0
       ' Ein neues Protokoll erstellen
       if settings.protokoll then
        spiel.protokoll ("Mau Mau - Copyright by jbsoft 2006", 1)
        spiel.protokoll ("")
        spiel.protokoll ("Protokoll Nr. " + trim$(str$(settings.protokollnr)) + " vom " + date$ + " um " + time$ + ":")
        spiel.protokoll ("")
        spiel.protokoll ("Die Einstellungen im berblick: ")
        if settings.computerbeginnt then n$ = "Ja" else n$ = "Nein"
        spiel.protokoll (" + Computer beginnt: " + n$)
        if settings.anzeige then n$ = "Ja" else n$ = "Nein"
        spiel.protokoll (" + Gegnerische Karten anzeigen: " + n$)
        spiel.protokoll (" + Karten zu Beginn: " + trim$(str$(settings.kartenanfang)))
        spiel.protokoll ("")
        spiel.protokoll ("Protokoll Start")
        spiel.protokoll ("")
       end if
       ' Wer beginnt?
       if settings.computerbeginnt then
        spiel_intern.am_zug = computer
       else
        spiel_intern.am_zug = spieler
       end if 
       ' Muss der beginnende Spieler direkt zu Beginn zwei Karten ziehen?
       if stock(1).karte=1 then
        spiel_intern.zweiziehen = 1
       ' Wird der Spieler stattdessen bersprungen?
       elseif stock(1).karte=2 then
        spiel_intern.ueberspringen = 1
       ' Oder darf sich der Spieler eine Farbe wnschen?
       elseif stock(1).karte=5 then
        if spiel_intern.am_zug=spieler then
         spiel_intern.spielerwunsch=1
         spiel_intern.gezogen=1
        else
         spiel_intern.computerwunsch=1
        end if
        spiel_intern.wunschfarbe = 1
        if spiel_intern.am_zug = spieler then spiel_intern.wuenschenanzeigen=1
       end if
      end if

      ' Ist der Spieler am Zug?
      if spiel_intern.am_zug = spieler then
       spiel.spieleractions (gameplay_result)
       ' Erscheint das Buben-Men?
       if gameplay_result=2 then
        if spiel_intern.wunschfarbe<4 then 
         spiel_intern.wunschfarbe+=1 
        else
         spiel_intern.wunschfarbe=1
        end if
       gameplay_result = 0
       end if
       if gameplay_result=3 then
        if spiel_intern.wunschfarbe>1 then
         spiel_intern.wunschfarbe-=1
        else
         spiel_intern.wunschfarbe=4
        end if
        gameplay_result = 0
       end if
       if gameplay_result=4 then
        ' Eine Meldung fr das Protokoll
        if settings.protokoll then 
         spiel.protokoll ("Der Spieler wnscht sich die Farbe " + getfarbe(spiel_intern.wunschfarbe) + ".")
        end if
        spiel_intern.am_zug = computer
        spiel_intern.wuenschenanzeigen = 0
        gameplay_result=0
       end if
      end if

      ' Oder ist der Computer am Zug?
      if spiel_intern.am_zug = computer then
       spiel.computeractions ()
      end if
 
      ' Hat ein Spieler gewonnen?
      if gewonnen() then
       minuten = getminutes (spiel_intern.startzeit, time$)
       ' Bei null Minuten wrde es einen Fehler geben
       if minuten = 0 then minuten = 1
       spieler1.userscore = getpoints(computer) / minuten
       ' Eine Meldung fr das Protokoll
       if settings.protokoll then
        ' Genauigkeit muss sein
        if minuten=1 then n$ = "" else n$ = "n"
        spiel.protokoll ("Nach " + trim$(str$(minuten)) + " Minute" + n$ + " ist das Spiel zu Ende.")
       end if
       if gewonnen() = spieler then
        if settings.sound then play (snd_src(3), snd(3))
        ' Meldungen fr das Protokoll
        if settings.protokoll then
         spiel.protokoll ("Der Spieler hat mit " + trim$(str$(spieler1.userscore)) + " Punkten das Spiel gewonnen.")
         if spieler1.userscore > highscore(8).userscore then
          spiel.protokoll ("Der Spieler konnte sich sogar in den Highscore eintragen.")
         else
          spiel.protokoll ("Leider hat es nicht fr den Highscore gereicht.")
         end if
        end if
       else
        if settings.sound then play (snd_src(4), snd(4))
        ' Eine Meldung fr das Protokoll
        if settings.protokoll then
         spiel.protokoll ("Leider hat der Spieler das Spiel verloren.")
        end if
       end if
       ' Meldung fr das Protokoll
       if settings.protokoll then
        spiel.protokoll ("")
        spiel.protokoll ("Protokoll Ende")
        spiel.protokoll ("")
       end if
       main_result = 6
      end if

     ' Highscore
     case 2
      show.highscore (highscore_result, e$)
      
      ' Zurck?
      if highscore_result = 1 then
       main_result = 0
       highscore_result = 0
      end if    
      
     ' Beenden
     case 3
      sleep 250   
      exit do   
 
     ' Optionen
     case 4
      show.optionmenu (option_result)
      ' Welcher Button wurde angeklickt?
      select case option_result
       ' Sound an/aus
       case 1
        settings.sound = 1 - settings.sound
        option_result = 0
       ' Karten des Gegners anzeigen?
       case 2
        settings.anzeige = 1 - settings.anzeige
        option_result = 0
       ' Wer beginnt? 
       case 3
        settings.computerbeginnt = 1 - settings.computerbeginnt
        option_result = 0 
       ' Vollbild?
       case 4
         settings.vollbild = 1 - settings.vollbild
         option_result = 0
       ' Spiele protokollieren
       case 5
        settings.protokoll = 1 - settings.protokoll
        option_result = 0
        if settings.protokoll=1 then settings.protokollnr=0
       ' Mehr Karten am Anfang
       case 6
        if settings.kartenanfang < 8 then settings.kartenanfang+= 1
        option_result = 0
       ' Weniger Karten am Anfang
       case 7
        if settings.kartenanfang > 3 then settings.kartenanfang-= 1
        option_result = 0
       ' Zurck?
       case 8
        option_result = 0
        main_result = 0
        config ()
       ' Speichern?
       case 9 
        option_result = 0
        main_result = 0
        config (2)
      end select

     ' Infos zum Programm anzeigen
     case 5
      show.infomenu (info_result)
      if info_result = 1 then 
       info_result = 0
       main_result = 0
      end if 
    
     ' Der Spieler hat gewonnen/verloren
     case 6
      show.finaldialog (final_result)
      ' Welcher Button wurde angeklickt?
      select case final_result
       ' Highscore aufrufen
       case 1
        final_result = 0
        main_result = 2
       ' Zurck
       case 2
        final_result = 0
        main_result = 0
      end select

    end select
    
    ' Den Cursor anzeigen
    put(x, y), cursor, trans
    
    ' Alle Grafiken in den Primrpuffer kopieren
    screencopy
    
    ' Den Button blinken lassen
    transparency+=transparency_speed
    if transparency < 20 or transparency > 100 then transparency_speed = -transparency_speed
    
loop 

' Und den Speicher wieder leeren
clearmemory ()

end

' *******************************************************************
' Hier die SUBs und FUNCTIONs:
'

' *******************************************************************
' Zuerst die FUNCTIONs:

' *******************************************************************
' Diese FUNCTION ordnet einer Farbnummer ihren entsprechenden String zu
function getfarbe (farbnummer as integer) as string

 ' Welche Farbnummer?
 tmp$ = ""
 select case farbnummer
  case 1: tmp$ = "Herz" 
  case 2: tmp$ = "Karo"
  case 3: tmp$ = "Pik"
  case 4: tmp$ = "Kreuz"
  case else: tmp$ = ""
 end select
 getfarbe = tmp$

end function

' *******************************************************************
' Diese FUNCTION ermittelt die Anzahl der Minuten zwischen zwei Zeiten
function getminutes (zeit1 as string, zeit2 as string) as integer

 ' Die Anzahl der Minuten und Stunden aus den Zeiten extrahieren
 min1 = val(mid$(zeit1, 4, 2))
 std1 = val(left$(zeit1, 2))
 min2 = val(mid$(zeit2, 4, 2))
 std2 = val(left$(zeit2, 2))

 ' Diese Daten verrechnen
 min = min2 - min1
 std = std2 - std1
 getminutes = std*60 + min

end function

' *******************************************************************
' Diese FUNCTION liefert die Anzahl der verbleibenden Punkte auf der 
' Hand eines Spielers zurck.
function getpoints (welcherspieler as integer) as integer
 
 ' Wert resetten
 wert = 0

 ' Schleife ber alle Karten des Spielers
 for index = 1 to anzahlkarten(welcherspieler) step 1
  ' Welche Karte?
  select case hand(welcherspieler, index).karte
   ' eine 7
   case 1
    wert+=7
   ' eine 8
   case 2
    wert+=8
   ' eine 9
   case 3
    wert+=9
   ' eine 10
   case 4
    wert+=10
   ' ein Bube
   case 5
    wert+=20
   ' eine Dame
   case 6
    wert+=10
   ' ein Knig
   case 7
    wert+=10
   ' ein As
   case 8  
    wert+=11
  end select
 next index

 ' Wert bergeben
 getpoints = wert

end function

' *******************************************************************
' Diese FUNCTION erstellt aus dem Code fr eine Karte leserliche Zeichen
function getrealname (kartennummer as integer, kartenfarbe as integer) as string

 ' Welche Karte?
 tmp$ = ""
 select case kartennummer
  case 1 to 4: tmp$+=trim$(str$(kartennummer+6))
  case 5: tmp$="Bube"
  case 6: tmp$="Dame"
  case 7: tmp$="Knig"
  case 8: tmp$="As"
  case else: tmp$ = ""
 end select
 ' Und den Funktionswert bergeben
 getrealname = trim$(getfarbe(kartenfarbe) + " " + tmp$)

end function

' *******************************************************************
' Diese FUNCTION liefert entweder 1 zurck, wenn der Spieler gewonen 
' hat, oder 2, wenn der Computer gewonnen hat
function gewonnen () as integer

 ' Schleife ber beide Spieler
 for s = 1 to 2 step 1
  if anzahlkarten(s)=0 then 
   gewonnen = s
   exit function
  end if
 next

end function

' *******************************************************************
' Diese FUNCTION berprft, ob sich der Mauszeiger im Bereich 
' (xmin|ymin)-(xmax|ymax) befindet
function mouseover (xmin as integer, ymin as integer, xmax as integer, ymax as integer)

 ' Befindet der Mauszeiger sich im gltigen Bereich?
 if x >=xmin and x<=xmax and y>=ymin and y<=ymax then 
  m = -1
 else
  m = 0
 end if
 mouseover = m

end function

' *******************************************************************
' Diese FUNCTION liefert die Anzahl der noch im Stock verbliebenen 
' Karten zurck
function nochkarten () as integer
 
 ' Wert zurcksetzen
 tmp = 0
 ' Ist noch eine Karte im Stock vohanden?
 for suchen = 1 to 32 step 1
  with stock(suchen)
   if .karte then
    tmp+= 1
   end if 
  end with
 next suchen
 ' Wert bergeben
 nochkarten = tmp

end function

' *******************************************************************
' Und jetzt die SUBs:

' *******************************************************************
' Diese SUB dient dazu, die mit imagecreate() erstellten Bildpuffer
' wieder aus dem Speicher zu entfernen
sub clearmemory ()
  
 imagedestroy back(1)
 imagedestroy back(2)
 imagedestroy background 
 imagedestroy cards
 imagedestroy fonts
 imagedestroy kartenfeld

 imagedestroy arrow_up
 imagedestroy arrow_down
 imagedestroy arrow_left
 imagedestroy arrow_right
 imagedestroy arrow_hover_up
 imagedestroy arrow_hover_down
 imagedestroy arrow_hover_left
 imagedestroy arrow_hover_right
 imagedestroy button_hover
 imagedestroy control
 imagedestroy control_active
 imagedestroy cursor
 imagedestroy updownbackground
 for w = 1 to 4 step 1
  imagedestroy wunschfarben(w)
 next w
 
 imagedestroy menu
 imagedestroy menu_small
 imagedestroy options
 imagedestroy result
 imagedestroy wunschbox

 for b = 1 to 10 step 1
  imagedestroy button(b)
 next b
 for f = 1 to 95 step 1
  imagedestroy font(f)
 next f 
 for FarbenIndex = 1 to 4 step 1
  for KartenIndex = 1 to 8 step 1 
   imagedestroy karten(KartenIndex, FarbenIndex)
  next KartenIndex 
 next FarbenIndex

end sub

' *******************************************************************
' Diese SUB ldt/speichert (je nach Parameter) die Einstellungen
sub config (what2do as integer=1)
    
 ' Laden oder speichern?
 select case what2do
  ' Einstellungen laden
  case 1
   f = freefile
   open exepath + "\data\settings.dat" for input as #f
    with settings
     input #f, .sound, .anzeige, .computerbeginnt, .vollbild, .kartenanfang, .protokoll, .protokollnr
    end with
   close #f
   f = freefile
   open exepath + "\data\score.dat" for input as #f
    for index = 1 to 8 step 1
     with highscore(index)
     input #f, .username, .userscore
     end with
   next index
   close #f 
  ' Einstellungen speichern
  case 2
   f = freefile
   open exepath + "\data\settings.dat" for output as #f
    with settings
     write #f, .sound, .anzeige, .computerbeginnt, .vollbild, .kartenanfang, .protokoll, .protokollnr
    end with
   close #f
   f = freefile
   open exepath + "\data\score.dat" for output as #f
    for index = 1 to 8 step 1
     with highscore(index)
      write #f, .username, .userscore
     end with
    next index
   close #f 
  end select
  anzahlkarten(spieler) = settings.kartenanfang
  anzahlkarten(computer) = settings.kartenanfang

end sub

' *******************************************************************
' Diese SUB schreibt einen Text in der Schriftart Courier New auf 
' den Bildschirm.
sub druck (xpos as integer, ypos as integer, text as string, alphawert as integer=255)
   
 ' Scanne das zu schreibende Wort ab
 for i = 1 to len(text) step 1 
  z$ = mid$(text, i, 1)
  ' Sonderfall: 
  if z$ = "" then 
   index = 95
   put(xpos + i * 10, ypos), font(index), alpha, alphawert
  elseif trim$(z$) <> "" then 
   index = asc(z$) - 32
   put(xpos + i * 10, ypos), font(index), alpha, alphawert
  end if
 next i
   
end sub

' *******************************************************************
' Diese SUB ersetzt die Eingaberoutine LINE INPUT
sub eingabe (text$, tastatur$, fertig)
    
 ' Die Tastatureingabe auswerten
 select case asc(tastatur$)
  ' Enter
  case 13
   fertig = -1
  ' Escape
  case 27
   text$ = ""
  ' Backspace
  case 8
   if len(text$) then text$ = left$(text$, len(text$) - 1)
  ' Alle anderen gltigen Zeichen
  case 32 to 125
   if len(text$) < 15 then text$ = text$ + tastatur$
  ' Ein Sonderzeichen 
  case 225
   if len(text$) < 15 then text$ = text$ + ""
 end select  
    
end sub

' *******************************************************************
' Diese SUB spielt eine beliebige Sounddatei mittels WinAPI ab
sub play (sFile as string, sAlias as string)
 mciSendString "stop " + sAlias, 0, 0, 0 
 mciSendString "close " + sAlias, 0, 0, 0    
 dim sBuffer as string 
 dim lResult as Long 
 dim sf as string 
 sf = Space$(255) 
 sBuffer = Space$(255) 
 sf = sFile 
 lResult = GetShortPathName(sf, sBuffer, len(sBuffer)) 
 if lResult <> 0 then 
  sBuffer = rtrim$(sBuffer) 
  if mciSendString("open " + sBuffer + " type MPEGVideo alias " + sAlias , 0, 0, 0) = 0 then 
   mciSendString "play " + sAlias + " from 0", 0, 0, 0
   exit sub
  end if 
 end if 
end sub

' *******************************************************************
' Diese SUB berprft, ob der Spieler mit der Maus ber eine eigene 
' Karte fhrt.
sub mouseovercard (kartennummer as integer)
  
  ' Startwerte setzen
  ypos = 180
  xpos = 90
  ' Und jede Karte seperat abfragen
  if anzahlkarten(spieler) > 0 then
   ' Schleife ber alle Karten
   for index = 1 to anzahlkarten(spieler) step 1
    ' Die Koordinaten mitbewegen
    ypos+ = kartenspalt
    if ypos > 440 then
     ypos = 180+kartenspalt
     xpos+ = 75
    end if 
    ' Die unterste Karte 
    if (index = anzahlkarten(spieler)) or (index mod kartenprospalte = 0) then 
     if mouseover(xpos, ypos, xpos+70, ypos+95) then
      kartennummer = index
      if spiel_intern.wuenschenanzeigen=0 then
       line(xpos-1, ypos-1)-(xpos+70, ypos+95), rgb(0, 0, 255), b
       if spiel_intern.am_zug=spieler then 
        line(346, 199)-(417, 295), rgb(0, 0, 255), b
        with hand(spieler, index)
         put(347, 200), karten(.karte, .farbe), alpha, transparency+100
        end with
       end if
      end if 
     end if
    ' Eine "normale" - d.h. zum grten Teil verdeckte - Karte
    elseif mouseover(xpos, ypos, xpos+70, ypos+kartenspalt) then
     if spiel_intern.wuenschenanzeigen=0 then
      line(xpos-1, ypos-1)-(xpos+70, ypos+kartenspalt), rgb(0, 0, 255), b
      if spiel_intern.am_zug=spieler then 
       line(346, 199)-(417, 295), rgb(0, 0, 255), b
       with hand(spieler, index)
        if spiel_intern.am_zug=spieler then put(347, 200), karten(.karte, .farbe), alpha, transparency+100
       end with
      end if
     end if
     kartennummer = index
     exit for
    ' keine Karte
    else
     kartennummer = 0
    end if
   next index 
  end if

end sub

' *******************************************************************
' In dieser SUB werden die Bildpuffer erstellt und die Bilder geladen
sub setupmemory ()
    
 ' Sounds laden
 snd(1) = "click"
 snd_src(1) = exepath + "\data\sounds\click.wav"
 snd(2) = "swash"
 snd_src(2) = exepath + "\data\sounds\swash.wav"
 snd(3) = "tada"
 snd_src(3) = exepath + "\data\sounds\tada.wav"
 snd(4) = "boo"
 snd_src(4) = exepath + "\data\sounds\boo.wav"
 snd(5) = "score"
 snd_src(5) = exepath + "\data\sounds\score.wav"
 snd(6) = "error"
 snd_src(6) = exepath + "\data\sounds\error.wav"

 ' Bildpuffer erstellen
 items              = imagecreate(102, 212)
 boxes              = imagecreate(875, 506)
 back(1)            = imagecreate(70, 95)
 back(2)            = imagecreate(70, 95)
 background         = imagecreate(800, 600)
 cards              = imagecreate(560, 380)
 fonts              = imagecreate(394, 60)
 kartenfeld         = imagecreate(652, 402)

 arrow_up           = imagecreate(32, 16)
 arrow_down         = imagecreate(32, 16)
 arrow_left         = imagecreate(16, 32)
 arrow_right        = imagecreate(16, 32)
 arrow_hover_up     = imagecreate(32, 16)
 arrow_hover_down   = imagecreate(32, 16)
 arrow_hover_left   = imagecreate(16, 32)
 arrow_hover_right  = imagecreate(16, 32)
 button_blank       = imagecreate(100, 34)
 button_hover       = imagecreate(100, 34)
 control            = imagecreate(32, 32)
 control_active     = imagecreate(32, 32)
 cursor             = imagecreate(26, 26)
 updownbackground   = imagecreate(39, 39)
 for w = 1 to 4 step 1
  wunschfarben(w)   = imagecreate(32, 32)
 next w
 
 menu               = imagecreate(400, 354)
 menu_small         = imagecreate(402, 149)
 options            = imagecreate(470, 403)
 result             = imagecreate(268, 96)
 wunschbox          = imagecreate(150, 45)

 for b = 1 to 10 step 1
  button(b)         = imagecreate(100, 34)
 next b
 for f = 1 to 95 step 1
  font(f) = imagecreate(13, 15)
 next f 
 for FarbenIndex = 1 to 4 step 1
  for KartenIndex = 1 to 8 step 1 
   karten(KartenIndex, FarbenIndex) = imagecreate(70, 95)
  next KartenIndex 
 next FarbenIndex

 ' Der Pfad fr die Bilder
 src$ = exepath + "\data\images"

 ' Das Bild mit den Items laden, alle Items "extrahieren" und danach das Bild wieder lschen
 bload src$ + "\items.bmp", items
 get items, (1, 34)-(100, 67), button_blank
 get items, (1, 70)-(100, 103), button_hover
 get items, (41, 172)-(66, 197), cursor
 get items, (1, 105)-(32, 120), arrow_up
 get items, (1, 122)-(32, 137), arrow_down
 get items, (1, 139)-(16, 170), arrow_left
 get items, (35, 139)-(50, 170), arrow_right
 get items, (34, 105)-(65, 120), arrow_hover_up
 get items, (34, 122)-(65, 137), arrow_hover_down
 get items, (18, 139)-(33, 170), arrow_hover_left
 get items, (52, 139)-(67, 170), arrow_hover_right
 get items, (67, 105)-(98, 136), wunschfarben(1)
 get items, (67, 1)-(98, 32), wunschfarben(2)
 get items, (69, 139)-(100, 170), wunschfarben(3)
 get items, (68, 172)-(99, 203), wunschfarben(4)
 get items, (1, 172)-(39, 210), updownbackground
 get items, (1, 1)-(32, 32), control
 get items, (34, 1)-(65, 32), control_active
 imagedestroy items

 ' Das Bild mit den Menboxen laden, alle Boxen "extrahieren" und danach das Bild wieder lschen
 bload src$ + "\boxes.bmp", boxes
 get boxes, (1, 1)-(400, 354), menu
 get boxes, (1, 356)-(402, 504), menu_small
 get boxes, (404, 1)-(873, 403), options
 get boxes, (404, 405)-(553, 449), wunschbox
 get boxes, (606, 405)-(873, 500), result
 imagedestroy boxes

 ' Die restlichen Bilder laden
 bload src$ + "\back_1.bmp", back(1)
 bload src$ + "\back_2.bmp", back(2)
 bload src$ + "\back.bmp", background
 bload src$ + "\cards.bmp", cards
 bload src$ + "\font.bmp", fonts
 bload src$ + "\kartenfeld.bmp", kartenfeld

 ' Die einzelnen Karten aus dem Feld "extrahieren"
 xpos = 0
 ypos = 0 
 for FarbenIndex = 1 to 4 step 1
  for KartenIndex = 1 to 8 step 1 
   get cards, (xpos, ypos)-(xpos+69, ypos+94), karten(KartenIndex, FarbenIndex)
   xpos+=70
   if KartenIndex=8 then
    xpos=0
    ypos+=95
   end if 
  next KartenIndex 
 next FarbenIndex
 imagedestroy cards

 ' Das Fontbild anzeigen, in 2 Farben zerlegen (&hfffff/&hff00ff) und anschlieend
 ' in einzelne Felder laden
 put(101, 101), fonts, trans
 for xcoord = 101 to 494 step 1
  for ycoord = 101 to 160 step 1
   if point(xcoord, ycoord) = rgb(255, 255, 255) then 
    pset(xcoord, ycoord), rgb(255, 0, 255)   
   elseif point(xcoord, ycoord) <> rgb(0, 0, 255) then 
    pset(xcoord, ycoord), rgb(0, 0, 255)
   end if
  next ycoord
 next xcoord
 get(101, 101)-(494, 160), fonts
 cls
 xwidth = 10
 ywidth = 18
 font_index = 1
 for ycoord = 1 to 3 step 1
  for xcoord = 1 to 39 step 1
   if font_index < 96 then  
    get fonts, ((xcoord-1)*xwidth+1, (ycoord-1)*ywidth+1)-(xcoord*xwidth, ycoord*ywidth), font(font_index)
    font_index+ = 1
   end if
  next xcoord 
 next ycoord
 imagedestroy fonts

 ' Die Butttons aus dem Leer-Button erstellen, seperat abspeichern und den Leer-Button wieder lschen
 cls
 put(100, 100), button_blank, pset
 druck 105, 109, "STARTEN"
 get(100, 100)-(199, 133), button(1)
 cls
 put(100, 100), button_blank, pset
 druck 96, 109, "HIGHSCORE"
 get(100, 100)-(199, 133), button(2)
 cls
 put(100, 100), button_blank, pset
 druck 105, 109, "BEENDEN"
 get(100, 100)-(199, 133), button(3)
 cls
 put(100, 100), button_blank, pset
 druck 100, 109, "OPTIONEN"
 get(100, 100)-(199, 133), button(4)
 cls
 put(100, 100), button_blank, pset
 druck 115, 109, "INFOS"
 get(100, 100)-(199, 133), button(5)
 cls
 put(100, 100), button_blank, pset
 druck 120, 109, "NEIN"
 get(100, 100)-(199, 133), button(6)
 cls
 put(100, 100), button_blank, pset
 druck 128, 109, "JA"
 get(100, 100)-(199, 133), button(7)
 cls
 put(100, 100), button_blank, pset
 druck 105, 109, "ZURUECK"
 get(100, 100)-(199, 133), button(8)
 cls
 put(100, 100), button_blank, pset
 druck 111, 109, "ZIEHEN"
 get(100, 100)-(199, 133), button(9)
 cls
 put(100, 100), button_blank, pset
 druck 96, 109, "SPEICHERN"
 get(100, 100)-(199, 133), button(10)
 imagedestroy button_blank

end sub

' *******************************************************************
' Diese SUB zeigt die Basisinformationen an
sub show.basicelements ()

 ' Hintergrundgrafik(en):
  put(0, 0), background, trans
 ' Das Copyright anzeigen
  druck 10, 580, "Copyright by jbsoft 2006"

end sub

' *******************************************************************
' Diese SUB enthlt den Dialog fr den Sieg des Spielers / die 
' Niederlage des Spielers
sub show.finaldialog (final_result as integer)

 ' Die Dialogbox
 put(200, 240), menu_small, trans
 ' Hat der Spieler gewonnen oder verloren?
 if gewonnen()=spieler then
  druck 210, 260, "Sie haben gewonnen!"
  druck 210, 280, "Herzlichen Glueckwunsch!"
  ' Hat es fr den Highscore gereicht?
  if spieler1.userscore > highscore(8).userscore then
   spiel_intern.highscoreeintrag=1
   druck 210, 300, "Sie haben es mit " + trim$(str$(spieler1.userscore)) + " Punkten"
   druck 210, 320, "bis in den Highscore geschafft!"
   if mouseover(488, 345, 588, 379) then
    put(488, 345), button(2), trans
    put(488, 345), button_hover, alpha, transparency
    if click and 1 then
     final_result = 1
     if settings.sound then play (snd_src(1), snd(1))
    end if
   else
    put(488, 345), button(2), trans
   end if
  else
   spiel_intern.highscoreeintrag=0
   druck 210, 300, "Leider hat es mit " + trim$(str$(spieler1.userscore)) + " Punkten nicht"
   druck 210, 320, "fuer den Highscore gereicht."
   if mouseover(488, 340, 588, 374) then
    put(488, 340), button(8), trans
    put(488, 340), button_hover, alpha, transparency
    if click and 1 then
     final_result = 2 
     if settings.sound then play (snd_src(1), snd(1))
    end if
   else
    put(488, 340), button(8), trans
   end if
  end if
 exit sub
 else
  spiel_intern.highscoreeintrag=0
  druck 210, 280, "Sie haben leider verloren."
  druck 210, 300, "Vielleicht haben Sie das naechste"
  druck 210, 320, "Mal mehr Glueck!"
  if mouseover(488, 340, 588, 374) then
   put(488, 340), button(8), trans
   put(488, 340), button_hover, alpha, transparency
   if click and 1 then
    final_result = 2
    if settings.sound then play (snd_src(1), snd(1))
   end if
  else
   put(488, 340), button(8), trans
  end if
 end if

end sub

' *******************************************************************
' Diese SUB zeigt die Elemente des eigentlichen Spiels an
sub show.gameplayelements (gameplay_result as integer)

 ' Das Kartenfeld und die Karten der Spieler
 put(60, 170), kartenfeld, trans
 spiel.zeigehaende ()

 ' Die oberste Karte des Stocks - falls vorhanden - liegt offen
 with stock(1)
  if nochkarten() then put(347, 325), karten(.karte, .farbe), trans
 end with 
 
 ' Wer ist dran?
 put(47, 155), control, trans
 if spiel_intern.am_zug = spieler then put(47, 155), control_active, alpha, 200-transparency
 put(693, 155), control, trans
 if spiel_intern.am_zug = computer then put(693, 155), control_active, alpha, 200-transparency

 ' Karte ziehen?
 if mouseover(332, 450, 432, 483) then
  put(332, 450), button(9), trans
  put(332, 450), button_hover, alpha, transparency
  if click and 1 then 
   gameplay_result = 1
   if settings.sound then 
    if spiel_intern.am_zug = spieler then 
     play (snd_src(1), snd(1))
    else
     play (snd_src(6), snd(6))
    end if    
   end if
  end if 
 else
  put(332, 450), button(9), trans
 end if

 ' Mchte sich der Spieler eine Karte wnschen?
 if (spiel_intern.spielerwunsch=1) and (spiel_intern.wuenschenanzeigen=1) then
  ' Die Box mit den Informationen
  put(170, 260), menu_small, trans
  druck 180, 270, "--------------- BUBE ---------------"
  druck 180, 300, "Welche Farbe wuenschen Sie sich?"
  ' Die aktuelle Wunschfarbe
  put(270, 335), updownbackground, trans
  put(274, 338), wunschfarben(spiel_intern.wunschfarbe), alpha, 75+transparency
  ' Eine Farbe "weiter links"
  if mouseover(248, 339, 264, 371) then
   put(248, 339), arrow_left, trans
   put(248, 339), arrow_hover_left, alpha, transparency
   if click and 1 then
    gameplay_result = 2
    if settings.sound then 
     if spiel_intern.am_zug = spieler then 
      play (snd_src(1), snd(1))
     end if 
    end if
   end if
  else
   put(248, 339), arrow_left, trans  
  end if
  ' Eine Farbe "weiter rechts"
  if mouseover(315, 339, 331, 371) then
   put(315, 339), arrow_right, trans
   put(315, 339), arrow_hover_right, alpha, transparency
   if click and 1 then
    gameplay_result = 3
    if settings.sound then 
     if spiel_intern.am_zug = spieler then 
      play (snd_src(1), snd(1))
     end if    
    end if
   end if
  else
   put(315, 339), arrow_right, trans
  end if
  ' Der Wunsch-Button
  if mouseover(450, 360, 550, 394) then
   put(450, 360), button(7), trans
   put(450, 360), button_hover, alpha, transparency
   if click and 1 then
    gameplay_result = 4
    if settings.sound then 
     if spiel_intern.am_zug = spieler then 
      play (snd_src(1), snd(1))
     end if    
    end if
   end if
  else
   put(450, 360), button(7), trans
  end if
 end if 

 ' Wird sich von einem Spieler eine Karte gewnscht?
 if ((spiel_intern.spielerwunsch=1) or (spiel_intern.computerwunsch=1)) and (spiel_intern.wuenschenanzeigen=0) then
  put(305, 500), wunschbox, trans
  druck 315, 515, "Wunsch:"
  put(405, 507), wunschfarben(spiel_intern.wunschfarbe), trans
 end if

end sub

' *******************************************************************
' Diese SUB zeigt den Highscore an
sub show.highscore (highscore_result as integer, keycode as string)
    
 ' Die Box und die berschrift anzeigen
 put (200, 200), menu, trans
 druck 210, 220, "------------- HIGHSCORE ------------"
 ' Die einzenlen Namen anzeigen
 ypos = 260
 for index = 1 to 8 step 1
  with highscore(index)
   if index = 1 then
    druck 250, ypos, trim$(str$(index)) + "."
    druck 290, ypos, "   " + .username, transparency+80
    druck 490, ypos, trim$(str$(.userscore)), transparency+80
   else
    druck 250, ypos, trim$(str$(index)) + "."
    druck 290, ypos, "   " + .username
    druck 490, ypos, trim$(str$(.userscore))
   end if 
   ypos+=30
  end with
 next index

 ' Die Namenseingabe - wenn erforderlich
 if spiel_intern.highscoreeintrag=1 then
  ' Eingaberoutine aufrufen
  eingabe (spieler1.username, keycode, fertig)
  ' Einen Cursor simulieren
  if transparency>60 then csr$ = "_" else csr$ = ""
  druck 210, 515, "Ihr Name: " + spieler1.username + csr$
  ' Wurde ENTER gedrckt?
  ' Wenn ja, dann sortiere den Spieler im Highscore ein 
  if fertig then 
   spiel_intern.highscoreeintrag=0
   with spieler1
    for spielerindex = 8 to 1 step -1
     if .userscore > highscore(spielerindex).userscore then
      index = spielerindex
     end if
    next spielerindex
    if index = 8 then
     highscore(index).username = .username
	 highscore(index).userscore = .userscore
    else
     for spielerindex = 7 to index step -1
      highscore(spielerindex + 1).userscore = highscore(spielerindex).userscore
      highscore(spielerindex + 1).username = highscore(spielerindex).username
     next spielerindex
     highscore(index).username = .username
	 highscore(index).userscore = .userscore
    end if
   end with
   config (2)
  end if
 end if

 ' Zurck?
 if mouseover(485, 505, 585, 538) then
  put(485, 505), button(8), trans
  put(485, 505), button_hover, alpha, transparency
  if click and 1 then 
   highscore_result = 1
   if settings.sound then play (snd_src(1), snd(1)) 
  end if 
 else
  put(485, 505), button(8), trans
 end if
end sub

' *******************************************************************
' Diese SUB zeigt ein kleines Informationsmen zum Spiel an
sub show.infomenu (info_result as integer)

 ' Die Menbox und der Inhalt 
 put (200, 200), menu, trans
 druck 210, 220, "-------------- INFOS -------------"
 druck 210, 260, "Dieses Programm wurde programmiert"
 druck 210, 280, "von jb (jbsoft) fuer den Deutschen"
 druck 210, 300, "Programmierwettbewerb."
 druck 210, 340, "Das Programm ist Freeware und darf"
 druck 210, 360, "unter Beachtung der in der Readme"
 druck 210, 380, "angegebenen Bestimmungen beliebig"
 druck 210, 400, "weitergegeben werden."
 druck 210, 440, "Und nun: Viel Spa mit Mau Mau!"
 druck 210, 480, "Jens Boos"
 ' Zurck?
 if mouseover(470, 490, 565, 523) then
  put(465, 490), button(8), trans
  put(465, 490), button_hover, alpha, transparency
  if click and 1 then 
   info_result = 1
   if settings.sound then play (snd_src(1), snd(1))
  end if 
 else
  put(465, 490), button(8), trans
 end if

end sub

' *******************************************************************
' Diese SUB zeigt das obere Hauptmen des Spiels
sub show.mainmenu (main_result as integer)

 ' Spiel starten?
 if mouseover(50, 103, 148, 136) then
  put(50, 103), button(1), trans
  put(50, 103), button_hover, alpha, transparency
  if click and 1 then
   spiel_intern.gamestart = 0
   main_result = 1
   if settings.sound then play (snd_src(1), snd(1))
  end if
 else
  put(50, 103), button(1), trans
 end if

 ' Highscore aufrufen?
 if mouseover(170, 103, 268, 136) then
  put(170, 103), button(2), trans
  put(170, 103), button_hover, alpha, transparency
  if click and 1 then 
   main_result = 2
   spiel_intern.highscoreeintrag=0
   if settings.sound then
    play (snd_src(1), snd(1))
    play (snd_src(5), snd(5))
   end if
  end if
 else
  put(170, 103), button(2), trans
 end if

 ' Spiel beenden?
 if mouseover(290, 103, 388, 136) then
  put(290, 103), button(3), trans
  put(290, 103), button_hover, alpha, transparency
  if click and 1 then 
   main_result = 3
   if settings.sound then play (snd_src(1), snd(1)) 
  end if 
 else
  put(290, 103), button(3), trans   
 end if  
   
 ' Optionen aufrufen
 if mouseover(505, 103, 605, 136) then
  put(505, 103), button(4), trans
  put(505, 103), button_hover, alpha, transparency
  if click and 1 then 
   config ()
   main_result = 4
   if settings.sound then play (snd_src(1), snd(1)) 
  end if 
 else
  put(505, 103), button(4), trans  
 end if
   
 ' Readme aufrufen
 if mouseover(625, 103, 725, 136) then
  put(625, 103), button(5), trans
  put(625, 103), button_hover, alpha, transparency
  if click and 1 then
   main_result = 5
   if settings.sound then play (snd_src(1), snd(1)) 
  end if 
 else
  put(625, 103), button(5), trans  
 end if
 
end sub

' *******************************************************************
' Diese SUB dient dazu, das Optionsmen anzuzeigen
sub show.optionmenu (option_result as integer)

 ' Die Optionen in der bersicht 
  put (170, 175), options, trans
  druck 175, 200, "------------------ OPTIONEN ----------------"
  druck 200, 245, "SOUND:"
  druck 200, 285, "GEGNERISCHE KARTEN"
  druck 200, 301, "ANZEIGEN:"
  druck 200, 345, "COMPUTER BEGINNT:"
  druck 200, 395, "VOLLBILD:"
  druck 200, 445, "SPIELE PROTOKOLLIEREN:"
  druck 200, 495, "KARTEN ZU BEGINN: " + trim$(str$(settings.kartenanfang))
 
 ' Sound?
 if mouseover(450, 235, 550, 268) then
  put(450, 235), button(6+settings.sound), trans
  put(450, 235), button_hover, alpha, transparency
  if click and 1 then 
   option_result = 1
   if settings.sound then play (snd_src(1), snd(1))
  end if 
 else
  put(450, 235), button(6+settings.sound), trans
 end if 

 ' Highscore anzeigen?
 if mouseover(450, 285, 550, 318) then
  put(450, 285), button(6+settings.anzeige), trans
  put(450, 285), button_hover, alpha, transparency
  if click and 1 then 
   option_result = 2
   if settings.sound then play (snd_src(1), snd(1))
  end if 
 else
  put(450, 285), button(6+settings.anzeige), trans
 end if 

 ' Fngt der Computer an?
 if mouseover(450, 335, 550, 368) then
  put(450, 335), button(6+settings.computerbeginnt), trans
  put(450, 335), button_hover, alpha, transparency
  if click and 1 then 
   option_result = 3
   if settings.sound then play (snd_src(1), snd(1))
  end if 
 else
  put(450, 335), button(6+settings.computerbeginnt), trans
 end if 
 
 ' Vollbild?
 if mouseover(450, 385, 550, 418) then
  put(450, 385), button(6+settings.vollbild), trans
  put(450, 385), button_hover, alpha, transparency
  if click and 1 then 
   option_result = 4
   if settings.sound then play (snd_src(1), snd(1))
  end if 
 else
  put(450, 385), button(6+settings.vollbild), trans
 end if 
 
 ' Spiele protokollieren?
 if mouseover(450, 435, 550, 468) then
  put(450, 435), button(6+settings.protokoll), trans
  put(450, 435), button_hover, alpha, transparency
  if click and 1 then 
   option_result = 5
   if settings.sound then play (snd_src(1), snd(1))
  end if 
 else
  put(450, 435), button(6+settings.protokoll), trans
 end if 

  ' Mehr/Weniger Karten-Umrandungsfeld
 put(452, 485), updownbackground, trans
 
 ' Mehr Karten
 if mouseover(455, 488, 508, 504) then
  put(455, 488), arrow_up, trans
  put(455, 488), arrow_hover_up, alpha, transparency
  if click and 1 then 
   option_result = 6
   if settings.sound then 
    if settings.kartenanfang < 8 then 
     play (snd_src(1), snd(1))
    else
     play (snd_src(6), snd(6))
    end if
   end if
  end if 
 else
  put(455, 488), arrow_up, trans
 end if 
 
 ' Weniger Karten
 if mouseover(455, 505, 508, 521) then
  put(455, 505), arrow_down, trans
  put(455, 505), arrow_hover_down, alpha, transparency
  if click and 1 then 
   option_result = 7
   if settings.kartenanfang > 3 then 
     play (snd_src(1), snd(1))
    else
     play(snd_src(6), snd(6))
    end if
  end if 
 else
  put(455, 505), arrow_down, trans
 end if 

 ' Zurck?
 if mouseover(515, 535, 615, 568) then
  put(515, 535), button(8), trans
  put(515, 535), button_hover, alpha, transparency
  if click and 1 then 
   option_result = 8
   if settings.sound then play (snd_src(1), snd(1)) 
  end if 
 else
  put(515, 535), button(8), trans
 end if
 
 ' Speichern?
 if mouseover(395, 535, 495, 568) then
  put(395, 535), button(10), trans
  put(395, 535), button_hover, alpha, transparency
  if click and 1 then 
   option_result = 9
   if settings.sound then play (snd_src(1), snd(1))
  end if 
 else
  put(395, 535), button(10), trans
 end if
 
end sub

' *******************************************************************
' Diese SUB enthlt die komplette Steuerung des Computergegners
sub spiel.computeractions ()

 ' Klickt der Spieler herum, obwohl er nicht dran ist?
 mouseovercard (cardnumber)
 if (cardnumber>0) and (click=1) then
  if settings.sound then play (snd_src(6), snd(6))
 end if

 ' Muss der Computer aufgrund einer 7 zwei Karten ziehen?
 if spiel_intern.zweiziehen=1 then
  ' Eine Meldung fr das Protokoll
  if settings.protokoll then 
   spiel.protokoll ("Der Computer muss aufgrund einer 7 zwei Karten ziehen.")
  end if
  spiel.ziehekarte (computer, 2)
  spiel_intern.zweiziehen=0
 end if

 ' Wird der Computer aufgrund einer 8 bersprungen?
 if spiel_intern.ueberspringen=1 then
  ' Eine Meldung fr das Protokoll
  if settings.protokoll then 
   spiel.protokoll ("Der Computer wird aufgrund einer 8 bersprungen.")
  end if
  spiel_intern.am_zug = spieler
  spiel_intern.ueberspringen = 0
  exit sub
 end if

 ' Das folgende Codestck nur einmal durchfhren, obwohl diese SUB pro 
 ' Computer-Spielzug 100mal durchlaufen wird, damit der Spielzug des 
 ' Computers fr das menschliche Auge sichtbar wird.
 spiel_intern.computerdelaycounter+=1
 if spiel_intern.computerdelaycounter=1 then
  ' Welche Karte(n) kann der Computer legen?
  redim kannlegen(anzahlkarten(computer)) as integer
  spiel_intern.kannlegen_anzahl = 0
  ' Wurde ein Bube gelegt?
  if (spiel_intern.spielerwunsch=1) or (spiel_intern.computerwunsch=1) then
   ' jede Karte auf der Hand berprfen
   for index = 1 to anzahlkarten(computer) step 1
   with hand(computer, index)
    ' gleiche Farbe
    if (.farbe=spiel_intern.wunschfarbe) and (.karte<>5) then
     kannlegen(index) = .karte
     spiel_intern.kannlegen_anzahl+=1
    ' ein Bube geht immer
    elseif .karte=5 then
     kannlegen(index) = .karte
     spiel_intern.kannlegen_anzahl+=1
    end if
   end with
   next index
  ' es wurde kein Bube gelegt
  else
   ' jede Karte auf der Hand berprfen
   for index = 1 to anzahlkarten(computer) step 1
   with hand(computer, index)
    ' ein Bube geht immer
    if .karte = 5 then
     kannlegen(index) = .karte
     spiel_intern.kannlegen_anzahl+=1
    ' gleiche Farbe
    elseif .farbe = stock(1).farbe then
     kannlegen(index) = .karte
     spiel_intern.kannlegen_anzahl+=1
    ' gleiche Ziffer
    elseif .karte = stock(1).karte then
     kannlegen(index) = .karte
     spiel_intern.kannlegen_anzahl+=1
    end if
   end with
   next index
  end if

  ' Welche ist die geeignetste Karte?
  if spiel_intern.kannlegen_anzahl>0 then
   spiel_intern.bestekarte_index=0
   spiel_intern.bestekarte_wert=0
   ' Sind nur Buben vorhanden?
   nurbuben=0
   for index = 1 to anzahlkarten(computer) step 1
    if kannlegen(index)=5 then nurbuben+=1
   next index
   if nurbuben=spiel_intern.kannlegen_anzahl then nurbuben=1 else nurbuben=0
   ' Jede Karte auf der Hand es Computers berprfen
   for index = 1 to anzahlkarten(computer) step 1
    ' Es sind nur Buben vorhanden
    if nurbuben=1 and kannlegen(index)=5 then
     spiel_intern.bestekarte_index=index
     ' Welche Farbe soll sich der Computer wnschen?
     ' (d.h. welche Farbe kommt am Hufigsten vor?)
     ' das alte Feld resetten
     for r = 1 to 4 step 1
      computerkartenanzahl(r) = 0
     next r
     ' Und nun die hufigste Farbe suchen
     for farbenindex = 1 to anzahlkarten(computer) step 1
      ' Die aktuelle Karte & Buben allgemein nicht mitzhlen
      if farbenindex <> spiel_intern.bestekarte_index then
       with hand(computer, farbenindex)
        if .karte <> 5 then
         computerkartenanzahl(.farbe)+=1
        end if
       end with
      end if
     next farbenindex
     spiel_intern.maxwert=0
     for kartenindex = 1 to 4 step 1
      if computerkartenanzahl(kartenindex)>spiel_intern.maxwert then
       spiel_intern.maxwert=kartenindex
      end if
     next kartenindex
     exit for
    ' andernfalls die Karte mit dem grten Wert suchen (nur kein Bube)
    elseif (kannlegen(index)>spiel_intern.bestekarte_wert) and (kannlegen(index)<>5) then
     spiel_intern.bestekarte_index=index
     spiel_intern.bestekarte_wert=kannlegen(index)
    end if
   next index
  end if

 end if

 ' Die zu legende Karte anzeigen:
 if spiel_intern.computerdelaycounter<140 then
  if spiel_intern.kannlegen_anzahl>0 then
   line(346, 199)-(418, 296), rgb(0, 0, 255), b
   with hand(computer, spiel_intern.bestekarte_index)
    put(347, 200), karten(.karte, .farbe), alpha, transparency+100
   end with
  end if
 end if
 ' Die Karte legen / eine Karte ziehen
 if spiel_intern.computerdelaycounter=141 then
  ' Kann eine Karte gelegt werden?
  if spiel_intern.kannlegen_anzahl>0 then
   ' Speichere die gelegte Karte fr das Protokoll
   tmpkarte = hand(computer, spiel_intern.bestekarte_index).karte
   tmpfarbe = hand(computer, spiel_intern.bestekarte_index).farbe
   ' spiel_intern.wunschfarbe=spiel_intern.maxwert
   spiel.legekarte (computer, spiel_intern.bestekarte_index, inordnung)
   ' Sollte die Karte (wider Erwarten) doch nicht passen, dann ziehe eine Karte
   if inordnung=0 then
    spiel.ziehekarte (computer, 1)
    ' Eine Meldung fr das Protokoll
    if settings.protokoll then 
     spiel.protokoll ("Der Computer zieht eine Karte.")
    end if
   else
    ' Eine Meldung fr das Protokoll
    if settings.protokoll then 
     spiel.protokoll ("Der Computer legt die Karte " + getrealname(tmpkarte, tmpfarbe) + ".")
    end if
    ' Und die "Wunsch-Anzeige-Box" - falls vorhanden - wieder entfernen
    if (spiel_intern.wuenschenanzeigen=0) and (spiel_intern.spielerwunsch=1) then
     spiel_intern.spielerwunsch=0
    end if
    if (spiel_intern.wuenschenanzeigen=0) and (spiel_intern.computerwunsch=1) then
     spiel_intern.computerwunsch=0
    end if   
   end if
  elseif spiel_intern.kannlegen_anzahl=0 then
   spiel.ziehekarte (computer, 1)
   ' Eine Meldung fr das Protokoll
   if settings.protokoll then 
    spiel.protokoll ("Der Computer zieht eine Karte.")
   end if
  end if
 end if
 ' Und noch ein bisschen warten
 if spiel_intern.computerdelaycounter>141 then
  ' Wurde eine Karte gelegt?
  if spiel_intern.kannlegen_anzahl>0 then
   ' Hatte die gelegte Karte Sonderfunktionen?
   ' eine 7
   if kannlegen(spiel_intern.bestekarte_index)=1 then
    spiel_intern.zweiziehen=1
   ' eine 8
   elseif kannlegen(spiel_intern.bestekarte_index)=2 then
    spiel_intern.ueberspringen=1
   ' ein Bube
   elseif kannlegen(spiel_intern.bestekarte_index)=5 then
    spiel_intern.computerwunsch=1
    spiel_intern.wunschfarbe=spiel_intern.maxwert
    ' Eine Meldung fr das Protokoll
    if settings.protokoll then
     spiel.protokoll ("Der Computer wnscht sich die Farbe " + getfarbe(farbnummer) + ".")
    end if
   end if
  end if
  spiel_intern.computerdelaycounter=0
  spiel_intern.gezogen=0
  spiel_intern.am_zug=spieler
 end if

end sub

' *******************************************************************
' Diese SUB verteilt Karten an die beiden Spieler
sub spiel.gebekarten ()
   
 ' Die ersten Karten aus dem Stock an die beiden Spieler verteilen
 StockIndex = 0
 for KartenIndex = 1 to settings.kartenanfang step 1
  for SpielerIndex = 1 to 2 step 1
   StockIndex+=1 
   with stock(StockIndex)
    if SpielerIndex = spieler then 
     hand(spieler, KartenIndex).karte = .karte
     hand(spieler, KartenIndex).farbe = .farbe
     .karte = 0
     .farbe = 0
    elseif SpielerIndex = computer then
     hand(computer, KartenIndex).karte = .karte
     hand(computer, KartenIndex).farbe = .farbe
     .karte = 0
     .farbe = 0
    end if 
   end with
  next SpielerIndex
 next KartenIndex
 ' Und danach die im Stock verbliebenen Karten "nach oben schieben"
 for index = StockIndex+1 to 32 step 1
  stock(index - StockIndex)= stock(index) 
 next index
 for index = 32-StockIndex+1 to 32 step 1
  stock(index).farbe = 0
  stock(index).karte = 0
 next index  
 
end sub

' *******************************************************************
' Diese SUB legt eine Karte auf de nStock und berprft vorher, ob 
' dies berhaupt mglich ist
sub spiel.legekarte (welcherspieler as integer, kartenindex as integer, ok as integer)
 
 ' Ist das Legen der Karte berhaupt mglich (2. Flle: Mit und ohne Bube)?
 ok = 0
 ' Mit Bube
 if (spiel_intern.spielerwunsch=1) or (spiel_intern.computerwunsch=1) then
  ' Ein Bube geht trotzdem
  if hand(welcherspieler, kartenindex).karte = 5 then
   ok = 1
  ' Bei einem Bube muss die gewnschte Farbe gelegt werden
  elseif hand(welcherspieler, kartenindex).farbe = spiel_intern.wunschfarbe then
   ok = 1
  else
   ok = 0
  end if
 ' Ohne Bube
 else 
  ' ein Bube geht immer
  if hand(welcherspieler, kartenindex).karte = 5 then
   ok = 1 
  ' gleiche Farbe
  elseif hand(welcherspieler, kartenindex).farbe = stock(1).farbe then 
   ok = 1
  ' gleiche Ziffer 
  elseif hand(welcherspieler, kartenindex).karte = stock(1).karte then
   ok = 1
  ' die Karte passt nicht
  else
   ok = 0
  end if
 end if
  
 if ok then 
  if settings.sound then play (snd_src(2), snd(2))
 else
  if settings.sound then play (snd_src(6), snd(6))
  exit sub
 end if 
 
 ' Eine Karte abziehen
 anzahlkarten(welcherspieler)-=1
 
 ' Aktuelle obere Karte hinter die letzte (besetzte) Stelle des Stocks setzen
 anzahl = nochkarten()
 stock(anzahl+1) = stock(1)

 ' Die erste Stelle im Stock lschen
 stock(1).karte = 0
 stock(1).farbe = 0

 ' Stock mischen
 stapelinit (2)

 ' Die gelegte Karte an die erste - vorher gelschte - Stelle des Stocks setzen
 stock(1) = hand(welcherspieler, kartenindex)

 ' Und die gelegte Karte aus der Hand es Spielers lschen
 for index = kartenindex to 31 step 1
  hand(welcherspieler, index) = hand(welcherspieler, index+1)
 next index
 
end sub

' *******************************************************************
' Diese SUB fgt dem Protokoll eine Zeile hinzu
sub spiel.protokoll (text as string, neuesprotokoll as integer=0)

 ' Soll ein neues Protokoll angefangen werden?
 if neuesprotokoll=1 then
  settings.protokollnr+=1
  config(2)
  f = freefile
  open exepath + "\Protokolle\Protokoll_" + trim$(str$(settings.protokollnr)) + ".txt" for output as #f
   print #f, text
  close #f

 ' Text ans alte Protokoll anhngen
 elseif neuesprotokoll=0 then
  f = freefile
  open exepath + "\Protokolle\Protokoll_" + trim$(str$(settings.protokollnr)) + ".txt" for append as #f
   print #f, text
  close #f

 end if

end sub

' *******************************************************************
' Diese SUB enthlt Befehle fr den Spieler selbst
sub spiel.spieleractions (gameplay_result as integer)

 ' Muss der Spieler aufgrund einer 7 zwei Karten ziehen?
 if spiel_intern.zweiziehen=1 then
  ' Eine Meldung fr das Protokoll
  if settings.protokoll then 
   spiel.protokoll ("Der Spieler muss aufgrund einer 7 zwei Karten ziehen.")
  end if
  spiel.ziehekarte (spieler, 2)
  spiel_intern.zweiziehen = 0
 end if

 ' Wird der Spieler aufgrund einer 8 bersprungen?
 if spiel_intern.ueberspringen=1 then
  ' Eine Meldung fr das Protokoll
  if settings.protokoll then 
   spiel.protokoll ("Der Spieler wird aufgrund einer 8 bersprungen.")
  end if
  spiel_intern.am_zug = computer
  spiel_intern.ueberspringen = 0
  exit sub
 end if

 ' Eine Karte ziehen
 if (gameplay_result=1) and (spiel_intern.gezogen=0) then
  ' Eine Meldung fr das Protokoll
  ' Eine Meldung fr das Protokoll
  if settings.protokoll then 
   spiel.protokoll ("Der Spieler zieht eine Karte, da er keine Karte legen kann/mchte.")
  end if
  spiel.ziehekarte (spieler)
  gameplay_result = 0
  spiel_intern.am_zug = computer
 end if

 ' Mchte der Spieler eine Karte legen?
 mouseovercard (cardnumber)
 if (cardnumber>0) and (click=1) then
  click=0
  tmpkarte = hand(spieler, cardnumber).karte
  tmpfarbe = hand(spieler, cardnumber).farbe
  spiel.legekarte (spieler, cardnumber, inordnung)
  if inordnung then 
   ' Und die "Wunsch-Anzeige-Box" -falls vorhanden - wieder entfernen
   if (spiel_intern.wuenschenanzeigen=0) and (spiel_intern.spielerwunsch=1) then
    spiel_intern.spielerwunsch=0
   end if
   if (spiel_intern.wuenschenanzeigen=0) and (spiel_intern.computerwunsch=1) then
    spiel_intern.computerwunsch=0
   end if
   ' Eine Meldung fr das Protokoll
   if settings.protokoll then 
    spiel.protokoll ("Der Spieler legt die Karte " + getrealname(tmpkarte, tmpfarbe) + ".")
   end if
   ' Der Computer ist erst am Zug, wenn die gelegte Karte kein Bube war
   if tmpkarte<>5 then spiel_intern.am_zug = computer
   ' Hat diese Karte Sonderfunktionen?
   select case tmpkarte
    ' eine 7
    case 1
     spiel_intern.zweiziehen = 1
    ' eine 8
    case 2
     spiel_intern.ueberspringen = 1
    ' ein Bube
    case 5
     spiel_intern.spielerwunsch = 1
     spiel_intern.wunschfarbe = 1
     spiel_intern.wuenschenanzeigen = 1
   end select
  end if 
 end if

end sub

' *******************************************************************
' Diese SUB zeigt die Karten der beiden Spieler an
sub spiel.zeigehaende ()
 
 ' Anzahl der Handkarten des Spielers ermitteln und anzeigen
 xpos=90
 ypos=180
 ' Schleife ber alle Karten des Spielers
 for index = 1 to anzahlkarten(spieler)
  ' Koordinaten erhhen
  ypos+=kartenspalt
  if ypos > 440 then
   ypos = 180+kartenspalt
   xpos+=75
  end if
  ' Karten - sollten sie vorhanden sein - anzeigen 
  with hand(spieler, index)   
   if .karte<>0 and .farbe<>0 then 
    put(xpos, ypos), karten(.karte, .farbe), trans
   end if 
  end with
 next index
 ' Anzahl der Handkarten des Computers ermitteln und anzeigen
 xpos=480
 ypos=180
 ' Schleife ber alle Karten des Computers
 for index = 1 to anzahlkarten(computer)
  ' Koordinaten erhhen
  ypos+=kartenspalt
  if ypos > 440 then
   ypos = 180+kartenspalt 
   xpos+=75
  end if
  ' Sollen die Karten des Gegners angezeigt werden?
  with hand(computer, index)
  ' Ja
  if settings.anzeige=0 then
   if (.farbe = 3) or (.farbe = 4) then 
    put(xpos, ypos), back(1), trans
   elseif (.farbe = 1) or (.farbe = 2) then
    put(xpos, ypos), back(2), trans
   end if 
  ' Nein
  else
   if (.karte<>0) and (.farbe<>0) then
    put(xpos, ypos), karten(.karte, .farbe), trans
   end if
  end if 
  end with
 next index

end sub

' *******************************************************************
' Mit dieser SUB kann ein Spieler Karten ziehen
sub spiel.ziehekarte (welcherspieler as integer, anzahl as integer=1)

 ' Sind noch gengend Karten vorhanden?
 if nochkarten() < 2 then 
  if settings.sound then play (snd_src(6), snd(6))
  exit sub
 end if

 ' Ein kleiner Sound
 if settings.sound then play (snd_src(2), snd(2))

 ' Der Spieler hat nun mehr Karten
 alte_anzahl = anzahlkarten(welcherspieler)
 anzahlkarten(welcherspieler)+=anzahl

 ' Einem Spieler die Karte/die Karten dazugeben
 for k = 1 to anzahl step 1
  hand(welcherspieler, alte_anzahl+k) = stock(1+k)
 next k

 ' Alle brigen Karten rcken einen nach
 for index = 2 to 32-anzahl step 1
  stock(index) = stock(index+anzahl)
 next index

end sub

' *******************************************************************
' Diese SUB sortiert/mischt den Stock (je nach Parameter)
sub stapelinit (what2do as integer=1)
 
 ' Sortieren oder mischen?
 select case what2do
  ' Karten sortieren
  case 1
   index = 0
   for FarbenIndex = 1 to 4 step 1
    for KartenIndex = 1 to 8 step 1   
     index = index + 1
     with stock(index)
      .farbe = FarbenIndex
      .karte = KartenIndex
     end with 
    next KartenIndex
   next FarbenIndex
  ' Mischen
  case else
   for dummy1 = 1 to 50 step 1
    ' Zwei Karten auswhlen und vertauschen
    index1 = int(rnd * 32) + 1  
    index2 = int(rnd * 32) + 1
    if (stock(index1).karte>0) and (stock(index2).karte>0) then
     swap stock(index1), stock(index2)
    end if
   next dummy
 end select
 
end sub
