' *******************************************************************
' *                                                                 *
' *  GallowMan                                                      *
' *                                                                 *
' *  pogrammiert von Jens Boos (jb) fr den                         *
' *                                                                 *
' *  Deutschen QuickBASIC & freeBASIC Programmierwettbewerb         *
' *                                                                 *
' *  vom 09.08.06 bis zum 06.10.06                                  *
' *                                                                 *
' *  Zur genaueren Erklrung des Programms schauen Sie              *
' *  bitte in die Datei Readme.TXT                                  *
' *                                                                 *
' *******************************************************************
' *                                                                 *
' *  Programmiert in freeBASIC Version 0.16b                        *
' *                                                                 *
' *******************************************************************

' *****************************************************************************
' Zufallsgenerator initialisieren
randomize timer

' *****************************************************************************
' dynamische Speicherverwaltung
'$dynamic

' *****************************************************************************
' Die UDTs:

' Die Fonts
type FontType
    Font                    as string
    FontWidth(32 to 255)    as integer
    MaxFontWidthY           as integer
end type
dim shared as FontType FontData(0)

' Die Maus
type MouseInfoType
    PositionX           as integer
    PositionY           as integer
    tmp                 as integer
    Tasten              as integer
    Tasten2             as integer
end type
dim shared as MouseInfoType Mouse

' Die Einstellungen
type SettingsType
    SoundEffects        as integer
    BGMusic             as integer
    Vollbild            as integer
    Pause               as integer
    TextDatei           as string
    Gruppe              as string
    HintergrundMusikAlt as string
    HintergrundMusik    as string
    SpielModus          as integer
    Zeit                as integer
end type
dim shared as SettingsType Settings

' Die Spielvariablen
type SpielInfoType
    SpielerName         as string
    SpielerScore        as integer
    WortErraten         as integer
    Fertig              as integer
    ZeitIstUm           as integer
    StatusIndex         as integer
    GesuchtesWort       as string
    GefundenesWort      as string
    Buchstaben          as string
    FalscheBuchstaben   as string
end type
dim shared as SpielInfoType SpielInfo

' Die Begriffe
type BegriffType
    Gruppe              as string
    Begriff             as string
end type
dim shared as BegriffType Begriffe(0)

' Das animierte Men
type MenuAnimationType
    MenuPositionX1      as integer
    MenuPositionX2      as integer
    MenuPositionY1      as integer
    MenuPositionY2      as integer
    TitlePositionY      as integer
    MaxPositionX1       as integer
    MaxPositionX2       as integer
    MaxPositionY1       as integer
    MaxPositionY2       as integer
    MinPositionX1       as integer
    MinPositionX2       as integer
    MinPositionY1       as integer
    MinPositionY2       as integer
    MaxDifferenceX      as integer
    MaxDifferenceY      as integer
    SpeedX1             as integer
    SpeedX2             as integer
    SpeedY1             as integer
    SpeedY2             as integer
    Radius              as integer
    RadiusSpeed         as integer
    MinRadius           as integer
    MaxRadius           as integer
    Transparency        as integer
end type
dim shared as MenuAnimationType MenuAnimation, NewMenuAnimation
dim shared as MenuAnimationType GameMenu1, GameMenu2, GameMenu3, GameMenu4

' Die animierten Menbuttons
type MenuButtonType
    PositionX       as integer
    PositionY       as integer
    Caption         as string
    Status          as integer
    Clicked         as integer
    Active          as integer
    Transparency    as integer
    SpeedX          as integer
    SpeedY          as integer
    OriginX         as integer
    OriginY         as integer
    DestinationX    as integer
    DestinationY    as integer
    Disabled        as integer
end type
dim shared as MenuButtonType MenuButtons(0)
dim shared as MenuButtonType DialogButtons(0)

' Die anderen Eingabe-Buttons im Spiel
type ButtonType
    PositionX       as integer
    PositionY       as integer
    Caption         as string
    Status          as integer
    Clicked         as integer
    Active          as integer
end type
dim shared as ButtonType EingabeButtons(26)

' Der Highscore
type HighScoreType
    SpielerName     as string
    SpielerScore    as integer
end type
dim shared as HighScoreType HighScoreData(5, 5)

' *****************************************************************************
' Die API-untersttzten Funktionen
'$include once: 'windows.bi'
'$include once: 'win\commdlg.bi'
declare function mciSendString lib "winmm.dll" _ 
    alias "mciSendStringA" (byval lpszCommand as string, _ 
    byval lpszReturnString as string, _ 
    byval cchReturnLength as long, _ 
    byval hwndCallback as long) as long
declare function SearchFile (Titel as string, Pfad as string, Filter as string) as string
declare function GetCurrentPosition (sAlias as string) as long
declare function GetSoundLength (sAlias as string) as long
declare sub PlaySound (sFile as string, sAlias as string, OK as integer, repeat as string = "")
declare sub StopSound (sAlias as string)

' *****************************************************************************
' Die SUBs
declare sub CenterPrint (xmin as integer, xmax as integer, ymin as integer, ymax as integer, Text as string, Farbe as long = rgb(255, 255, 255), bgfarbe as long = rgb(255, 0, 255))
declare sub DrawBox (PositionX1 as integer, PositionY1 as integer, PositionX2 as integer, PositionY2 as integer, Radius as integer, Farbe as long, BGFarbe as long, Transparency as integer)
declare sub GetMouseInfo ()
declare sub LadeBegriffe (Datei as string)
declare sub LadeBegriffeZurGruppe ()
declare sub LadeEingabeButtons ()
declare sub LadeHighScore ()
declare sub LoadFonts (FontName as string, Feld() as byte)
declare sub LoadGameMenu (MenuID as integer)
declare sub LoadSettings ()
declare sub PrintFont (xpos as integer, ypos as integer, Text as string, farbe as long = rgb(255, 255, 255), bgfarbe as long = rgb(255, 0, 255))
declare sub ResetGameData (Complete as integer = 1)
declare sub SaveSettings ()
declare sub SchreibeInHighScore (SpielerName as string, SpielerScore as integer, SpielModus as integer)
declare sub SetFont (Font as string)
declare sub ShowAnimatedMenu (MenuData as MenuAnimationType)
declare sub ShowDialogButtons (MenuResult as integer)
declare sub ShowEingabeMaske ()
declare sub ShowGameMenu (MenuResult as integer)
declare sub SpeicherHighScore ()

' *****************************************************************************
' Und die FUNCTIONs
declare function AdaptStringLength (Ausdruck as string, Font as string, Length as integer) as string
declare function GetTextLength (Text as string) as integer
declare function GetFontXWidth (FontName as string) as integer
declare function GetFontYWidth (FontName as string) as integer
declare function IsMouseOver (xmin as integer, ymin as integer, xmax as integer, ymax as integer) as integer
declare function GetFileName (TextDatei as string) as string
declare function ChangeValue (IstWert as integer, SollWert as integer, Speed as integer = 3) as integer
declare function SucheWort () as string
declare function IstFertig (Wort as string) as integer
declare function CalculateTime (Zeit as integer) as string
declare function Eingabe (Ausdruck as string, MaxLength as integer, Font as string) as string
declare function IsHighScoreEintrag (Score as integer, SpielModus as integer) as integer
declare function CalculateScore () as integer
declare function GetScoreString () as string

' *****************************************************************************
' Variablen

' Die Fonts
dim shared Font1XWidth(32 to 255) as integer
dim shared Font2XWidth(32 to 255) as integer
dim shared as integer MaxFontXWidth, MaxFontYWidth
dim shared as integer CurrentFont

' Die Einstellungen und Spielinformationen
dim shared as string TextDatei, NeueTextDatei, NeueHintergrundMusik
dim shared as string Gruppen(0), Joker(0)
dim shared as string BegriffeInDerGruppe(0)
dim shared as string Taste, Zeichen, ZeitTMP
dim as string Minuten, Sekunden, Cursor
dim shared as integer GruppenIndex, Zeit
dim as integer CursorIndex

' Die Bilder
dim shared as any ptr BackGround, Title, GallowMan, Button, ButtonInActive
dim shared as any ptr MenuButton, MenuButtonInActive, Display
dim shared as any ptr StatusBilder(11)

' Die Mens und Animationen
dim shared as double pi = 3.141
dim shared as integer CurrentMenuID
dim shared as string CurrentMenuTitle
dim shared as integer AllChanged
dim shared as integer AnimateFlyIn, AnimateFlyOut, AnimateStatus
dim shared as integer AnimateDialogFlyIn, AnimateDialogFlyOut, AnimateDialogStatus, AnimateTMP
dim shared as integer Farbe, FarbWert
dim shared as integer Transparency
dim as integer MenuResult, OldMenuResult
dim as integer DialogMenuResult, DialogOldMenuResult
dim as integer DialogFarbe

' Die Position der berschrift
dim as integer TitlePositionY = 40

' *****************************************************************************
' Die Einstellungen laden
LoadSettings ()

' *****************************************************************************
' Der Bildschirmmodus 640x480x24 (Doublebuffering)
if Settings.Vollbild then
    screen 18, 24, 2, 1
else
    screen 18, 24, 2
end if
screenset 1, 2

' *****************************************************************************
' Die Bilder laden
BackGround = imagecreate(640, 480)
bload exepath + "\data\img\bg.bmp", BackGround
Title = imagecreate(215, 43)
bload exepath + "\data\img\title.bmp", Title
Button = imagecreate(28, 29)
bload exepath + "\data\img\button.bmp", Button
ButtonInActive = imagecreate(28, 29)
bload exepath + "\data\img\button_inactive.bmp", ButtonInActive
MenuButton = imagecreate(150, 28)
bload exepath + "\data\img\menubutton.bmp", MenuButton
MenuButtonInActive = imagecreate(150, 28)
bload exepath + "\data\img\menubutton_inactive.bmp", MenuButtonInActive
Display = imagecreate(580, 50)
bload exepath + "\data\img\display.bmp", Display
for Index = 1 to 11 step 1
    StatusBilder(Index) = imagecreate(220, 220)
    bload exepath + "\data\img\gm" + trim$(str$(Index)) + ".bmp", StatusBilder(Index)
next Index

' *****************************************************************************
' Die Fonts laden
dim shared NormalFont(0, 0, 0) as byte
LoadFonts("Comic", NormalFont())
dim shared LargeFont(0, 0, 0) as byte
LoadFonts("Comic_Bold", LargeFont())
SetFont("Comic")

' *****************************************************************************
' Das Startmen laden
LoadGameMenu (1)
MenuAnimation = NewMenuAnimation

' *****************************************************************************
' Die Eingabe-Buttons laden
LadeEingabeButtons ()

' *****************************************************************************
' Beginn Hauptschleife
do

    ' Benutzereingaben abfragen
    GetMouseInfo()
    Taste = inkey$

    ' Programm beenden?
    if ((Taste = chr$(27)) or (Taste = chr$(255) + "k")) and (Beenden = 0) then exit do

    ' Den Hintergrund anzeigen
    put(0, 0), BackGround, trans
    put(200, TitlePositionY), Title, trans

    ' Titel versetzen?
    if (CurrentMenuID = 5) and (AnimateFlyOut = 1) then
        if TitlePositionY < 40 then TitlePositionY+ = 1
    elseif (CurrentMenuID = 5) and (AnimateFlyOut = 0) then
        if TitlePositionY > 30 then TitlePositionY- = 1
    else
        TitlePositionY = 40
    end if

    ' Die Buttons animieren
    if (AnimateFlyOut = 1) then
        AnimateStatus = 0
        for Index = 1 to ubound(MenuButtons) step 1
            with MenuButtons(Index)
                if .PositionX <> .OriginX then .PositionX+ = .SpeedX
                if .PositionY <> .OriginY then .PositionY+ = .SpeedY
                if .Transparency > 0 then .Transparency- = 15
                if (.PositionX = .OriginX) and (.PositionY = .OriginY) then
                    AnimateStatus+ = 1
                end if
            end with
        next Index
        if AnimateStatus = ubound(MenuButtons) then AnimateFlyOut = 0
    end if

    ' Der Einblende-Effekt der Schrift
    if AnimateFlyIn = 1 then
        Farbe = rgb(FarbWert, FarbWert, FarbWert)
        if FarbWert < 250 then FarbWert+ = 5
        if Transparency < 250 then Transparency+ = 5
    elseif AnimateFlyOut = 1 then
        Farbe = rgb(FarbWert, FarbWert, FarbWert)
        if FarbWert > 128 then FarbWert- = 5
        if Transparency > 10 then Transparency- = 5
    end if

    ' Die Mens anzeigen
    OldMenuResult = MenuResult

    ' *************************************************************************
    ' Hauptmen
    if (CurrentMenuID = 1) then

        ' Men anzeigen
        ShowGameMenu (MenuResult)

        ' Kann das Spiel gestartet werden?
        if GruppenIndex = 0 then
            MenuButtons(1).Disabled = 1
        else
            MenuButtons(1).Disabled = 0
        end if

        ' Kann der Highscore angesehen werden?
        if Settings.SpielModus = 1 then
            MenuButtons(4).Disabled = 1
        else
            MenuButtons(4).Disabled = 0
        end if

        ' Spiel starten
        if (MenuResult = 1) and (MenuResult <> OldMenuResult) then
            AnimateFlyOut = 1
        elseif (MenuResult = 1) and (AnimateFlyOut = 0) then
            ResetGameData ()
            LoadGameMenu (5)
            MenuResult = 0

        ' Optionen
        elseif (MenuResult = 2) and (MenuResult <> OldMenuResult) then
            AnimateFlyOut = 1
        elseif (MenuResult = 2) and (AnimateFlyOut = 0) then
            LoadGameMenu (2)
            MenuResult = 0

        ' Credits
        elseif (MenuResult = 3) and (MenuResult <> OldMenuResult) then
            AnimateFlyOut = 1
        elseif (MenuResult = 3) and (AnimateFlyOut = 0) then
            LoadGameMenu (3)
            MenuResult = 0

        ' Highscore
        elseif (MenuResult = 4) and (MenuResult <> OldMenuResult) then
            AnimateFlyOut = 1
        elseif (MenuResult = 4) and (AnimateFlyOut = 0) then
            LoadGameMenu (9)
            MenuResult = 0

        ' Beenden
        elseif (MenuResult = 5) and (MenuResult <> OldMenuResult) then
            AnimateFlyOut = 1
        elseif (MenuResult = 5) and (AnimateFlyOut = 0) then
            LoadGameMenu (4)
            MenuResult = 0
        end if

    ' *************************************************************************
    ' Optionen
    elseif (CurrentMenuID = 2) then

        ShowGameMenu (MenuResult)
        PrintFont(155, 160, "Hier knnen Sie smtliche relevanten Einstellungen", Farbe)
        PrintFont(155, 180, "zum Spiel ndern:", Farbe)

        ' Soundeinstellungen ndern
        if (MenuResult = 1) and (MenuResult <> OldMenuResult) then
            AnimateFlyOut = 1
        elseif (MenuResult = 1) and (AnimateFlyOut = 0) then
            'SaveSettings ()
            LoadGameMenu (6)
            MenuResult = 0

        ' Grafikeinstellungen ndern
        elseif (MenuResult = 2) and (MenuResult <> OldMenuResult) then
            AnimateFlyOut = 1
        elseif (MenuResult = 2) and (AnimateFlyOut = 0) then
            SaveSettings ()
            LoadGameMenu (10)
            MenuResult = 0

        ' Begriffe ndern
        elseif (MenuResult = 3) and (MenuResult <> OldMenuResult) then
            AnimateFlyOut = 1
        elseif (MenuResult = 3) and (AnimateFlyOut = 0) then
            SaveSettings ()
            LoadGameMenu (7)
            MenuResult = 0

        ' Spiel-Modus ndern
        elseif (MenuResult = 4) and (MenuResult <> OldMenuResult) then
            AnimateFlyOut = 1
        elseif (MenuResult = 4) and (AnimateFlyOut = 0) then
            LoadGameMenu (8)
            MenuResult = 0

        ' Speichern
        elseif (MenuResult = 5) and (MenuResult <> OldMenuResult) then
            AnimateFlyOut = 1
        elseif (MenuResult = 5) and (AnimateFlyOut = 0) then
            SaveSettings ()
            LoadGameMenu (1)
            MenuResult = 0

        ' Zurck
        elseif (MenuResult = 6) and (MenuResult <> OldMenuResult) then
            AnimateFlyOut = 1
        elseif (MenuResult = 6) and (AnimateFlyOut = 0) then
            LoadSettings ()
            LoadGameMenu (1)
            MenuResult = 0
        end if

    ' *************************************************************************
    ' Credits
    elseif (CurrentMenuID = 3) then

        ' Men anzeigen
        ShowGameMenu (MenuResult)
        PrintFont(155, 185, "GallowMan wurde programmiert von jb (jbsoft)", Farbe)
        PrintFont(155, 205, "im Rahmen des offiziellen deutschen QuickBASIC", Farbe)
        PrintFont(155, 225, "und freeBASIC Programmierwettbewerbs.", Farbe)
        PrintFont(155, 255, "GallowMan ist Freeware und darf unter Beachtung", Farbe)
        PrintFont(155, 275, "der in der Readme angegebenen Bestimmungen", Farbe)
        PrintFont(155, 295, "beliebig weitergegeben werden.", Farbe)
        PrintFont(155, 325, "Mehr Informationen zum Spiel finden Sie unter", Farbe)
        PrintFont(155, 345, "www.jb-electronics.de", Farbe)

        ' OK
        if (MenuResult = 1) and (MenuResult <> OldMenuResult) then
            AnimateFlyOut = 1
        elseif (MenuResult = 1) and (AnimateFlyOut = 0) then
            LoadGameMenu (1)
            MenuResult = 0
        end if

    ' *************************************************************************
    ' Beenden
    elseif (CurrentMenuID = 4) then

        ' Men anzeigen
        ShowGameMenu (MenuResult)
        PrintFont(220, 200, "GallowMan wirklich beenden?", Farbe)

        ' Ja
        if MenuResult = 1 then
            sleep 350
            exit do

        ' Nein
        elseif (MenuResult = 2) and (MenuResult <> OldMenuResult) then
            AnimateFlyOut = 1
        elseif (MenuResult = 2) and (AnimateFlyOut = 0) then
            LoadGameMenu (1)
            MenuResult = 0
        end if

    ' *************************************************************************
    ' Das Spiel
    elseif (CurrentMenuID = 5) then

        ' Die Spieloberflche
        ShowAnimatedMenu (GameMenu1)
        ShowAnimatedMenu (GameMenu2)
        ShowEingabeMaske ()
        ShowGameMenu (MenuResult)

        ' Joker gesperrt?
        if MenuButtons(2).Disabled then
            put(MenuButtons(2).PositionX, MenuButtons(2).PositionY), MenuButtonInActive, alpha, Transparency
        end if
        if MenuButtons(3).Disabled then
            put(MenuButtons(3).PositionX, MenuButtons(3).PositionY), MenuButtonInActive, alpha, Transparency
        end if

        ' das Galgenmnnchen zeichnen
        if SpielInfo.StatusIndex then
            put(380, 175), StatusBilder(SpielInfo.StatusIndex), alpha, Transparency
        end if

        ' Punktestand angeben
        MenuButtons(4).Caption = GetScoreString()

        ' Spiel auf Zeit?
        if Settings.SpielModus > 2 then
            if (ZeitTMP <> time$) and (AnimateFlyIn = 0) and (AnimateFlyOut = 0) and ((SpielInfo.WortErraten or SpielInfo.Fertig or SpielInfo.ZeitIstUm) = 0) then
                Zeit- = 1
                ZeitTMP = time$
            end if
            ' Zeit abgelaufen?
            if Zeit = 0 then SpielInfo.ZeitIstUm = 1
            ' verbleibende Zeit anzeigen?
            MenuButtons(5).Caption = CalculateTime(Zeit)
        end if

        ' Den Cursor blinken lassen
        CursorIndex+ = 1
        if CursorIndex > 20 then CursorIndex = 0
        if CursorIndex < 11 then Cursor = "|" else Cursor = ""

        ' das bereits gefundene Wort zusammensetzen
        with SpielInfo
            .GefundenesWort = ""
            for Index = 1 to len(.GesuchtesWort) step 1
                if instr(lcase$(.Buchstaben), lcase$(mid$(.GesuchtesWort, Index, 1))) then
                    .GefundenesWort+ = mid$(.GesuchtesWort, Index, 1)
                elseif mid$(.GesuchtesWort, Index, 1) = chr$(32) then
                    .GefundenesWort+ = " "
                else
                    .GefundenesWort+ = "_"
                end if
            next Index
        end with

        ' Gefundenes Wort anzeigen
        put(30, 100), Display, alpha, FarbWert
        SetFont("Comic_Bold")
            CenterPrint(30, 610, 80, 160, SpielInfo.GefundenesWort, Farbe)
            PrintFont(110, 180, "Buchstaben:", Farbe)
        SetFont("Comic")

        ' Hat der Spieler gewonnen?
        if IstFertig(SpielInfo.GefundenesWort) then
            if (SpielInfo.WortErraten < 2) then SpielInfo.WortErraten+ = 1
            if (SpielInfo.WortErraten = 1) then
                AnimateDialogFlyIn = 1
                SpielInfo.SpielerScore+ = CalculateScore()
            end if
        end if

        ' Ist das Spiel zu Ende?
        if SpielInfo.StatusIndex >= 11 then
            if (SpielInfo.Fertig < 2) then SpielInfo.Fertig+ = 1
            if (SpielInfo.Fertig = 1) then
                AnimateDialogFlyIn = 1
                Taste = ""
            end if
        end if

        ' Die Dialog-Buttons animieren
        if (AnimateDialogFlyOut = 1) then
            AnimateDialogStatus = 0
            for Index = 1 to ubound(DialogButtons) step 1
                with DialogButtons(Index)
                    if .PositionX <> .OriginX then .PositionX+ = .SpeedX
                    if .PositionY <> .OriginY then .PositionY+ = .SpeedY
                    if .Transparency > 0 then .Transparency- = 15
                    if (.PositionX = .OriginX) and (.PositionY = .OriginY) then
                        AnimateDialogStatus+ = 1
                    end if
                end with
            next Index
            if AnimateDialogStatus = ubound(DialogButtons) then AnimateDialogFlyOut = 0
        end if

        ' Der Wort-Erraten-Dialog (im Just-For-Fun oder DeathMatch-Spielmodus)
        if (SpielInfo.WortErraten > 0) and (Settings.SpielModus < 3) then
            ' Dialog anzeigen
            DialogButtons(1).Caption = "Ist ja schon gut..."
            if (AnimateDialogFlyOut = 1) or (AnimateFlyOut = 1) then
                if GameMenu3.Transparency > 10 then GameMenu3.Transparency- = 4
            else
                if GameMenu3.Transparency < 160 then GameMenu3.Transparency+ = 10
            end if
            DialogFarbe = rgb(GameMenu3.Transparency / 2 + 170, GameMenu3.Transparency / 2 + 170, GameMenu3.Transparency / 2 + 170)
            ShowAnimatedMenu (GameMenu3)
            DialogOldMenuResult = DialogMenuResult
            ShowDialogButtons (DialogMenuResult)
            if GameMenu3.Transparency > 40 then
                SetFont("Comic_Bold")
                    PrintFont(205, 120, "Klasse Leistung!", DialogFarbe)
                SetFont("Comic")
                PrintFont(120, 180, "Sie haben das gesuchte Wort erraten und so Ihrem", DialogFarbe)
                PrintFont(120, 200, "(uerst dankbaren) Galgenmnnchen das Leben gerettet!", DialogFarbe)
                PrintFont(120, 220, "Aber dabei wollen Sie es doch nicht belassen, oder?!", DialogFarbe)
                PrintFont(120, 240, "Weiter geht's!", DialogFarbe)
            end if
            ' Weiter geht's
            if (DialogMenuResult = 1) and (DialogMenuResult <> DialogOldMenuResult) then
                AnimateDialogFlyOut = 1
            elseif (DialogMenuResult = 1) and (AnimateDialogFlyOut = 0) then
                ResetGameData (0)
                DialogMenuResult = 0
                DialogOldMenuResult = 0
            end if

        ' Der Wort-Erraten-Dialog (im Spiel-Auf-Zeit-Modus)
        elseif (SpielInfo.WortErraten > 0) and (Settings.SpielModus > 2) then
            ' Dialog anzeigen
            DialogButtons(1).Caption = "OK..."
            if (AnimateDialogFlyOut = 1) or (AnimateFlyOut = 1) then
                if GameMenu3.Transparency > 10 then GameMenu3.Transparency- = 4
            else
                if GameMenu3.Transparency < 160 then GameMenu3.Transparency+ = 10
            end if
            DialogFarbe = rgb(GameMenu3.Transparency / 2 + 170, GameMenu3.Transparency / 2 + 170, GameMenu3.Transparency / 2 + 170)
            ShowAnimatedMenu (GameMenu3)
            DialogOldMenuResult = DialogMenuResult
            ShowDialogButtons (DialogMenuResult)
            if GameMenu3.Transparency > 40 then
                SetFont("Comic_Bold")
                    PrintFont(205, 120, "Saubere Arbeit!", DialogFarbe)
                SetFont("Comic")
                PrintFont(120, 180, "Sie haben das gesuchte Wort erraten und so Ihrem", DialogFarbe)
                PrintFont(120, 200, "(uerst dankbaren) Galgenmnnchen das Leben gerettet!", DialogFarbe)
                PrintFont(120, 220, "Aber die Zeit ist ja noch nicht um. Was fr ein Jammer!", DialogFarbe)
                PrintFont(120, 240, "Also auf geht's!", DialogFarbe)
            end if
            ' Weiter geht's
            if (DialogMenuResult = 1) and (DialogMenuResult <> DialogOldMenuResult) then
                AnimateDialogFlyOut = 1
            elseif (DialogMenuResult = 1) and (AnimateDialogFlyOut = 0) then
                ResetGameData (0)
                SpielInfo.StatusIndex = 0
                DialogMenuResult = 0
                DialogOldMenuResult = 0
            end if

        ' Der Zeit-Ist-Um-Dialog
        elseif SpielInfo.ZeitIstUm then
            ' das Galgenmnnchen geht den Gang alles Irdischen
            if SpielInfo.StatusIndex < 11 then SpielInfo.StatusIndex+ = 1
            ' Dialog anzeigen
            if (AnimateDialogFlyOut = 1) or (AnimateFlyOut = 1) then
                if GameMenu3.Transparency > 10 then GameMenu3.Transparency- = 4
            else
                if GameMenu3.Transparency < 160 then GameMenu3.Transparency+ = 10
            end if
            DialogFarbe = rgb(GameMenu3.Transparency / 2 + 170, GameMenu3.Transparency / 2 + 170, GameMenu3.Transparency / 2 + 170)
            ShowAnimatedMenu (GameMenu3)
            DialogOldMenuResult = DialogMenuResult
            ShowDialogButtons (DialogMenuResult)
            if GameMenu3.Transparency > 40 then
                SetFont("Comic_Bold")
                    PrintFont(205, 120, "Die Zeit ist um!", DialogFarbe)
                SetFont("Comic")
                PrintFont(120, 170, "Die Lebenszeit Ihres Galgenmnnchens ist soeben abgelaufen.", DialogFarbe)
                PrintFont(120, 190, "Aber auch die schnste Serie geht halt mal zu Ende...", DialogFarbe)
                if IsHighScoreEintrag(SpielInfo.SpielerScore, Settings.SpielModus) then
                    PrintFont(120, 210, "Aber Sie haben es mit " & trim$(str$(SpielInfo.SpielerScore)) & " Punkten in den Highscore geschafft!", DialogFarbe)
                    PrintFont(120, 230, "Ihr Name: " & Eingabe(SpielInfo.SpielerName, 190, "Comic_Bold") & Cursor, DialogFarbe)
                    DialogButtons(1).Caption = "Nicht schlecht!"
                    DialogButtons(1).Disabled = 1 - OK
                    if len(trim$(SpielInfo.SpielerName)) > 0 then
                        OK = 1
                    else
                        OK = 0
                    end if
                    if (OK = 1) and (Taste = chr$(13)) then DialogMenuResult = 1
                    ' Zum Highscore
                    if (OK = 1) and (DialogMenuResult = 1) and (DialogMenuResult <> DialogOldMenuResult) then
                        SchreibeInHighScore(SpielInfo.SpielerName, SpielInfo.SpielerScore, Settings.SpielModus)
                        PlaySound(exepath + "\data\snd\active.wav", "active", Settings.SoundEffects)
                        AnimateDialogFlyOut = 1
                        AnimateTMP = 1
                    elseif (OK = 1) and (DialogMenuResult = 1) and (AnimateDialogFlyOut = 0) and (AnimateTMP = 1) then
                        AnimateFlyOut = 1
                        AnimateTMP = 0
                    elseif (OK = 1) and (DialogMenuResult = 1) and (AnimateDialogFlyOut = 0) and (AnimateFlyOut = 0) then
                        ResetGameData ()
                        LoadGameMenu (9)
                        DialogMenuResult = 0
                        MenuResult = 0
                    end if
                else
                    DialogButtons(1).Caption = "Aber sicher doch"
                    PrintFont(120, 210, "Leider haben Sie es nicht in den Highscore geschafft...", DialogFarbe)
                    PrintFont(120, 230, "Aber halb so wild: Es warten noch viele andere frische", DialogFarbe)
                    PrintFont(120, 250, "Galgenmnnchen auf Sie! Kopf hoch!", DialogFarbe)
                    DialogButtons(1).Caption = "Hmm..."
                    ' Zurck zum Hauptmen
                    if (DialogMenuResult = 1) and (DialogMenuResult <> DialogOldMenuResult) then
                        AnimateDialogFlyOut = 1
                        AnimateTMP = 1
                    elseif (DialogMenuResult = 1) and (AnimateDialogFlyOut = 0) and (AnimateTMP = 1) then
                        AnimateFlyOut = 1
                        AnimateTMP = 0
                    elseif (DialogMenuResult = 1) and (AnimateDialogFlyOut = 0) and (AnimateFlyOut = 0) then
                        ResetGameData ()
                        LoadGameMenu (1)
                        DialogMenuResult = 0
                        MenuResult = 0
                    end if
                end if
            end if

        ' Der Verloren-Dialog (im Just-For-Fun-Modus)
        elseif (SpielInfo.Fertig > 0) and (Settings.SpielModus = 1) then
            ' Dialog anzeigen
            DialogButtons(1).Caption = "Jaja..."
            if (AnimateDialogFlyOut = 1) or (AnimateFlyOut = 1) then
                if GameMenu3.Transparency > 10 then GameMenu3.Transparency- = 4
            else
                if GameMenu3.Transparency < 160 then GameMenu3.Transparency+ = 10
            end if
            DialogFarbe = rgb(GameMenu3.Transparency / 2 + 170, GameMenu3.Transparency / 2 + 170, GameMenu3.Transparency / 2 + 170)
            ShowAnimatedMenu (GameMenu3)
            DialogOldMenuResult = DialogMenuResult
            ShowDialogButtons (DialogMenuResult)
            if GameMenu3.Transparency > 40 then
                SetFont("Comic_Bold")
                    PrintFont(230, 120, "Pech gehabt!", DialogFarbe)
                SetFont("Comic")
                PrintFont(120, 180, "Sie haben das gesuchte Wort nicht erraten knnen und deshalb", DialogFarbe)
                PrintFont(120, 200, "hat Ihr Galgenmnnchen den Lffel abgegeben.", DialogFarbe)
                PrintFont(120, 220, "brigens, das Wort lautete: " & SpielInfo.GesuchtesWort, DialogFarbe)
                PrintFont(120, 240, "Da brauchen Sie wohl noch etwas bung...", DialogFarbe)
            end if
            ' Weiter geht's
            if (DialogMenuResult = 1) and (DialogMenuResult <> DialogOldMenuResult) then
                AnimateDialogFlyOut = 1
            elseif (DialogMenuResult = 1) and (AnimateDialogFlyOut = 0) then
                ResetGameData ()
                LoadGameMenu (1)
                DialogMenuResult = 0
                DialogOldMenuResult = 0
                MenuResult = 0
            end if

        ' Der Verloren-Dialog (im DeathMatch-Spielmodus)
        elseif (SpielInfo.Fertig > 0) and (Settings.SpielModus = 2) then
            ' Dialog anzeigen
            if (AnimateDialogFlyOut = 1) or (AnimateFlyOut = 1) then
                if GameMenu3.Transparency > 10 then GameMenu3.Transparency- = 4
            else
                if GameMenu3.Transparency < 160 then GameMenu3.Transparency+ = 10
            end if
            DialogFarbe = rgb(GameMenu3.Transparency / 2 + 170, GameMenu3.Transparency / 2 + 170, GameMenu3.Transparency / 2 + 170)
            ShowAnimatedMenu (GameMenu3)
            DialogOldMenuResult = DialogMenuResult
            ShowDialogButtons (DialogMenuResult)
            if GameMenu3.Transparency > 40 then
                SetFont("Comic_Bold")
                    PrintFont(275, 120, "Tja...", Farbe)
                SetFont("Comic")
                PrintFont(120, 170, "Und wieder gibt es ein Galgenmnnchen weniger...", DialogFarbe)
                PrintFont(120, 190, "brigens, das Wort lautete: " & SpielInfo.GesuchtesWort, DialogFarbe)
                if IsHighScoreEintrag(SpielInfo.SpielerScore, Settings.SpielModus) then
                    PrintFont(120, 210, "Sie haben es mit " & trim$(str$(SpielInfo.SpielerScore)) & " Punkten sogar in den Highscore geschafft!", DialogFarbe)
                    PrintFont(120, 230, "Ihr Name: " & Eingabe(SpielInfo.SpielerName, 190, "Comic_Bold") & Cursor, DialogFarbe)
                    DialogButtons(1).Caption = "Nicht schlecht!"
                    DialogButtons(1).Disabled = 1 - OK
                    if len(trim$(SpielInfo.SpielerName)) > 0 then
                        OK = 1
                    else
                        OK = 0
                    end if
                    if (OK = 1) and (Taste = chr$(13)) then DialogMenuResult = 1
                    ' Zurck zum Hauptmen
                    if (OK = 1) and (DialogMenuResult = 1) and (DialogMenuResult <> DialogOldMenuResult) then
                        PlaySound(exepath + "\data\snd\active.wav", "active", Settings.SoundEffects)
                        SchreibeInHighScore(SpielInfo.SpielerName, SpielInfo.SpielerScore, Settings.SpielModus)
                        AnimateDialogFlyOut = 1
                        AnimateTMP = 1
                    elseif (OK = 1) and (DialogMenuResult = 1) and (AnimateDialogFlyOut = 0) and (AnimateTMP = 1) then
                        AnimateFlyOut = 1
                        AnimateTMP = 0
                    elseif (OK = 1) and (DialogMenuResult = 1) and (AnimateDialogFlyOut = 0) and (AnimateFlyOut = 0) then
                        ResetGameData ()
                        LoadGameMenu (9)
                        DialogMenuResult = 0
                        MenuResult = 0
                    end if
                else
                    PrintFont(120, 210, "Leider haben Sie es nicht in den Highscore geschafft...", DialogFarbe)
                    PrintFont(120, 230, "Aber halb so wild: Es warten noch viele andere frische", DialogFarbe)
                    PrintFont(120, 250, "Galgenmnnchen auf Sie! Kopf hoch!", DialogFarbe)
                    DialogButtons(1).Caption = "Hmm..."
                    ' Zurck zum Hauptmen
                    if (DialogMenuResult = 1) and (DialogMenuResult <> DialogOldMenuResult) then
                        AnimateDialogFlyOut = 1
                        AnimateTMP = 1
                    elseif (DialogMenuResult = 1) and (AnimateDialogFlyOut = 0) and (AnimateTMP = 1) then
                        AnimateFlyOut = 1
                        AnimateTMP = 0
                    elseif (DialogMenuResult = 1) and (AnimateDialogFlyOut = 0) and (AnimateFlyOut = 0) then
                        ResetGameData ()
                        LoadGameMenu (1)
                        DialogMenuResult = 0
                        MenuResult = 0
                    end if
                end if
            end if

        ' Der Verloren-Dialog (im Spiel-Auf-Zeit-Modus)
        elseif (SpielInfo.Fertig > 0) and (Settings.SpielModus > 2) then
            ' Dialog anzeigen
            DialogButtons(1).Caption = "Jaja..."
            if (AnimateDialogFlyOut = 1) or (AnimateFlyOut = 1) then
                if GameMenu3.Transparency > 10 then GameMenu3.Transparency- = 4
            else
                if GameMenu3.Transparency < 160 then GameMenu3.Transparency+ = 10
            end if
            DialogFarbe = rgb(GameMenu3.Transparency / 2 + 170, GameMenu3.Transparency / 2 + 170, GameMenu3.Transparency / 2 + 170)
            ShowAnimatedMenu (GameMenu3)
            DialogOldMenuResult = DialogMenuResult
            ShowDialogButtons (DialogMenuResult)
            if GameMenu3.Transparency > 40 then
                SetFont("Comic_Bold")
                    PrintFont(265, 120, "Hmm...", DialogFarbe)
                SetFont("Comic")
                PrintFont(120, 180, "Sie haben das gesuchte Wort nicht erraten knnen und das hat", DialogFarbe)
                PrintFont(120, 200, "das Schicksal Ihres Galgenmnnchens besiegelt.", DialogFarbe)
                PrintFont(120, 220, "brigens, das Wort lautete: " & SpielInfo.GesuchtesWort, DialogFarbe)
                PrintFont(120, 240, "Aber es ist ja noch Zeit brig. Also auf in die Schlacht!", DialogFarbe)
            end if
            ' Weiter geht's
            if (DialogMenuResult = 1) and (DialogMenuResult <> DialogOldMenuResult) then
                AnimateDialogFlyOut = 1
            elseif (DialogMenuResult = 1) and (AnimateDialogFlyOut = 0) then
                ResetGameData (0)
                SpielInfo.Fertig = 0
                SpielInfo.StatusIndex = 0
                ZeitTMP = time$
                DialogMenuResult = 0
                DialogOldMenuResult = 0
                MenuResult = 0
            end if

        end if

        ' Zurck?
        if (MenuResult = 1) and (MenuResult <> OldMenuResult) then
            AnimateFlyOut = 1
        elseif (MenuResult = 1) and (AnimateFlyOut = 0) then
            LoadGameMenu (1)
            MenuResult = 0

        ' Buchstaben-Joker
        elseif (MenuResult = 2) and (MenuResult <> OldMenuResult) then
            redim Joker(0)
            with SpielInfo
                for Index = 1 to len(.GesuchtesWort) step 1
                    Zeichen = lcase$(mid$(.GesuchtesWort, Index, 1))
                    if instr(lcase$(.Buchstaben), Zeichen) = 0 then
                        redim preserve Joker(ubound(Joker) + 1)
                        Joker(ubound(Joker)) = Zeichen
                    end if
                next Index
                Zeichen = Joker(int(rnd * ubound(Joker)) + 1)
                for Index = 1 to ubound(EingabeButtons) step 1
                    if lcase$(EingabeButtons(Index).Caption) = lcase$(Zeichen) then
                        EingabeButtons(Index).Active = 0
                        MenuButtons(2).Disabled = 1
                        .Buchstaben+ = lcase$(EingabeButtons(Index).Caption)
                        exit for
                    end if
                next Index
            end with

        ' Ausschluss-Joker
        elseif (MenuResult = 3) and (MenuResult <> OldMenuResult) then
            redim Joker(0)
            with SpielInfo
                for Index = 1 to len(.FalscheBuchstaben) step 1
                    Zeichen = lcase$(mid$(.FalscheBuchstaben, Index, 1))
                    if instr(lcase$(.Buchstaben), Zeichen) = 0 then
                        redim preserve Joker(ubound(Joker) + 1)
                        Joker(ubound(Joker)) = Zeichen
                    end if
                next Index
                Zeichen = Joker(int(rnd * ubound(Joker)) + 1)
                for Index = 1 to ubound(EingabeButtons) step 1
                    if lcase$(EingabeButtons(Index).Caption) = lcase$(Zeichen) then
                        EingabeButtons(Index).Active = 0
                        MenuButtons(3).Disabled = 1
                        exit for
                    end if
                next Index
            end with

        end if

    ' *************************************************************************
    ' Soundmen
    elseif (CurrentMenuID = 6) then

        ' Men anzeigen
        ShowGameMenu (MenuResult)
        PrintFont(155, 170, "Hier knnen Sie die Hintergrundmusik auswhlen,", Farbe)
        PrintFont(155, 190, "ein- und ausschalten, und /oder die Soundeffekte", Farbe)
        PrintFont(155, 210, "des Spiels an- und ausstellen.", Farbe)

        ' Titel der Buttons anpassen
        if Settings.BGMusic then
            MenuButtons(1).Caption = "Musik: AN"
        elseif Settings.BGMusic = 0 then
            MenuButtons(1).Caption = "Musik: AUS"
        end if
        if Settings.SoundEffects then
            MenuButtons(2).Caption = "Effekte: AN"
        elseif Settings.SoundEffects = 0 then
            MenuButtons(2).Caption = "Effekte: AUS"
        end if

        ' Hintergrundmusik an/aus
        if (MenuResult = 1) and (MenuResult <> OldMenuResult) then
            Settings.BGMusic = 1 - Settings.BGMusic
            if Settings.BGMusic = 0 then
                StopSound("bgmusic")
            elseif (Settings.BGMusic = 1) and (GetCurrentPosition("bgmusic") = 0) then
                PlaySound(Settings.HintergrundMusik, "bgmusic", Settings.BGMusic, "repeat")
            end if
            MenuResult = 0

        ' Soundeffekte ein/aus
        elseif (MenuResult = 2) and (MenuResult <> OldMenuResult) then
            Settings.SoundEffects = 1 - Settings.SoundEffects
            MenuResult = 0

        ' Musikdatei auswhlen
        elseif (MenuResult = 3) and (MenuResult <> OldMenuResult) then
            NeueHintergrundMusik = SearchFile("Hintergrundmusik whlen", exepath + "\data\snd", "Alle Dateien" + chr$(0) + "*.*" + chr$(0))
            Settings.HintergrundMusik = NeueHintergrundMusik
            MenuResult = 0

        ' OK
        elseif (MenuResult = 4) and (MenuResult <> OldMenuResult) then
            AnimateFlyOut = 1
        elseif (MenuResult = 4) and (AnimateFlyOut = 0) then
            LoadGameMenu (2)
            MenuResult = 0
        end if

    ' *************************************************************************
    ' Begriffe ndern
    elseif (CurrentMenuID = 7) then

        ' Men anzeigen
        ShowGameMenu (MenuResult)
        PrintFont(170, 170, "Hier knnen Sie die Datei festlegen, in der die", Farbe)
        PrintFont(170, 190, "Begriffe fr das Spiel zu suchen sind.", Farbe)
        PrintFont(170, 210, "Sollten mehrere Wort-Gruppen in dieser Datei", Farbe)
        PrintFont(170, 230, "enthalten sein, knnen Sie sie hier auswhlen.", Farbe)
        PrintFont(170, 300, "Ausgewhlte Datei: " & TextDatei, Farbe)
        PrintFont(170, 333, "Ausgewhlte Gruppe:", Farbe)
        if GruppenIndex <= ubound(Gruppen) then
            MenuButtons(2).Caption = Gruppen(GruppenIndex)
        elseif GruppenIndex = ubound(Gruppen) + 1 then
            MenuButtons(2).Caption = "Alle Gruppen"
        elseif GruppenIndex = ubound(Gruppen) + 2 then
            MenuButtons(2).Caption = "Zufllige Auswahl"
        end if

        ' Gruppentitel/besondere Funktion anzeigen
        if (GruppenIndex > 0) and (GruppenIndex <= ubound(Gruppen))then
            Settings.Gruppe = Gruppen(GruppenIndex)
        elseif (GruppenIndex = ubound(Gruppen) + 1) then
            Settings.Gruppe = "[special]Alle Gruppen"
        elseif (GruppenIndex = ubound(Gruppen) + 2) then
            Settings.Gruppe = "[special]Zufllige Auswahl"
        end if

        if (MenuResult = 1) and (MenuResult <> OldMenuResult) then
            NeueTextDatei = SearchFile("Begriffsdatei whlen", exepath + "\Begriffe", "Alle Dateien" + chr$(0) + "*.*" + chr$(0))
            if len(trim$(NeueTextDatei)) then
                Settings.TextDatei = NeueTextDatei
                TextDatei = GetFileName(NeueTextDatei)
                LadeBegriffe (Settings.TextDatei)
                if GruppenIndex = 0 then
                    MenuButtons(2).Disabled = 1
                else
                    MenuButtons(2).Disabled = 0
                end if
            end if
            MenuResult = 0

        elseif (MenuResult = 2) and (MenuResult <> OldMenuResult) then
            GruppenIndex+ = 1
            if GruppenIndex > ubound(Gruppen) + 2 then GruppenIndex = 1
            MenuResult = 0

        elseif (MenuResult = 3) and (MenuResult <> OldMenuResult) then
            AnimateFlyOut = 1
        elseif (MenuResult = 3) and (AnimateFlyOut = 0) then
            LoadGameMenu (2)
            MenuResult = 0
        end if

    ' *************************************************************************
    ' Spiel-Modus ndern
    elseif (CurrentMenuID = 8) then

        ShowGameMenu (MenuResult)
        PrintFont(185, 195, "Hier knnen Sie den Spiel-Modus bestimmen:", Farbe)
        PrintFont(185, 215, "- Just For Fun: Entspannte Schnupperrunde", Farbe)
        PrintFont(185, 235, "- DeathMatch: Bis zum bitteren Ende", Farbe)
        PrintFont(185, 255, "- Jede Sekunde zhlt: auf Zeit", Farbe)

        ' Titel des Buttons anpassen
        if Settings.SpielModus = 1 then
            MenuButtons(1).Caption = "Just For Fun"
        elseif Settings.SpielModus = 2 then
            MenuButtons(1).Caption = "DeathMatch"
        elseif Settings.SpielModus = 3 then
            MenuButtons(1).Caption = "Auf Zeit (00:30)"
        elseif Settings.SpielModus = 4 then
            MenuButtons(1).Caption = "Auf Zeit (01:30)"
        elseif Settings.SpielModus = 5 then
            MenuButtons(1).Caption = "Auf Zeit (03:00)"
        end if

        ' Modus ndern
        if (MenuResult = 1) and (MenuResult <> OldMenuResult) then
            Settings.SpielModus+ = 1
            if Settings.SpielModus > 5 then Settings.SpielModus = 1
            if Settings.SpielModus = 1 then
                Settings.Zeit = 0
            elseif Settings.SpielModus = 3 then
                Settings.Zeit = 30
            elseif Settings.SpielModus = 4 then
                Settings.Zeit = 90
            elseif Settings.SpielModus = 5 then
                Settings.Zeit = 180
            end if
            MenuResult = 0

        ' Zurck?
        elseif (MenuResult = 2) and (MenuResult <> OldMenuResult) then
            AnimateFlyOut = 1
        elseif (MenuResult = 2) and (AnimateFlyOut = 0) then
            LoadGameMenu (2)
            MenuResult = 0
        end if

    ' *************************************************************************
    ' Highscore
    elseif (CurrentMenuID = 9) then

        ' Highscore anzeigen
        ShowGameMenu(MenuResult)
        SetFont("Comic_Bold")
            if Settings.SpielModus = 2 then
                CurrentMenuTitle = "Highscore: DeathMatch"
            elseif Settings.SpielModus = 3 then
                CurrentMenuTitle = "Highscore: Spiel auf Zeit (0:30)"
            elseif Settings.SpielModus = 4 then
                CurrentMenuTitle = "Highscore: Spiel auf Zeit (1:30)"
            elseif Settings.SpielModus = 5 then
                CurrentMenuTitle = "Highscore: Spiel auf Zeit (3:00)"
            end if
            for Index = 1 to 5 step 1
                PrintFont(100, 110 + MaxFontYWidth * Index, trim$(str$(Index)) & ".", Farbe + ((Index <> 1) * &h282828))
                PrintFont(160, 110 + MaxFontYWidth * Index, HighScoreData(Settings.SpielModus, Index).SpielerName, Farbe + ((Index <> 1) * &h282828))
                PrintFont(395, 110 + MaxFontYWidth * Index, trim$(str$(HighScoreData(Settings.SpielModus, Index).SpielerScore)) & " Punkte", Farbe + ((Index <> 1) * &h282828))
            next Index
        SetFont("Comic")

        ' Zurck
        if (MenuResult = 1) and (MenuResult <> OldMenuResult) then
            AnimateFlyOut = 1
        elseif (MenuResult = 1) and (AnimateFlyOut = 0) then
            LoadGameMenu (1)
            MenuResult = 0
        end if

    ' *************************************************************************
    ' Grafik-Optionen
    elseif (CurrentMenuID = 10) then

        ' Men anzeigen
        ShowGameMenu (MenuResult)
        PrintFont(170, 185, "Hier knnen Sie einstellen, ob GallowMan im", Farbe)
        PrintFont(170, 205, "Vollbild- oder Fenstermodus gestartet wird:", Farbe)
        PrintFont(170, 280, "Ebenso einstellbar ist die Grafikgeschwindigkeit:", Farbe)

        ' Titel der Buttons anpassen
        if Settings.Vollbild then
            MenuButtons(1).Caption = "Vollbildmodus"
        else
            MenuButtons(1).Caption = "Fenstermodus"
        end if
        MenuButtons(2).Caption = "Geschwindigkeit: " & trim$(str$(Settings.Pause))

        ' Volbild/kein Vollbild
        if (MenuResult = 1) and (MenuResult <> OldMenuResult) then
            Settings.Vollbild = 1 - Settings.Vollbild
            MenuResult = 0

        ' Geschwindigkeit
        elseif (MenuResult = 2) and (MenuResult <> OldMenuResult) then
            Settings.Pause+ = 1
            if Settings.Pause > 30 then Settings.Pause = 1
            MenuResult = 0     

        ' OK
        elseif (MenuResult = 3) and (MenuResult <> OldMenuResult) then
            AnimateFlyOut = 1
        elseif (MenuResult = 3) and (AnimateFlyOut = 0) then
            LoadGameMenu (2)
            MenuResult = 0
        end if

    end if

    ' eine kleine Pause
    sleep Settings.Pause

    ' Doublebuffering
    screencopy
    cls

loop

' Speicherplatz wieder freigeben
imagedestroy BackGround
imagedestroy Title
imagedestroy Button
imagedestroy ButtonInActive
imagedestroy MenuButton
imagedestroy MenuButtonInActive
imagedestroy Display
for Index = 1 to 11 step 1
    imagedestroy StatusBilder(Index)
next Index
end

' *****************************************************************************
' Die SUBs:

' *****************************************************************************
' Diese SUB gibt einen zentrierten Text im aktuell geladenen Font aus
sub CenterPrint (xmin as integer, xmax as integer, ymin as integer, ymax as integer, Text as string, Farbe as long = rgb(255, 255, 255), BGFarbe as long = rgb(255, 0, 255))

    ' Variablen
    dim as integer DistanceX, CenterX
    dim as integer DistanceY, CenterY

    ' Zentrieren
    DistanceX = xmax - xmin
    CenterX = (DistanceX - GetTextLength(Text)) / 2
    DistanceY = ymax - ymin
    CenterY = (DistanceY - FontData(CurrentFont).MaxFontWidthY) / 2

    ' Text ausgeben
    PrintFont (xmin + CenterX, ymin + CenterY, Text, Farbe, BGFarbe)

end sub


' *****************************************************************************
' Diese SUB zeichnet ein gerundetes Rechteck
sub DrawBox (PositionX1 as integer, PositionY1 as integer, PositionX2 as integer, PositionY2 as integer, Radius as integer, Farbe as long, BGFarbe as long, Transparency as integer)

    ' Puffer erstellen
    dim as integer WidthX, WidthY
    dim as any ptr ImageBuffer
    WidthX = PositionX2 - PositionX1
    WidthY = PositionY2 - PositionY1
    ImageBuffer = imagecreate(WidthX + 1, WidthY + 1)

    ' Box zeichnen
    if BGFarbe = &hff00ff then
        circle ImageBuffer, (Radius, WidthY - Radius), Radius, Farbe, pi / 2, pi
        circle ImageBuffer, (Radius, Radius), Radius, Farbe, 0, pi / 2
        circle ImageBuffer, (Radius, WidthY - Radius), Radius, Farbe, pi / 2 + pi
        circle ImageBuffer, (Radius, WidthY - Radius), Radius, Farbe, pi, pi + pi / 2
        line ImageBuffer, (PositionX1 + Radius, PositionY1)-(PositionX2 - Radius, PositionY1), Farbe
        line ImageBuffer, (PositionX1, PositionY1 + Radius)-(PositionX1, PositionY2 - Radius), Farbe
        line ImageBuffer, (PositionX1 + Radius, PositionY2)-(PositionX2 - Radius, PositionY2), Farbe
        line ImageBuffer, (PositionX2, PositionY2 - Radius)-(PositionX2, PositionY1 + Radius), Farbe
    else
        circle ImageBuffer, (Radius, Radius), Radius, Farbe, pi / 2, pi
        circle ImageBuffer, (WidthX - Radius, Radius), Radius, Farbe, 0, pi / 2
        circle ImageBuffer, (WidthX - Radius, WidthY - Radius), Radius, Farbe, pi / 2 + pi
        circle ImageBuffer, (Radius, WidthY - Radius), Radius, Farbe, pi, pi + pi / 2
        circle ImageBuffer, (Radius, Radius), Radius - 1, BGFarbe, , , , f
        circle ImageBuffer, (WidthX - Radius, Radius), Radius - 1, BGFarbe, , , , f
        circle ImageBuffer, (WidthX - Radius, WidthY - Radius), Radius - 1, BGFarbe, , , , f
        circle ImageBuffer, (Radius, WidthY - Radius), Radius - 1, BGFarbe, , , , f
        line ImageBuffer, (Radius, 0)-(WidthX - Radius, 0), Farbe
        line ImageBuffer, (0, Radius)-(0, WidthY - Radius), Farbe
        line ImageBuffer, (Radius, WidthY)-(WidthX - Radius, WidthY), Farbe
        line ImageBuffer, (WidthX, WidthY - Radius)-(WidthX, Radius), Farbe
        line ImageBuffer, (1, Radius)-(WidthX - 1, WidthY - Radius), BGFarbe, bf
        line ImageBuffer, (Radius, 1)-(WidthX - Radius, WidthY - 1), BGFarbe, bf
    end if

    ' anzeigen
    put(PositionX1, PositionY1), ImageBuffer, alpha, Transparency
    imagedestroy ImageBuffer

end sub

' *****************************************************************************
' Diese SUB ermittelt die Position der Maus etc.
sub GetMouseInfo ()

    ' Schreibarbeit sparen
    with Mouse

        ' Maus abfragen
        getmouse .PositionX, .PositionY, , .Tasten

        ' Maus entprellen
        .Tasten2 = .Tasten
        if (.Tasten2 <> .tmp) then
            .tmp = .Tasten2
            if .tmp and 1 then
                .Tasten2 = .Tasten2 and 1
            end if
        else
            .Tasten2 = 0
        end if

    end with

end sub

' *****************************************************************************
' Diese SUB ldt alle Begriffe aus einer Datei
sub LadeBegriffe (Datei as string)

    ' Variablen
    dim as integer f, Count, Index, Gefunden
    dim as string Zeile, Gruppe

    ' Feld resetten
    redim Gruppen(0)
    Gruppen(0) = "- nicht gefunden -"
    GruppenIndex = 0

    ' aktuellen Font setzen, um auf berschreitung der Maximallnge prfen zu knnen
    SetFont("Comic_Bold")

    ' Daten laden
    f = freefile
    open Datei for input as #f

        do until eof(f)

            ' Zeile einlesen
            line input #f, Zeile
            Zeile = trim$(Zeile)

            ' Leerzeilen gelten nicht
            if len(Zeile) then

                ' neue Gruppe?
                if (left$(Zeile, 1) = "[") and (right$(Zeile, 1) = "]") then
                    Gruppe = AdaptStringLength(mid$(Zeile, 2, len(Zeile) - 2), "Comic", 130)
                elseif len(trim$(Gruppe)) then
                    ' Ist der Begriff zu lang?
                    if GetTextLength(Zeile) < 550 then
                        if Gruppen(GruppenIndex) <> Gruppe then
                            GruppenIndex+ = 1
                            redim preserve Gruppen(GruppenIndex)
                            Gruppen(GruppenIndex) = Gruppe
                        end if
                        Count = ubound(Begriffe)
                        redim preserve Begriffe(Count + 1)
                        Begriffe(Count + 1).Gruppe = Gruppe
                        ' Enthlt der Begriff ungltige Zeichen?
                        for Index = 1 to len(Zeile)
                            Zeichen = mid$(Zeile, Index, 1)
                            if (Zeichen = "") or (Zeichen = "") then
                                Zeile = mid$(Zeile, 1, Index - 1) + "AE" + mid$(Zeile, Index + 1, len(Zeile) - Index)
                            elseif (Zeichen = "") or (Zeichen = "")  then
                                Zeile = mid$(Zeile, 1, Index - 1) + "OE" + mid$(Zeile, Index + 1, len(Zeile) - Index)
                            elseif (Zeichen = "") or (Zeichen = "") then
                                Zeile = mid$(Zeile, 1, Index - 1) + "UE" + mid$(Zeile, Index + 1, len(Zeile) - Index)
                            elseif Zeichen = "" then
                                Zeile = mid$(Zeile, 1, Index - 1) + "SS" + mid$(Zeile, Index + 1, len(Zeile) - Index)
                            end if
                        next Index
                        Zeile = ucase$(Zeile)
                        Begriffe(Count + 1).Begriff = Zeile
                    end if

                end if

            end if

        loop

    close #f

    ' Index setzen
    if ubound(Gruppen) then
        GruppenIndex = 1
    else
        GruppenIndex = 0
    end if

    ' Ausgewhlte Gruppe suchen
    if GruppenIndex then
        for GruppenIndex = 1 to ubound(Gruppen) step 1
            if lcase$(trim$(Settings.Gruppe)) = lcase$(trim$(Gruppen(GruppenIndex))) then
                exit for
            end if
        next GruppenIndex
    end if

    ' Standardgruppe nicht gesetzt?
    if (len(trim$(Settings.Gruppe)) = 0) and (GruppenIndex > 0) then
        Settings.Gruppe = Gruppen(1)
        GruppenIndex = 1
        SaveSettings ()
    end if

    ' Standardgruppe nicht in Datei enthalten?
    if ubound(Gruppen) then
        for Index = 1 to ubound(Gruppen) step 1
            if lcase$(trim$(Gruppen(Index))) = lcase$(trim$(Settings.Gruppe)) then
                Gefunden = 1
                exit for
            elseif lcase$(trim$(Settings.Gruppe)) = "[special]alle gruppen" then
                Gefunden = 1
                exit for
            elseif lcase$(trim$(Settings.Gruppe)) = "[special]zufllige auswahl" then
                Gefunden = 1
                exit for
            end if
        next Index
        if (Gefunden = 0) then
            Settings.Gruppe = Gruppen(1)
            GruppenIndex = 1
            SaveSettings ()
        end if
    end if

    ' aktuellen Font wieder resetten
    SetFont("Comic")

end sub

' *****************************************************************************
' Diese SUB ldt alle Begriffe zu einer bestimmten Gruppe in ein Feld
sub LadeBegriffeZurGruppe ()

    ' Variablen
    dim as integer Index, AllCount, Zufall, Begriff1, Begriff2, BegriffCount
    dim as string Gruppe

    ' Feld resetten
    redim BegriffeInDerGruppe(0)

    ' spezielle Gruppe ausgewhlt
    if (GruppenIndex > 0) and (GruppenIndex <= ubound(Gruppen)) then

        ' Begriffe zur aktuellen Gruppe suchen
        AllCount = ubound(Begriffe)
        BegriffCount = 0
        for Index = 1 to AllCount step 1
            with Begriffe(Index)
                if lcase$(.Gruppe) = lcase$(Gruppen(GruppenIndex)) then
                    BegriffCount+ = 1
                    redim preserve BegriffeInDerGruppe(BegriffCount)
                    BegriffeInDerGruppe(BegriffCount) = .Begriff
                end if
            end with
        next Index
        if BegriffCount = 0 then exit sub

    ' alle Gruppen?
    elseif (GruppenIndex = ubound(Gruppen) + 1) then

        ' Begriffe zur aktuellen Gruppe suchen
        AllCount = ubound(Begriffe)
        BegriffCount = 0
        for Index = 1 to AllCount step 1
            with Begriffe(Index)
                BegriffCount+ = 1
                redim preserve BegriffeInDerGruppe(BegriffCount)
                BegriffeInDerGruppe(BegriffCount) = .Begriff
            end with
        next Index
        if BegriffCount = 0 then exit sub

    ' zufllige Gruppe?
    elseif (GruppenIndex = ubound(Gruppen) + 2) then

        ' zufllige Gruppe ermitteln
        Zufall = int(rnd * ubound(Gruppen)) + 1

        ' Begriffe zur zufllig ausgewhlten Gruppe suchen
        AllCount = ubound(Begriffe)
        BegriffCount = 0
        for Index = 1 to AllCount step 1
            with Begriffe(Index)
                if lcase$(.Gruppe) = lcase$(Gruppen(Zufall)) then
                    BegriffCount+ = 1
                    redim preserve BegriffeInDerGruppe(BegriffCount)
                    BegriffeInDerGruppe(BegriffCount) = .Begriff
                end if
            end with
        next Index
        if BegriffCount = 0 then exit sub

    end if

    ' Begriffsfelder "mischen"
    AllCount = ubound(BegriffeInDerGruppe)
    for Zufall = 1 to 100 step 1
        Begriff1 = int(rnd * AllCount) + 1
        Begriff2 = int(rnd * AllCount) + 1
        swap BegriffeInDerGruppe(Begriff1), BegriffeInDerGruppe(Begriff2)
    next Zufall

end sub

' *****************************************************************************
' Diese FUNCTION ldt den Highscore
sub LadeHighScore ()

    ' Variablen
    dim as integer f, SpielModusHighScore, Index, SpielerScore
    dim as string Zeile, SpielerName

    ' Datei ffnen
    f = freefile
    open exepath + "\data\score.dat" for input as #f

    ' einzelne Highscores laden
    for SpielModusHighScore = 2 to 5 step 1

        ' Dummy-Zeile
        input #f, Zeile

        ' alle 5 Eintrge laden
        for Index = 1 to 5 step 1
            with HighScoreData(SpielModusHighScore, Index)
                input #f, .SpielerName, .SpielerScore
            end with
        next Index

    next SpielModusHighScore

    ' Datei schlieen
    close #f

end sub

' *****************************************************************************
' Diese SUB ldt alle Eingabe-Buttons frs Spiel
sub LadeEingabeButtons ()

    ' Variablen
    dim as integer Index, PositionX, PositionY

    ' Buttons positionieren
    PositionX = 56
    PositionY = 235
    for Index = 1 to 26 step 1
        with EingabeButtons(Index)
            .PositionX = PositionX
            .PositionY = PositionY
            .Caption = chr$(64 + Index)
            .Active = 1
            PositionX+ = 40
            if (Index mod 7) = 0 then
                PositionX = 60
                PositionY+ = 40
            end if
        end with
    next Index

end sub

' *****************************************************************************
' Diese SUB ldt einen Font
sub LoadFonts (FontName as string, Feld() as byte)

    ' Der Dateiname wird zusammengesetzt
    dim as string PfadName
    PfadName = exepath + "\data\font" + chr$(92) + trim$(lcase$(FontName)) + ".jbfnt"

    ' Neuer Font-Index
    dim as integer FontCount, FontIndex
    FontCount = ubound(FontData)
    FontCount+ = 1
    redim preserve FontData(FontCount)
    FontIndex = FontCount
    FontData(FontIndex).Font = FontName

    ' Abmessungen des Fonts ermitteln
    MaxFontXWidth = GetFontXWidth(FontName)
    MaxFontYWidth = GetFontYWidth(FontName)
    FontData(FontIndex).MaxFontWidthY = MaxFontYWidth

    ' Die Pixelfont-Daten
    redim Feld(32 to 255, MaxFontXWidth, MaxFontYWidth) as byte

    f = freefile
    open PfadName for binary access read as #f

    dim xwidth as string * 1
    dim dummy as string * 1

    get #f, , dummy
    get #f, , dummy

    for FontIndex = 32 to 255 step 1

        get #f, , xwidth
        FontData(FontCount).FontWidth(FontIndex) = asc(xwidth)
  
        for ypos = 1 to MaxFontYWidth step 1
            for xpos = 1 to asc(xwidth) step 1
                get #f, , dummy
                if asc(dummy) = 255 then 
                    Feld(FontIndex, xpos, ypos) = 1 
                else
                    Feld(FontIndex, xpos, ypos) = 0
                end if
            next xpos
        next ypos

    next FontIndex

    close #f

end sub

' *****************************************************************************
' Diese SUB ldt die Mens inklusive Buttons
sub LoadGameMenu (MenuID as integer)

    select case MenuID

        ' Hauptmen
        case 1
            with NewMenuAnimation
                .MenuPositionX1 = 160
                .MenuPositionX2 = 470
                .MenuPositionY1 = 130
                .MenuPositionY2 = 410
                .TitlePositionY = .MenuPositionY1 + 30
                .MinRadius = 20
                .MaxRadius = 100
                .RadiusSpeed = 5
                .Radius = (.MinRadius + .MaxRadius) / 2
                .MaxDifferenceX = 3
                .MaxDifferenceY = 3
                .MaxPositionX1 = .MenuPositionX1 + .MaxDifferenceX
                .MaxPositionX2 = .MenuPositionX2 + .MaxDifferenceX
                .MaxPositionY1 = .MenuPositionY1 + .MaxDifferenceY
                .MaxPositionY2 = .MenuPositionY2 + .MaxDifferenceY
                .MinPositionX1 = .MenuPositionX1 - .MaxDifferenceX
                .MinPositionX2 = .MenuPositionX2 - .MaxDifferenceX
                .MinPositionY1 = .MenuPositionY1 - .MaxDifferenceY
                .MinPositionY2 = .MenuPositionY2 - .MaxDifferenceY
                .SpeedX1 = 1
                .SpeedX2 = -1
                .SpeedY1 = -1
                .SpeedY2 = 1
            end with
            AllChanged = 1
            FarbWert = 128
            CurrentMenuID = 1
            CurrentMenuTitle = "Hauptmen"
            redim MenuButtons(5)
            with MenuButtons(1)
                .PositionX = 240
                .PositionY = 200
                .Caption = "Spiel Starten"
                .Transparency = 0
                .SpeedX = -15
                .SpeedY = -15
                .OriginX = .PositionX + .SpeedX * 20
                .OriginY = .PositionY + .SpeedY * 20
                .DestinationX = .PositionX
                .DestinationY = .PositionY
                .PositionX = .OriginX
                .PositionY = .OriginY
            end with
            with MenuButtons(2)
                .PositionX = 240
                .PositionY = 240
                .Caption = "Optionen"
                .Transparency = 0
                .SpeedX = 15
                .SpeedY = -15
                .OriginX = .PositionX + .SpeedX * 25
                .OriginY = .PositionY + .SpeedY * 25
                .DestinationX = .PositionX
                .DestinationY = .PositionY
                .PositionX = .OriginX
                .PositionY = .OriginY
            end with
            with MenuButtons(3)
                .PositionX = 240
                .PositionY = 280
                .Caption = "Credits"
                .Transparency = 0
                .SpeedX = -15
                .SpeedY = 15
                .OriginX = .PositionX + .SpeedX * 30
                .OriginY = .PositionY + .SpeedY * 30
                .DestinationX = .PositionX
                .DestinationY = .PositionY
                .PositionX = .OriginX
                .PositionY = .OriginY
            end with
            with MenuButtons(4)
                .PositionX = 240
                .PositionY = 320
                .Caption = "Highscore"
                .Transparency = 0
                .SpeedX = 15
                .SpeedY = 15
                .OriginX = .PositionX + .SpeedX * 35
                .OriginY = .PositionY + .SpeedY * 35
                .DestinationX = .PositionX
                .DestinationY = .PositionY
                .PositionX = .OriginX
                .PositionY = .OriginY
            end with
            with MenuButtons(5)
                .PositionX = 240
                .PositionY = 360
                .Caption = "Beenden"
                .Transparency = 0
                .SpeedX = -15
                .SpeedY = -15
                .OriginX = .PositionX + .SpeedX * 40
                .OriginY = .PositionY + .SpeedY * 40
                .DestinationX = .PositionX
                .DestinationY = .PositionY
                .PositionX = .OriginX
                .PositionY = .OriginY
            end with

        ' Optionen
        case 2
            with NewMenuAnimation
                .MenuPositionX1 = 120
                .MenuPositionX2 = 510
                .MenuPositionY1 = 105
                .MenuPositionY2 = 440
                .TitlePositionY = .MenuPositionY1 + 30
                .MinRadius = 20
                .MaxRadius = 100
                .RadiusSpeed = 5
                .Radius = (.MinRadius + .MaxRadius) / 2
                .MaxDifferenceX = 3
                .MaxDifferenceY = 3
                .MaxPositionX1 = .MenuPositionX1 + .MaxDifferenceX
                .MaxPositionX2 = .MenuPositionX2 + .MaxDifferenceX
                .MaxPositionY1 = .MenuPositionY1 + .MaxDifferenceY
                .MaxPositionY2 = .MenuPositionY2 + .MaxDifferenceY
                .MinPositionX1 = .MenuPositionX1 - .MaxDifferenceX
                .MinPositionX2 = .MenuPositionX2 - .MaxDifferenceX
                .MinPositionY1 = .MenuPositionY1 - .MaxDifferenceY
                .MinPositionY2 = .MenuPositionY2 - .MaxDifferenceY
                .SpeedX1 = 1
                .SpeedX2 = -1
                .SpeedY1 = -1
                .SpeedY2 = 1
            end with
            AllChanged = 0
            FarbWert = 128
            CurrentMenuID = 2
            CurrentMenuTitle = "Optionen"
            redim MenuButtons(6)
            with MenuButtons(1)
                .PositionX = 240
                .PositionY = 210
                .Caption = "Sound"
                .Transparency = 0
                .SpeedX = -15
                .SpeedY = -15
                .OriginX = .PositionX + .SpeedX * 20
                .OriginY = .PositionY + .SpeedY * 20
                .DestinationX = .PositionX
                .DestinationY = .PositionY
                .PositionX = .OriginX
                .PositionY = .OriginY
            end with
            with MenuButtons(2)
                .PositionX = 240
                .PositionY = 250
                .Caption = "Grafik"
                .Transparency = 0
                .SpeedX = -5
                .SpeedY = -15
                .OriginX = .PositionX + .SpeedX * 25
                .OriginY = .PositionY + .SpeedY * 25
                .DestinationX = .PositionX
                .DestinationY = .PositionY
                .PositionX = .OriginX
                .PositionY = .OriginY
            end with
            with MenuButtons(3)
                .PositionX = 240
                .PositionY = 290
                .Caption = "Begriffe"
                .Transparency = 0
                .SpeedX = 5
                .SpeedY = -15
                .OriginX = .PositionX + .SpeedX * 30
                .OriginY = .PositionY + .SpeedY * 30
                .DestinationX = .PositionX
                .DestinationY = .PositionY
                .PositionX = .OriginX
                .PositionY = .OriginY
            end with
            with MenuButtons(4)
                .PositionX = 240
                .PositionY = 330
                .Caption = "Spiel-Modus"
                .Transparency = 0
                .SpeedX = 15
                .SpeedY = -15
                .OriginX = .PositionX + .SpeedX * 35
                .OriginY = .PositionY + .SpeedY * 35
                .DestinationX = .PositionX
                .DestinationY = .PositionY
                .PositionX = .OriginX
                .PositionY = .OriginY
            end with
            with MenuButtons(5)
                .PositionX = 160
                .PositionY = 380
                .Caption = "Speichern"
                .Transparency = 0
                .SpeedX = -15
                .SpeedY = 15
                .OriginX = .PositionX + .SpeedX * 40
                .OriginY = .PositionY + .SpeedY * 40
                .DestinationX = .PositionX
                .DestinationY = .PositionY
                .PositionX = .OriginX
                .PositionY = .OriginY
            end with
            with MenuButtons(6)
                .PositionX = 320
                .PositionY = 380
                .Caption = "Zurck"
                .Transparency = 0
                .SpeedX = 15
                .SpeedY = 15
                .OriginX = .PositionX + .SpeedX * 45
                .OriginY = .PositionY + .SpeedY * 45
                .DestinationX = .PositionX
                .DestinationY = .PositionY
                .PositionX = .OriginX
                .PositionY = .OriginY
            end with

        ' Credits
        case 3
            with NewMenuAnimation
                .MenuPositionX1 = 125
                .MenuPositionX2 = 505
                .MenuPositionY1 = 110
                .MenuPositionY2 = 430
                .TitlePositionY = .MenuPositionY1 + 40
                .MinRadius = 20
                .MaxRadius = 100
                .RadiusSpeed = 5
                .Radius = (.MinRadius + .MaxRadius) / 2
                .MaxDifferenceX = 3
                .MaxDifferenceY = 3
                .MaxPositionX1 = .MenuPositionX1 + .MaxDifferenceX
                .MaxPositionX2 = .MenuPositionX2 + .MaxDifferenceX
                .MaxPositionY1 = .MenuPositionY1 + .MaxDifferenceY
                .MaxPositionY2 = .MenuPositionY2 + .MaxDifferenceY
                .MinPositionX1 = .MenuPositionX1 - .MaxDifferenceX
                .MinPositionX2 = .MenuPositionX2 - .MaxDifferenceX
                .MinPositionY1 = .MenuPositionY1 - .MaxDifferenceY
                .MinPositionY2 = .MenuPositionY2 - .MaxDifferenceY
                .SpeedX1 = 1
                .SpeedX2 = -1
                .SpeedY1 = -1
                .SpeedY2 = 1
            end with
            AllChanged = 0
            FarbWert = 128
            CurrentMenuID = 3
            CurrentMenuTitle = "Credits - GallowMan"
            redim MenuButtons(1)
            with MenuButtons(1)
                .PositionX = 240
                .PositionY = 385
                .Caption = "OK"
                .Transparency = 0
                .SpeedX = 15
                .SpeedY = 15
                .OriginX = .PositionX + .SpeedX * 25
                .OriginY = .PositionY + .SpeedY * 25
                .DestinationX = .PositionX
                .DestinationY = .PositionY
                .PositionX = .OriginX
                .PositionY = .OriginY
            end with

        ' Beenden
        case 4
            with NewMenuAnimation
                .MenuPositionX1 = 165
                .MenuPositionX2 = 465
                .MenuPositionY1 = 135
                .MenuPositionY2 = 350
                .TitlePositionY = .MenuPositionY1 + 30
                .MinRadius = 20
                .MaxRadius = 90
                .RadiusSpeed = 5
                .Radius = (.MinRadius + .MaxRadius) / 2
                .MaxDifferenceX = 3
                .MaxDifferenceY = 3
                .MaxPositionX1 = .MenuPositionX1 + .MaxDifferenceX
                .MaxPositionX2 = .MenuPositionX2 + .MaxDifferenceX
                .MaxPositionY1 = .MenuPositionY1 + .MaxDifferenceY
                .MaxPositionY2 = .MenuPositionY2 + .MaxDifferenceY
                .MinPositionX1 = .MenuPositionX1 - .MaxDifferenceX
                .MinPositionX2 = .MenuPositionX2 - .MaxDifferenceX
                .MinPositionY1 = .MenuPositionY1 - .MaxDifferenceY
                .MinPositionY2 = .MenuPositionY2 - .MaxDifferenceY
                .SpeedX1 = 1
                .SpeedX2 = -1
                .SpeedY1 = -1
                .SpeedY2 = 1
            end with
            AllChanged = 0
            FarbWert = 128
            CurrentMenuID = 4
            CurrentMenuTitle = "Beenden"
            redim MenuButtons(2)
            with MenuButtons(1)
                .PositionX = 240
                .PositionY = 240
                .Caption = "Ja"
                .Transparency = 0
                .SpeedX = -15
                .SpeedY = -15
                .OriginX = .PositionX + .SpeedX * 20
                .OriginY = .PositionY + .SpeedY * 20
                .DestinationX = .PositionX
                .DestinationY = .PositionY
                .PositionX = .OriginX
                .PositionY = .OriginY
            end with
            with MenuButtons(2)
                .PositionX = 240
                .PositionY = 280
                .Caption = "Nein"
                .Transparency = 0
                .SpeedX = 15
                .SpeedY = 15
                .OriginX = .PositionX + .SpeedX * 30
                .OriginY = .PositionY + .SpeedY * 30
                .DestinationX = .PositionX
                .DestinationY = .PositionY
                .PositionX = .OriginX
                .PositionY = .OriginY
            end with

        ' Das Spiel
        case 5
            with GameMenu1
                .MenuPositionX1 = 30
                .MenuPositionX2 = 345
                .MenuPositionY1 = 170
                .MenuPositionY2 = 400
                .MinRadius = 15
                .MaxRadius = 60
                .RadiusSpeed = 5
                .Radius = (.MinRadius + .MaxRadius) / 2
                .MaxDifferenceX = 3
                .MaxDifferenceY = 3
                .MaxPositionX1 = .MenuPositionX1 + .MaxDifferenceX
                .MaxPositionX2 = .MenuPositionX2 + .MaxDifferenceX
                .MaxPositionY1 = .MenuPositionY1 + .MaxDifferenceY
                .MaxPositionY2 = .MenuPositionY2 + .MaxDifferenceY
                .MinPositionX1 = .MenuPositionX1 - .MaxDifferenceX
                .MinPositionX2 = .MenuPositionX2 - .MaxDifferenceX
                .MinPositionY1 = .MenuPositionY1 - .MaxDifferenceY
                .MinPositionY2 = .MenuPositionY2 - .MaxDifferenceY
                .SpeedX1 = 1
                .SpeedX2 = -1
                .SpeedY1 = -1
                .SpeedY2 = 1
            end with
            with GameMenu2
                .MenuPositionX1 = 370
                .MenuPositionX2 = 600
                .MenuPositionY1 = 170
                .MenuPositionY2 = 400
                .MinRadius = 15
                .MaxRadius = 50
                .RadiusSpeed = 5
                .Radius = (.MinRadius + .MaxRadius) / 2
                .MaxDifferenceX = 4
                .MaxDifferenceY = 4
                .MaxPositionX1 = .MenuPositionX1 + .MaxDifferenceX
                .MaxPositionX2 = .MenuPositionX2 + .MaxDifferenceX
                .MaxPositionY1 = .MenuPositionY1 + .MaxDifferenceY
                .MaxPositionY2 = .MenuPositionY2 + .MaxDifferenceY
                .MinPositionX1 = .MenuPositionX1 - .MaxDifferenceX
                .MinPositionX2 = .MenuPositionX2 - .MaxDifferenceX
                .MinPositionY1 = .MenuPositionY1 - .MaxDifferenceY
                .MinPositionY2 = .MenuPositionY2 - .MaxDifferenceY
                .SpeedX1 = 1
                .SpeedX2 = -1
                .SpeedY1 = -1
                .SpeedY2 = 1
            end with
            with GameMenu3
                .MenuPositionX1 = 100
                .MenuPositionX2 = 540
                .MenuPositionY1 = 100
                .MenuPositionY2 = 340
                .MinRadius = 15
                .MaxRadius = 50
                .RadiusSpeed = 5
                .Radius = (.MinRadius + .MaxRadius) / 2
                .MaxDifferenceX = 4
                .MaxDifferenceY = 4
                .MaxPositionX1 = .MenuPositionX1 + .MaxDifferenceX
                .MaxPositionX2 = .MenuPositionX2 + .MaxDifferenceX
                .MaxPositionY1 = .MenuPositionY1 + .MaxDifferenceY
                .MaxPositionY2 = .MenuPositionY2 + .MaxDifferenceY
                .MinPositionX1 = .MenuPositionX1 - .MaxDifferenceX
                .MinPositionX2 = .MenuPositionX2 - .MaxDifferenceX
                .MinPositionY1 = .MenuPositionY1 - .MaxDifferenceY
                .MinPositionY2 = .MenuPositionY2 - .MaxDifferenceY
                .SpeedX1 = 1
                .SpeedX2 = -1
                .SpeedY1 = -1
                .SpeedY2 = 1
                .Transparency = 1
            end with
            FarbWert = 128
            CurrentMenuID = 5
            CurrentMenuTitle = "Spielen"
            if Settings.SpielModus > 2 then
                redim MenuButtons(5)
            else
                redim MenuButtons(4)
            end if
            with MenuButtons(1)
                .PositionX = 450
                .PositionY = 430
                .Caption = "Zurck"
                .Transparency = 0
                .SpeedX = -15
                .SpeedY = -15
                .OriginX = .PositionX + .SpeedX * 40
                .OriginY = .PositionY + .SpeedY * 40
                .DestinationX = .PositionX
                .DestinationY = .PositionY
                .PositionX = .OriginX
                .PositionY = .OriginY
            end with
            with MenuButtons(2)
                .PositionX = 30
                .PositionY = 430
                .Caption = "Buchstaben-Joker"
                .Transparency = 0
                .SpeedX = -15
                .SpeedY = 15
                .OriginX = .PositionX + .SpeedX * 45
                .OriginY = .PositionY + .SpeedY * 45
                .DestinationX = .PositionX
                .DestinationY = .PositionY
                .PositionX = .OriginX
                .PositionY = .OriginY
            end with
            with MenuButtons(3)
                .PositionX = 240
                .PositionY = 430
                .Caption = "Ausschluss-Joker"
                .Transparency = 0
                .SpeedX = 15
                .SpeedY = 15
                .OriginX = .PositionX + .SpeedX * 50
                .OriginY = .PositionY + .SpeedY * 50
                .DestinationX = .PositionX
                .DestinationY = .PositionY
                .PositionX = .OriginX
                .PositionY = .OriginY
            end with
            with MenuButtons(4)
                .PositionX = 32
                .PositionY = 42
                .Caption = "Punktestand"
                .Transparency = 0
                .SpeedX = -15
                .SpeedY = -15
                .OriginX = .PositionX + .SpeedX * 55
                .OriginY = .PositionY + .SpeedY * 55
                .DestinationX = .PositionX
                .DestinationY = .PositionY
                .PositionX = .OriginX
                .PositionY = .OriginY
                .Disabled = 1
            end with
            if Settings.SpielModus > 2 then
                with MenuButtons(5)
                    .PositionX = 450
                    .PositionY = 42
                    .Caption = "Zeit"
                    .Transparency = 0
                    .SpeedX = 15
                    .SpeedY = -15
                    .OriginX = .PositionX + .SpeedX * 60
                    .OriginY = .PositionY + .SpeedY * 60
                    .DestinationX = .PositionX
                    .DestinationY = .PositionY
                    .PositionX = .OriginX
                    .PositionY = .OriginY
                    .Disabled = 1
                end with
            end if
            redim DialogButtons(1)
            with DialogButtons(1)
                .PositionX = 240
                .PositionY = 290
                .Caption = ""
                .Transparency = 0
                .SpeedX = 15
                .SpeedY = -15
                .OriginX = .PositionX + .SpeedX * 25
                .OriginY = .PositionY + .SpeedY * 25
                .DestinationX = .PositionX
                .DestinationY = .PositionY
                .PositionX = .OriginX
                .PositionY = .OriginY
            end with

        ' Sound
        case 6
            with NewMenuAnimation
                .MenuPositionX1 = 115
                .MenuPositionX2 = 505
                .MenuPositionY1 = 110
                .MenuPositionY2 = 430
                .TitlePositionY = .MenuPositionY1 + 30
                .MinRadius = 20
                .MaxRadius = 100
                .RadiusSpeed = 5
                .Radius = (.MinRadius + .MaxRadius) / 2
                .MaxDifferenceX = 3
                .MaxDifferenceY = 3
                .MaxPositionX1 = .MenuPositionX1 + .MaxDifferenceX
                .MaxPositionX2 = .MenuPositionX2 + .MaxDifferenceX
                .MaxPositionY1 = .MenuPositionY1 + .MaxDifferenceY
                .MaxPositionY2 = .MenuPositionY2 + .MaxDifferenceY
                .MinPositionX1 = .MenuPositionX1 - .MaxDifferenceX
                .MinPositionX2 = .MenuPositionX2 - .MaxDifferenceX
                .MinPositionY1 = .MenuPositionY1 - .MaxDifferenceY
                .MinPositionY2 = .MenuPositionY2 - .MaxDifferenceY
                .SpeedX1 = 1
                .SpeedX2 = -1
                .SpeedY1 = -1
                .SpeedY2 = 1
            end with
            AllChanged = 0
            FarbWert = 128
            CurrentMenuID = 6
            CurrentMenuTitle = "Sound"
            redim MenuButtons(4)
            with MenuButtons(1)
                .PositionX = 240
                .PositionY = 250
                .Caption = ""
                .Transparency = 0
                .SpeedX = -15
                .SpeedY = -15
                .OriginX = .PositionX + .SpeedX * 20
                .OriginY = .PositionY + .SpeedY * 20
                .DestinationX = .PositionX
                .DestinationY = .PositionY
                .PositionX = .OriginX
                .PositionY = .OriginY
            end with
            with MenuButtons(2)
                .PositionX = 240
                .PositionY = 290
                .Caption = ""
                .Transparency = 0
                .SpeedX = 15
                .SpeedY = -15
                .OriginX = .PositionX + .SpeedX * 25
                .OriginY = .PositionY + .SpeedY * 25
                .DestinationX = .PositionX
                .DestinationY = .PositionY
                .PositionX = .OriginX
                .PositionY = .OriginY
            end with
            with MenuButtons(3)
                .PositionX = 240
                .PositionY = 330
                .Caption = "Musik auswhlen"
                .Transparency = 0
                .SpeedX = -15
                .SpeedY = 15
                .OriginX = .PositionX + .SpeedX * 30
                .OriginY = .PositionY + .SpeedY * 30
                .DestinationX = .PositionX
                .DestinationY = .PositionY
                .PositionX = .OriginX
                .PositionY = .OriginY
            end with
            with MenuButtons(4)
                .PositionX = 240
                .PositionY = 380
                .Caption = "OK"
                .Transparency = 0
                .SpeedX = 15
                .SpeedY = 15
                .OriginX = .PositionX + .SpeedX * 35
                .OriginY = .PositionY + .SpeedY * 35
                .DestinationX = .PositionX
                .DestinationY = .PositionY
                .PositionX = .OriginX
                .PositionY = .OriginY
            end with

        ' Begriffe ndern
        case 7
            with NewMenuAnimation
                .MenuPositionX1 = 120
                .MenuPositionX2 = 510
                .MenuPositionY1 = 110
                .MenuPositionY2 = 440
                .TitlePositionY = .MenuPositionY1 + 30
                .MinRadius = 20
                .MaxRadius = 100
                .RadiusSpeed = 5
                .Radius = (.MinRadius + .MaxRadius) / 2
                .MaxDifferenceX = 3
                .MaxDifferenceY = 3
                .MaxPositionX1 = .MenuPositionX1 + .MaxDifferenceX
                .MaxPositionX2 = .MenuPositionX2 + .MaxDifferenceX
                .MaxPositionY1 = .MenuPositionY1 + .MaxDifferenceY
                .MaxPositionY2 = .MenuPositionY2 + .MaxDifferenceY
                .MinPositionX1 = .MenuPositionX1 - .MaxDifferenceX
                .MinPositionX2 = .MenuPositionX2 - .MaxDifferenceX
                .MinPositionY1 = .MenuPositionY1 - .MaxDifferenceY
                .MinPositionY2 = .MenuPositionY2 - .MaxDifferenceY
                .SpeedX1 = 1
                .SpeedX2 = -1
                .SpeedY1 = -1
                .SpeedY2 = 1
            end with
            AllChanged = 0
            FarbWert = 128
            CurrentMenuID = 7
            CurrentMenuTitle = "Begriffe"
            redim MenuButtons(3)
            with MenuButtons(1)
                .PositionX = 170
                .PositionY = 260
                .Caption = "Datei auswhlen"
                .Transparency = 0
                .SpeedX = -15
                .SpeedY = -15
                .OriginX = .PositionX + .SpeedX * 20
                .OriginY = .PositionY + .SpeedY * 20
                .DestinationX = .PositionX
                .DestinationY = .PositionY
                .PositionX = .OriginX
                .PositionY = .OriginY
            end with
            with MenuButtons(2)
                .PositionX = 320
                .PositionY = 330
                .Caption = ""
                .Transparency = 0
                .SpeedX = 15
                .SpeedY = -15
                .OriginX = .PositionX + .SpeedX * 25
                .OriginY = .PositionY + .SpeedY * 25
                .DestinationX = .PositionX
                .DestinationY = .PositionY
                .PositionX = .OriginX
                .PositionY = .OriginY
            end with
            with MenuButtons(3)
                .PositionX = 240
                .PositionY = 390
                .Caption = "OK"
                .Transparency = 0
                .SpeedX = 15
                .SpeedY = 15
                .OriginX = .PositionX + .SpeedX * 35
                .OriginY = .PositionY + .SpeedY * 35
                .DestinationX = .PositionX
                .DestinationY = .PositionY
                .PositionX = .OriginX
                .PositionY = .OriginY
            end with

        ' Spiel-Modus ndern
        case 8
            with NewMenuAnimation
                .MenuPositionX1 = 140
                .MenuPositionX2 = 490
                .MenuPositionY1 = 130
                .MenuPositionY2 = 390
                .TitlePositionY = .MenuPositionY1 + 30
                .MinRadius = 20
                .MaxRadius = 80
                .RadiusSpeed = 5
                .Radius = (.MinRadius + .MaxRadius) / 2
                .MaxDifferenceX = 3
                .MaxDifferenceY = 3
                .MaxPositionX1 = .MenuPositionX1 + .MaxDifferenceX
                .MaxPositionX2 = .MenuPositionX2 + .MaxDifferenceX
                .MaxPositionY1 = .MenuPositionY1 + .MaxDifferenceY
                .MaxPositionY2 = .MenuPositionY2 + .MaxDifferenceY
                .MinPositionX1 = .MenuPositionX1 - .MaxDifferenceX
                .MinPositionX2 = .MenuPositionX2 - .MaxDifferenceX
                .MinPositionY1 = .MenuPositionY1 - .MaxDifferenceY
                .MinPositionY2 = .MenuPositionY2 - .MaxDifferenceY
                .SpeedX1 = 1
                .SpeedX2 = -1
                .SpeedY1 = -1
                .SpeedY2 = 1
            end with
            AllChanged = 0
            FarbWert = 128
            CurrentMenuID = 8
            CurrentMenuTitle = "Spiel-Modus"
            redim MenuButtons(2)
            with MenuButtons(1)
                .PositionX = 240
                .PositionY = 285
                .Caption = ""
                .Transparency = 0
                .SpeedX = 15
                .SpeedY = -15
                .OriginX = .PositionX + .SpeedX * 25
                .OriginY = .PositionY + .SpeedY * 25
                .DestinationX = .PositionX
                .DestinationY = .PositionY
                .PositionX = .OriginX
                .PositionY = .OriginY
            end with
            with MenuButtons(2)
                .PositionX = 240
                .PositionY = 340
                .Caption = "OK"
                .Transparency = 0
                .SpeedX = -15
                .SpeedY = 15
                .OriginX = .PositionX + .SpeedX * 35
                .OriginY = .PositionY + .SpeedY * 35
                .DestinationX = .PositionX
                .DestinationY = .PositionY
                .PositionX = .OriginX
                .PositionY = .OriginY
            end with

        ' Highscore
        case 9
            with NewMenuAnimation
                .MenuPositionX1 = 40
                .MenuPositionX2 = 600
                .MenuPositionY1 = 70
                .MenuPositionY2 = 420
                .TitlePositionY = .MenuPositionY1 + 40
                .MinRadius = 15
                .MaxRadius = 50
                .RadiusSpeed = 5
                .Radius = (.MinRadius + .MaxRadius) / 2
                .MaxDifferenceX = 4
                .MaxDifferenceY = 4
                .MaxPositionX1 = .MenuPositionX1 + .MaxDifferenceX
                .MaxPositionX2 = .MenuPositionX2 + .MaxDifferenceX
                .MaxPositionY1 = .MenuPositionY1 + .MaxDifferenceY
                .MaxPositionY2 = .MenuPositionY2 + .MaxDifferenceY
                .MinPositionX1 = .MenuPositionX1 - .MaxDifferenceX
                .MinPositionX2 = .MenuPositionX2 - .MaxDifferenceX
                .MinPositionY1 = .MenuPositionY1 - .MaxDifferenceY
                .MinPositionY2 = .MenuPositionY2 - .MaxDifferenceY
                .SpeedX1 = 1
                .SpeedX2 = -1
                .SpeedY1 = -1
                .SpeedY2 = 1
                .Transparency = 1
            end with
            AllChanged = 0
            FarbWert = 128
            CurrentMenuID = 9
            CurrentMenuTitle = "Highscore"
            redim MenuButtons(1)
            with MenuButtons(1)
                .PositionX = 240
                .PositionY = 375
                .Caption = "Zurck"
                .Transparency = 0
                .SpeedX = 15
                .SpeedY = 15
                .OriginX = .PositionX + .SpeedX * 30
                .OriginY = .PositionY + .SpeedY * 30
                .DestinationX = .PositionX
                .DestinationY = .PositionY
                .PositionX = .OriginX
                .PositionY = .OriginY
            end with

        ' Grafik-Einstellungen
        case 10
            with NewMenuAnimation
                .MenuPositionX1 = 140
                .MenuPositionX2 = 490
                .MenuPositionY1 = 130
                .MenuPositionY2 = 410
                .TitlePositionY = .MenuPositionY1 + 30
                .MinRadius = 20
                .MaxRadius = 100
                .RadiusSpeed = 5
                .Radius = (.MinRadius + .MaxRadius) / 2
                .MaxDifferenceX = 3
                .MaxDifferenceY = 3
                .MaxPositionX1 = .MenuPositionX1 + .MaxDifferenceX
                .MaxPositionX2 = .MenuPositionX2 + .MaxDifferenceX
                .MaxPositionY1 = .MenuPositionY1 + .MaxDifferenceY
                .MaxPositionY2 = .MenuPositionY2 + .MaxDifferenceY
                .MinPositionX1 = .MenuPositionX1 - .MaxDifferenceX
                .MinPositionX2 = .MenuPositionX2 - .MaxDifferenceX
                .MinPositionY1 = .MenuPositionY1 - .MaxDifferenceY
                .MinPositionY2 = .MenuPositionY2 - .MaxDifferenceY
                .SpeedX1 = 1
                .SpeedX2 = -1
                .SpeedY1 = -1
                .SpeedY2 = 1
            end with
            AllChanged = 0
            FarbWert = 128
            CurrentMenuID = 10
            CurrentMenuTitle = "Grafik"
            redim MenuButtons(3)
            with MenuButtons(1)
                .PositionX = 240
                .PositionY = 235
                .Caption = "Bildschirmmodus"
                .Transparency = 0
                .SpeedX = -15
                .SpeedY = -15
                .OriginX = .PositionX + .SpeedX * 20
                .OriginY = .PositionY + .SpeedY * 20
                .DestinationX = .PositionX
                .DestinationY = .PositionY
                .PositionX = .OriginX
                .PositionY = .OriginY
            end with
            with MenuButtons(2)
                .PositionX = 240
                .PositionY = 310
                .Caption = "Geschwindigkeit"
                .Transparency = 0
                .SpeedX = 15
                .SpeedY = -15
                .OriginX = .PositionX + .SpeedX * 25
                .OriginY = .PositionY + .SpeedY * 25
                .DestinationX = .PositionX
                .DestinationY = .PositionY
                .PositionX = .OriginX
                .PositionY = .OriginY
            end with
            with MenuButtons(3)
                .PositionX = 240
                .PositionY = 365
                .Caption = "OK"
                .Transparency = 0
                .SpeedX = 15
                .SpeedY = 15
                .OriginX = .PositionX + .SpeedX * 30
                .OriginY = .PositionY + .SpeedY * 30
                .DestinationX = .PositionX
                .DestinationY = .PositionY
                .PositionX = .OriginX
                .PositionY = .OriginY
            end with

        case else
            CurrentMenuID = 0
            CurrentMenuTitle = ""
            redim MenuButtons(0)

    end select

    ' Buttons animieren
    AnimateFlyIn = 1

end sub

' *****************************************************************************
' Diese SUB ldt alle Einstellungen
sub LoadSettings ()

    ' Variablen
    dim as integer WertNichtKorrekt

    ' Den Highscore laden
    LadeHighScore ()

    ' Laden
    f = freefile
    open exepath + "\data\settings.dat" for input as #f
        with Settings
            input #f, .SoundEffects
            input #f, .BGMusic
            input #f, .Vollbild
            input #f, .Pause
            input #f, .TextDatei
            input #f, .Gruppe
            input #f, .HintergrundMusik
            input #f, .SpielModus
            input #f, .Zeit
        end with
    close #f
    Settings.HintergrundMusikAlt = Settings.HintergrundMusik

    ' Textdatei noch nicht gesetzt?
    if len(trim$(Settings.TextDatei)) = 0 then
        Settings.TextDatei = exepath + "\Begriffe\Begriffe.txt"
        WertNichtKorrekt = 1
    end if

    ' Sounddatei nicht gesetzt?
    if len(trim$(Settings.HintergrundMusik)) = 0 then
        Settings.BGMusic = 0
    end if

    ' Die Begriffe laden
    LadeBegriffe (Settings.TextDatei)

    ' Dateinamen der Textdatei ermitteln
    TextDatei = GetFileName(Settings.TextDatei)

    ' Hintergrundmusik?
    if Settings.BGMusic and GetCurrentPosition("bgmusic") = 0 then
        PlaySound(Settings.HintergrundMusik, "bgmusic", Settings.BGMusic, "repeat")
    elseif Settings.BGMusic = 0 then
        StopSound("bgmusic")
    end if

    ' Spielmodus?
    if (Settings.SpielModus > 5) or (Settings.SpielModus < 1) then
        Settings.SpielModus = 1
        WertNichtKorrekt = 1
    end if

    ' Die Zeit?
    if (Settings.Zeit <> 30) and (Settings.Zeit <> 90) and (Settings.Zeit <> 180) then
        Settings.Zeit = 30
        WertNichtKorrekt = 1
    end if

    ' Die Pause
    if (Settings.Pause < 1) or (Settings.Pause > 30) then
        Settings.Pause = 15
        WertNichtKorrekt = 1
    end if

    ' War einer der Werte nicht korrekt?
    if WertNichtKorrekt then
        SaveSettings ()
    end if

end sub

' *****************************************************************************
' Diese SUB spielt einen Sound ab
sub PlaySound (sFile as string, sAlias as string, OK as integer, repeat as string = "")

    ' Sound eingeschaltet?
    if OK = 0 then exit sub

    StopSound(sAlias)
    dim sBuffer as string 
    dim lResult as long 
    dim sf as string 
    sf = Space$(255) 
    sBuffer = Space$(255) 
    sf = sFile 
    lResult = GetShortPathName(sf, sBuffer, len(sBuffer)) 
    if lResult <> 0 then 
        sBuffer = rtrim$(sBuffer) 
        if mciSendString("open " + sBuffer + " type MPEGVideo alias " + sAlias , 0, 0, 0) = 0 then 
            mciSendString("play " + sAlias + " from 0 " + repeat, 0, 0, 0)
        end if 
    end if

end sub

' *****************************************************************************
' Diese SUB gibt einen Text im aktuell geladenen Font aus
sub PrintFont (xpos as integer, ypos as integer, Text as string, farbe as long = rgb(255, 255, 255), bgfarbe as long = rgb(255, 0, 255))

    dim CharCount as integer
    dim char as string
    dim as integer mainxpos, mainypos, CharIndex
    mainxpos = xpos
    mainypos = ypos

    if lcase$(trim$(FontData(CurrentFont).Font)) = "comic" then
        for CharCount = 1 to len(Text) step 1
            char = mid$(Text, CharCount, 1)
            CharIndex = asc(char)
            if (CharIndex > 31) then 
                for y = 1 to FontData(CurrentFont).MaxFontWidthY step 1
                    for x = 1 to GetTextLength(char) step 1
                        if NormalFont(CharIndex, x, y) then
                            pset (x + mainxpos, y + mainypos), farbe
                        elseif bgfarbe <> rgb(255, 0, 255) then
                            pset (x + mainxpos, y + mainypos), bgfarbe
                        end if
                    next x
                next y
            elseif char = chr$(13) then
                mainxpos = xpos
                mainypos+ = FontData(CurrentFont).MaxFontWidthY
            end if
            mainxpos+ = FontData(CurrentFont).FontWidth(CharIndex)
        next CharCount

    elseif lcase$(trim$(FontData(CurrentFont).Font)) = "comic_bold" then
        for CharCount = 1 to len(Text) step 1
            char = mid$(Text, CharCount, 1)
            CharIndex = asc(char)
            if (CharIndex > 31) then 
                for y = 1 to FontData(CurrentFont).MaxFontWidthY step 1
                    for x = 1 to GetTextLength(char) step 1
                        if LargeFont(CharIndex, x, y) then
                            pset (x + mainxpos, y + mainypos), farbe
                        elseif bgfarbe <> rgb(255, 0, 255) then
                            pset (x + mainxpos, y + mainypos), bgfarbe
                        end if
                    next x
                next y
            elseif char = chr$(13) then
                mainxpos = xpos
                mainypos+ = FontData(CurrentFont).MaxFontWidthY
            end if
            mainxpos+ = FontData(CurrentFont).FontWidth(CharIndex)
        next CharCount
    end if

end sub

' *****************************************************************************
' Diese SUB setzt alle Spieldaten zurck
sub ResetGameData (Complete as integer = 1)

    ' Variablen
    dim as integer Index, Vorhanden, OldUpperBound

    ' Alle Eingabe-Buttons resetten
    for Index = 1 to 26 step 1
        EingabeButtons(Index).Active = 1
    next Index

    ' alle Buchstaben entfernen
    SpielInfo.Buchstaben = ""

    ' alle Begriffe laden
    if Complete then
        LadeBegriffeZurGruppe ()
    end if

    ' neues Wort
    if Complete then SpielInfo.GesuchtesWort = ""
    SpielInfo.GesuchtesWort = SucheWort()

    ' die falschen Buchstaben ermitteln
    SpielInfo.FalscheBuchstaben = ""
    for Index = 1 to ubound(EingabeButtons) step 1
        with EingabeButtons(Index)
            if instr(lcase$(SpielInfo.GesuchtesWort), lcase$(.Caption)) = 0 then
                SpielInfo.FalscheBuchstaben+ = .Caption
            end if
        end with
    next Index

    ' Der Spieler hat natrlich noch nicht gewonnen oder verloren, noch ist die Zeit um
    SpielInfo.WortErraten = 0
    SpielInfo.Fertig = 0
    SpielInfo.ZeitIstUm = 0

    ' Komplett zurcksetzen?
    if Complete then
        SpielInfo.StatusIndex = 0
        Zeit = Settings.Zeit + 1
        SpielInfo.SpielerScore = 0
        SpielInfo.SpielerName = ""
    end if

end sub

' *****************************************************************************
' Diese SUB speichert alle Einstellungen
sub SaveSettings ()

    ' Speichern
    f = freefile
    open exepath + "\data\settings.dat" for output as #f
        with Settings
            if (len(.HintergrundMusik) = 0) then
                .HintergrundMusik = chr$(32)
            end if
            write #f, .SoundEffects
            write #f, .BGMusic
            write #f, .Vollbild
            write #f, .Pause
            write #f, .TextDatei
            write #f, .Gruppe
            write #f, .HintergrundMusik
            write #f, .SpielModus
            write #f, .Zeit
        end with
    close #f

    ' Highscore speichern
    SpeicherHighScore ()

    ' Hintergrundmusik neu starten?
    if Settings.HintergrundMusikAlt <> Settings.HintergrundMusik then
        StopSound("bgmusic")
        PlaySound(Settings.HintergrundMusik, "bgmusic", Settings.BGMusic, "repeat")
        Settings.HintergrundMusik = Settings.HintergrundMusikAlt
    elseif Settings.BGMUsic and GetCurrentPosition("bgmusic") = 0 then
        PlaySound(Settings.HintergrundMusik, "bgmusic", Settings.BGMusic, "repeat")
    elseif Settings.BGMusic = 0 then
        StopSound("bgmusic")
    end if

end sub

' *****************************************************************************
' Diese SUB fgt einem Highscore einen Eintrag zu
sub SchreibeInHighScore (SpielerName as string, SpielerScore as integer, SpielModus as integer)

    ' Variablen
    dim as integer HighScoreIndex, Index

    ' An welcher Stelle in den Highscore schreiben?
    Index = 0
    for HighScoreIndex = 5 to 1 step -1
        if SpielerScore > HighScoreData(SpielModus, HighScoreIndex).SpielerScore then
            Index = HighScoreIndex
        end if
    next HighScoreIndex

    ' Eintrag berhaupt mglich?
    if Index = 0 then exit sub

    ' In den Highscore eintragen
    for HighScoreIndex = 4 to Index step -1
        HighScoreData(SpielModus, HighScoreIndex + 1).SpielerScore = HighScoreData(SpielModus, HighScoreIndex).SpielerScore
        HighScoreData(SpielModus, HighScoreIndex + 1).SpielerName = HighScoreData(SpielModus, HighScoreIndex).SpielerName
    next HighScoreIndex
    HighScoreData(SpielModus, Index).SpielerName = SpielerName
    HighScoreData(SpielModus, Index).SpielerScore = SpielerScore

    ' Highscore abspeichern
    SpeicherHighScore ()

end sub

' *****************************************************************************
' Diese SUB setzt eine Schriftart
sub SetFont (Font as string)

    ' Variablen
    dim as integer FontCount, FontIndex

    ' Font suchen
    FontCount = ubound(FontData)
    for FontIndex = 1 to FontCount step 1
        if lcase$(trim$(Font)) = lcase$(trim$(FontData(FontIndex).Font)) then
            CurrentFont = FontIndex
            exit sub
        end if
    next FontIndex

end sub

' *****************************************************************************
' Diese SUB zeichnet ein animiertes Men
sub ShowAnimatedMenu (MenuData as MenuAnimationType)

    ' Men zeichnen
    with MenuData

        ' Menbox zeichnen
        if .Transparency = 0 then
            DrawBox(.MenuPositionX1 + 8, .MenuPositionY1 + 8, .MenuPositionX2 + 8, .MenuPositionY2 + 8, .Radius, rgb(255, 0, 255), rgb(50, 50, 50), FarbWert / 6)
            DrawBox(.MenuPositionX1, .MenuPositionY1, .MenuPositionX2, .MenuPositionY2, .Radius, rgb(255, 255, 255), rgb(120, 120, 255), FarbWert / 3)
        else
            DrawBox(.MenuPositionX1 + 8, .MenuPositionY1 + 8, .MenuPositionX2 + 8, .MenuPositionY2 + 8, .Radius, rgb(50, 50, 50), rgb(50, 50, 50), .Transparency / 2)
            DrawBox(.MenuPositionX1, .MenuPositionY1, .MenuPositionX2, .MenuPositionY2, .Radius, rgb(255, 255, 255), rgb(120, 120, 255), .Transparency)
        end if

        .MenuPositionX1+ = .SpeedX1
        if (.MenuPositionX1 < .MinPositionX1) or (.MenuPositionX1 > .MaxPositionX1) then .SpeedX1 = -.SpeedX1
        .MenuPositionX2+ = .SpeedX2
        if (.MenuPositionX2 < .MinPositionX2) or (.MenuPositionX2 > .MaxPositionX2) then .SpeedX2 = -.SpeedX2
        .MenuPositionY1+ = .SpeedY1
        if (.MenuPositionY1 < .MinPositionY1) or (.MenuPositionY1 > .MaxPositionY1) then .SpeedY1 = -.SpeedY1
        .MenuPositionY2+ = .SpeedY2
        if (.MenuPositionY2 < .MinPositionY2) or (.MenuPositionY2 > .MaxPositionY2) then .SpeedY2 = -.SpeedY2
        .Radius+ = .RadiusSpeed
        if (.Radius < .MinRadius) or (.Radius > .MaxRadius) then
            .RadiusSpeed = -.RadiusSpeed
        end if

    end with

end sub

' *****************************************************************************
' Diese SUB zeichnet die Buttons der Dialog-Boxen
sub ShowDialogButtons (menuResult as integer)

    ' Variablen
    dim as integer Index, TMPIndex, Fault
    AnimateDialogStatus = 0

    ' Schleife ber alle Buttons
    for Index = 1 to ubound(DialogButtons) step 1
        with DialogButtons(Index)

            ' Button animieren
            if (AnimateDialogFlyIn = 1) then
                if .PositionX <> .DestinationX then .PositionX- = .SpeedX
                if .PositionY <> .DestinationY then .PositionY- = .SpeedY
                if .Transparency < 255 then .Transparency+ = 15
                if (.PositionX = .DestinationX) and (.PositionY = .DestinationY) then
                    AnimateDialogStatus+ = 1
                end if
            end if

            ' Button steuern
            IsMouse = IsMouseOver(.PositionX + 5, .PositionY + 5, .PositionX + 144, .PositionY + 24)
            if .Disabled = 0 then
                if IsMouse and (AnimateFlyOut = 0) and (AnimateFlyIn = 0) then
                    if (Mouse.Tasten2 and 1) = 1 then
                        fault = 0
                        for TMPIndex = 1 to Index step 1
                            if EingabeButtons(TMPIndex).Status = 2 then Fault = 1
                        next tmpindex
                        if fault = 0 then
                            .Status = 1
                            PlaySound(exepath + "\data\snd\pressdown.wav", "pressdown", Settings.SoundEffects)
                        end if
                    end if
                    if (.Status = 1) and (Mouse.Tasten = 0) then
                        PlaySound(exepath + "\data\snd\active.wav", "active", Settings.SoundEffects)
                        MenuResult = Index
                    end if
                end if
                if Mouse.Tasten = 0 and .Status = 1 then
                    .Status = 0
                    PlaySound(exepath + "\data\snd\pressdown.wav", "pressdown", Settings.SoundEffects)
                end if
            else
                if IsMouse and (AnimateFlyOut = 0) and (AnimateFlyIn = 0) and ((Mouse.Tasten2 and 1) = 1) then
                    PlaySound(exepath + "\data\snd\inactive.wav", "inactive", Settings.SoundEffects)
                end if
            end if

            ' und anzeigen
            DrawBox(.PositionX + 5, .PositionY + 5, .PositionX + 155, .PositionY + 33, 11, rgb(50, 50, 50), rgb(50, 50, 50), 30)
            put(.PositionX, .PositionY), MenuButton, alpha, .Transparency
            if .Disabled = 0 then
                CenterPrint(.PositionX, .PositionX + 149 + .Status, .PositionY + .Status, .PositionY + 25, .Caption, (1 - IsMouse) * Farbe + (IsMouse * rgb(200, 200, 200)))
            else
                CenterPrint(.PositionX, .PositionX + 149 + .Status, .PositionY + .Status, .PositionY + 25, .Caption, Farbe)
            end if

        end with
    next Index

    ' Animation abgeschlossen?
    if AnimateDialogStatus = ubound(DialogButtons) then AnimateDialogFlyIn = 0

end sub

' *****************************************************************************
' Diese SUB zeichnet die Eingabetastatur
sub ShowEingabeMaske ()

    ' Variablen
    dim as integer Index, TMPIndex, Fault

    ' Alle Buttons anzeigen
    for Index = 1 to ubound(EingabeButtons) step 1
        with EingabeButtons(Index)
            DrawBox(.PositionX + 5, .PositionY + 5, .PositionX + 34, .PositionY + 33, 11, rgb(255, 0, 255), rgb(50, 50, 50), 30)
            put (.PositionX, .PositionY), Button, alpha, Transparency
            if .Active = 0 then
                PrintFont(.PositionX + 8 + .Status, .PositionY + 4 + .Status, .Caption, Farbe)
                PrintFont(.PositionX + 9 + .Status, .PositionY + 4 + .Status, .Caption, Farbe)
                put(.PositionX, .PositionY), ButtonInActive, alpha, Transparency
            end if
            IsMouse = IsMouseOver(.PositionX + 5, .PositionY + 5, .PositionX + 23, .PositionY + 24)
            if (SpielInfo.WortErraten or SpielInfo.Fertig or SpielInfo.ZeitIstUm) > 0 then IsMouse = 0
            if .Active then
                PrintFont(.PositionX + 8 + .Status, .PositionY + 4 + .Status, .Caption, (1 - IsMouse) * Farbe + (IsMouse * rgb(200, 200, 200)))
                PrintFont(.PositionX + 9 + .Status, .PositionY + 4 + .Status, .Caption, (1 - IsMouse) * Farbe + (IsMouse * rgb(200, 200, 200)))
                if IsMouse then
                    if (Mouse.Tasten2 and 1) = 1 then
                        if (SpielInfo.WortErraten or SpielInfo.Fertig or SpielInfo.ZeitIstUm) = 0 then
                            Fault = 0
                            for TMPIndex = 1 to Index step 1
                                if EingabeButtons(TMPIndex).Status = 2 then Fault = 1
                            next TMPIndex
                            if Fault = 0 then
                                .Status = 1
                                PlaySound(exepath + "\data\snd\pressdown.wav", "pressdown", Settings.SoundEffects)
                            end if
                        end if
                    end if
                    if (.Status = 1) and (Mouse.Tasten = 0) then
                        .Active = 0
                        if instr(lcase$(SpielInfo.Buchstaben), lcase$(.Caption)) = 0 then
                            SpielInfo.Buchstaben+ = .Caption
                            if instr(lcase$(SpielInfo.GesuchtesWort), lcase$(.Caption)) = 0 then
                                if SpielInfo.StatusIndex < 11 then SpielInfo.StatusIndex+ = 1
                            end if
                        end if
                        PlaySound(exepath + "\data\snd\active.wav", "active", Settings.SoundEffects)
                    end if
                end if
                if Mouse.Tasten = 0 and .Status = 1 then
                    .Status = 0
                    PlaySound(exepath + "\data\snd\pressdown.wav", "pressdown", Settings.SoundEffects)
                end if
            else
                if (IsMouse > 0) and (Mouse.Tasten2 and 1) = 1 then PlaySound(exepath + "\data\snd\inactive.wav", "inactive", Settings.SoundEffects)
            end if
            if lcase$(Taste) = lcase$(trim$(.Caption)) then
                if (SpielInfo.WortErraten or SpielInfo.Fertig or SpielInfo.ZeitIstUm) = 0 then
                    if .Active = 1 then
                        PlaySound(exepath + "\data\snd\active.wav", "active", Settings.SoundEffects)
                    else
                        PlaySound(exepath + "\data\snd\inactive.wav", "inactive", Settings.SoundEffects)
                    end if
                    if .Active then
                        if instr(lcase$(SpielInfo.Buchstaben), lcase$(.Caption)) = 0 then
                            SpielInfo.Buchstaben+ = .Caption
                            if instr(lcase$(SpielInfo.GesuchtesWort), lcase$(.Caption)) = 0 then
                                if SpielInfo.StatusIndex < 11 then SpielInfo.StatusIndex+ = 1
                            end if
                        end if
                        .Active = 0
                    end if
                end if
            end if
        end with
    next Index

end sub

' *****************************************************************************
' Diese SUB zeichnet die Menbuttons
sub ShowGameMenu (MenuResult as integer)

    dim as integer MaxChanged = 23

    ' Men zeichnen
    with MenuAnimation

        if CurrentMenuID <> 5 then

            ' Menbox zeichnen
            DrawBox(.MenuPositionX1 + 8, .MenuPositionY1 + 8, .MenuPositionX2 + 8, .MenuPositionY2 + 8, .Radius, rgb(255, 0, 255), rgb(50, 50, 50), 50)
            DrawBox(.MenuPositionX1, .MenuPositionY1, .MenuPositionX2, .MenuPositionY2, .Radius, rgb(255, 255, 255), rgb(120, 120, 255), 100)

            ' Von der lteren Menbox zur aktuellen berblenden
            if AllChanged < MaxChanged then
                AllChanged = 0
                AllChanged+ = ChangeValue(.MenuPositionX1, NewMenuAnimation.MenuPositionX1)
                AllChanged+ = ChangeValue(.MenuPositionX2, NewMenuAnimation.MenuPositionX2)
                AllChanged+ = ChangeValue(.MenuPositionY1, NewMenuAnimation.MenuPositionY1)
                AllChanged+ = ChangeValue(.MenuPositionY2, NewMenuAnimation.MenuPositionY2)
                AllChanged+ = ChangeValue(.MinRadius, NewMenuAnimation.MinRadius)
                AllChanged+ = ChangeValue(.MaxRadius, NewMenuAnimation.MaxRadius)
                AllChanged+ = ChangeValue(.RadiusSpeed, NewMenuAnimation.RadiusSpeed)
                AllChanged+ = ChangeValue(.Radius, NewMenuAnimation.Radius)
                AllChanged+ = ChangeValue(.TitlePositionY, NewMenuAnimation.TitlePositionY)
                AllChanged+ = ChangeValue(.MaxDifferenceX, NewMenuAnimation.MaxDifferenceX)
                AllChanged+ = ChangeValue(.MaxDifferenceY, NewMenuAnimation.MaxDifferenceY)
                AllChanged+ = ChangeValue(.SpeedX1, NewMenuAnimation.SpeedX1)
                AllChanged+ = ChangeValue(.SpeedX2, NewMenuAnimation.SpeedX2)
                AllChanged+ = ChangeValue(.SpeedY1, NewMenuAnimation.SpeedY1)
                AllChanged+ = ChangeValue(.SpeedY2, NewMenuAnimation.SpeedY2)
                AllChanged+ = ChangeValue(.MaxPositionX1, .MenuPositionX1 + .MaxDifferenceX)
                AllChanged+ = ChangeValue(.MaxPositionX2, .MenuPositionX2 + .MaxDifferenceX)
                AllChanged+ = ChangeValue(.MaxPositionY1, .MenuPositionY1 + .MaxDifferenceY)
                AllChanged+ = ChangeValue(.MaxPositionY2, .MenuPositionY2 + .MaxDifferenceY)
                AllChanged+ = ChangeValue(.MinPositionX1, .MenuPositionX1 - .MaxDifferenceX)
                AllChanged+ = ChangeValue(.MinPositionX2, .MenuPositionX2 - .MaxDifferenceX)
                AllChanged+ = ChangeValue(.MinPositionY1, .MenuPositionY1 - .MaxDifferenceY)
                AllChanged+ = ChangeValue(.MinPositionY2, .MenuPositionY2 - .MaxDifferenceY)
            end if

            ' Men animieren
            .MenuPositionX1+ = .SpeedX1
            if (.MenuPositionX1 < .MinPositionX1) or (.MenuPositionX1 > .MaxPositionX1) then .SpeedX1 = -.SpeedX1
            .MenuPositionX2+ = .SpeedX2
            if (.MenuPositionX2 < .MinPositionX2) or (.MenuPositionX2 > .MaxPositionX2) then .SpeedX2 = -.SpeedX2
            .MenuPositionY1+ = .SpeedY1
            if (.MenuPositionY1 < .MinPositionY1) or (.MenuPositionY1 > .MaxPositionY1) then .SpeedY1 = -.SpeedY1
            .MenuPositionY2+ = .SpeedY2
            if (.MenuPositionY2 < .MinPositionY2) or (.MenuPositionY2 > .MaxPositionY2) then .SpeedY2 = -.SpeedY2
            if AllChanged = MaxChanged then
                .Radius+ = .RadiusSpeed
                if (.Radius < .MinRadius) or (.Radius > .MaxRadius) then
                    .RadiusSpeed = -.RadiusSpeed
                end if
            end if

            ' Mentitel
            SetFont("Comic_Bold")
                CenterPrint(.MenuPositionX1, .MenuPositionX2 + (GetTextLength(CurrentMenuTitle) mod 2), .TitlePositionY, .TitlePositionY, CurrentMenuTitle, Farbe)
            SetFont("Comic")

        end if

        ' Buttons steuern
        dim as integer Index, TMPIndex, Fault
        AnimateStatus = 0
        for Index = 1 to ubound(MenuButtons) step 1
            with MenuButtons(Index)

                ' Button animieren
                if (AnimateFlyIn = 1) then
                    with MenuButtons(Index)
                        if .PositionX <> .DestinationX then .PositionX- = .SpeedX
                        if .PositionY <> .DestinationY then .PositionY- = .SpeedY
                        if .Transparency < 255 then .Transparency+ = 15
                        if (.PositionX = .DestinationX) and (.PositionY = .DestinationY) then
                            AnimateStatus+ = 1
                        end if
                    end with
                end if

                ' Button steuern
                IsMouse = IsMouseOver(.PositionX + 5, .PositionY + 5, .PositionX + 144, .PositionY + 24)
                if IsMouse and (AnimateFlyOut = 0) and (AnimateFlyIn = 0) then
                    if (Mouse.Tasten2 and 1) = 1 then
                        if (SpielInfo.WortErraten or SpielInfo.Fertig or SpielInfo.ZeitIstUm or .Disabled) > 0 then
                            PlaySound(exepath + "\data\snd\inactive.wav", "inactive", Settings.SoundEffects)
                        else
                            Fault = 0
                            for TMPIndex = 1 to index step 1
                                if EingabeButtons(TMPIndex).Status = 2 then Fault = 1
                            next tmpindex
                            if fault = 0 then
                                .Status = 1
                                PlaySound(exepath + "\data\snd\pressdown.wav", "pressdown", Settings.SoundEffects)
                            end if
                        end if
                    end if
                    if (.Status = 1) and (Mouse.Tasten = 0) then
                        PlaySound(exepath + "\data\snd\active.wav", "active", Settings.SoundEffects)
                        MenuResult = Index
                    end if
                end if
                if Mouse.Tasten = 0 and .Status = 1 then
                    .Status = 0
                    PlaySound(exepath + "\data\snd\pressdown.wav", "pressdown", Settings.SoundEffects)
                end if

                ' und anzeigen
                DrawBox(.PositionX + 5, .PositionY + 5, .PositionX + 155, .PositionY + 33, 11, rgb(255, 0, 255), rgb(50, 0, 50), 30)
                put(.PositionX, .PositionY), MenuButton, alpha, .Transparency
                if .Disabled = 0 then
                    CenterPrint(.PositionX, .PositionX + 149 + .Status, .PositionY + .Status, .PositionY + 25, .Caption, (1 - IsMouse) * Farbe + (IsMouse * rgb(200, 200, 200)))
                else
                    CenterPrint(.PositionX, .PositionX + 149 + .Status, .PositionY + .Status, .PositionY + 25, .Caption, Farbe)
                end if

            end with
        next Index

    end with

    ' Animation abgeschlossen?
    if AnimateStatus = ubound(MenuButtons) then AnimateFlyIn = 0

end sub

' *****************************************************************************
' Diese SUB speichert den Highscore ab
sub SpeicherHighScore ()

    ' Variablen
    dim as integer f, SpielModusHighScore, Index, SpielerScore
    dim as string Zeile, SpielerName

    ' Datei ffnen
    f = freefile
    open exepath + "\data\score.dat" for output as #f

    ' einzelne Highscores speichern
    for SpielModusHighScore = 2 to 5 step 1

        ' welcher Highscore?
        print #f, "[SpielModus = " & trim$(str$(SpielModusHighScore)) & "]"

        ' alle 5 Eintrge speichern
        for Index = 1 to 5 step 1
            with HighScoreData(SpielModusHighScore, Index)
                write #f, .SpielerName, .SpielerScore
            end with
        next Index

    next SpielModusHighScore

    ' Datei schlieen
    close #f

end sub

' *****************************************************************************
' Diese SUB beendet einen Sound
sub StopSound (sAlias as string)

    mciSendString "stop " + sAlias, 0, 0, 0 
    mciSendString "close " + sAlias, 0, 0, 0

end sub

' *****************************************************************************
' Die FUNCTIONs:

' *****************************************************************************
' Diese FUNCTION passt einen Ausdruck an eine String-Lnge an
function AdaptStringLength (Ausdruck as string, Font as string, Length as integer) as string

    ' Variablen
    dim as integer OldFont
    dim as string TmpAusdruck

    ' alten Font speichern
    OldFont = CurrentFont

    ' Font setzen
    SetFont(Font)

    ' Lnge anpassen?
    TmpAusdruck = Ausdruck
    if (GetTextLength(TmpAusdruck) > Length) then
        do
            if len(TmpAusdruck) then 
                TmpAusdruck = left$(TmpAusdruck, len(TmpAusdruck) - 1)
            else
                exit do
            end if
        loop until GetTextLength(TmpAusdruck) <= Length - GetTextLength("...")
        TmpAusdruck+ = "..."
    end if

    ' Font wieder zurcksetzen
    SetFont(FontData(OldFont).Font)

    ' Wert zurckgeben
    return TmpAusdruck

end function

' *****************************************************************************
' Diese FUNCTION errechnet die Punkte des Spielers
function CalculateScore () as integer

    ' Variablen
    dim as integer Index
    dim as string Enthalten, NichtEnthalten, Zeichen

    ' Wie viele der gedrckten Buchstaben waren im Wort enthalten?
    Enthalten = ""
    NichtEnthalten = ""
    for Index = 1 to len(SpielInfo.Buchstaben) step 1
        Zeichen = lcase$(mid$(SpielInfo.Buchstaben, Index, 1))
        if instr(lcase$(SpielInfo.GesuchtesWort), Zeichen) then
            if instr(Enthalten, Zeichen) = 0 then Enthalten+ = Zeichen
        else
            if instr(NichtEnthalten, Zeichen) = 0 then NichtEnthalten+ = Zeichen
        end if
    next Index

    ' Punktestand berechnen
    return ((2 * len(Enthalten)) - len(NichtEnthalten))

end function

' *****************************************************************************
' Diese FUNCTION wandelt eine Sekundenzeit in Minuten und Sekunden um
function CalculateTime (Zeit as integer) as string

    ' Variablen
    dim as string Minutes, Seconds

    ' Berechnung der Werte
    Seconds = trim$(str$(Zeit mod 60))
    Minutes = trim$(str$(Zeit \ 60))
    if len(Seconds) = 1 then Seconds= "0" & Seconds
    if len(Minutes) = 1 then Minutes = "0" & Minutes

    ' Wert zurckgeben
    return Minutes & ":" & Seconds

end function

' *****************************************************************************
' Diese FUNCTION nhert den einen Wert dem anderen Wert an
function ChangeValue (IstWert as integer, SollWert as integer, Speed as integer = 10) as integer

    dim Dummy as integer

    for Dummy = 1 to Speed step 1
        if IstWert < SollWert then
            IstWert+ = 1
        elseif IstWert > SollWert then
            IstWert- = 1
        end if
    next Dummy
    if IstWert = SollWert then return 1 else return 0

end function

' *****************************************************************************
' Diese FUNCTION fungiert als einfache EIngaberoutine
function Eingabe (Ausdruck as string, MaxLength as integer, Font as string) as string

    ' Variablen
    dim as integer OldFont

    ' Tastatureingabe auswerten
    select case Taste
        ' Backspace
        case chr$(8)
            if len(Ausdruck) then
                Ausdruck = left$(Ausdruck, len(Ausdruck) - 1)
                PlaySound(exepath + "\data\snd\pressdown.wav", "pressdown", Settings.SoundEffects)
            else
                PlaySound(exepath + "\data\snd\inactive.wav", "inactive", Settings.SoundEffects)
            end if
        ' Escape?
        case chr$(27)
            Ausdruck = ""
            PlaySound(exepath + "\data\snd\pressdown.wav", "pressdown", Settings.SoundEffects)
        ' Alphanumerisches Zeichen
        case chr$(31) to chr$(127)
            OldFont = CurrentFont
            SetFont(Font)
            if GetTextLength(Ausdruck + Taste) < MaxLength then
                Ausdruck+ = Taste
                PlaySound(exepath + "\data\snd\pressdown.wav", "pressdown", Settings.SoundEffects)
            else
                PlaySound(exepath + "\data\snd\inactive.wav", "inactive", Settings.SoundEffects)
            end if
            SetFont(FontData(OldFont).Font)
    end select

    ' Ausdruck zurckgeben
    return Ausdruck

end function

' *****************************************************************************
' Diese FUNCTION gibt die aktuelle Position innerhalb eine Sound-Alias zurck
function GetCurrentPosition (sAlias as string) as long

    dim sBuffer as string * 255
    mcisendstring "status " + sAlias + " position", sBuffer, len(sBuffer), 0
    return val(sBuffer)

end function

' *****************************************************************************
' Diese FUNCTION extrahiert den Dateinamen aus einer Pfadangabe
function GetFileName (TextDatei as string) as string

    ' Variablen
    dim as integer Length, Position
    dim as string Zeichen, Datei

    ' Pfad abscannen
    Length = len(TextDatei)
    for Position = Length to 1 step -1
        Zeichen = mid$(TextDatei, Position, 1)
        if Zeichen <> chr$(92) then
            Datei = Zeichen + Datei
        else
            exit for
        end if
    next Position

    ' Wert zurckgeben
    return Datei

end function

' *****************************************************************************
' Diese FUNCTION ermittelt die Breite eines Fonts
function GetFontXWidth (FontName as string) as integer

    dim fontsize as string * 1
    f = freefile
    open exepath + "\data\font" + chr$(92) + FontName + ".jbfnt" for binary access read as #f
        get #f, , fontsize
    close #f
    return asc(fontsize)    

end function

' *****************************************************************************
' Diese FUNCTION ermittelt die Hhe eines Fonts
function GetFontYWidth (FontName as string) as integer

    dim fontsize as string * 1
    f = freefile
    open exepath + "\data\font" + chr$(92) + FontName + ".jbfnt" for binary access read as #f
        get #f, , fontsize
        get #f, , fontsize
    close #f
    return asc(fontsize)    

end function

' *****************************************************************************
' Diese FUNCTION erstellt einen String a la "10 Punkte"
function GetScoreString () as string

    ' Variablen
    dim as string Punkte

    ' String zusammenbauen
    Punkte = trim$(str$(SpielInfo.SpielerScore))
    if (val(Punkte) = 1) or (val(Punkte) = -1) then
        Punkte+ = " Punkt"
    else
        Punkte+ = " Punkte"
    end if

    ' String zurckgeben
    return Punkte

end function

' *****************************************************************************
' Diese FUNCTION gibt die Lnge eines Sound-Alias zurck
function GetSoundLength (sAlias as string) as long

    dim sBuffer as string * 255
    mcisendstring "status " + sAlias + " length", sBuffer, len(sBuffer), 0
    return val(sBuffer)

end function

' *****************************************************************************
' Diese FUNCTION ermittelt die Breite eines Textes im geladenen Font
function GetTextLength (Text as string) as integer

    dim char as string
    dim CharCount as integer
    dim TextLength as integer
    for CharCount = 1 to len(Text)
        char = mid$(Text, CharCount, 1)
        TextLength+ = FontData(CurrentFont).FontWidth(asc(char))
    next CharCount
    return TextLength

end function

' *****************************************************************************
' Diese FUNCTION berprft, ob der Spieler es in den Highscore geschafft hat
function IsHighScoreEintrag (Score as integer, SpielModus as integer) as integer

    ' Hat der Spieler es geschafft?
    if (Score >= HighScoreData(SpielModus, 5).SpielerScore) then
        return 1
    else
        return 0
    end if

end function

' *****************************************************************************
' Diese FUNCTION berprft, ob sich die Maus ber einer bestimmten Stelle befindet
function IsMouseOver (xmin as integer, ymin as integer, xmax as integer, ymax as integer) as integer

    with Mouse
        if (.PositionX >= xmin) and (.PositionY >= ymin) and (.PositionX <= xmax) and (.PositionY <= ymax) then
            return 1
        else
            return 0
        end if
    end with

end function

' *****************************************************************************
' Diese FUNCTION berprft, ob ein Wort vollstndig erraten wurde
function IstFertig (Wort as string) as integer

    ' Variablen
    dim as integer Index
    dim as string Zeichen

    ' Wort abscannen
    for Index = 1 to len(Wort) step 1
        Zeichen = mid$(Wort, Index, 1)
        if Zeichen = "_" then return 0
    next Index
    return 1

end function

' *****************************************************************************
' Diese FUNCTION erstellt den Windows-API-Datei-Laden-Dialog
function SearchFile (Titel as string, Pfad as string, Filter as string) as string

    ' TYPE fr den Datei-ffnen-Dialog
    dim as OpenFileName OpenSaveData

    ' Einstellungen festlegen
    with OpenSaveData

        dim as string * 2048 Datei, DateiTitel
        Datei = space$(2047) + chr$(0)
        DateiTitel = string$(2048, chr$(0))
        .lStructSize = len(OpenSaveData)
        .hwndOwner = 0
        .hInstance = 0
        .lpstrFilter = strptr(Filter)
        .nFilterIndex = 1
        .lpstrFile = strptr(Datei)
        .nMaxFile = len(Datei)
        .lpstrFileTitle = strptr(DateiTitel)
        .nMaxFileTitle = len(DateiTitel)

        ' Vorgegebenes Verzeichnis
        .lpstrInitialDir = strptr(Pfad)

        ' Titel festlegen
        .lpstrTitle = strptr(Titel)

        ' Datei geladen?
        if GetOpenFileName(@OpenSaveData) then return trim$(Datei)

    end with

end function

' *****************************************************************************
' Diese FUNCTION sucht ein Wort aus
function SucheWort () as string

    ' Variablen
    dim as integer Index, BegriffCount

    ' alten Begriff suchen und neuen ermitteln
    BegriffCount = ubound(BegriffeInDerGruppe)
    for Index = 1 to BegriffCount step 1
        if trim$(SpielInfo.GesuchtesWort) = "" then
            return BegriffeInDerGruppe(1)
        elseif (lcase$(BegriffeInDerGruppe(Index)) = lcase$(SpielInfo.GesuchtesWort)) then
            if (Index < BegriffCount) then
                return BegriffeInDerGruppe(Index + 1)
            else
                LadeBegriffeZurGruppe ()
                return BegriffeInDerGruppe(1)
            end if
        end if
    next Index

end function
