'
' Easy Cash - Kasssensoftware
'
' programmiert von jb fr den Deutschen QuickBASIC Programmierwettbewerb
'
' vom 15.06.2005 bis zum 30.07.2005
'
' mehr Informationen finden Sie in den Dateien 
' 
' README.TXT und Programmerklrung.TXT 
'

' Die Prozedurdeklarationen:
'
' Hinweis: Beschreibungen zu den SUBs und FUNCTIONs sind am Ende des Hauptmoduls
'          ber ihrem jeweiligem Code zu finden.  
'

' Zu erst die FUNCTIONs:
declare function betrag$ (Wert$)
declare function center$ (Spalten, Ausdruck$)
declare function chifre$ (wort$)
declare function convert$ (Wort$, direction = 0)
declare function csr$ (csr)
declare function datum$ ()
declare function eingabe$ (wort$, KeyCode$, MaxLength)
declare function format$ (Laenge, FuehrendesZeichen$, Ausdruck$)
declare function gesamt$ (feld() as any, ProduktIndex)
declare function inklmwst$ (MwSt$, preis$) 
declare function month$ (monat$)
declare function runde$ (wert as single)
declare function welchewarengruppe$ (wgnr$)
declare function zeit$ ()

' Und dann die SUBs:
declare sub clr ()
declare sub drawbox (Title$, y, x, Zeilen, Spalten)
declare sub drawtitle ()
declare sub druck (Zeile, Spalte, Text$)
declare sub erkenne (bcode() as any, barcode$, warengruppe$, warengruppennr$, beschreibung$, preis$, mwst$, Index)
declare sub ladealles () 
declare sub ladefelder ()
declare sub rechnung (userfeld() as any, feld() as any, rech() as any, ProduktIndex, Gegeben$, Zurueck$)
declare sub speicherfelder () 
declare sub waitforkey (keycode$)

' Dynamische Felder erlauben
'$dynamic

' Die Bildschirmeinstellungen werden gesetzt
' (640 * 480)
screen 12, , 2

' Die beiden Bildschirmseiten werden gesetzt ( -> Doublebuffering!)
screenset 1, 2

' Sowie Vordergrund- und Hintergrundfarbe 
color 15, 1

' Den Pfadnamen ermitteln...
dim shared Pfad$
Pfad$ = exepath 

' Die benutzerdefinierten Typen:

' Ein Typ, der alle Einstellungen umfasst
type settings
 
 ' Anzahl der Benutzer
 anzahluser          as long
 
 ' Anzahl der gespeicherten Warengrupen
 anzahlwarengruppen  as long
 
 ' Anzahl der gespeicherten Produkte
 anzahlbarcodes      as long
 
 ' Die MwSt-Stze
 MwStE               as integer
 MwStV               as integer
 
 ' Format der Rechnung (HTML- oder Text-Datei)
 html                as integer
 txt                 as integer
 
 ' Soll die Rechnung angezeigt werden?
 zeige               as integer
 
 ' Die Kassen-Nummer oder -Bezeichnung
 kassennr            as string
 
 ' Die Filialenbilanz mit und ohne MwSt
 bilanzmitmwst       as double
 bilanzohnemwst      as double
 
 ' Und die enthaltenen MwSt-Stze (voll und ermigt)
 mwsteenthalten      as double
 mwstventhalten      as double
 
 ' Die Anzahl der verkauften Produkte
 verkaufteprodukte   as ulongint 
 
 ' Der Filialname
 filiale             as string
 
 ' Die Adresse der Filiale
 adresse             as string
 
 ' Die ffnungszeiten der Filiale
 oeffnungszeiten     as string
 
 ' Der Rechnungs-Abschlusstext
 abschlusstext       as string
 
end type

' Ein Typ, der die Benutzereigenschaften speichert
type benutzertype
 
 ' Ist der Benutzer normaler User oder Administrator? 
 user                as integer
 admin               as integer
 
 ' Der Benutzername
 benutzername        as string
 
 ' Das Passwort
 passwort            as string
 
 ' Die Anzahl der verkauften Produkte
 verkaufteprodukte   as long
 
 ' Die persnliche Bilanz
 bilanz              as single
 
 ' Die Anzahl der Rechnungen
 rechnungen          as long
 
end type 

' Typ fr die gespeicherten Produkte
type bcodetype
 
 ' Der Barcode
 barcode             as string
 
 ' Die Warengruppen-Nummer
 wgnr                as string
 
 ' Die Warengruppen-Bezeichnung
 wg                  as string
 
 ' Die Produktbeschreibung
 beschreibung        as string
 
 ' Der Preis
 preis               as string
 
 ' Die MwSt 
 mwst                as string
 
 ' Wie oft wurde das Produkt verkauft?
 wieoftverkauft      as ulongint

end type  

' Typ fr die Produkte
type producttype
 
 ' Der Index in der Rechnung
 index               as integer
 
 ' Die Anzahl
 anzahl              as string
 
 ' Der Preis
 preis               as string
 
 ' Der Barcode
 barcode             as string
 
 ' Die Warengruppe und die Warengruppen-Nummer
 wg                  as string
 wgnr                as string
 
 ' Die MwSt (ermigt oder voll)
 mwst                as string
 
 ' Eine kurze Beschreibung des Produkts
 beschreibung        as string

end type

' Typ fr die Warengruppen
type wgruppe
 
 ' Die Warengruppe und ihre Nummer
 wg                  as string
 nr                  as string
 
end type

' Typ fr die Rechnung
type rechnungstype
 
 ' Die Anzahl
 anzahl              as string
 
 ' Der Preis
 preis               as string
 
 ' Die kurze Beschreibung 
 beschreibung        as string
 
 ' Die MwSt (ermigt oder voll)
 mwst                as string
 
 ' Die Warengruppe
 wg                  as string

end type    


' Die Variablen:

' Der aktuelle Benutzer
dim shared BenutzerIndex

' *Eine* Variable fr alle Einstellungen
dim shared Einstellungen as settings

' Die Einstellungen werden geladen
ladealles

' Die Datenfelder dimensionieren
with Einstellungen 

 ' Enthlt die Benutzer mit ihren Einstellungen
 dim shared user(.anzahluser) as benutzertype
 
 ' Enthlt die gespeicherten Produkte
 dim shared barcode(.anzahlbarcodes) as bcodetype

 ' Enthlt die Bezeichnungen zur jeweiligen Warengruppe
 dim shared warengruppe(.anzahlwarengruppen) as wgruppe

end with

' Und die Datenfelder mit Inhalten aus den externen Dateien fllen
ladefelder 

' Die Variable task$, die den Programmablauf steuert, wird auf den Startwert, d.h. 
' auf "anmeldung", gesetzt
' Aus bersichtlichkeitsgrnden wird hier ein String verwendet.
task$ =  "anmeldung"

do

 ' Bilschirm grau fllen 
  clr ()
 
 ' Ein blinkender Cursor
  csrzaehler+=1
  if csrzaehler > 40 then csrzaehler = 0
  
 ' Die Tastaturabfrage 
  TastaturEingabe$ = inkey$ 
 
 ' Die berschrift mit Datum und Uhrzeit
  drawtitle 
 
 ' Damit der Prozessor nicht voll ausgelastet wird
  sleep 3
 
  ' Die Abfrage der Variable task$
  select case lcase$(task$)
  
   
   ' Der Begrungsbildschirm
   case "anmeldung"
    
    drawbox "Anmeldung", 8, 11, 9 + Einstellungen.anzahluser , 50
    druck 10, 13, "Hallo! Willkommen bei Easy Cash!"
    druck 12, 13, "Um sich anzumelden, drcken Sie bitte"
    druck 13, 13, "die entsprechende Taste!"
    
    ' Zeige alle User an
    for i = 1 to Einstellungen.anzahluser
     
     ' Ist der User Administrator oder normaler Benutzer?
     if user(i).admin then 
      status$ = "(Administrator/in)"
     else
      status$ = "(Benutzer/in)"
     end if 
     
     ' Namen und Status mit einem fortlaufenden Buchstaben anzeigen  
     druck 14 + i, 13, "[" + chr$(96 + i) + "] " + user(i).Benutzername 
     druck 14 + i, 37, status$
     
     ' Wurde der fortlaufende Buchstabe gedrckt, weiter zu Passworteingabe
     if lcase$(Tastatureingabe$) = chr$(96 + i) then 
      BenutzerIndex = i 
      pw$ = ""
      task$ = "passworteingabe"
     end if
    
    next i
    
    ' Oder das Ganze benden
    druck 15 + i, 13, "[" + chr$(96 + i) + "] Beenden" 
    
    ' Die Auswertung der Tastatureingabe
    select case lcase$(Tastatureingabe$)
     ' Beenden
     case chr$(27), chr$(96 + i)
      end
    end select    
    
   ' Der Benutzer meldet sich an 
   case "passworteingabe"
    
    drawbox "Anmeldung", 8, 11, 8, 40
    druck 10, 13, "Hallo, " + user(BenutzerIndex).Benutzername + "!"
    druck 11, 13, "Bitte geben Sie Ihr Passwort ein!"
    
    ' Die Eingabe
    pw$ = eingabe$(pw$, TastaturEingabe$, 20)
    
    ' Und Sternchenanzeige
    druck 13, 13, "--> " + string$(len(pw$), "*") + csr$(csrzaehler)
    
    ' Die Auswertung der Tastatureingabe
    select case lcase$(TastaturEingabe$)
     
     ' Enter
     case chr$(13)
      ' Richtiges Passwort?
      if pw$ = user(BenutzerIndex).passwort then 
       
       druck 15, 13, "Passwort korrekt. Weiter mit ENTER."
       screencopy
       waitforkey chr$(13)
       
       ' Weiter zum entsprechenden Men
       if user(BenutzerIndex).user then 
        task$ = "usermenu"
       else
        task$ = "adminmenu"
       end if    
      
      ' Falsches Passwort
      else
       
       druck 15, 13, "Passwort falsch. Beenden mit ENTER."
       screencopy
       waitforkey chr$(13)
       end
      
      end if    
     
     ' Escape
     case chr$(27)
      task$ = "anmeldung"   
    
    end select
      
   
   ' Das Men fr den Kassierer/die Kassiererin  
   case "usermenu" 
    
    drawbox "Men", 8, 11, 7, 37
    druck 10, 13, "Bitte whlen Sie einen Menpunkt!"
    druck 12, 13, "[a] Produkteingabe"
    druck 13, 13, "[b] Zurck"
    druck 14, 13, "[c] Beenden"
    
    ' Die Auswertung der Tastatureingabe
    select case lcase$(Tastatureingabe$)
     
     case "a"
      redim Produkt(1) as producttype
      EingabeIndex = 1
      ProduktIndex = 1
      MaxProduktIndex = 1
      task$ = "produkteingabe"
     
     ' Escape oder "b"
     case chr$(27), "b"
      task$ = "anmeldung"
     
     case "c"
      end
     
     end select 
     
   
   ' Das Herzstck: Die Produkteingabe
   case "produkteingabe"
    
    drawbox "Produkteingabe", 8, 11, 17, 48
    druck 10, 13, "Strg + L : Aktuelles Produkt lschen"
    druck 11, 13, "Strg + R : Rechnung erstellen"
    druck 12, 13, "Escape   : Zurck"
    
    ' Fehlermeldung wenn die Eingabe noch nicht vollstndig ist
    if not neueeingabe then druck 25, 13, "Achtung: Ihre Eingabe enthlt noch Fehler!" 
    
    ' Aktuelle Produktnummer anzeigen
    druck 14, 13, "Produkt            : " + ltrim$(str$(ProduktIndex)) 
    
    with Produkt(ProduktIndex)
    
    ' Den Preis inklusive MwSt anzeigen
    druck 15, 13, "Preis (inkl. MwSt) : " + inklmwst$(.mwst, .preis) + " EUR"
    
    ' Die gerade einzugebende Eigenschaft mit einem "*" markieren
    druck 16 + EingabeIndex, 13, "*"
    
    ' Kann ein neues Produkt eingegeben werden?
    if val(.anzahl) <= 0 then neueeingabe = 0
    if val(.preis) < 0 then neueeingabe = 0
    neueeingabe = len(rtrim$(ltrim$(.barcode))) * len(.anzahl)
    
    ' Ein benutzerdefinierter Barcode wurde eingegeben 
    if lcase$(.barcode) = "user" then 
      
      MaxIndex = 7 
      .wg = "Sonstiges"
      .wgnr = " - "
      neueeingabe = neueeingabe * len(.preis) * len(.beschreibung) * len(.mwst)
      if val(.preis) < 0 or val(.anzahl) <= 0 then neueeingabe = 0
      if lcase$(.mwst) <> "e" and lcase$(.mwst) <> "v" then neueeingabe = 0 
    
    ' Ein normaler 13-stelliger Barcode 
    elseif len(.barcode) = 13 then 
      
      'Suche den Barcode aus den gespeicherten Produkten heraus
      erkenne barcode(), .barcode, .wg, .wgnr, .beschreibung, .preis, .mwst, .index
      MaxIndex = 2
    
    ' Andernfalls gebe garnichts aus
    else  
      
      .wg = "": .wgnr = "": .beschreibung = "": .preis = "": .mwst = ""
      MaxIndex = 2
    
    end if    
     
    ' Welche Eigenschaft ist momentan einzugeben?
    select case EingabeIndex
     
     ' Der Barcode
     case 1
     .barcode = eingabe$(.barcode, TastaturEingabe$, 13)
      druck 17, 36 + len(.barcode), csr$(csrzaehler)
     
     ' Die Anzahl
     case 2
      .anzahl = eingabe$(.anzahl, TastaturEingabe$, 5)
      druck 18, 36 + len(.anzahl),  csr$(csrzaehler)
     
     ' Der Preis
     case 3
      .preis = eingabe$(.preis, TastaturEingabe$, 8)
      druck 19, 36 + len(.preis), csr$(csrzaehler)
     
     ' Die Beschreibung
     case 6
      .beschreibung = eingabe$(.beschreibung, TastaturEingabe$, 20)
      druck 22, 36 + len(.beschreibung), csr$(csrzaehler)
     
     ' Die MwSt-Gruppe 
     case 7
      .mwst = eingabe$(.mwst, TastaturEingabe$, 1)
      druck 23, 36 + len(.mwst), csr$(csrzaehler)
    
    end select
    
    ' Das Ganze ausgeben
    druck 17, 15, "Barcode            : " + .barcode
    druck 18, 15, "Anzahl             : " + .anzahl
    druck 19, 15, "Preis (exkl. MwSt) : " + .preis
    druck 20, 15, "Warengruppe        : " + .wg
    druck 21, 15, "WG-Nummer          : " + .wgnr
    druck 22, 15, "Beschreibung       : " + .beschreibung
    druck 23, 15, "MwSt (E/V)         : " + .mwst
    
    end with
    
    ' Die Auswertung der Tastatureingabe
    select case TastaturEingabe$
     
     ' Cursor hoch
     case chr$(255) + "H"
      
      ' Die vorherige einzugebende Eigenschaft
      if EingabeIndex > 1 then EingabeIndex = EingabeIndex - 1
      if EingabeIndex = 5 then EingabeIndex = 3
     
     ' Cursor runter
     case chr$(255) + "P"
      
      ' Die nchste einzugebende Eigenschaft 
      if EingabeIndex < MaxIndex then 
       EingabeIndex = EingabeIndex + 1
       if EingabeIndex = 4 then EingabeIndex = 6
      end if
     
     ' Escape
     case chr$(27)
      
      ' Zurck zum jeweiligen Men
      if user(BenutzerIndex).admin then 
       task$ = "adminmenu"
      else 
       task$ = "usermenu"
      end if
     
     ' PgUp
     case chr$(255) + "I" 
      
      ' Wenn aktuelle Eingabe vollstndig, springe zurck zum vorherigen Produkt
      if neueeingabe then  
       if ProduktIndex > 1 then ProduktIndex = ProduktIndex - 1
      end if
     
     ' PgDn
     case chr$(255) + "Q"
      
      ' Wenn aktuelle Eingabe vollstndig, springe weiter zum nchsten Produkt und
      ' erweitere das Feld um einen - noch leeren - Eintrag
      if neueeingabe then 
       ProduktIndex = ProduktIndex + 1
       EingabeIndex = 1
       if ProduktIndex > MaxProduktIndex then 
        MaxProduktIndex = ProduktIndex  
        redim preserve Produkt(ProduktIndex) as producttype
       end if
      end if
     
     ' Strg+L
     case chr$(12)
      if ProduktIndex > 0 then 
       
       ' Das zu lschende Produkt liegt mitten drin
       if MaxProduktIndex > 1 and MaxProduktIndex <> ProduktIndex then 
        for i = ProduktIndex to MaxProduktIndex - 1
         Produkt(i) = Produkt(i + 1)
        next i    
        MaxProduktIndex = MaxProduktIndex - 1
        redim preserve Produkt(MaxProduktIndex) as producttype
       
       ' Das zu lschende Produkt liegt am Ende 
       elseif MaxProduktIndex = ProduktIndex then  
        with Produkt(ProduktIndex)
         .barcode = ""
         .anzahl = ""
         .preis = ""
         .wg = ""
         .wgnr = ""
         .beschreibung = ""
         .mwst = ""
        end with 
        MaxProduktIndex = MaxproduktIndex - 1
        if ProduktIndex > 1 then ProduktIndex = ProduktIndex - 1
       
       ' Das zu lschende Produkt ist der erste Eintrag im Feld
       elseif MaxProduktIndex = 1 then  
        redim produkt(1) as producttype
        MaxProduktIndex = ProduktIndex
       end if
      end if 
     
     ' Strg+R
     case chr$(18)
      
      ' Ist die Eingabe vollstndig?
      if neueeingabe then 
       
       ' Weiter geht's zur Rechnung
       Gegeben$ = ""
       task$ = "rechnung"
      
      end if
    
    end select    
   
   
   ' Das Men fr den Filialleiter/die Filialleiterin
   case "adminmenu"
    
    drawbox "Men", 8, 11, 8, 37
    druck 10, 13, "Bitte whlen Sie einen Menpunkt!"
    druck 12, 13, "[a] Produkteingabe"
    druck 13, 13, "[b] Manager"
    druck 14, 13, "[c] Sonstiges"
    druck 15, 13, "[d] Zurck"
    
    ' Die Auswertung der Tastatureingabe
    select case lcase$(TastaturEingabe$)
     
     case "a"
      redim Produkt(1) as producttype
      EingabeIndex = 1
      ProduktIndex = 1
      MaxProduktIndex = 1
      task$ = "produkteingabe" 
     
     case "b"
      task$ = "manager"   
     
     case "c"
      task$ = "sonstiges"
     
     ' Escape oder "d"
     case chr$(27), "d"
      task$ = "anmeldung"   
     
     end select
     
   
   ' Das Men fr den Benutzer-, Produkte und Warengruppenmanager
   case "manager"
    
    drawbox "Manager", 8, 11, 8, 37
    druck 10, 13, "Bitte whlen Sie einen Menpunkt!"
    druck 12, 13, "[a] Benutzermanager"
    druck 13, 13, "[b] Produktemanager"
    druck 14, 13, "[c] Warengruppenmanager"
    druck 15, 13, "[d] Zurck"
    
    ' Die Auswertung der Tastatureingabe
    select case lcase$(Tastatureingabe$)
     
     case "a"
      OldIndex = Einstellungen.anzahluser
      KontoIndex = 1
      EingabeIndex = 1
      MaxKontoIndex = Einstellungen.anzahluser
      task$ = "benutzermanager"
     
     case "b"
      OldIndex = Einstellungen.anzahlbarcodes 
      MaxIndex = Einstellungen.anzahlbarcodes
      ProduktIndex = 1
      EingabeIndex = 1
      task$ = "produktemanager"
     
     case "c"
      OldIndex = Einstellungen.anzahlwarengruppen
      WarengruppenIndex = 1
      EingabeIndex = 1
      MaxIndex = Einstellungen.anzahlwarengruppen
      task$ = "warengruppenmanager"
     
     ' Escape oder "d"
     case chr$(27), "d"
      task$ = "adminmenu"
    
    end select
     
   
   ' Der Benutzermanager zum Erstellen/Bearbeiten/Lschen von Benutzerkonten
   case "benutzermanager"
    
    drawbox "Benutzermanager", 8, 11, 15, 50
    druck 10, 13, "Strg + S : Speichern und zurck"
    druck 11, 13, "Strg + L : Aktuellen Benutzer lschen"
    druck 12, 13, "Escape   : Zurck"
    
    ' Zeige die Nummer des aktuellen Benutzerkontos an 
    druck 14, 13, "Aktuelles Benutzerkonto: " + trim$(str$(KontoIndex))
    
    with user(KontoIndex)
     
     ' Ist die aktuelle Eingabe vollstndig?
     neueruser = len(trim$(.benutzername)) * len(trim$(.passwort)) 
     
     ' Ist das nicht der Fall, informiere den User
     if not neueruser then druck 23, 13, "Fehler: Eingabe noch nicht vollstndig!"
     
     ' Zeige die Daten an
     druck 16, 15, "Benutzername        : " + .benutzername
     druck 17, 15, "Passwort            : " + .passwort
     druck 18, 15, "Persnliche Bilanz  : " + trim$(str$(.bilanz)) 
     druck 19, 15, "Verkaufte Produkte  : " + trim$(str$(.verkaufteprodukte))
     druck 20, 15, "Anzahl Rechnungen   : " + trim$(str$(.rechnungen))
     
     ' Die aktuell einzugebende Eigenschaft mit einem "*" markieren
     druck 15 + EingabeIndex, 13, "*"
         
     ' Die aktuelle einzugebende Eingenschaft
     select case EingabeIndex
      
      ' Der Benutzername
      case 1
       druck 16, 37 + len(.benutzername), csr$(csrzaehler)
       .benutzername = eingabe$(.benutzername, TastaturEingabe$, 20)
      
      ' Das Passwort
      case 2
       druck 17, 37 + len(.passwort), csr$(csrzaehler)
      .passwort = eingabe$(.passwort, TastaturEingabe$, 20)
      
      ' Die persnliche Bilanz
      case 3
       druck 18, 37 + len(trim$(str$(.bilanz))), csr$(csrzaehler)   
       .bilanz = val(eingabe$(str$(.bilanz), TastaturEingabe$, 9))
      
      ' Die Anzahl der verkauften Produkte
      case 4
       druck 19, 37 + len(trim$(str$(.verkaufteprodukte))), csr$(csrzaehler)
       .verkaufteprodukte = val(eingabe$(str$(.verkaufteprodukte), TastaturEingabe$, 9))
      
      ' Die Anzahl der Rechnungen
      case 5
       druck 20, 37 + len(trim$(str$(.rechnungen))), csr$(csrzaehler)
       .rechnungen = val(eingabe$(str$(.rechnungen), TastaturEingabe$, 9))
     
     end select
    
     ' Die Auswertung der Tastatureingabe
     select case TastaturEingabe$
      
      ' Escape 
      case chr$(27)
       
       ' Alles resetten
       redim user(OldIndex) as benutzertype
       ladealles
       ladefelder
       task$ = "manager"
     
      ' PgDn
      case chr$(255) + "Q"
       
       ' Wenn eine neue Eingabe mglich ist, springe zum nchsten Benutzer
       if neueruser and KontoIndex < 10 then  
        EingabeIndex = 1
        KontoIndex = KontoIndex + 1
        if KontoIndex > MaxKontoIndex then 
         MaxKontoIndex = KontoIndex 
         redim preserve user(KontoIndex) as benutzertype
         .admin = 0
         .user = 1
       end if    
      end if
     
     ' PgUp
     case chr$(255) + "I"
      
      ' Wenn die aktuelle Eingabe vollstndig ist, springe zum vorherigen Benutzer 
      if neueruser then 
       if KontoIndex > 1 then 
        KontoIndex = KontoIndex - 1
        EingabeIndex = 1
       end if
      end if
     
     ' Cursor hoch
     case chr$(255) + "H"
      
      ' Springe zur vorherigen einzugebenden Eigenschaft
      if EingabeIndex > 1 then EingabeIndex = EingabeIndex - 1
     
     ' Cursor runter
     case chr$(255) + "P"
      
      ' Springe zur nchsten einzugebenden Eigenschaft
      if EingabeIndex < 5 then EingabeIndex = EingabeIndex + 1
     
     ' Strg+S
     case chr$(19)
      
      ' Die nderungen speichern - aber nur, wenn die aktuelle Eingabe 
      ' vollstndig ist
      
      if neueruser then 
       Einstellungen.anzahluser = MaxKontoIndex
       speicherfelder 
       druck 22, 13, "nderungen gespeichert. Weiter mit ENTER."
       screencopy
       waitforkey chr$(13)
       task$ = "manager"
      end if    
     
     ' Strg+L
     case chr$(12)
      
      ' Sein eigenes Konto kann man nicht lschen
      if KontoIndex <> BenutzerIndex then 
       
       ' Das zu lschende Konto liegt in der Mitte des Feldes
       if KontoIndex > 1 and KontoIndex <> MaxKontoIndex then 
        for i = KontoIndex to MaxKontoIndex - 1
         user(i) = user(i + 1)
        next i    
        MaxKontoIndex = MaxKontoIndex - 1
        redim preserve user(MaxKontoIndex) as benutzertype
       
       ' es liegt ganz am Ende des Feldes
       elseif KontoIndex = MaxKontoIndex then 
        with user(KontoIndex)
         .benutzername = ""
         .passwort = ""
         .bilanz = 0
         .verkaufteprodukte = 0
         .admin = 0
         .user = 1
         .rechnungen = 0
        end with    
        MaxKontoIndex = MaxKontoIndex - 1
        if KontoIndex > 1 then KontoIndex = KontoIndex - 1    
       
       ' Es liegt ganz am Anfang des Feldes
       elseif MaxKontoIndex = 1 then 
        redim user(1) as benutzertype
        MaxKontoIndex = KontoIndex
       end if    
      
      end if    
    
    end select    
    
    end with
   
   
   ' Der Warengruppenmanager zum Erstellen/Bearbeiten/Lschen von Warengruppen
   case "warengruppenmanager"
    
    drawbox "Warengruppenmanager", 8, 11, 12, 60
    druck 10, 13, "PgUp/PgDn : Vorherige/nchste Warengruppe"
    druck 11, 13, "Strg+L    : Warengruppe lschen"
    druck 12, 13, "Strg+S    : Speichern + Zurck"
    druck 13, 13, "Escape    : Zurck"
    druck 15, 13, "Aktuelle Warengruppen-Nummer   : " + warengruppe(WarengruppenIndex).nr
    druck 17, 15, "Aktuelle Bezeichnung         : " + warengruppe(WarengruppenIndex).wg + csr$(csrzaehler)
    
    with warengruppe(WarengruppenIndex)
    
    ' Ist die aktuell einzugebende Eigenschaft vollstndig?
    neueeingabe = len(.wg)
    
    ' Wenn dem nicht so ist, informiere den User
    if not neueeingabe then druck 19, 13, "Fehler: Eingabe noch nicht vollstndig!"
    
    ' Markiere die aktuell einzugebende Eingenschaft mit einem "*"
    druck 17, 13, "*"
    
    ' Die Eingabe der Warengruppenbezeichnung
    .wg = eingabe$(.wg, TastaturEingabe$, 20)   
    
    end with
    
    ' Die Auswertung der Tastatureingabe
    select case TastaturEingabe$
     
     ' Escape
     case chr$(27)
      redim warengruppe(OldIndex) as wgruppe
      ladealles
      ladefelder 
      task$ = "manager"
     
     ' PgUp
     case chr$(255) + "I"
      
      ' Wenn eine neue Eingabe mglich ist, springe zur vorherigen Warengruppe
      if neueeingabe then  
       if WarengruppenIndex > 1 then WarengruppenIndex = WarengruppenIndex - 1   
      end if
     
     ' PgDn
     case chr$(255) + "Q"
      
      ' Wenn eine neue Eingabe mglich ist, springe zur nchsten Warengruppe
      if neueeingabe then 
       WarengruppenIndex = WarengruppenIndex + 1
       if WarengruppenIndex > MaxIndex then
        MaxIndex = WarengruppenIndex
        redim preserve shared warengruppe(WarengruppenIndex)
        warengruppe(WarengruppenIndex).nr = ltrim$(str$(WarengruppenIndex))
       end if
      end if    
     
     ' Strg+S
     case chr$(19)
      
      ' Wenn eine neue Eingabe mglich ist, speichere die Einstellungen
      if neueeingabe then   
       Einstellungen.anzahlwarengruppen = MaxIndex
       speicherfelder 
       ladefelder 
       druck 19, 13, "nderungen gespeichert. Weiter mit ENTER."
       screencopy
       waitforkey chr$(13)
       task$ = "manager"
      end if
     
     ' Strg+L
     case chr$(12)
      if WarengruppenIndex > 0 then 
       
       ' Die aktuelle Warengrupe liegt mitten im Feld      
       if MaxIndex > 1 and MaxIndex <> WarengruppenIndex then  
        for i = WarengruppenIndex to MaxIndex - 1
         warengruppe(i) = warengruppe(i + 1)
        next i    
        MaxIndex = MaxIndex - 1
        redim preserve warengruppe(MaxIndex) as wgruppe
       
       ' Sie liegt am Ende des Feldes
       elseif MaxIndex = WarengruppenIndex then 
        with warengruppe(WarengruppenIndex)
         .wg = ""
        end with    
        MaxIndex = MaxIndex - 1
        if WarengruppenIndex > 1 then WarengruppenIndex = WarengruppenIndex - 1 
       
       ' Sie liegt am Anfang des Feldes
       elseif MaxIndex = 1 then 
        redim warengruppe(1) as wgruppe
        MaxIndex = WarengruppenIndex
       end if
      
      end if  
    
    end select
   
   
   ' Der Produktemanager zum Erstellen/Bearbeiten/Lschen von Produkten
   case "produktemanager"
    
    drawbox "Produktemanager", 8, 11, 18, 52
    druck 10, 13, "PgUp/PgDn : Nchstes/vorheriges Produkt"
    druck 11, 13, "Strg+S    : Speichern + zurck"
    druck 12, 13, "Strg+L    : Aktuelles Produkt lschen"
    druck 13, 13, "Escape    : Zurck"
    druck 15, 13, "Aktuelles Produkt : " + ltrim$(str$(ProduktIndex))
    druck 16, 13, "Preis inkl. MwSt  : " + inklmwst(barcode(ProduktIndex).mwst, barcode(ProduktIndex).preis)
    
    with barcode(ProduktIndex)
     
    ' Die aktuell einzugebende Eigenschaft mit einem "*" anzeigen 
    druck 17 + EingabeIndex, 13, "*"
    
    ' Ist eine neue Eingabe mglich?
    neueeingabe = len(.barcode) * len(.preis) * len(.wgnr)
    neueeingabe = neueeingabe * len(.beschreibung) * len(.mwst)
    if not val(.wgnr) then neueeingabe = 0 
    
    ' Wenn nicht, informiere den User
    if not neueeingabe then druck 24, 13, "Achtung: Ihre Eingabe enthlt noch Fehler!"
    
    ' Zeige alle Eigenschaften an
    druck 18, 15, "Barcode            : " + .barcode
    druck 19, 15, "Preis (exkl. MwSt) : " + .preis
    druck 20, 15, "Warengruppe        : " + welchewarengruppe$(.wgnr)
    druck 21, 15, "WG-Nummer          : " + .wgnr
    druck 22, 15, "Beschreibung       : " + left$(.beschreibung, 20)
    druck 23, 15, "MwWt (E/V)         : " + .mwst
    
    ' Die einzugebenden Eigenschaften 
    select case EingabeIndex
      
      ' Der Barcode
      case 1
       druck 18, 36 + len(.barcode), csr$(csrzaehler)  
       .barcode = eingabe$(.barcode, TastaturEingabe$, 13)
      
      ' Der Preis
      case 2
       druck 19, 36 + len(.preis), csr$(csrzaehler) 
       .preis = eingabe$(.preis, TastaturEingabe$, 10)
      
      ' Die Warengruppennummer
      case 4
       druck 21, 36 + len(.wgnr), csr$(csrzaehler) 
       .wgnr = eingabe$(.wgnr, TastaturEingabe$, 5)
      
      ' Die Beschreibung
      case 5
       druck 22, 36 + len(left$(.beschreibung, 20)), csr$(csrzaehler)     
       .beschreibung = eingabe$(left$(.beschreibung, 20), TastaturEingabe$, 20) 
      
      ' Die MwSt-Gruppe 
      case 6
       druck 23, 36 + len(.mwst), csr$(csrzaehler) 
       .mwst = eingabe$(.mwst, TastaturEingabe$, 1) 
     
     end select    
    
    end with
    
    ' Die Auswertung der Tastatureingabe
    select case TastaturEingabe$
     
     ' Escape
     case chr$(27)
      redim barcode(OldIndex) as bcodetype
      ladealles
      ladefelder 
      task$ = "manager"
     
     ' Cursor hoch
     case chr$(255) + "H"
      
      ' Springe zur vorherigen einzugebenden Eigenschaft
      if EingabeIndex > 1 then EingabeIndex = EingabeIndex - 1
      if EingabeIndex = 3 then EingabeIndex = 2
     
     ' Cursor runter
     case chr$(255) + "P" 
      
      ' Springe zur nchsten einzugebenden Eigenschaft
      if EingabeIndex < 6 then EingabeIndex = EingabeIndex + 1
      if EingabeIndex = 3 then EingabeIndex = 4 
     
     ' PgUp
     case chr$(255) + "I"
      
      ' Wenn die ektuelle Eingabe vollstndig ist, springe zum vorherigen Produkt
      if neueeingabe then  
       EingabeIndex = 1
       if ProduktIndex > 1 then ProduktIndex = ProduktIndex - 1
      end if
     
     ' PgDn
     case chr$(255) + "Q"
      
      ' Wenn die ektuelle Eingabe vollstndig ist, springe zum nchsten Produkt
      if neueeingabe then  
       EingabeIndex = 1
       Produktindex = ProduktIndex + 1
       if ProduktIndex > MaxIndex then 
        MaxIndex = ProduktIndex
        redim preserve shared barcode(MaxIndex) as bcodetype
       end if
      end if
     
     ' Strg+S
     case chr$(19)
      
      ' Wenn die aktuelle Eingabe vollstndig ist, speichere ab
      if neueeingabe then 
       Einstellungen.anzahlbarcodes = MaxIndex
       speicherfelder
       ladealles
       ladefelder
       druck 25, 13, "nderungen gespeichert. Weiter mit ENTER."
       screencopy
       waitforkey chr$(13)
       task$ = "manager"
      end if
      
     'Strg+L
     case chr$(12)
      if ProduktIndex > 0 then  
       
       ' Das zu lschende Produkt liegt mitten im Feld
       if MaxIndex > 1 and ProduktIndex <> MaxIndex then 
        for i = ProduktIndex to MaxIndex - 1
         barcode(i) = barcode(i + 1)
        next i    
        MaxIndex = MaxIndex - 1
        redim preserve barcode(MaxIndex) as bcodetype
       
       ' Das zu lschende Produkt liegt am Ende des Feldes
       elseif MaxIndex = ProduktIndex then 
        with barcode(ProduktIndex)
         .barcode = ""
         .preis = ""
         .mwst = ""
         .wgnr = ""
         .beschreibung = ""
         end with    
         MaxIndex = MaxIndex - 1
         if ProduktIndex > 1 then ProduktIndex = ProduktIndex - 1
       
       ' Das zu lschende Produkt liegt am Anfang des Feldes
       elseif MaxIndex = 1 then 
        redim shared barcode(1) as bcodetype
        MaxIndex = ProduktIndex
       end if
      end if
    
    end select    
    
   
   ' Das Men "Sonstiges"
   case "sonstiges"
    
    drawbox "Sonstiges", 8, 11, 8, 37
    druck 10, 13, "Bitte whlen Sie einen Menpunkt!"
    druck 12, 13, "[a] Mehrwertsteuersatz ndern"
    druck 13, 13, "[b] Rechnungsoptionen"
    druck 14, 13, "[c] Bilanzen"
    druck 15, 13, "[d] Zurck"
    
    ' Die Auswertung der Tastatureingabe
    select case lcase$(Tastatureingabe$)
     
     case "a"
      EingabeIndex = 1
      NeuMwStE = Einstellungen.MwStE: NeuMwStV = Einstellungen.MwStV
      task$ = "mwst"
     
     case "b"
      EingabeIndex = 1
      task$ = "rechnungsoptionen"   
     
     case "c"
      task$ = "bilanzen"
     
     ' Escape oder "d"
     case chr$(27), "d"
      task$ = "adminmenu"
    
    end select    
  
   
   ' Das Men zum ndern des Mehrwertsteuersatzes
   case "mwst"
    
    drawbox "MwSt", 8, 11, 11, 48
    druck 10, 13, "+/-      : Mehrwertsteuer ndern"
    druck 11, 13, "Strg + S : Speichern"
    druck 12, 13, "Escape   : Zurck"
    
    ' Zeige den aktuellen MWSt-Satz an
    druck 15, 13, "   Mehrwertsteuer E: " + ltrim$(str$(NeuMwStE))
    druck 16, 13, "   Mehrwertsteuer V: " + ltrim$(str$(NeuMwStV))
    
    ' Markiere die aktuell einzugebende Eigenschaft mit einem "*" 
    druck 14 + EingabeIndex, 14, "*"
     
    ' Die Auswertung der Tastatureingabe
    select case TastaturEingabe$
     
     case "+"
      
      ' Die MwSt E erhhen
      if EingabeIndex = 1 then 
       if NeuMwStE < 100 then NeuMwStE = NeuMwStE + 1
      
      ' Die MwSt V erhhen 
      else
       if NeuMwStV < 100 then NeuMwStV = NeuMwStV + 1
      
      end if    
     
     case "-"
      
      ' Die MwSt E erniedrigen
      if EingabeIndex = 1 then 
       if NeuMwStE > 0 then NeuMwStE = NeuMwStE - 1
      
      ' Die MWSt V erniedrigen
      else
       if NeuMwStV > 0 then NeuMwStV = NeuMwStV - 1    
      
      end if    
     
     'Cursor hoch
     case chr$(255) + "H"
      
      'Die MwSt E eingeben
      EingabeIndex = 1
     
     
     ' Cursor runter 
     case chr$(255) + "P" 
      
      ' Die MwSt V eingeben 
      EingabeIndex = 2 
     
     ' Strg+S
     case chr$(19)
      
      ' Abspeichern
      with Einstellungen
       .MwStE = NeuMwStE: .MwStV = NeuMwStV
      end with
      speicherfelder 
      ladefelder 
      druck 18, 13, "Einstellungen gespeichert. Weiter mit ENTER."
      screencopy
      waitforkey chr$(13)
      task$ = "sonstiges"
     
     ' Escape
     case chr$(27)
      task$ = "sonstiges"
    
    end select    
    
   
   ' Die Rechnung und alles was dazugehrt
   case "rechnung"
    
    drawbox "Rechnung", 8, 11, 12, 40
    
    ' Den Gesamtpreis ausrechnen und anzeigen
    g$ = gesamt$(Produkt(), MaxProduktIndex) 
    druck 10, 13, "Endbetrag : " + g$ + " EUR"
    
    ' Das vom Kufer gezahlte Geld eingeben und anzeigen
    druck 12, 13, "Gegeben   : " + Gegeben$ + csr$(csrzaehler)
    Gegeben$ = eingabe$(Gegeben$, TastaturEingabe$, 20) 
    
    ' Die Auswertung der Tastatureingabe
    select case lcase$(TastaturEingabe$)
     
     ' Enter
     case chr$(13)
      
      ' Hat der Kufer genug Geld bezahlt?
      if val(Gegeben$) >= val(g$) then 
       
       ' Rechne das Rckgeld aus
       geg! = val(Gegeben$): ges! = val(g$)
       Zurueck! = geg! - ges!
       Zurueck$ = Betrag$(runde$(Zurueck!))
       
       ' und zeige es an
       druck 14, 13, "Zurck    : " + Zurueck$ + " EUR"
       druck 16, 13, "Weiter mit ENTER." 
       screencopy
       waitforkey chr$(13)
       
       ' Und schreibe anschlieend die Rechnung
       redim rech(ProduktIndex) as rechnungstype 
       rechnung user(), Produkt(), rech(), MaxProduktIndex, Gegeben$, Zurueck$
       druck 18, 13, "Rechnung geschrieben."
       druck 19, 13, "Beenden mit ENTER."
       screencopy
       waitforkey chr$(13)
       
       ' Wieder zurck zum entsprechenden Men 
       if user(BenutzerIndex).user then 
        task$ = "usermenu"
       else
        task$ = "adminmenu"
       end if 
      
      ' Wenn er zu wenig gegeben hat, noch mal von vorne
      else
       
       Gegeben$ = ""
      
      end if    
     
     ' Escape
     case chr$(27)
    
      task$= "produkteingabe"
    
    end select    
    
   
   ' Das Rechnungsdesign
   case "rechnungsoptionen"
    
    drawbox "Rechnungsoptionen", 8, 11, 15, 55 
    druck 10, 13, "Enter    : Eigenschaft toggeln"
    druck 11, 13, "Strg + S : Speichern und zurck"
    druck 12, 13, "Escape   : Zurck"
    
    ' Zeige die aktuell einzugebende Eigenschaft mit einem "*" an
    druck 13 + EingabeIndex, 13, "*"
    
    with Einstellungen
     
     ' Welche Darstellung?
     if .html then art$ = "HTML-Dokument" else art$ = "Textdatei"
     
     ' Soll die Rechnung angezeigt werden?
     if .zeige then anzeige$ = "ja" else anzeige$ = "nein"
     
     ' Zeige die Einstellungen an 
     druck 14, 15, "Darstellung    : " + art$
     druck 15, 15, "Anzeigen       : " + anzeige$
     druck 16, 15, "Kassen-Nr      : " + .kassennr
     druck 17, 15, "Filialname     : " + .filiale
     druck 18, 15, "Adresse        : " + .adresse
     druck 19, 15, "ffnungszeiten : " + .oeffnungszeiten
     druck 20, 15, "Abschlusstext  : " + .abschlusstext
     
     ' Die aktuell einzugebende Eigenschaft
     select case EingabeIndex
      
      ' Die Kassenbezeichnung
      case 3
       druck 16, 32 + len(.kassennr), csr$(csrzaehler)
       .kassennr = eingabe$(.kassennr, TastaturEingabe$, 20)
      
      ' Der Filialname
      case 4
       druck 17, 32 + len(.filiale), csr$(csrzaehler)
       .filiale = eingabe$(.filiale, TastaturEingabe$, 30) 
      
      ' Die Adresse
      case 5
       druck 18, 32 + len(.adresse), csr$(csrzaehler)
       .adresse = eingabe$(.adresse, TastaturEingabe$, 30)
      
      ' Die ffnungszeiten
      case 6
       druck 19, 32 + len(.oeffnungszeiten), csr$(csrzaehler)
       .oeffnungszeiten = eingabe$(.oeffnungszeiten, TastaturEingabe$, 30)    
      
      ' Der Abschlusstext
      case 7
       druck 20, 32 + len(.abschlusstext), csr$(csrzaehler)
       .abschlusstext = eingabe$(.abschlusstext, TastaturEingabe$, 30)
     
     end select    
    
    end with
    
    ' Die Auswertung der Tastatureingabe
    select case TastaturEingabe$
     
     ' Enter
     case chr$(13)
      
      ' Entweder die Darstellungsart der Rechnung 
      if EingabeIndex = 1 then 
       Einstellungen.html = Einstellungen.html xor 1
       Einstellungen.txt = Einstellungen.txt xor 1
      
      ' oder die Anzeigeoption der Rechnung toggeln 
      elseif EingabeIndex = 2 then 
       Einstellungen.zeige = Einstellungen.zeige xor 1   
      
      end if 
     
     ' Cursor hoch
     case chr$(255) + "H"
      
      ' Zur vorherigen einzugebenden Eigenschaft springen
      if EingabeIndex > 1 then EingabeIndex = EingabeIndex - 1
     
     ' Cursor runter
     case chr$(255) + "P"
      
      ' Zur nchsten einzugebenden Eigenschaft springen
      if EingabeIndex < 7 then EingabeIndex = EingabeIndex + 1
     
     ' Escape
     case chr$(27)
      
      ladealles
      task$ = "sonstiges"   
     
     ' Strg+S
     case chr$(19)
      
      ' Abspeichern
      speicherfelder 
      ladefelder 
      druck 22, 13, "nderungen gespeichert. Weiter mit ENTER."
      screencopy
      waitforkey chr$(13)
      task$ = "sonstiges"
   
   end select
    
   
   ' Die Bilanzbersicht
   case "bilanzen"
    
    drawbox "Bilanzen", 8, 11, 8, 37
    druck 10, 13, "Bitte whlen Sie einen Menpunkt!"
    druck 12, 13, "[a] Gesamtbilanzen"
    druck 13, 13, "[b] Produktbilanzen"
    druck 14, 13, "[c] Bilanzen resetten"
    druck 15, 13, "[d] Zurck"
    
    ' Die Auswertung der Tastatureingabe
    select case lcase$(TastaturEingabe$)
     
     case "a"
      task$ = "gesamtbilanzen"  
     
     case "b"
      ProduktIndex = 1
      task$ = "produktbilanzen"
     
     case "c"
      task$ = "bilanzenresetten"   
     
     ' Escape oder "d"
     case chr$(27), "d"
      task$ = "sonstiges"   
     
     end select    
    
   ' Die Bilanzen resetten
   case "bilanzenresetten"
    
    drawbox "Bilanzen-Reset", 8, 11, 8, 49
    druck 10, 13, "Mchten Sie wirklich alle Bilanzen resetten?"
    druck 12, 13, "[a] Ja"
    druck 13, 13, "[b] Nein"
    
    ' Die Auswertung der Tastatureingabe
    select case lcase$(TastaturEingabe$)
     
     ' Escape oder "b"
     case chr$(27), "b"  
      task$ = "bilanzen"
     
     case "a"
      
      ' Schleife ber alle Produkte
      for i = 1 to Einstellungen.anzahlbarcodes
       
        ' Lsche die Anzahl der Verkufe
        barcode(i).wieoftverkauft = 0
       
      next i    
      
      ' Schleife ber alle Benutzer
      for i = 1 to Einstellungen.anzahluser
       
       ' Lsche die persnliche Bilanz eines jeden Benutzers
       with user(i)
        .bilanz = 0
        .verkaufteprodukte = 0
        .rechnungen = 0
        end with    
      
      next i    
      
      ' Lsche die Filialbilanzen
      with Einstellungen
      .verkaufteprodukte = 0
      .bilanzmitmwst = 0
      .bilanzohnemwst = 0
      .mwsteenthalten = 0
      .mwstventhalten = 0
      end with
      
      ' Speichere die nderungen ab 
      speicherfelder 
      ladefelder 
      
      ' Fertig
      druck 15, 13, "Bilanzen ressettet. Weiter mit ENTER."
      screencopy
      waitforkey chr$(13)
      task$ = "bilanzen"
    
    end select
     
   
   ' Die Produktbilanzen
   case "produktbilanzen"
    
    drawbox "Produktbilanzen", 8, 11, 8, 50
    druck 10, 13, "PgUp/PgDn : nchstes / vorheriges Produkt"
    druck 11, 13, "Escape    : Zurck"    
    
    ' Zeige das Produkt und seine Anzahl an Verkufen an
    druck 13, 13, "Aktuelles Produkt : " + barcode(ProduktIndex).beschreibung
    druck 15, 13, "Verkauft          : " + Format$(9, "0", str$(barcode(ProduktIndex).wieoftverkauft))
    
    ' Die Auswertung der Tastatureingabe
    select case TastaturEingabe$
     
     'PgDn
     case chr$(255) + "Q"
     
      ' Springe zum nchsten Produkt
      if ProduktIndex < Einstellungen.anzahlbarcodes then ProduktIndex = ProduktIndex + 1
     
     'PgUp
     case chr$(255) + "I"
      
      ' Springe zum vorherigen Produkt 
      if ProduktIndex > 1 then ProduktIndex = ProduktIndex - 1   
     
     'Escape
     case chr$(27)
      
      ladefelder
      task$ = "bilanzen"  
    
    end select  
    
   
   ' Die Gesamtbilanzen 
   case "gesamtbilanzen"
    
    drawbox "Gesamtbilanzen", 8, 11, 9, 54
    druck 10, 13, "Escape: Zurck"
    with Einstellungen
     
     ' Zeige den Gesamtumsatz an
     druck 12, 13, "Umsatz (inkl. MwSt)           : " + format$(16, " ", betrag$(str$(.bilanzmitmwst)) + " EUR")   
     
     ' Und den Umsatz exkl. MwSt
     druck 13, 13, "Umsatz (exkl. MwSt)           : " + format$(16, " ", betrag$(str$(.bilanzohnemwst)) + " EUR")
     
     ' Zeige dann die enthaltene MwSt an:  
     
     ' erst die volle MwSt
     z$ = "Darin enthaltene MwSt V (     : "
     mid$(z$, 26, len(trim$(str$(.mwstv))) + 2) = trim$(str$(.mwstv)) + "%)"
     druck 14, 13, z$ + format$(16, " ", betrag$(str$(.mwstventhalten)) + " EUR")
     
     ' und dann die ermigte MwSt
     z$ = "Darin enthaltene MwSt E (     : "
     mid$(z$, 26, len(trim$(str$(.mwste))) + 2) = trim$(str$(.mwste)) + "%)" 
     druck 15, 13, z$ + format$(16, " ", betrag$(str$(.mwsteenthalten)) + " EUR")
     
     ' Zeige die Anzahl der verkauften Produkte an
     druck 16, 13, "Verkaufte Produkte            : " + format$(16, " ", str$(.verkaufteprodukte) + " Stk")
     
     ' Die Auswertung der Tastatureingabe
     select case TastaturEingabe$
      
      ' Escape
      case chr$(27)
       
       task$ = "bilanzen"  
     
     end select    
    
    end with
  
  
  end select
  
 
 ' Und alles schn in den Primrpuffer kopieren...
 screencopy
 
loop  

end

'
' Jetzt folgen die Unterprogramme: 
'

' Zu erst kommen die FUNCTIONs:

' ******************************

' Diese FUNCTION wandelt eine Kommazahl in einen String der Form
' eines Geldbetragses um
function betrag$ (Wert$)

' Die berflssigen Leerstellen entfernen
Wert$ = rtrim$(ltrim$(Wert$))

' Das Komma suchen
k = (instr(Wert$, ".") or instr(Wert$, ","))

' Ist ein Komma enthalten?
if k then 
 
 ' Wert$ in Euro$ und Cent$ aufsplitten 
 Euro$ = left$(Wert$, k - 1)
 if len(Euro$) = 1 then Euro$ = "0" + Euro$
 Cent$ = mid$(Wert$, k + 1, 2)
 if len(Cent$) = 1 then Cent$ = Cent$ + "0"
 if len(Cent$) > 2 then Cent$ = left$(Cent$, 2)

' Kein Komma
else
 
 ' Andernfalls den Wert beibehalten und Cent$ auf "00" setzen
 if val(Wert$) then Euro$ = Wert$ else Euro$ = "00"
 if len(Euro$) = 1 then Euro$ = "0" + Euro$
 Cent$ = "00"

end if 

' Und den String zusammensetzen
betrag$ = Euro$ + "." + Cent$  

end function

' ******************************

' Diese FUNCTION zentriert einen Ausdruck in einem String bestimmter Lnge 
function center$ (Laenge, Ausdruck$)

if len(Ausdruck$) < Laenge then 
    
 ' Die Anzahl Leerstellen links und rechts
 leer# = (Laenge - len(Ausdruck$)) / 2
 
 ' Wenn Ausdruck$ eine ungerade Lnge hat, links ein Leerzeichen anfgen.
 leer = int(leer#)
 if leer# <> int(leer#) then  
  ug$ = " "
 else
  ug$ = ""
 end if  

 ' Und den String zusammensetzen
 center$ = string$(leer, " ") + ug$ + Ausdruck$ + string$(leer, " ")

end if    

end function    

' ******************************

' Diese FUNCTION gibt den mit der XOR-Methode ver-/entschlsselten Ausdruck 
' von wort$ zurck
function chifre$ (wort$)

 tmp$ = ""
 
 ' Schleife ber alle Buchstaben des Wortes
 for i = 1 to len(wort$)
  
  ' Die Verschlsselung
  tmp$ = tmp$ + chr$(asc(mid$(wort$, i, 1)) xor 1)
 
 next i    

 chifre$ = tmp$
 tmp$ = ""

end function    

' ******************************

' Diese FUNCTION liefert einen konvertierten Ausdruck zurck.
' Diese Kovertierung betrifft nur die Umlaute sowie das scharfe s, und ist in 
' beide Richtungen durchfhrbar (direction) 
function convert$ (Wort$, direction = 0)
 
 NeuerText$ = ""
 
 ' Schleife ber alle Buchstaben des Ausdrucks 
 for i = 1 to len(Wort$)
  
  ' In welche Richtung konvertieren?
  if direction = 0 then 
  
   ' Schauen, ob ein Zeichen ersetzt werden muss
   Zeichen$ = mid$(Wort$, i, 1)
   select case Zeichen$
    case "": Zeichen$ = chr$(225)
    case "": Zeichen$ = chr$(142)
    case "": Zeichen$ = chr$(132)
    case "": Zeichen$ = chr$(153)    
    case "": Zeichen$ = chr$(148)
    case "": Zeichen$ = chr$(154)
    case "": Zeichen$ = chr$(129)   
   end select
   NeuerText$ = NeuerText$ + Zeichen$
  
  else
   
   ' Schauen, ob ein Zeichen ersetzt werden muss
   Zeichen$ = mid$(Wort$, i, 1)
   select case Zeichen$
    case chr$(225): Zeichen$ = ""
    case chr$(142): Zeichen$ = ""
    case chr$(132): Zeichen$ = ""
    case chr$(153): Zeichen$ = ""    
    case chr$(148): Zeichen$ = ""
    case chr$(154): Zeichen$ = ""
    case chr$(129): Zeichen$ = ""    
   end select
   NeuerText$ = NeuerText$ + Zeichen$
  
  end if
  
 next i

 convert$ = NeuerText$

end function

' ******************************

' Diese FUNCTION simuliert einen blinkenden Cursor
function csr$ (csrzaehler)
 
 ' Den Cursor nur zur halben Zeit anzeigen
 if csrzaehler < 20 then 
  csr$ = "_"
 else
  csr$ = ""
 end if

end function

' ******************************

' Diese FUNCTION gibt das Datum im Format "16. Juli 2005" zurck
function datum$ ()
 
 ' Tag, Monat und Jahr isolieren
 tag$ = mid$(date$, 4, 2)
 monat$ = left$(date$, 2)
 jahr$ = right$(date$, 4)
 
 ' Und zusammensetzen
 datum$ = tag$ + ". " + month$(monat$) + " " + jahr$

end function

' ******************************

' Diese FUNCTION dient als Eingaberoutine
function eingabe$ (wort$, KeyCode$, MaxLength)

 ' Die Abfrage der Tastatureingabe
 select case KeyCode$
 
  ' Backspace
  case chr$(8)
   if len(wort$) then wort$ = left$(wort$, len(wort$) - 1)
  
  ' Alphanumerisches Zeichen
  case chr$(31) to chr$(127)
   if len(wort$) < MaxLength then wort$ = wort$ + KeyCode$   
 
 end select    

 eingabe$ = wort$

end function

' ******************************

' Diese FUNCTION transportiert den Ausdruck Ausdruck$ in einen mit der Lnge Laenge 
' und einer Anzahl fhrender Zeichen; dieses Zeichen ist FuehrendesZeichen$
function format$ (Laenge, FuehrendesZeichen$, Ausdruck$)

if len(Ausdruck$) < Laenge then 
 
 ' Die Anzahl der vorangehenden Zeichen ermitteln
 Anzahl = Laenge - len(rtrim$(ltrim$(Ausdruck$)))
 
 format$ = string$(Anzahl, FuehrendesZeichen$) + Ausdruck$

elseif len(Ausdruck$) = laenge then 
 
 ' Wenn der Ausdruck gleich lang ist, dann nichts ndern
 format$ = Ausdruck$

else
 
 ' Wenn der Ausdruck zu lang ist, Leerstring zurckgeben
 format$ = ""    

end if

end function

' ******************************

' Diese FUNCTION errechnet des Gesamtpreis, der schon vor dem Erstellen der
' Rechnung bentigt wird
function gesamt$ (feld() as producttype, ProduktIndex)
 
 ' Variable resetten
 g! = 0 
 
 ' Schleife ber alle Produkte
 for i = 1 to ProduktIndex
  
  with feld(i)
   
   ' Den Preis inkl. MwSt mit der Anzahl multipliziert hinzuaddieren
   g! = g! + val(runde$(val(inklmwst$(.mwst, .preis)) * val(.anzahl)))
   
  end with
 
 next i  
 
 g$ = runde$(g!)
 gesamt$ = betrag$(g$)
 
end function   

' ******************************

' Diese FUNCTION gibt einen Preis inklusive MwSt zurck
function inklmwst$ (mwst$, preis$)

 ' Volle oder ermigte MwSt?
 select case lcase$(mwst$)
  
  case "e"
   mwst = Einstellungen.mwste
  
  case "v"
   mwst = Einstellungen.mwstv
 
 end select 
 
 ' Die Rechnung
 wert$ = runde$(val(preis$) + val(preis$) * mwst / 100)

 inklmwst$ = betrag$(wert$) 

end function    

' ******************************

' Diese FUNCTION ermittelt den Monat zur entsprechenden Nummer
function month$ (monat$)

 ' Welcher Monat?
 select case val(monat$)
  case 1:  month$ = "Januar"
  case 2:  month$ = "Februar"
  case 3:  month$ = "Mrz"    
  case 4:  month$ = "April"
  case 5:  month$ = "Mai"
  case 6:  month$ = "Juni"
  case 7:  month$ = "Juli"
  case 8:  month$ = "August"
  case 9:  month$ = "September"
  case 10: month$ = "Oktober"
  case 11: month$ = "November"
  case 12: month$ = "Dezember"    
 end select
 
end function  

' ******************************

' Diese FUNCTION dient dazu, einen Wert bis auf 2 Kommastellen 
' zu runden
function runde$ (wert as single)

 ' Den Wert zum String konvertieren 
 z$ = trim$(str$(wert))
 
 ' Das Komma suchen
 komma = instr(z$, ".") or instr(z$, ",")
 
 ' Ist ein Komma enthalten?
 if komma then 
 
  ' Wenn der Ausdruck im Exponentialformat steht, kommt das "Spezialverfahren"
  if instr(lcase$(z$), "e") then
  
   ' Wert mit print using in eine temporre Datei schreiben
   f = freefile
   open pfad$ + "\TEMP\TEMPDATA.DAT" for output as #f
    print #f, using "#######.#######"; wert
   close #f
  
   ' Und Wert wieder laden
   f = freefile
   open pfad$ + "\TEMP\TEMPDATA.DAT" for input as #f
    input #f, w$
    w$ = trim$(w$)
   close #f
  
   ' Und die temporre Datei wieder lschen
   kill pfad$ + "\TEMP\TEMPDATA.DAT"
  
   ' Dann z$ mit w$ berschreiben und fortfahren.
   z$ = w$
  
  end if 
 
 ' Die Vorkomastellen abschneiden
 vorkommastellen$ = left$(z$, komma)
 
 ' Start- und Endpunkt fr das Runden festlegen
 startpunkt = len(z$)
 endpunkt = komma + 2

 ' Das Feld, das jede Ziffer der zu rundenden Zahl enthlt, dimensionieren
 dim feld(startpunkt) as integer

 ' Die Zahlen in das Feld einlesen
 for i = startpunkt to 1 step -1
 
  ' Jede einzelne Ziffer ins Feld schreiben, und aufpassen, dass 
  ' das Komma nicht ins Feld kommt
  if mid$(z$, i, 1) <> "." then 
   
   feld(i) = val(mid$(z$, i, 1))
  
  else
   
   i = i - 1
  
  end if
 
 next i

 ' Der eigentliche Rundungsvorgang
 for i = startpunkt to endpunkt step -1
 
  ' Wenn die aktuelle Zahl grer als 5 ist, erhhe die nchste Zahl um 1
  if i - 1 >= endpunkt then  
   if feld(i) >= 5 and feld(i) <= 9 then feld(i - 1) = feld(i - 1) + 1
  end if
  
  ' Wenn die aktuelle Zahl aufgrund eines Fehlers gleich 10 ist, erhhe die
  ' nchste Zahl um 1
  if feld(i) = 10 then 
   feld(i - 1) = feld(i - 1) + 1
   feld(i) = 0
  end if
  
  ' Lsche die aktuelle Ziffer, wenn sie wegfallen kann
  if i > endpunkt then feld(i) = 0
 
 next i    

 ' Wieder zu einem String zusammensetzen
 g$ = vorkommastellen$
 for i = endpunkt - 1 to startpunkt step 1
  
  g$ = g$ + trim$(str$(feld(i)))   
 
 next i

 ' Und das war's  
 runde$ = trim$(g$)

 
 ' Wenn kein Komma enthalten ist, kann nicht gerundet werden
 else
 
  runde$ = z$
  
 end if 

end function

' ******************************

' Diese FUNCTION ordnet der Warengruppennummer ihre Bezeichnung zu
function welchewarengruppe$ (wgnr$)
    
 w$ = ""
 Nummer = val(wgnr$)
 
 ' berprfen, ob im zulssigen Bereich
 if Nummer > 0 and Nummer <= ubound(warengruppe) then 
  
  w$ = warengruppe(Nummer).wg   
 
 else
  
  w$ = ""   
 
 end if  
 
 welchewarengruppe$ = w$
    
end function

' ******************************

' Diese FUNCTION gibt nur die Minuten und Stunden der Uhrzeit zurck
function zeit$ 

zeit$ = left$(time$, 5)

end function

' ******************************

' und dann kommen die SUBs:

' Diese SUB fllt den Bildschirm mit grauen ASCII-Zeichen aus
sub clr ()

 color 7
 
 ' Schleife ber alle Bildschirmzeilen
 for i = 1 to 30 step 1
  
  locate i, 1: print string$(80, "");   
 
 next i
 
 color 15, 1

end sub 

' ******************************

' Diese SUB erstellt ein Fenster mit einem Schatten an Position y, x, das den
' Titel Title$ hat, und Zeilen lang ist und Spalten breit 
sub drawbox (Title$, y, x, Zeilen, Spalten)
 
 ' Die einzelnen Zeichen definieren
 LinksOben$ = ""
 RechtsOben$ = ""
 LinksUnten$ = ""
 RechtsUnten$ = ""
 HorizontalerBalken$ = ""
 VertikalerBalken$ = ""
 Schatten$ = ""
 
 ' Der Titel wird ber dem Fenster zentriert
 
 ' Die Anzahl Leerstellen links und rechts ermitteln
 leer# = (Spalten - len(Title$)) / 2  - 2
 
 ' Wenn es eine ungerade Zahl ergibt, links eine Leerstelle anfgen
 leer = int(leer#)
 if leer# <> int(leer#) then  
  ug$ = HorizontalerBalken$
 else
  ug$ = ""
 end if 
  
 ' berschrift und letzte Zeile erstellen
 Ueberschrift$ = LinksOben$  + ug$ + string$(leer, HorizontalerBalken$) + "[" + convert$(Title$) + "]" + string$(leer, HorizontalerBalken$) + RechtsOben$
 LetzteZeile$ = LinksUnten$ + string$(Spalten - 2, HorizontalerBalken$) + RechtsUnten$ 
 
 ' Und aufzeichnen
 color 15, 1: locate y, x: print Ueberschrift$
 
 ' Schleife ber alle Zeilen ausgenommen der ersten und letzten
 for i = y + 1 to y + Zeilen step 1
  
  ' Zeile zusammenstellen
  Zeile$ = VertikalerBalken$ + string$(len(Ueberschrift$) - 2, " ") + VertikalerBalken$
  
  ' unbd ausgeben
  color 15, 1
   locate i, x: print Zeile$;
  
  ' Und noch der Schatten
  color 0
   print Schatten$ 
 
 next i
 
 ' Und die letzte Zeile ausgeben
 color 15, 1
  locate i, x: print LetzteZeile$;
 
 ' mit Schatten
 color 0
  print Schatten$
  locate i + 1, x + 1: print string$(len(LetzteZeile$), Schatten$)
 
 color 15, 1
  
end sub

' ******************************

' Diese SUB schreibt den Titel auf den Bildschirm
sub drawtitle ()
 
 ' Die Farben werden gendert, da ein Schatten gezeichnet werden muss 
 
 color 15, 1
  locate 2, 10:  print "" + string$(50, "") + ""
  locate 3, 10:  print " Easy Cash by jbsoft " + string$(26, " ") + "   ";
  
 color 0
  print ""

 color 15, 1
  locate 3, 33:  print zeit$
  locate 3, 41:  print datum$
  locate 4, 10:  print "" + string$(50, "") + "";
 
 color 0
  print ""
 
 locate 5, 11
  print string$(52, "")
 
 color 15, 1

end sub  

' ******************************

' Diese SUB druckt den Text Text$ an Position Zeile, Spalte aus - eine 
' Zusammenfassung von locate Zeile, Spalte: print Text$
sub druck (Zeile, Spalte, Text$)
 
 locate Zeile, Spalte: print convert$(Text$)

end sub

' ******************************

' Diese SUB ordnet dem Barcode barcode$ die anderen Daten, wie etwa die Warengruppe, zu 
sub erkenne (bcode() as bcodetype, barcode$, warengruppe$, warengruppennr$, beschreibung$, preis$, mwst$, Index)

 ' Die Variablen resetten
 warengruppe$ = "" 
 warengruppennr$ = ""
 beschreibung$ = ""
 preis$ = ""
 mwst$ = ""
 Index = 0
 
 ' Schleife ber alle gespeicherten Produkte
 for i = 1 to Einstellungen.anzahlbarcodes step 1
  
  with bcode(i)  
   
   ' Wenn der Barcode erkannt wurde, setze die  Werte fr die anderen
   ' Variablen ein.
   if barcode$ = .barcode then 
    
    Index = i
    warengruppennr$ = .wgnr
    warengruppe$ = welchewarengruppe$(.wgnr)
    beschreibung$ = .beschreibung
    preis$ = .preis
    mwst$ = .mwst
       
   end if    
  
  end with
 
 next i    

end sub   

' ******************************

' Diese SUB ldt die Anzahl der einzelnen Daten, damit spter die Felder
' passend dimensioniert werden knnen
sub ladealles ()

 with Einstellungen
 
  ' Die Anzahl der Benutzer 
  f = freefile
  open Pfad$ + "\FILES\USERDATA.DAT" for input as #f
   input #f, .anzahluser
  close #f
  
  ' Die Anzahl der gespeicherten Warengruppen
  f = freefile
  open Pfad$ + "\FILES\WGRUPPEN.DAT" for input as #f
   input #f, .anzahlwarengruppen
  close #f
  
  ' Die Anzahl der gespeicherten Produkte
  f = freefile
  open Pfad$ + "\FILES\BARCODE.DAT" for input as #f
   input #f, .anzahlbarcodes
  close #f
  
  ' Der MwSt-Satz
  f = freefile
  open Pfad$ + "\FILES\MWST.DAT" for input as #f
   input #f, .MwStE, .MwStV
  close #f
 
  ' Die Rechnungseinstellungen
  f = freefile
  open Pfad$ + "\FILES\RECHNUNG.DAT" for input as #f
   input #f, .html, .txt, .zeige
   input #f, .kassennr
   input #f, .filiale
   input #f, .adresse
   input #f, .oeffnungszeiten
   input #f, .abschlusstext
  close #f  

 end with

end sub    

' ******************************

' Diese SUB ldt die Daten in die Felder
sub ladefelder ()

 with Einstellungen
 
 ' Die Bilanz
 f = freefile 
 open Pfad$ + "\FILES\BILANZ.DAT" for input as #f
  input #f, .bilanzmitmwst
  input #f, .bilanzohnemwst
  input #f, .mwsteenthalten
  input #f, .mwstventhalten
  input #f, .verkaufteprodukte
 close #f
  
 ' Die Benutzereinstellungen
 f = freefile
 open Pfad$ + "\FILES\USERDATA.DAT" for input as #f
 input #f, dummy
 for i = 1 to .anzahluser
  with user(i)
  input #f, .user, .admin, .benutzername, pw$, .bilanz, .verkaufteprodukte, .rechnungen 
  .passwort = chifre$(pw$)
  end with
 next i
 close #f
 
 ' Die gespeicherten Produkte
 f = freefile
 open Pfad$ + "\FILES\BARCODE.DAT" for input as #f
 input #f, dummy
 for i = 1 to .anzahlbarcodes 
  with barcode(i)
   input #f, .wgnr, .barcode, .beschreibung, .preis, .mwst, .wieoftverkauft   
  end with
 next i  
 close #f 
 
 ' Die gespeicherten Warengruppen
 f = freefile
 open Pfad$ + "\FILES\WGRUPPEN.DAT" for input as #f
 input #f, dummy
 for i = 1 to .anzahlwarengruppen
  with warengruppe(i) 
   input #f, .nr, .wg
  end with
 next i
 close #f
 
 end with
 
end sub

' ******************************

' Diese SUB berechnet die Preise und erstellt die Rechnung 
sub rechnung (userfeld() as benutzertype, feld() as producttype, rechfeld() as rechnungstype, ProduktIndex, Gegeben$, Zurueck$)
 
dim MwStVGesamt    as double: MwStVGesamt = 0
dim MwStEGesamt    as double: MwStEGesamt = 0
dim GesamtOhneMwSt as double: GesamtOhneMwSt = 0
dim GesamtMitMwSt  as double: GesamtMitMwSt = 0
AnzahlProdukte = 0

' Der entprechende Benutzer bekommt eine neue Rechnung aufs Konto  
userfeld(BenutzerIndex).rechnungen = userfeld(BenutzerIndex).rechnungen + 1 

' Erst mal die Berechnungen

for i = 1 to ProduktIndex step 1
 with feld(i)
  
  rechfeld(i).beschreibung = .beschreibung
  rechfeld(i).preis = .preis
  rechfeld(i).mwst = .mwst
  rechfeld(i).anzahl = .anzahl
  rechfeld(i).wg = .wg
  
  ' Die Anzahl der Kufe des entsprechenden Produkts erhhen
  barcode(.index).wieoftverkauft = barcode(.index).wieoftverkauft + val(.anzahl)
  
  ' Die MwSt fr jeden einzelnen Artikel ausrechnen
  if lcase$(.mwst) = "v" then 
   
   ' Die volle MwSt
   MwStVGesamt = MwStVGesamt + val(runde$(val(inklmwst$(.mwst, .preis)) * val(.anzahl) - val(.preis) * val(.anzahl)))
  
  else
   
   ' Die ermigte MwSt
   MwStEGesamt = MwStEGesamt + val(runde$(val(inklmwst$(.mwst, .preis)) * val(.anzahl) - val(.preis) * val(.anzahl)))
  
  end if

  ' Der Gesamtpreis *ohne* MwSt
  GesamtOhneMwSt = GesamtOhneMwSt + val(runde$(val(.preis) * val(.anzahl)))

  ' Der Gesamtpreis *mit* MwSt
  GesamtMitMwSt = GesamtMitMwSt + val(runde$(val(inklmwst$(.mwst, .preis)) * val(.anzahl))) 
    
  ' Die Anzahl der Produkte
  AnzahlProdukte = AnzahlProdukte + val(.anzahl) 
 
 end with
next i   
 
' Das Feld, das jede Zeile der Rechnung enthlt, dimensionieren
redim RechnungsFeld$(40 + ProduktIndex)

' Und dann Zeile fr Zeile in das Feld RechnungsFeld$() bertragen

RechnungsFeld$(1) =  "=========================================================================="
RechnungsFeld$(2) =  Center$(74, Einstellungen.filiale)
RechnungsFeld$(3) =  Center$(74, Einstellungen.adresse)
RechnungsFeld$(4) =  Center$(74, Einstellungen.oeffnungszeiten)
RechnungsFeld$(5) =  "=========================================================================="
RechnungsFeld$(6) =  ""
RechnungsFeld$(7) =  " Datum     : " + datum$
RechnungsFeld$(8) =  " Uhrzeit   : " + zeit$
RechnungsFeld$(9) =  " Bedienung : " + userfeld(BenutzerIndex).benutzername
RechnungsFeld$(10) = " Kassen-Nr : " + Einstellungen.kassennr
RechnungsFeld$(11) = " Bon-Nr    : " + ltrim$(str$(userfeld(BenutzerIndex).rechnungen))
RechnungsFeld$(12) = ""
RechnungsFeld$(13) =  "=========================================================================="
RechnungsFeld$(14) = " Sie kauften folgende Artikel:"
RechnungsFeld$(15) = "=========================================================================="
RechnungsFeld$(16) = ""
RechnungsFeld$(17) = "   Anzahl      Bezeichnung        Warengruppe     Einzelpreis       MwSt"
RechnungsFeld$(18) = ""
RechnungsFeld$(19) = "=========================================================================="
RechnungsFeld$(20) = ""
 
 ' Jede Rechnungszeile einzeln zusammenbauen
 
 for i = 1 to ProduktIndex step 1
 
  with rechfeld(i)
   
    ' Zeile leeren
    Zeile$ = string$(75, " ")
    
    ' Und mit Hilfe von mid$() fllen
    mid$(Zeile$, 3, len(Format$(5, " ", .anzahl))) = Format$(5, " ", .anzahl)
    mid$(Zeile$, 13, len(.beschreibung)) = .beschreibung
    mid$(Zeile$, 36, len(.wg)) = .wg
    mid$(Zeile$, 55, len(inklmwst$(.mwst, .preis))) = inklmwst$(.mwst, .preis) 
    mid$(Zeile$, 71, 1) = .mwst
    
    ' Und ins Feld RechnungsFeld$() schreiben
    RechnungsFeld$(20 + i) = Zeile$
    
  end with
 
 next i

RechnungsFeld$(20 + i) = ""
RechnungsFeld$(21 + i) = "=========================================================================="
RechnungsFeld$(22 + i) = ""
with Einstellungen
 RechnungsFeld$(23 + i) = " Gesamt MwSt V (" +  ltrim$(str$(.MwStV)) + "%)" + string$(3 - len(ltrim$(str$(.MwStV))), " ") + " :   " + Format$(48, " ", betrag$(str$(MwStVGesamt)))
 RechnungsFeld$(24 + i) = " Gesamt MwSt E (" +  ltrim$(str$(.MwStE)) + "%)" + string$(3 - len(ltrim$(str$(.MwStE))), " ") + " :   " + Format$(48, " ", betrag$(str$(MwStEGesamt)))
end with
RechnungsFeld$(25 + i) = " Gesamt netto         :   " + format$(48, " ", betrag$(str$(GesamtOhneMwSt)))
RechnungsFeld$(26 + i) = ""
RechnungsFeld$(27 + i) = " Gesamt brutto        :   " + format$(48, " ", betrag$(str$(GesamtMitMwSt)))  
RechnungsFeld$(28 + i) = ""
RechnungsFeld$(29 + i) = " Gegeben              :   " + format$(48, " ", betrag$(Gegeben$))
RechnungsFeld$(30 + i) = "" 
RechnungsFeld$(31 + i) = " Zurueck              :   " + format$(48, " ", betrag$(Zurueck$))
RechnungsFeld$(32 + i) = "" 
RechnungsFeld$(33 + i)  =" Alle Preise in Euro"
RechnungsFeld$(34 + i) = "=========================================================================="
RechnungsFeld$(35 + i) = center$(74, Einstellungen.abschlusstext)
RechnungsFeld$(36 + i) = "=========================================================================="

' Und dann alles in eine Datei schreiben, entweder .TXT oder .HTML

if Einstellungen.html then 
 
 ' An die HTML-Syntax muss sich gehalten werden...
 
 ' Wir wollen einen Zeilenumbruch zu Beginn jeder Zeile
 ZeilenStart$ = "<br>"
 
 ' Der Header initialisiert einen SCREEN 0 - hnlichen Textaufbau
 Header$ = "<html>"
 Header$ = Header$ + "<head><title> Rechnung Nr. " + format$(7, "0", ltrim$(str$(userfeld(BenutzerIndex).rechnungen))) + "</title></head>"
 Header$ = Header$ + "<body bgcolor=" + chr$(34) + "#FFFFFF" + chr$(34) + ">"
 Header$ = Header$ + "<pre><font face=" + chr$(34) + "Courier, Courier New " + chr$(34)+ ">"
 
 ' Die Tags schlieen
 Ende$ = "</font></pre></body></html>"
 
 ' Und natrlich die passende Endung
 Endung$ = ".HTM"

else
 
 ' Bei der Textdatei fllt das natrlich weg.
 ZeilenStart$ = ""
 Header$ = ""
 Ende$ = ""
 Endung$ = ".TXT"

end if

' Die Rechnung schreiben

f = freefile

' Der Pfadname mit der fortlaufenden Rechnungsnummer
pathname$ = Pfad$ + "\RECH\R_" + format$(7, "0", ltrim$(str$(userfeld(BenutzerIndex).rechnungen))) + Endung$

' Und der Schreibvorgang beginnt
open pathname$ for output as #f
 
 print #f, Header$
 
 for i = 1 to 38 + ProduktIndex 
  print #f, ZeilenStart$ + RechnungsFeld$(i)
 next i

 print #f, Ende$

close #f

' Jetzt noch den Umsatz zu der Filialenbilanz und zur persnlichen Bilanz des 
' Kassierers/ der Kassiererin hinzurechnen und abspeichern.

' Die Bilanz des Kassierers/ der Kassiererin
with userfeld(BenutzerIndex)
 .bilanz = .bilanz + GesamtMitMwSt
 .verkaufteprodukte = .verkaufteprodukte + AnzahlProdukte 
end with 

' Die Filialenbilanz
with Einstellungen
 .bilanzmitmwst = .bilanzmitmwst + GesamtMitMwSt
 .bilanzohnemwst = .bilanzohnemwst + GesamtOhneMwSt
 .mwsteenthalten = .mwsteenthalten + MwStEGesamt
 .mwstventhalten = .mwstventhalten + MwStVGesamt
 .verkaufteprodukte = .verkaufteprodukte + AnzahlProdukte
end with

speicherfelder 

' Und die Rechnung eventuell noch anzeigen
with Einstellungen
 
 if .html and .zeige then 
  
  shell "start explorer " + pathname$ 
 
 elseif .txt and .zeige then 
  
  shell "start notepad  " + pathname$
 
 end if

end with

end sub 

' ******************************

' Diese SUB speichert alle Daten ab
sub speicherfelder () 

 with Einstellungen 
 
  ' Die Bilanzen
  f = freefile 
  open Pfad$ + "\FILES\BILANZ.DAT" for output as #f
   write #f, .bilanzmitmwst
   write #f, .bilanzohnemwst
   write #f, .mwsteenthalten
   write #f, .mwstventhalten
   write #f, .verkaufteprodukte
  close #f
  
  ' Die Rechnungseinstellungen
  f = freefile
  open Pfad$ + "\FILES\RECHNUNG.DAT" for output as #f
   write #f, .html, .txt, .zeige
   write #f, .kassennr
   write #f, .filiale
   write #f, .adresse
   write #f, .oeffnungszeiten
   write #f, .abschlusstext
  close #f
  
  ' Der MwSt-Satz
  f = freefile
  open Pfad$ + "\FILES\MWST.DAT" for output as #f
   write #f, .MwStE, .MwStV
  close #f
  
  ' Die Benutzereinstellungen
  f = freefile
  open Pfad$ + "\FILES\USERDATA.DAT" for output as #f
   write #f, .anzahluser
   for i = 1 to .anzahluser 
    with user(i)
     write #f, .user, .admin, .benutzername, chifre$(.passwort), .bilanz, .verkaufteprodukte, .rechnungen 
    end with
   next i
  close #f  
  
  ' Die gespeicherten Produkte
  f = freefile
  open Pfad$ + "\FILES\BARCODE.DAT" for output as #f
   write #f, .anzahlbarcodes
   for i = 1 to .anzahlbarcodes 
    with barcode(i)
     write #f, .wgnr, .barcode, .beschreibung, .preis, .mwst, .wieoftverkauft    
    end with
   next i
  close #f
  
  ' Die gespeicherten Warengruppen
  f = freefile
  open Pfad$ + "\FILES\WGRUPPEN.DAT" for output as #f
   write #f, .anzahlwarengruppen 
   for i = 1 to .anzahlwarengruppen
    with warengruppe(i)
     write #f, .nr, .wg
    end with
   next i 
  close #f
  
 end with
  
end sub    

' ******************************

' Wartet auf die Bettigung der Taste key$
sub waitforkey (key$)
 
 ' Endlosschleife bis Taste key$ bettigt 
 do
  
  ' Dem Prozessor etwas Gutes tun...
  sleep 3
 
 loop until inkey$ = key$

end sub
