' *****************************************************************************
'
' EasyBlur
'
' Dieses Programm lsst Bilder verschwimmen
'
' Copyright www.jb-electronics.de
'
' *****************************************************************************

' *****************************************************************************
' SUBs und FUNCTIONs:
declare function LoadImage (DateiName as string) as integer ptr

' *****************************************************************************
' Grafikmodus setzen und Logo laden und anzeigen
windowtitle "EasyBlur"
screenres 150, 50, 32, 2
dim as integer ptr Logo
Logo = LoadImage(exepath + "/res/logo.bmp")
put(0, 0), Logo, pset
screencopy

' *****************************************************************************
' BlurFactor eingeben
color &hffffff, &h0245d0
dim as string FactorStr
do
    locate 1, 1: print " "
    screencopy
    FactorStr = input$(1)
    locate 1, 1: print FactorStr
    screencopy
loop until (FactorStr = "1" or FactorStr = "2" or FactorStr = "3" or FactorStr = "4" or FactorStr = "5" or FactorStr = "6" or FactorStr = "7" or FactorStr = "8" or FactorStr = "9" or FactorStr = chr$(27))
if FactorStr = chr$(27) then
    end
end if

' *****************************************************************************
' Variablen
dim shared as integer WidthX, WidthY
dim as integer ptr BildAlt, BildTmp, BildNeu
dim as integer Factor, ArraySize
dim as integer PosX, PosY
dim as integer r, g, b, x, y, count, Farbe

' *****************************************************************************
' Eingegebenen Factor setzen
Factor = val(FactorStr)

' *****************************************************************************
' Bild in der Kommandozeile laden
if (len(trim$(command$)) > 0) then
    BildAlt = LoadImage(command$)
    BildTmp = LoadImage(command$)
    BildNeu = imagecreate(WidthX, WidthY)
else
    end
end if

' *****************************************************************************
' eigentlicher Blur-Vorgang (Strle bestimmt durch Variable Factor)
for PosX = 0 to WidthX - 1 step 1
    for PosY = 0 to WidthY - 1 step 1
        Farbe = point(PosX, PosY, BildTMP)
        r = (Farbe shr 16) and 255
        g = (Farbe shr 8) and 255
        b = Farbe and 255
        count = 1
        for x = PosX - Factor to PosX + Factor step 1
            for y = PosY - Factor to PosY + Factor step 1
                if (x >= 0) and (x <= WidthX) then
                    if (y >= 0) and (y <= WidthY) then
                        Farbe = point(x, y, BildTMP)
                        r+ = (Farbe shr 16) and 255
                        g+ = (Farbe shr 8) and 255
                        b+ = Farbe and 255
                        count+ = 1
                        if multikey(1) then
                            end
                        end if
                    end if
                end if
            next y
        next x
        r/ = count
        g/ = count
        b/ = count
        pset BildNeu, (PosX, PosY), rgb(r, g, b)
    next PosY
next PosX

' *****************************************************************************
' Geblurrte Datei speichern
bsave left$(command$, len(command$) - 4) + "_eb_" + trim$(str$(Factor)) + ".bmp" , BildNeu

' *****************************************************************************
' Imagebuffer lschen und Programm beenden
imagedestroy BildAlt
imagedestroy BildTMP
imagedestroy BildNeu

end

' *****************************************************************************
' Diese FUNCTION ldt eine beliebige Bitmap
function LoadImage (DateiName as string) as integer ptr

    ' Variablen
    dim as integer WidthPixel, HeightPixel
    dim as integer ptr ImagePointer

    ' Gre des Bildes ermitteln
    dim as byte f
    f = freefile
    open DateiName for binary access read as #f
        get #f, 19, HeightPixel
        get #f, 23, WidthPixel
    close #f

    ' Bild laden
    ImagePointer = imagecreate(WidthPixel, HeightPixel)
    bload DateiName, ImagePointer

    ' Globale Variablen setzen fr Bildgre
    WidthY = WidthPixel
    WidthX = HeightPixel

    ' Daten zurckgeben
    return ImagePointer

end function
