// ************************************************************************************************
//
// Zhler mit 7-Segment-Ausgabe unter Verwendung des Schieberegisters CD4094
//
// PIC 16F627A
//
// Copyright www.jb-electronics.de
//
// ************************************************************************************************

// PIC-Header einbinden
#include <pic.h>

// ************************************************************************************************
// Methodenprototypen

void warte (uchar Count);
void schreibeWert (uchar Wert);

uchar get7SegmentValue (uchar Wert, uchar DecimalPoint);

// ************************************************************************************************
// Hauptmethode
void main (void) {

	// Konfigurationsbits setzen
	__CONFIG(0x3F2A);

	// PORTB als Ausgang definieren
	TRISB = 0b0;

	// auer RB4, da dort ein Taster angeschlossen wird
	TRISB4 = 1;

	// PORTB unterteilen
	#define STROBE	RB0
	#define DATA 	RB1
	#define CLOCK	RB2
	#define TASTER	RB4
	#define LED    	RB5
	
	// ********************************************************************************************
	// Beginn der Hauptschleife
	while (true) {

		// ****************************************************************************************
		// Variablen deklarieren
		uchar Index, Wert;

		// ****************************************************************************************
		// Daten ausgeben
		schreibeWert (get7SegmentValue(Wert, 0));

		// ****************************************************************************************
        // Wert erhhen?
		if (TASTER) {
			Wert++;
			if (Wert > 9) {
				Wert = 0;
			}
			while (TASTER) {}
		}
		
		// ****************************************************************************************
		// gerade Zahlen hervorheben durch LED
        if (Wert % 2 == 0) {
			LED = 1;
		} else {
			LED = 0;
		}
	
	}

}

// ************************************************************************************************
// schreibt einen Wert in ein Schieberegister
void schreibeWert (uchar Wert) {

	// Variablen
	uchar Index;

	// initialisieren
	STROBE = 0;

	// Wert senden
	warte(255);
	for (Index = 0; Index < 8; Index++) {
		DATA = (Wert >> Index) & 1;
		warte(255);
		CLOCK = 1;
		warte(255);
		CLOCK = 0;
		warte(255);
	}

	// Wert bernehmen
	STROBE = 1;
	
	//ENABLE = 1;
	warte(255);

}

// ************************************************************************************************
// wandelt einen Wert in ein Zeichen im 7-Segment-Code um
uchar get7SegmentValue (uchar Wert, uchar DecimalPoint) {

	// Variablen
	uchar result;

	// welches Ausgabemuster bei welchem Zeichen?
	//
	//   Bit    Segment
	//
	//    0       DP
	//    1       g
	//    2       f
	//    3       e
	//    4       d
	//    5       c
	//    6       b
	//    7       a
	//
	if (Wert == 0) {
		result = 0b11111100;
	} else if (Wert == 1) {
		result = 0b01100000;
	} else if (Wert == 2) {
		result = 0b11011010;
	} else if (Wert == 3) {
		result = 0b11110010;
	} else if (Wert == 4) {
		result = 0b01100110;
	} else if (Wert == 5) {
		result = 0b10110110;
	} else if (Wert == 6) {
		result = 0b10111110;
	} else if (Wert == 7) {
		result = 0b11100000;
	} else if (Wert == 8) {
		result = 0b11111110;
	} else if (Wert == 9) {
		result = 0b11110110;
	} else {
		result = 0b10001110;
	}

	// Dezimalpunkt aktiv?
	if (DecimalPoint > 0) {
		result| = 0b1;
	}
	
	// Wert zurckgeben
	return (result);

}

// ************************************************************************************************
// Diese Methode wartet kurz, um Signale gltig werden zu lassen
void warte (uchar Count) {

	// Variablen
	uchar t;
	
	// Warteschleife
	for (t = 0; t < Count; t++) {
		NOP();
	}

}
