// ************************************************************************************************
//
// Copyright www.jb-electronics.de
//
// Universal-Uhr
//
// (x) Ausgabe von Zeitinformationen ber 6 x 4 Datenleitungen im BCD-Format
// (x) Einstellen der Stunden und Minuten ber je einen Taster; dabei werden die Sekunden resettet
//
// http://www.jb-electronics.de/html/elektronik/digital/d_universal_uhr_ic.htm
//
// ************************************************************************************************


// ************************************************************************************************
// PIC-Header einbinden
#include <pic.h>


// ************************************************************************************************
// Globale Variablen
static int timebase = 0;
static unsigned char Stunden = 0, Minuten = 0, Sekunden = 0;
static int SW_STD_BUFFER = 0, SW_MIN_BUFFER = 0, SW_STD_HOLD_TIME = 0, SW_MIN_HOLD_TIME = 0;


// ************************************************************************************************
// Hauptmethode
void main (void) {


    // *****
	// Konfigurationsbits setzen (entsprechende Zeile fr verwendeten PIC einkommentieren)

	__CONFIG(0x2be1); 		// PIC16F707
	//__CONFIG(0x3f71); 	// PIC16F877A
	
	// *****
	// alles auf Ausgang stellen
	TRISA1 = 0; TRISA2 = 0; TRISA3 = 0; TRISA4 = 0; TRISA5 = 0; TRISE0 = 0; TRISE1 = 0; TRISE2 = 0;
	TRISB0 = 0; TRISB1 = 0; TRISB2 = 0; TRISB3 = 0; TRISB4 = 0; TRISB5 = 0; TRISB6 = 0; TRISB7 = 0;
	TRISD5 = 0; TRISD4 = 0; TRISC7 = 0; TRISC6 = 0; TRISC5 = 0; TRISC4 = 0; TRISD3 = 0; TRISD2 = 0;


	// *****
	// alle Analog-Digital-Wandler deaktivieren
	// (nur bei PIC16F707 notwendig, muss beim PIC16F877A auskommentiert werden)
	ANSA0 = 0; ANSA1 = 0; ANSA2 = 0; ANSA3 = 0; ANSA4 = 0; ANSA5 = 0; ANSA6 = 0; ANSA7 = 0;
	ANSB0 = 0; ANSB1 = 0; ANSB2 = 0; ANSB3 = 0; ANSB4 = 0; ANSB5 = 0; ANSB6 = 0; ANSB7 = 0;
	ANSC0 = 0; ANSC1 = 0; ANSC2 = 0; ANSC5 = 0; ANSC6 = 0; ANSC7 = 0;
	ANSD0 = 0; ANSD1 = 0; ANSD2 = 0; ANSD3 = 0; ANSD4 = 0; ANSD5 = 0; ANSD6 = 0; ANSD7 = 0;
	ANSE0 = 0; ANSE1 = 0; ANSE2 = 0;


	// *****
	// Definitionen der Pins

	#define STD_1_A		RB7
	#define STD_1_B		RB6
	#define STD_1_C		RB5
	#define STD_1_D		RB4

	#define STD_10_A	RB3
	#define STD_10_B	RB2
	#define STD_10_C	RB1
	#define STD_10_D	RB0

	#define MIN_1_A		RD5
	#define MIN_1_B		RD4
	#define MIN_1_C		RC7
	#define MIN_1_D		RC6

	#define MIN_10_A	RC5
	#define MIN_10_B	RC4
	#define MIN_10_C	RD3
	#define MIN_10_D	RD2

	#define SEK_1_A		RA1
	#define SEK_1_B		RA2
	#define SEK_1_C		RA3
	#define SEK_1_D		RA4

	#define SEK_10_A	RA5
	#define SEK_10_B	RE0
	#define SEK_10_C	RE1
	#define SEK_10_D	RE2

	#define SW_STD		RD0
	#define SW_MIN		RD1
	TRISD0 = 1; TRISD1 = 1;


	// *****
	// Einstellungen Timer0

	// interner Takt (= 1/4 des Quarz)
	T0CS = 0;

	// Vorteiler des TImer0 auf 1:1 stellen
	PSA = 1;
	PS0 = 1;
	PS1 = 1;
	PS2 = 1;

	// Interrupt bei Timer-berlauf auslsen
	T0IE = 1;


	// *****
	// Global Interrupts aktivieren
	GIE = 1;

	// *****
	// Beginn der Hauptschleife
	while (1) {


		// *****
		// Daten in BCD kodieren und ausgeben

		STD_1_A 	= (Stunden % 10) & 0b0001;
		STD_1_B 	= ((Stunden % 10) & 0b0010) >> 1;
		STD_1_C 	= ((Stunden % 10) & 0b0100) >> 2;
		STD_1_D 	= ((Stunden % 10) & 0b1000) >> 3;

		STD_10_A 	= (Stunden / 10) & 0b0001;
		STD_10_B 	= ((Stunden / 10) & 0b0010) >> 1;
		STD_10_C 	= ((Stunden / 10) & 0b0100) >> 2;
		STD_10_D 	= ((Stunden / 10) & 0b1000) >> 3;

		MIN_1_A		= (Minuten % 10) & 0b0001;
		MIN_1_B		= ((Minuten % 10) & 0b0010) >> 1;
		MIN_1_C		= ((Minuten % 10) & 0b0100) >> 2;
		MIN_1_D		= ((Minuten % 10) & 0b1000) >> 3;

		MIN_10_A	= (Minuten / 10) & 0b0001;
		MIN_10_B	= ((Minuten / 10) & 0b0010) >> 1;
		MIN_10_C	= ((Minuten / 10) & 0b0100) >> 2;
		MIN_10_D	= ((Minuten / 10) & 0b1000) >> 3;

		SEK_1_A		= (Sekunden % 10) & 0b0001;
		SEK_1_B		= ((Sekunden % 10) & 0b0010) >> 1;
		SEK_1_C		= ((Sekunden % 10) & 0b0100) >> 2;
		SEK_1_D		= ((Sekunden % 10) & 0b1000) >> 3;

		SEK_10_A	= (Sekunden / 10) & 0b0001;
		SEK_10_B	= ((Sekunden / 10) & 0b0010) >> 1;
		SEK_10_C	= ((Sekunden / 10) & 0b0100) >> 2;
		SEK_10_D	= ((Sekunden / 10) & 0b1000) >> 3;


		// *****
		// Stunden einstellen?
		if ((SW_STD) && (SW_STD_BUFFER == 0)) {
			Stunden++;
			if (Stunden >= 24) {
				Stunden = 0;
			}
			Sekunden = 0;
			timebase = 0;
			if (SW_STD_HOLD_TIME < 4000) {
				SW_STD_BUFFER = 2000;
			} else {
				SW_STD_BUFFER = 500;
			}
		}


		// *****
		// Minuten einstellen?
		if ((SW_MIN) && (SW_MIN_BUFFER == 0)) {
			Minuten++;
			if (Minuten >= 60) {
				Minuten = 0;
			}
			Sekunden = 0;
			timebase = 0;
			if (SW_MIN_HOLD_TIME < 4000) {
				SW_MIN_BUFFER = 2000;
			} else {
				SW_MIN_BUFFER = 500;
			}
		}

	}

}

// ************************************************************************************************
// Interrupt-Service-Routine (ISR)
static void interrupt isr (void) {

	// Timer0 luft ber; dies tut er 4096 x pro Sekunde
	if (T0IF) {

		// Zeitbasis-Variable erhhen
		timebase++;

		// Auf 4096 Ticks berprfen und so 1Hz ermitteln
		if (timebase >= 4095) {

			// Zeit inkrementieren
			timebase = 0;
			Sekunden++;
			if (Sekunden >= 60) {
				Sekunden = 0;
				Minuten++;
				if (Minuten >= 60) {
					Minuten = 0;
					Stunden++;
					if (Stunden >= 24) {
						Stunden = 0;
					}
				}
			}

		}

		// Taster-Entprellung

		if (SW_STD_BUFFER > 0) {
			SW_STD_BUFFER--;
		}
		if (SW_MIN_BUFFER > 0) {
			SW_MIN_BUFFER--;
		}
		if (SW_STD) {
			if (SW_STD_HOLD_TIME <= 4096) {
				SW_STD_HOLD_TIME++;
			}
		} else {
			SW_STD_HOLD_TIME = 0;
		}
		if (SW_MIN) {
			if (SW_MIN_HOLD_TIME <= 4096) {
				SW_MIN_HOLD_TIME++;
			}
		} else {
			SW_MIN_HOLD_TIME = 0;
		}

		// Wichtig: Interrupt-Flag wieder zurcksetzen, sonst wird die Methode im nchsten Takt direkt wieder aufgerufen.
		T0IF = 0;

	}

}