// ************************************************************************************************
//
// Copyright www.jb-electronics.de
//
// RS232-PWM-Dimmer
//
// (x) empfange einen Zahlenwert X zwischen 0..255 via RS232
// (x) dimme die LED auf einen Duty-Cycle von X:255
//
// http://www.jb-electronics.de/html/elektronik/digital/d_rs232_pwm_dimmer.htm
//
// ************************************************************************************************

// ************************************************************************************************
// PIC-Header einbinden
#include <pic.h>

// ************************************************************************************************
// Globale Variablen
static unsigned char value = 0;

// ************************************************************************************************
// Hauptmethode
void main (void) {


    // *****
	// Konfigurationsbits setzen
	__CONFIG(FOSC_XT & WDTE_OFF & PWRTE_ON & MCLRE_ON & BOREN_ON & LVP_OFF & CPD_OFF & CP_OFF);


	// *****
	// TRISTATE-Register setzen
	
	// RB1 = RX
	TRISB1 = 1;

	// RB2 = TX
	TRISB2 = 0;

	// RB3  ist PWM-Ausgang
	TRISB3 = 0;


	// *****
	// PWM konfigurieren

	// Obergrenze von Timer2 setzen:
	PR2 = 0xff;

	// Prescaler von Timer2 auf 1:1 setzen (00 = 1:1, 01 = 1:4, 1x = 1:16)
	// und Timer einschalten (Bit Nr. 2)
	T2CON = 0b100;

	// Das CCP1 Modul auf PWM setzen
	CCP1CON = 0b1100;

	// Start-Duty-Cycle-Wert: Die LED soll ein bisschen glimmen: DC =  10:1023
	CCPR1L  = 10;


	// *****
	// USART auf RS232 konfigurieren
	
	// langsame Baud-Rate
	BRGH = 0;

	// Baud-Rate einstellen
	// F_OSC = 4.194304MHz, Baud-Rate = F_OSC / 64 / (SPBRG + 1)
	// Bei Baud-Rate = 1200 ist SPBRG = 54 ideal, das sind von 1200 nur 0.7% Abweichung, erlaubt wren 5%
	SPBRG = 54;

	// USART-Modus auf "asynchron" stellen
	SYNC = 0;

	// die serielle Schnittstelle einschalten
	SPEN = 1;

	// Interrupt bei empfangenem Zeichen auslsen
	RCIE = 1;

	// Empfangsmodus einschalten
	CREN = 1;


	// *****
	// Interrupts aktivieren

	// global
	GIE = 1;

	// periphere Interrupts aktivieren (der USART-Interrupt ist ein peripherer Interrupt!)
	PEIE = 1;


	// *****
	// Beginn der Hauptschleife
	while (1) {

		// nichts tun...

	}


}

// ************************************************************************************************
// Interrupt-Service-Routine (ISR)
static void interrupt isr (void) {

	// Zeichen empfangen?
	if (RCIF) {

		// Wert auslesen
		value = RCREG;
		CCPR1L = value;

		// eventuelle Fehler clearen
		// (hier sollte eigentlich eine richtige Fehlerberprfung eingebaut sein)
		CREN = 0;
		CREN = 1;
		OERR = 0;
		FERR = 0;

		// das Zeichen zurcksenden als Test
		TXREG = value;
		TXEN = 1;

	}

}