// ************************************************************************************************
//
// Copyright www.jb-electronics.de
//
// RGB frame - one channel (needs to be used three times)
//
// using the PIC16F716
//
// (x) reads a potentiometer connected to RA0
// (x) linearly adjusts the brightness of an LED connected to
//     RB3 using a PWM table
// 
// http://www.jb-electronics.de/html/elektronik/digital/d_rgb_rahmen.htm
//
// ************************************************************************************************


// ************************************************************************************************
// include PIC header files
#include <pic.h>


// ************************************************************************************************
// function prototypes
void getADC ();


// ************************************************************************************************
// global variables

// current ADC value
static int adc_value;

// PWM table mimicks linear behaviour
static unsigned char pwm_table[64] = { 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   1,   1,   1,   1,   1,
									   1,   1,   2,   2,   2,   2,   3,   3,   3,   4,   4,   5,   5,   6,   7,   8,
									   9,  10,  11,  12,  13,  15,  17,  19,  21,  23,  26,  29,  32,  36,  40,  45,
									  50,  56,  62,  69,  77,  86,  96, 107, 119, 133, 148, 165, 184, 206, 229, 255  };


// ************************************************************************************************
// main program loop
void main (void) {


    // *****
	// set configuration bits
	__CONFIG(FOSC_XT & WDTE_OFF & PWRTE_ON & BOREN_ON & BODENV_40 & CP_OFF);


	// *****
	// PWM settings

	// enable PWM mode
	CCP1M0 = 0;
	CCP1M1 = 0;
	CCP1M2 = 1;
	CCP1M3 = 1;

	// PWM duty cycle

	// (two LSB of 10 Bit value)
	DC1B0 = 0;
	DC1B1 = 0;

	// (eight MSB if 10 Bit value)
	CCPR1L = 0;

	// upper limit of TIMER2
	PR2 = 0xff;

	// set prescaler of Timer2 to 1:1
	T2CKPS0 = 0;
	T2CKPS1 = 0;

	// turn on TIMER2
	TMR2ON = 1;


	// *****
	// configure ADC

	// all inputs RA0:3 are inputs
	TRISA = 0b1111;

	// ADC sampling time per bit is 32 * T_osc
	ADCS0 = 0;
	ADCS1 = 1;

	// RA0:3 ports as analog inputs
	PCFG0 = 0;
	PCFG1 = 0;
	PCFG2 = 0;

	// turn it ON
	ADON = 1;


	// *****
	// start main loop
	while (1) {


		// adjust PWM level according to current ADC value
		CCPR1L = pwm_table[adc_value >> 2];
		getADC ();


	}


}


// ************************************************************************************************
// this function reads the ADC value on port RA0
void getADC () {

	// get the ADC value
	CHS0 = 0; CHS1 = 0; CHS2 = 0; GO = 1; while (GO);
	adc_value = ADRES;

}