// ************************************************************************************************
//
// Mini-Binruhr unter Verwendung des
//
// PIC 16F627A
//
// Ausgabe der Zeit ber zehn LEDs
//
// Ein-/Ausschalten der LEDs ber Taster TOGGLE
//
// Einstellen der Uhrzeit ber die Taster SET und TOGGLE
//
// Copyright www.jb-electronics.de
//
// ************************************************************************************************

// ************************************************************************************************
// PIC-Header einbinden
#include <pic.h>

// ************************************************************************************************
// Methodenprototypen
void warte ();
void updateDisplay ();

// ************************************************************************************************
// Globale Variablen
static int TimingCounter, Sekunden, Minuten, Stunden;
static int SetMode, Minutes_ON, Hours_ON, BlinkingMinutes, BlinkingHours;
static int TOGGLE_BUFFER, SET_BUFFER;
static int LEDS_ON;

// ************************************************************************************************
// Hauptmethode
void main (void) {

    // ********************************************************************************************
	// Konfigurationsbits setzen
	__CONFIG(0x3F2A);

	// ********************************************************************************************
	// Portspezifikationen
	#define STD_BIT0	RB4
	#define STD_BIT1	RB5	
	#define STD_BIT2	RB6
	#define STD_BIT3	RB7

	#define MIN_BIT0	RB3
	#define MIN_BIT1	RB2
	#define MIN_BIT2	RB1
	#define MIN_BIT3	RB0
	#define MIN_BIT4	RA3
	#define MIN_BIT5	RA2

	#define TOGGLE     	RA0
    #define SET     	RA1

	// Analogkomparator bei PORTA abschalten
	CMCON = 0b111;

	// Tristate setzen
	TRISB0 = 0;
	TRISB1 = 0;
	TRISB2 = 0;
	TRISB3 = 0;
	TRISA3 = 0;
	TRISA2 = 0;
	TRISB4 = 0;
	TRISB5 = 0;
	TRISB6 = 0;
	TRISB7 = 0;
	TRISA0 = 1;
	TRISA1 = 1;

	// ********************************************************************************************
	// TIMER setzen (Interrupt-Routine wird so genau 4096mal pro Sekunde aufgerufen)
	T0CS = 0;
	PSA = 1;
	PS0 = 1;
	PS1 = 1;
	PS2 = 1;

	// Interrupt bei Timer-berlauf auslsen
	T0IE = 1;

	// Interrupts aktivieren
	GIE = 1;

	// ********************************************************************************************
	// Starteinstellungen
	Stunden = 1;
	Minuten = 0;
	LEDS_ON = 1;
	SetMode = 0;
	BlinkingMinutes = 0;
	BlinkingHours = 0;

	// ********************************************************************************************
	// Beginn der Hauptschleife
	while (1) {

		// ****************************************************************************************
		// Tasten abfragen

        // LEDs ein-/ausschalten?
        if ((TOGGLE) && (SetMode == 0)) {
            if (TOGGLE_BUFFER == 0) {
				LEDS_ON^ = 1;
				while (TOGGLE) {
					TOGGLE_BUFFER = 50;
				}
            }
        }

        // Uhrzeit einstellen?
        if ((SET) && (SET_BUFFER == 0)) {
			// Set wird zum ersten Mal gedrckt?
			if ((SetMode == 0) && (SET_BUFFER == 0)) {
				LEDS_ON = 1;
				BlinkingHours = 1;
				while (SET) {
					SET_BUFFER = 50;
				}
				SetMode = 1; 
			}
		}
		if (SetMode == 1) {
			if ((TOGGLE) && (TOGGLE_BUFFER == 0)) {
				Sekunden = 0;
				Stunden+ = 1;
				if (Stunden >= 13) {
					Stunden = 1;
				}
				while (TOGGLE) {
					TOGGLE_BUFFER = 50;
				}
			}
			if ((SET) && (SET_BUFFER == 0)) {
				BlinkingHours = 0;
				BlinkingMinutes = 1;
				SetMode = 2;
				while (SET) {
					SET_BUFFER = 50;
				}
			}
		}
		if (SetMode == 2) {
			if ((TOGGLE) && (TOGGLE_BUFFER == 0)) {
				Sekunden = 0;
				Minuten+ = 1;
				if (Minuten >= 60) {
					Minuten = 0;
				}
				while (TOGGLE) {
					TOGGLE_BUFFER = 50;
				}
			}
			if ((SET) && (SET_BUFFER == 0)) {
				BlinkingHours = 0;
				BlinkingMinutes = 0;
				SetMode = 0;
				while (SET) {
					SET_BUFFER = 50;
				}
			}
		}

	}

}

// ************************************************************************************************
// Interrupt-Routine fr genauen 1Hz-Takt
// (Wird 4096 mal pro Sekunde ausgefhrt, da 4.194304MHz = 2Hz Takt)
static void interrupt isr (void) {

	// ********************************************************************************************
	// ein bisschen Zeit verstrichen?
	if (T0IF) {

		TimingCounter++;

		// Uhrzeit anzeigen
		updateDisplay ();

		// blinkende Uhrzeiten erzeugen (fr Einstellmodus)
		if (BlinkingMinutes) {
			if (TimingCounter < 1024) {
				Minutes_ON = 1;
			} else if ((TimingCounter > 1024) && (TimingCounter < 2048)) {
				Minutes_ON = 0;
			} else if ((TimingCounter > 2048) && (TimingCounter < 3072)) {
				Minutes_ON = 1;
			} else if ((TimingCounter > 3072) && (TimingCounter < 4096)) {
				Minutes_ON = 0;
			}
		} else {
			Minutes_ON = 1;
		}
		if (BlinkingHours) {
			if (TimingCounter < 1024) {
				Hours_ON = 1;
			} else if ((TimingCounter > 1024) && (TimingCounter < 2048)) {
				Hours_ON = 0;
			} else if ((TimingCounter > 2048) && (TimingCounter < 3072)) {
				Hours_ON = 1;
			} else if ((TimingCounter > 3072) && (TimingCounter < 4096)) {
				Hours_ON = 0;
			}
		} else {
			Hours_ON = 1;
		}

		// eine Sekunde um?
		if (TimingCounter > 4095) {
			Sekunden+ = 1;
            if (Sekunden >= 60) {
                Sekunden = 0;
                Minuten+ = 1;
                if (Minuten >= 60) {
                    Minuten = 0;
                    Stunden+ = 1;
                    if (Stunden >= 13) {
                        Stunden = 1;
                    }
                }
            }
			TimingCounter = 0;
		}

        // Tasten puffern
        if (TOGGLE == 0) {
            if (TOGGLE_BUFFER > 0) {
                TOGGLE_BUFFER- = 1;
            }
		}
        if (SET == 0) {
            if (SET_BUFFER > 0) {
                SET_BUFFER- = 1;
            }
		}

		// Interrupt resetten
		T0IF = 0;

	}

}

// ************************************************************************************************
// Diese Methode zeigt die Uhrzeit an
void updateDisplay () {

	// Uhrzeit anzeigen?
	// (negative Logik, da LEDs nach +5V geschaltet sind)

	// Stunden binr zerlegen und direkt ber die Ports anzeigen
	if ((LEDS_ON) && (Hours_ON))   {

		if (Stunden & 1) {
			STD_BIT0 = 0;
		} else {
			STD_BIT0 = 1;
		}
		if (Stunden & 2) {
			STD_BIT1 = 0;
		} else {
			STD_BIT1 = 1;
		}
		if (Stunden & 4) {
			STD_BIT2 = 0;
		} else {
			STD_BIT2 = 1;
		}
		if (Stunden & 8) {
			STD_BIT3 = 0;
		} else {
			STD_BIT3 = 1;
		}
	
	// keine Anzeige (s.o.)
	} else {

		STD_BIT0 = 1;
		STD_BIT1 = 1;
		STD_BIT2 = 1;
		STD_BIT3 = 1;

	}

	// Minuten binr zerlegen und direkt ber die Ports anzeigen
	if ((LEDS_ON) && (Minutes_ON)) {

		if (Minuten & 1) {
			MIN_BIT0 = 0;
		} else {
			MIN_BIT0 = 1;
		}
		if (Minuten & 2) {
			MIN_BIT1 = 0;
		} else {
			MIN_BIT1 = 1;
		}
		if (Minuten & 4) {
			MIN_BIT2 = 0;
		} else {
			MIN_BIT2 = 1;
		}
		if (Minuten & 8) {
			MIN_BIT3 = 0;
		} else {
			MIN_BIT3 = 1;
		}
		if (Minuten & 16) {
			MIN_BIT4 = 0;
		} else {
			MIN_BIT4 = 1;
		}
		if (Minuten & 32) {
			MIN_BIT5 = 0;
		} else {
			MIN_BIT5 = 1;
		}

	// keine Anzeige (s.o.)
	} else {

		MIN_BIT0 = 1;
		MIN_BIT1 = 1;
		MIN_BIT2 = 1;
		MIN_BIT3 = 1;
		MIN_BIT4 = 1;
		MIN_BIT5 = 1;

	}

}
