// ************************************************************************************************
//
// Leuchtschild unter Verwendung des
//
// PIC 16F627A
//
// automatische Ansteuerung von 43 LEDs (hinterleuchtetes Wort: LASER)
//
// mit verschiedenen Effekten
//
// L	5
// A	10
// S	8
// E	10
// R	10
//
// Copyright www.jb-electronics.de
//
// ************************************************************************************************

// ************************************************************************************************
// PIC-Header einbinden
#include <pic.h>

// Methodenprototypen
void sendLEDs ();
void warte ();

// ************************************************************************************************
// Globale Variablen
static int TimingCounter, DisplayMode;
static int From, UpTo;
static int C1, C2, C3, C4, C5, C6, toggle, letter;
static int SegL, SegA, SegS, SegE, SegR;

// ************************************************************************************************
// Hauptmethode
void main (void) {

    // ********************************************************************************************
	// Konfigurationsbits setzen
	__CONFIG(0x3F2A);

	// ********************************************************************************************
	// Portspezifikationen

	// PORTB unterteilen
	#define CLK			RB0
	#define STROBE		RB1
	#define DATA		RB2

	// PORTB als Ausgang definieren
	TRISB = 0b00000000;

	// ********************************************************************************************
	// TIMER setzen
	T0CS = 0;
	PSA = 1;
	PS0 = 1;
	PS1 = 1;
	PS2 = 1;

	// Interrupt bei Timer-berlauf auslsen
	T0IE = 1;

	// Interrupts aktivieren
	GIE = 1;

	// ********************************************************************************************
	// Wie viele LEDs pro Buchstabe?
	SegL = 5;
	SegA = 10;
	SegS = 8;
	SegE = 10;
	SegR = 10;

	// ********************************************************************************************
	// Display-Modus setzen (1 = alle an, 2 = blinkend, 3 = Einzel-LEDs nach und nach an,
    //                       4 = Buchstabe nach Buchstabe, 5 = aus der Mitte heraus)
	DisplayMode = 1;
	toggle = 0;
	letter = 0;
    From = 0;
	UpTo = 0;
	C1 = 0;
	C2 = 0;
	C3 = 0;
    C4 = 0;
    C5 = 0;

	// ********************************************************************************************
	// Beginn der Hauptschleife
	while (true) {

		// LED-Daten senden
		sendLEDs ();

	}
	
}

// ************************************************************************************************
// Interrupt-Routine
static void interrupt isr (void) {

	// ********************************************************************************************
	// Eine Sekunde um? (wird ca. 4000 mal pro Sekunde ausgefhrt)
	if (T0IF) {

		// Zhler als Zeitbasis fr das Timing
		TimingCounter++;

		// ****************************************************************************************
		// Welcher Effekt?

		// Alles an
		if (DisplayMode == 1) {
			UpTo = 48;
			if (TimingCounter == 4000) {
				TimingCounter = 0;
				C1++;
				if (C1 == 10) {
					C1 = 0;
					DisplayMode = 2;
				}
			}
		}
			
		// blinkend
		if (DisplayMode == 2) {
			if (toggle) {
				UpTo = 48;
			} else {
				UpTo = 0;
			}
			if (TimingCounter == 2000) {
				TimingCounter = 0;
				toggle^= 1;
				C2++;
				if (C2 == 20) {
                    From = 0;
					toggle = 0;
					C2 = 0;
					DisplayMode = 3;
				}
			}			
		}

		// Segmente einzeln?
		if (DisplayMode == 3) {
 			if (TimingCounter == 200) {
				TimingCounter = 0;
				if (UpTo < 48) {
					UpTo++;
				} else {
					From++;
                    if (From >= 45) {
                        From = 0;
                        UpTo = 0;
					    C3++;
					    if (C3 == 4) {
						  C3 = 0;
						  DisplayMode = 4;
                        }
					}
				}
			}
		}

		// Buchstaben einzeln?
		if (DisplayMode == 4) {
 			if (TimingCounter == 3000) {
				TimingCounter = 0;
				letter++;
				if (letter == 1) {
					UpTo = UpTo + SegL;
				} else if (letter == 2) {
					UpTo = UpTo + SegA; 
				} else if (letter == 3) {
					UpTo = UpTo + SegS; 
				} else if (letter == 4) {
					UpTo = UpTo + SegE; 
				} else if (letter == 5) {
					UpTo = UpTo + SegR;
				}
				if (letter == 6) {
					UpTo = 0;
					letter = 0;
					C4++;
					if (C4 == 5) {
						toggle = 0;
                        From = 19;
    					UpTo = 20;
						C4 = 0;
						DisplayMode = 5;
					}
				}
			}
		}

        // Aus der Mitte heraus
        if (DisplayMode == 5) {
            if (TimingCounter == 200) {
                TimingCounter = 0;
				if (toggle == 0) {
                	UpTo = UpTo + 1;
                	From = From - 1;
				} else {
                	UpTo = UpTo - 1;
                	From = From + 1;
				}
                if ((From < -5) || (UpTo <= 20)) {
                    C5++;
					toggle^ = 1;
				}
				if (C5 == 11) {
					toggle = 0;
					From = 0;
					UpTo = 0;
					C5 = 0;
	            	DisplayMode = 6;
                }
            }
        }

		// einzelner Leuchtpunkt hin und her
		if (DisplayMode == 6) {
 			if (TimingCounter == 400) {
				TimingCounter = 0;
				if (toggle == 0) {
					UpTo++;
					From++;
				} else {
					UpTo--;
					From--;
				}
				if ((From > 48) || (From < -5)) {
					toggle^ = 1;
				}
				if ((toggle == 1) && (From == 0)) {
                    From = 0;
                    UpTo = 0;
			    	C6++;
			    	if (C6 == 4) {
						C6 = 0;
						From = 0;
						UpTo = 43;
						DisplayMode = 1;
                     }
				}
			}
		}

		T0IF = 0;

	}

}

// ************************************************************************************************
// Diese Methode sendet alle LED-Daten
void sendLEDs () {

	// Variablen
	uchar Index;

	// Ausgnge resetten
	CLK = 0;
	DATA = 0;
	STROBE = 0;
	warte ();

	// Schleife ber alle Bits (6 8er-Schieberegister d.h. 6x8 Bits = 48 Bits)
	for (Index = 48; Index > 0; Index--) {

		// Datensignal an Bus legen
		if ((Index >= From) && (Index <= UpTo)) {
			DATA = 1;
		} else {
			DATA = 0;
		}
		warte ();

		// Signal einen weiter schieben
		warte ();
		CLK = 1;
		warte ();
		CLK = 0;

	}

	// Daten sichtbar werden lassen
	STROBE = 1;
	warte ();
	STROBE = 0;

}

// ************************************************************************************************
// Diese Methode wartet kurz, um Signale gltig werden zu lassen
void warte () {

	NOP();

}
