// ************************************************************************************************
//
// LED-Lauflicht unter Verwendung des
//
// PIC 16F627A
//
// 5-Kanal-Lauflicht mit je 3 LEDs pro Kanal
//
// Muster: x
//         xx
//         xxx
//         xxxx
//         xxxxx
//
//			etc.
//
// Copyright www.jb-electronics.de
//
// ************************************************************************************************

// ************************************************************************************************
// PIC-Header einbinden
#include <pic.h>

// ************************************************************************************************
// Globale Variablen
static int TimeCounter;
static uchar LauflichtPosition;

#define N	5

// ************************************************************************************************
// Hauptmethode
void main (void) {

    // ********************************************************************************************
	// Konfigurationsbits setzen
	__CONFIG(0x3F2A);

	// ********************************************************************************************
	// Portspezifikationen
	#define CH1		RB0
	#define	CH2		RB1
	#define	CH3		RB2
	#define CH4		RB3
	#define CH5		RB4

	// Tristate setzen (alles auf Ausgang)
	TRISB = 0b00000000;
	CMCON = 0b111;
	TRISA = 0b000;

	// ********************************************************************************************
	// Zeitinformationen resetten
	TimeCounter = 0;

	// ********************************************************************************************
	// Lauflicht resetten
	LauflichtPosition = 0;

	// ********************************************************************************************
	// Timer0 setzen
	T0CS = 0;
	PSA = 1;
	PS0 = 0;
	PS1 = 0;
	PS2 = 0;

	// Interrupt bei Timer1-berlauf auslsen
	T0IE = 1;

	// Interrupts aktivieren
	GIE = 1;

	// ********************************************************************************************
	// Beginn der Hauptschleife
	while (true) {

		// ****************************************************************************************
		// Lauflichtsteuerung

		CH1 = (LauflichtPosition >= 1);
		CH2 = (LauflichtPosition >= 2);
		CH3 = (LauflichtPosition >= 3);
		CH4 = (LauflichtPosition >= 4);
		CH5 = (LauflichtPosition >= 5);

	}

}



// ************************************************************************************************
// Interrupt-Routine fr genauen 1Hz-Takt
static void interrupt isr (void) {

	// ********************************************************************************************
	// Timer1-Overflow
	if (T0IF) {

		// Zeitpuffer erhhen
		TimeCounter++;

		// 1s vorbei? (bei Fosc = 4MHz)
		if (TimeCounter == 3906) {
			LauflichtPosition++;
			if (LauflichtPosition > N) {
				LauflichtPosition = 0;
			}
			TimeCounter = 0;
		}

		T0IF = 0;

    }


}
