// ************************************************************************************************
//
// Binr-Uhr unter Verwendung des
//
// PIC 16F627A
//
//
// (x) Anzeigen der Uhrzeit ber 10 LEDs
// (x) Einstellen der Uhrzeit (Stunden & Minuten) ber einen Taster
// (x) Ein-/Ausschalten der LEDs ber Schalter
// (x) zustzliche AM/PM-LED
//
// Copyright www.jb-electronics.de
//
// ************************************************************************************************

// ************************************************************************************************
// PIC-Header einbinden
#include <pic.h>

// ************************************************************************************************
// Methodenprototypen
void sendeWerte ();
void pulseCLK ();
void startUp ();
void warte ();

// ************************************************************************************************
// Globale Variablen
static uchar Sekunden, Minuten, Stunden, blink;
static int TimingCounter, i, t;
static int SW_BUFFER, StundenSetTime, MinutenSetTime, MAX;

// ************************************************************************************************
// Hauptmethode
void main (void) {

    // ********************************************************************************************
	// Konfigurationsbits setzen
	__CONFIG(0x3F2A);

	// ********************************************************************************************
	// Portspezifikationen
	#define DATA	RA2
	#define CLK		RA3
	#define DIMMER	RB3
	#define STR_MIN	RA1
	#define STR_STD	RA0
	#define SW		RB0

	// Tristate setzen
	// CMCON = 0b111;
	TRISA = 0b0000;
	TRISB0 = 1;
	TRISB1 = 1;
	TRISB2 = 1;
	TRISB3 = 0;

	// ********************************************************************************************
	// Startwerte fr Zeitinformationen setzen
	Stunden = 12;
	Minuten = 0;

	// ********************************************************************************************
	// TIMER setzen
	T0CS = 0;
	PSA = 1;
	PS0 = 1;
	PS1 = 1;
	PS2 = 1;

	// Interrupt bei Timer-berlauf auslsen
	T0IE = 1;

	// Interrupts aktivieren
	GIE = 1;

	// LEDs sollen AN sein
	DIMMER = 1;

	// nichts soll blinken (0: nichts, 1: Stunden, 2: Minuten)
	blink = 0;

	// Maximale Wartezeit: ca. 3 Sekunden
	MAX = 12288;

	Stunden = 1;
	Minuten = 1;

	startUp ();

	// ********************************************************************************************
	// Beginn der Hauptschleife
	while (true) {

		// ****************************************************************************************
		// Uhrzeit anzeigen
		sendeWerte ();

		// Taste gedrckt?
		if ((SW) && (SW_BUFFER == 0)) {

			SW_BUFFER = 1500;

			// Vorher normaler Anzeigemodus: wechsle in Stunden-Einstell-Modus
			if (blink == 0) {
				StundenSetTime = 0;
				MinutenSetTime = 0;
				blink++;
				if (blink >= 3) {
					blink = 0;
				}

			// Stunden-Einstell-Modus
			} else if (blink == 1) {
				StundenSetTime = 0;
				Stunden++;
				t = 0;
				if (Stunden >= 13) {
					Stunden = 1;
				}	

			// Minuten-Einstell-Modus
			} else if (blink == 2) {
				MinutenSetTime = 0;
				Minuten++;
				t = 0;
				if (Minuten >= 60) {
					Minuten = 0;
				}	
			}


		}



	}

}



// ************************************************************************************************
// Interrupt-Routine
static void interrupt isr (void) {

	// ********************************************************************************************
	// Entprell-Routine fr Taster
	if (T0IF) {

		// Zeit weiterzhlen
		TimingCounter++;
		t++;
		if (TimingCounter >= 4096) {

			TimingCounter = 0;
			Sekunden++;
			if (Sekunden >= 60) {
				Sekunden = 0;
				Minuten++;
				if (Minuten >= 60) {
					Minuten = 0;
					Stunden++;
					if (Stunden >= 13) {
						Stunden = 1;
					}
				}
			}
		}

		// Tastenpuffer schrittweise leeren
		if (SW_BUFFER > 0) {
			SW_BUFFER--;
		}

		// Zeit im Stundenmodus ohne Tastenbettigung zhlen
		if (blink == 1) {
			StundenSetTime++;
			if (StundenSetTime >= MAX) {
				MinutenSetTime = 0;
				blink = 2;
			}
		}

		// Zeit im Minutenmodus ohne Tastenbettigung zhlen
		if (blink == 2) {
			MinutenSetTime++;
			if (MinutenSetTime >= MAX) {
				blink = 0;
			}
		}

		T0IF = 0;

    }


}

// ************************************************************************************************
// Diese Methode sendet die Uhrzeit (binr zerlegt) an ein Schieberegister
void sendeWerte () {

	uchar Min, Std;
	Min = Minuten;
	Std = Stunden;

	// das aktuell einzustellende blinkt
	if ((t > 1000) && (t < 2000)) {
		if (blink == 1) {
			Std = 0;	
		}
		if (blink == 2) {
			Min = 0;	
		}
	} else if (t > 2000) {
		t = 0;
	}


	STR_MIN = 0;
	for (i = 7; i >= 0; i--) {
		if (Min & (1 << i)) {
			DATA = 0;
		} else {
			DATA = 1;
		}
		pulseCLK ();
	}
	STR_MIN = 1;
	STR_MIN = 0;
	
	STR_STD = 0;
	for (i = 7; i >= 0; i--) {
		if (Std & (1 << i)) {
			DATA = 0;
		} else {
			DATA = 1;
		}
		pulseCLK ();
	}
	STR_STD = 1;
	STR_STD = 0;


}

// ************************************************************************************************
// Diese Methode pulst einmal kurz den CLK-Pin
void pulseCLK () {

	CLK = 1;
	CLK = 0;

}

// ************************************************************************************************
// erzeugt den Start-Effekt
void startUp () {

	uchar tmp;

	for (tmp = 0; tmp < 5; tmp++) {
	
		Minuten = 0b000000; Stunden = 0b0000; sendeWerte (); warte ();
		Minuten = 0b000001; Stunden = 0b0000; sendeWerte (); warte ();
		Minuten = 0b000011; Stunden = 0b0000; sendeWerte (); warte ();
		Minuten = 0b000111; Stunden = 0b0000; sendeWerte (); warte ();
		Minuten = 0b001111; Stunden = 0b0000; sendeWerte (); warte ();
		Minuten = 0b011111; Stunden = 0b0000; sendeWerte (); warte ();
		Minuten = 0b111111; Stunden = 0b0000; sendeWerte (); warte ();
		Minuten = 0b111111; Stunden = 0b0001; sendeWerte (); warte ();
		Minuten = 0b111111; Stunden = 0b0011; sendeWerte (); warte ();
		Minuten = 0b111111; Stunden = 0b0111; sendeWerte (); warte ();
		Minuten = 0b111111; Stunden = 0b1111; sendeWerte (); warte ();
	
		Minuten = 0b111111; Stunden = 0b1111; sendeWerte (); warte ();
		Minuten = 0b111111; Stunden = 0b0111; sendeWerte (); warte ();
		Minuten = 0b111111; Stunden = 0b0011; sendeWerte (); warte ();
		Minuten = 0b111111; Stunden = 0b0001; sendeWerte (); warte ();
		Minuten = 0b011111; Stunden = 0b0000; sendeWerte (); warte ();
		Minuten = 0b001111; Stunden = 0b0000; sendeWerte (); warte ();
		Minuten = 0b000111; Stunden = 0b0000; sendeWerte (); warte ();
		Minuten = 0b000011; Stunden = 0b0000; sendeWerte (); warte ();
		Minuten = 0b000001; Stunden = 0b0000; sendeWerte (); warte ();
		Minuten = 0b000000; Stunden = 0b0000; sendeWerte (); warte ();

	}

	Stunden = 1;
	Minuten = 1;


}

void warte () {

	uchar tmp1, tmp2;
	for (tmp1 = 0; tmp1 < 10; tmp1++) {
		for (tmp2 = 0; tmp2 < 255; tmp2++) {
			NOP ();
		}
	}

}
