// ************************************************************************************************
//
// Binruhr unter Verwendung des
//
// PIC 16F627A
//
// Ausgabe der Zeit ber 10 LEDs, Einstellen der Zeit ber zwei Taster
//
// Copyright www.jb-electronics.de
//
// ************************************************************************************************

// PIC-Header einbinden
#include <pic.h>

// ************************************************************************************************
// Methodenprototypen
void warte ();
void schreibeWert (uchar Wert, uchar Wohin);

// ************************************************************************************************
// Globale Variablen
static uchar SekundeUm;
static int Counter;

// ************************************************************************************************
// Hauptmethode
void main (void) {

    // ********************************************************************************************
	// Konfigurationsbits setzen
	__CONFIG(0x3F2A);

	// ********************************************************************************************
	// Portspezifikationen
	
	// PORTB als Ausgang definieren
	TRISB = 0b00000000;

	// RB4 und RB5 sind aber Eingnge, da dort Taster angeschlossen werden
	TRISB4 = 1;
	TRISB5 = 1;

	// PORTB unterteilen
	#define STROBE_MINUTEN	RB0
	#define STROBE_STUNDEN	RB1
	#define DATA			RB2
	#define CLOCK			RB3
	#define STELLEN_STUNDEN	RB4
	#define STELLEN_MINUTEN	RB5

	// ********************************************************************************************
	// TIMER setzen
	T0CS = 0;
	PSA = 1;
	PS0 = 1;
	PS1 = 1;
	PS2 = 1;

	// Interrupt bei Timer-berlauf auslsen
	T0IE = 1;

	// Interrupts aktivieren
	GIE = 1;

	// ********************************************************************************************
	// Beginn der Hauptschleife
	while (true) {

		// ****************************************************************************************
		// Variablen
		uchar Sekunden, Minuten, Stunden, tmp;

		// ****************************************************************************************
		// Uhrzeit neu berechnen, wenn Sekunde um
		if (SekundeUm) {
			Sekunden++;
			if (Sekunden == 60) {
				Sekunden = 0;
				Minuten++;
				if (Minuten == 60) {
					Minuten = 0;
					Stunden++;
					if (Stunden == 13) {
						Stunden = 1;
					}
				}
			}
			SekundeUm = 0;
		}

		// ****************************************************************************************
		// Stunden auf 0?
		if (Stunden == 0) {
			Stunden = 1;
		}

		// ****************************************************************************************
		// Uhrzeit senden
		schreibeWert (Stunden, 1);
		schreibeWert (Minuten, 2);

		// ****************************************************************************************
		// Uhr stellen?
		if (STELLEN_STUNDEN) {
			tmp = 0;
			Counter = 0;
			Stunden++;
			if (Stunden == 13) {
				Stunden = 1;
			}
			schreibeWert (Stunden, 1);
			while (STELLEN_STUNDEN) {
				if ((SekundeUm) && (tmp < 2)) {
					tmp++;
				}
				if ((Counter == 2048) && (tmp == 2)) {
					Stunden++;
					if (Stunden == 13) {
						Stunden = 1;
					}
					schreibeWert (Stunden, 1);
					Counter = 0;
				}
			}
			tmp = 0;
			Counter = 0;
		}
		if (STELLEN_MINUTEN) {
			tmp = 0;
			Counter = 0;
			Minuten++;
			if (Minuten == 60) {
				Minuten = 0;
			}
			schreibeWert (Minuten, 2);
			while (STELLEN_MINUTEN) {
				if ((SekundeUm) && (tmp < 2)) {
					tmp++;
				}
				if ((Counter == 2048) && (tmp == 2)) {
					Minuten++;
					if (Minuten == 60) {
						Minuten = 0;
					}
					schreibeWert (Minuten, 2);
					Counter = 0;
				}
			}
			tmp = 0;
			Counter = 0;
		}

	}

}

// ************************************************************************************************
// Interrupt-Routine fr genauen 1Hz-Takt
static void interrupt isr  (void) {

	// Eine Sekunde um?
	if (T0IF) {
		Counter++;
		if (Counter == 4096) {
			SekundeUm = 1;
			Counter = 0;
		}
		T0IF = 0;
	}

}

// ************************************************************************************************
// schreibt einen Wert in ein Schieberegister
void schreibeWert (uchar Wert, uchar Wohin) {

	// Variablen
	int Index;

	// initialisieren
	STROBE_STUNDEN = 0;
	STROBE_MINUTEN = 0;

	// Wert senden
	warte();
	for (Index = 7; Index >= 0; Index--) {
		if (Wert & (1 << Index)) {
			DATA = 1;
		} else {
		 	DATA = 0;
		}
		warte();
		CLOCK = 1;
		warte();
		CLOCK = 0;
		warte();
	}

	// Wert bernehmen
	if (Wohin == 1) {
		STROBE_STUNDEN = 1;
	} else {
		STROBE_MINUTEN = 1;
	}
	warte();

}

// ************************************************************************************************
// Diese Methode wartet kurz, um Signale gltig werden zu lassen
void warte () {

	// einen Takt nichts tun
	NOP();

}
