// ************************************************************************************************
//
// Vitrinenschalter unter Verwendung des
//
// PIC 16F627A
//
// Steuerung des Schalters (2 Relais) ber zwei Sensoren
//
// Anzeige des Modus ber eine LED-Anzeige
//
// Wechseln des Modus ber einen Taster
//
// Copyright www.jb-electronics.de
//
// ************************************************************************************************

// ************************************************************************************************
// PIC-Header einbinden
#include <pic.h>

// ************************************************************************************************
// Methodenprototypen
uchar get7SegmentValue (uchar Wert, uchar DecimalPoint);

// ************************************************************************************************
// Globale Variablen
static uchar SekundeUm;
static int TimingCounter, Modus = 0, SekundenUm = 0, SekundenOK = 0, Active = 0, DisplayOn = 0, DP = 0;
static int Zeiten[9];

// ************************************************************************************************
// Hauptmethode
void main (void) {

    // ********************************************************************************************
	// Konfigurationsbits setzen
	__CONFIG(0x3F2A);

	// ********************************************************************************************
	// Portspezifikationen

	// PORTA unterteilen
	#define SENSOR_EIN		RA0
	#define SENSOR_AUS		RA1
	#define RELAIS1			RA3
	#define RELAIS2			RA2
	#define TASTER			RA4

	// Tristate PORTA setzen
	TRISA0 = 0b1;
	TRISA1 = 0b1;
	TRISA2 = 0b0;
	TRISA3 = 0b0;
	TRISA4 = 0b1;

	CMCON = 0b111;

	// PORTB als Ausgang definieren
	TRISB = 0b00000000;

	// PORTB definieren
	#define DISPLAY			PORTB

	// ********************************************************************************************
	// TIMER setzen
	T0CS = 0;
	PSA = 1;
	PS0 = 1;
	PS1 = 1;
	PS2 = 1;

	// Interrupt bei Timer-berlauf auslsen
	T0IE = 1;

	// Interrupts aktivieren
	GIE = 1;

	// Relais abschalten
	RELAIS1 = 0;
	RELAIS2 = 0;

	// Displaymodus anzeigen
	DisplayOn = 5;

	// Zeiten laden
	Zeiten[1] = 5;
	Zeiten[2] = 10;
	Zeiten[3] = 30;
	Zeiten[4] = 60;
	Zeiten[5] = 120;
	Zeiten[6] = 180;
	Zeiten[7] = 300;
	Zeiten[8] = 600;

	// ********************************************************************************************
	// Beginn der Hauptschleife
	while (true) {

		// ****************************************************************************************
		// Modus einstellen
		if (TASTER) {
			Modus++;
			if (Modus > 8) {
				Modus = 0;
			}
			while (TASTER);
			TimingCounter = 0;
			SekundenUm = 0;
			RELAIS1 = 0;
			RELAIS2 = 0;
			DisplayOn = 5;
			Active = 0;
		}

		// Welcher Modus ist aktiv?

		// EIN/AUS Modus
		if (Modus == 0) {
			if (!SENSOR_EIN) {
				RELAIS1 = 1;
				RELAIS2 = 1;
				while (!SENSOR_EIN);
			} else if (!SENSOR_AUS) {
				RELAIS1 = 0;
				RELAIS2 = 0;
				while (!SENSOR_AUS);
			}


		// Zeitmodi
		} else if (Modus > 0) {

			if (!SENSOR_EIN) {
				Active = 1;
			}
			if (!SENSOR_AUS) {
				RELAIS1 = 0;
				RELAIS2 = 0;
				Active = 0;
			}
			if (Active) {
				if (SekundenUm <= Zeiten[Modus]) {
					RELAIS1 = 1;
					RELAIS2 = 1;
				} else {
					RELAIS1 = 0;
					RELAIS2 = 0;
					Active = 0;
					SekundenUm = 0;
				}
			}

		}

	}
	
}

// ************************************************************************************************
// Interrupt-Routine fr genauen 1Hz-Takt
static void interrupt isr (void) {

	// ********************************************************************************************
	// Eine Sekunde um? (wird 4096 mal pro Sekunde ausgefhrt)
	if (T0IF) {

		// Zhler als Zeitbasis fr die Zeituhr
		TimingCounter++;
		if (TimingCounter == 2047) {
			DP^ = 1;
		} else if (TimingCounter == 4095) {
			DP^ = 1;
			if (Active) {
				SekundenUm+ = 1;
			}
			TimingCounter = 0;
			if (DisplayOn) {
				DisplayOn- = 1;
			}
		}
		T0IF = 0;

	}

	// Modus anzeigen
	if (DisplayOn) {
		DISPLAY = get7SegmentValue(Modus + 1, 0);
	} else {
		DISPLAY = 0b11111111;
	}

	// DP blinken lassen
	if ((DP == 1) && (DisplayOn == 0)) {
		DISPLAY^ = 0b10000000;
	}

}

// ************************************************************************************************
// wandelt einen Wert in ein Zeichen im 7-Segment-Code um
uchar get7SegmentValue (uchar Wert, uchar DecimalPoint) {

	// Variablen
	uchar result;

	// welches Ausgabemuster bei welchem anzuzeigenden Zeichen?
	if (Wert == 0) {
		result = 0b11000000;
	} else if (Wert == 1) {
		result = 0b11111001;
	} else if (Wert == 2) {
		result = 0b10100100;
	} else if (Wert == 3) {
		result = 0b10110000;
	} else if (Wert == 4) {
		result = 0b10011001;
	} else if (Wert == 5) {
		result = 0b10010010;
	} else if (Wert == 6) {
		result = 0b10000010;
	} else if (Wert == 7) {
		result = 0b11111000;
	} else if (Wert == 8) {
		result = 0b10000000;
	} else if (Wert == 9) {
		result = 0b10010000;
	} else {
		result = 0b10001110;
	}

	// Dezimalpunkt aktiv?
	if (DecimalPoint) {
	//	result| = 0b01111111;
	}
	
	// Wert zurckgeben
	return (result);

}
